/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPropertyBaseInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractMaterialMultiApproveProcessor
extends AbstractBusinessProcessor {
    private Logger logger = Logger.getLogger(AbstractMaterialMultiApproveProcessor.class);

    public AbstractMaterialMultiApproveProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void checkFunctionPermission(Context ctx, String ouId, String PerminsionItem) throws BOSException, EASBizException {
        String getCUSQL = " select FCONTROLUNITID from T_ORG_BaseUnit where fid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getCUSQL, (Object[])new Object[]{ouId});
        String cuId = ouId;
        try {
            if (rs.next()) {
                cuId = rs.getString("FCONTROLUNITID");
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        ObjectUuidPK CUPK = new ObjectUuidPK(cuId);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)CUPK, PerminsionItem);
    }

    protected int multiAssitantApprove(Context ctx, List<MaterialPropertyBaseInfo> baselist, String tableName) throws BOSException, EASBizException {
        int count = 0;
        if (baselist != null && !baselist.isEmpty()) {
            ArrayList<String[]> list = new ArrayList<String[]>();
            IMaterial ima = MaterialFactory.getLocalInstance(ctx);
            String[] idStr = null;
            for (int i = 0; i < baselist.size(); ++i) {
                MaterialPropertyBaseInfo info = baselist.get(i);
                MaterialInfo mainfo = info.getMaterial();
                if (mainfo == null || mainfo.getStatus() == UsedStatusEnum.UNAPPROVE || mainfo.getStatus() == UsedStatusEnum.FREEZED) continue;
                idStr = new String[4];
                if (info == null || info.getEffectedStatus() != 2 || info.getStatus() != UsedStatusEnum.UNAPPROVE) continue;
                idStr[0] = mainfo.getId().toString();
                idStr[1] = mainfo.getBaseUnit().getId().toString();
                if (info.getClass().getSimpleName().equals("MaterialPurchasingInfo")) {
                    idStr[2] = ((MeasureUnitInfo)info.get("unit")).getId().toString();
                    idStr[3] = info.getId().toString();
                }
                if (info.getClass().getSimpleName().equals("MaterialSalesInfo")) {
                    idStr[2] = ((MeasureUnitInfo)info.get("unit")).getId().toString();
                    idStr[3] = info.getId().toString();
                }
                if (info.getClass().getSimpleName().equals("MaterialInventoryInfo")) {
                    idStr[2] = ((MeasureUnitInfo)info.get("unit")).getId().toString();
                    idStr[3] = info.getId().toString();
                }
                if (info.getClass().getSimpleName().equals("MaterialPlanInfo")) {
                    idStr[2] = ((MeasureUnitInfo)info.get("productUnit")).getId().toString();
                    idStr[3] = info.getId().toString();
                }
                list.add(idStr);
            }
            if (list != null && !list.isEmpty()) {
                List checklist = this.checkAssitantMeasureUnitMulti(list, ctx);
                count = checklist.size();
                if (checklist != null && !checklist.isEmpty()) {
                    this.multiAssitantApproveSql(ctx, checklist, tableName);
                }
            }
        }
        return count;
    }

    protected List checkAssitantMeasureUnitMulti(List materiallist, Context ctx) throws BOSException, EASBizException {
        ArrayList<String> restlist = new ArrayList<String>();
        if (materiallist != null && !materiallist.isEmpty()) {
            StringBuffer sqlbuffer = new StringBuffer();
            for (int i = 0; i < materiallist.size(); ++i) {
                String[] assitantobj = (String[])materiallist.get(i);
                sqlbuffer.append(this.checkAssitantMeasureUnitSql(assitantobj, ctx));
                if (i == materiallist.size() - 1) continue;
                sqlbuffer.append(" union all ");
            }
            if (sqlbuffer.length() != 0) {
                this.logger.info((Object)("\u6821\u9a8c\u8ba1\u91cf\u5355\u4f4dsql: " + sqlbuffer.toString()));
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlbuffer.toString());
                try {
                    int j = 0;
                    while (rs.next()) {
                        if (rs.getInt(1) == 0) {
                            String[] assitantobj = (String[])materiallist.get(j);
                            restlist.add(assitantobj[3]);
                        }
                        ++j;
                    }
                }
                catch (SQLException e) {
                    this.logger.error((Object)e);
                }
            }
        }
        return restlist;
    }

    protected void multiAssitantApproveSql(Context ctx, List infolist, String tableName) throws BOSException, EASBizException {
        StringBuffer updatesql = new StringBuffer();
        if (infolist != null && !infolist.isEmpty()) {
            updatesql.append(" update " + tableName + " set FStatus = ").append(String.valueOf(1));
            updatesql.append("  where fid in (");
            for (int i = 0; i < infolist.size(); ++i) {
                String assitantId = infolist.get(i).toString();
                updatesql.append(" '").append(assitantId).append("'");
                if (i == infolist.size() - 1) continue;
                updatesql.append(",");
            }
            updatesql.append(")");
            String updateSql = updatesql.toString();
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    protected String checkAssitantMeasureUnitSql(String[] idArray, Context ctx) throws BOSException, EASBizException {
        String baseID = idArray[0];
        String baseUnitID = idArray[1];
        String comparedUnitID = idArray[2];
        StringBuffer sql = new StringBuffer(200);
        sql.append("(select count(1) from T_BD_MultiMeasureUnit where fmaterialid = '");
        sql.append(baseID).append("'");
        sql.append(" and FMeasureUnitID='").append(baseUnitID).append("'");
        sql.append(" and FQtyPrecision > (");
        sql.append(" select FQtyPrecision from T_BD_MultiMeasureUnit where");
        sql.append(" FMeasureUnitID ='").append(comparedUnitID).append("'");
        sql.append(" and fmaterialid = '").append(baseID).append("'");
        sql.append("))");
        return sql.toString();
    }

    protected int multiUnApprove(Context ctx, List<MaterialPropertyBaseInfo> baselist, String tableName) throws BOSException, EASBizException {
        ArrayList<MaterialPropertyBaseInfo> list = new ArrayList<MaterialPropertyBaseInfo>();
        int count = 0;
        if (baselist != null && !baselist.isEmpty()) {
            for (int i = 0; i < baselist.size(); ++i) {
                MaterialPropertyBaseInfo info = baselist.get(i);
                if (info == null || info.getEffectedStatus() != 2 || info.getStatus() != UsedStatusEnum.APPROVED) continue;
                info.setStatus(UsedStatusEnum.UNAPPROVE);
                list.add(info);
            }
            count = list.size();
            if (list != null && !list.isEmpty()) {
                this.multiUnApproveSql(ctx, list, tableName);
            }
        }
        return count;
    }

    protected void multiUnApproveSql(Context ctx, List<MaterialPropertyBaseInfo> infolist, String tableName) throws BOSException, EASBizException {
        StringBuffer updatesql = new StringBuffer();
        UserInfo userInfo = this.getUserInfo(ctx);
        if (infolist != null && !infolist.isEmpty()) {
            updatesql.append(" update " + tableName + " set FStatus = ").append(String.valueOf(0));
            updatesql.append(",FLastUpdateUserID='" + userInfo.getId().toString() + "',FLastUpdateTime=getDate()");
            updatesql.append("  where fid in (");
            for (int i = 0; i < infolist.size(); ++i) {
                String assitantId = infolist.get(i).getId().toString();
                updatesql.append(" '").append(assitantId.toString()).append("'");
                if (i == infolist.size() - 1) continue;
                updatesql.append(",");
            }
            updatesql.append(")");
            String updateSql = updatesql.toString();
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    protected UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    protected String getDataPermissionSql(Context ctx, String cuId, String PerminsionItem) throws BOSException, EASBizException {
        ObjectUuidPK CUPK = new ObjectUuidPK(cuId);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        return iPermission.getPermissionWhereSQL((IObjectPK)userPK, (IObjectPK)CUPK, PerminsionItem, "id");
    }
}

