/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;

public class MaterialCompanyAutoCreateProcessor
extends AbstractBusinessProcessor {
    public MaterialCompanyAutoCreateProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ApplicationContext ac = this.getExecuteContext().getApplicationContext();
        MaterialInfo matInfo = (MaterialInfo)ac.getData("matInfo");
        CompanyOrgUnitInfo comOrgInfo = (CompanyOrgUnitInfo)ac.getData("comOrgInfo");
        HashMap errors = (HashMap)ac.getData("errors");
        IMaterialCompanyInfo imatCom = MaterialCompanyInfoFactory.getLocalInstance(this.ctx);
        MaterialCompanyInfoInfo comInfo = new MaterialCompanyInfoInfo();
        comInfo.setMateial(matInfo);
        comInfo.setStatus(UsedStatusEnum.UNAPPROVE);
        comInfo.setEffectedStatus(2);
        comInfo.setCompany(comOrgInfo);
        CtrlUnitInfo curCtrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)this.ctx);
        String defaultAccountType = MaterialUtil.getParam(this.ctx, curCtrlUnitInfo.getId().toString(), "defaultAccountType");
        int intDefaultAccountType = 0;
        if (defaultAccountType != null) {
            intDefaultAccountType = Integer.parseInt(defaultAccountType);
        }
        AccountType accountType = (AccountType)((Object)AccountType.getEnumList().get(intDefaultAccountType));
        comInfo.setAccountType(accountType);
        comInfo.setCalculateType(CalculateTypeEnum.PURCHASE);
        try {
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            imatCom.addnew((CoreBaseInfo)comInfo);
        }
        catch (PermissionException e1) {
            errors.put("com", e1);
        }
    }
}

