/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialProfitCenterInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.MaterialControllerBean;
import com.kingdee.eas.basedata.master.material.app.processor.AbstractMaterialMultiApproveProcessor;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MaterialProMultiApproveProcessor
extends AbstractMaterialMultiApproveProcessor {
    private Logger logger = Logger.getLogger(MaterialProMultiApproveProcessor.class);

    public MaterialProMultiApproveProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        String ouID = (String)this.getExecuteContext().getApplicationContext().getData("ouID");
        ArrayList idList = (ArrayList)this.getExecuteContext().getApplicationContext().getData("idList");
        ResponseContext response = new ResponseContext();
        int result = 0;
        String symbol = (String)this.getExecuteContext().getApplicationContext().getData("symbol");
        if (symbol.startsWith("mulAppr.")) {
            result = this._mulApproveProfit(this.ctx, ouID, idList);
        } else if (symbol.startsWith("mulUnappr")) {
            result = this._mulUnApproveProfit(this.ctx, ouID, idList);
        }
        response.put((Object)"result", (Object)result);
        batchResults.setResponse(response);
    }

    protected int _mulApproveProfit(Context ctx, String ouID, ArrayList idList) throws BOSException, EASBizException {
        this.checkFunctionPermission(ctx, ouID, "bd_materialPro_approve");
        int count = 0;
        IMaterialProfitCenterInfo iProperty = MaterialProfitCenterInfoFactory.getLocalInstance(ctx);
        ArrayList<MaterialProfitCenterInfoInfo> baselist = null;
        ArrayList lst = MaterialControllerBean.getidsWhere(idList, "material.id");
        for (int j = 0; j < lst.size(); ++j) {
            String swhere = (String)lst.get(j);
            baselist = new ArrayList<MaterialProfitCenterInfoInfo>();
            String datapermSql = this.getDataPermissionSql(ctx, ouID, "bd_materialPro_approve");
            MaterialProfitCenterInfoCollection coll = null;
            coll = datapermSql != null && datapermSql.equals("1 = 1") ? iProperty.getMaterialProfitCenterInfoCollection("select *, material.id, material.status, material.baseUnit.*  where  status = 0 and profitCenter.id = '" + ouID + "' and " + swhere) : iProperty.getMaterialProfitCenterInfoCollection("select *, material.id, material.status, material.baseUnit.* where  status = 0 and profitCenter.id = '" + ouID + "' and " + swhere + " and " + datapermSql);
            if (coll == null) continue;
            for (int i = 0; i < coll.size(); ++i) {
                MaterialProfitCenterInfoInfo info = coll.get(i);
                baselist.add(info);
            }
            count += this.multiAssitantProfitCenterApprove(ctx, baselist, "T_BD_MaterialProfitCenterInfo");
        }
        return count;
    }

    protected int _mulUnApproveProfit(Context ctx, String ouID, ArrayList idList) throws BOSException, EASBizException {
        this.checkFunctionPermission(ctx, ouID, "bd_materialPro_unApprove");
        int count = 0;
        IMaterialProfitCenterInfo iProperty = MaterialProfitCenterInfoFactory.getLocalInstance(ctx);
        ArrayList<MaterialProfitCenterInfoInfo> baselist = null;
        ArrayList lst = MaterialControllerBean.getidsWhere(idList, "material.id");
        for (int j = 0; j < lst.size(); ++j) {
            String swhere = (String)lst.get(j);
            baselist = new ArrayList<MaterialProfitCenterInfoInfo>();
            String datapermSql = this.getDataPermissionSql(ctx, ouID, "bd_materialPro_unApprove");
            MaterialProfitCenterInfoCollection coll = null;
            coll = datapermSql != null && datapermSql.equals("1 = 1") ? iProperty.getMaterialProfitCenterInfoCollection("where  status = 1 and profitCenter.id = '" + ouID + "' and " + swhere) : iProperty.getMaterialProfitCenterInfoCollection("where  status = 1 and profitCenter.id = '" + ouID + "' and " + swhere + " and " + datapermSql);
            if (coll == null) continue;
            for (int i = 0; i < coll.size(); ++i) {
                MaterialProfitCenterInfoInfo info = coll.get(i);
                baselist.add(info);
            }
            count += this.multiAssitantProfitCenterUnApprove(ctx, baselist, "T_BD_MaterialProfitCenterInfo");
        }
        return count;
    }

    protected int multiAssitantProfitCenterUnApprove(Context ctx, List<MaterialProfitCenterInfoInfo> baselist, String tableName) throws BOSException, EASBizException {
        ArrayList<MaterialProfitCenterInfoInfo> list = new ArrayList<MaterialProfitCenterInfoInfo>();
        int count = 0;
        if (baselist != null && !baselist.isEmpty()) {
            for (int i = 0; i < baselist.size(); ++i) {
                MaterialProfitCenterInfoInfo info = baselist.get(i);
                if (info == null || info.getStatus() != UsedStatusEnum.APPROVED) continue;
                info.setStatus(UsedStatusEnum.UNAPPROVE);
                list.add(info);
            }
            count = list.size();
            if (list != null && !list.isEmpty()) {
                this.multiAssitantProfitCenterUnApproveSql(ctx, list, tableName);
            }
        }
        return count;
    }

    protected void multiAssitantProfitCenterUnApproveSql(Context ctx, List<MaterialProfitCenterInfoInfo> infolist, String tableName) throws BOSException, EASBizException {
        StringBuffer updatesql = new StringBuffer();
        UserInfo userInfo = this.getUserInfo(ctx);
        if (infolist != null && !infolist.isEmpty()) {
            updatesql.append(" update " + tableName + " set FStatus = ").append(0);
            updatesql.append(",FLastUpdateUserID='" + userInfo.getId().toString() + "',FLastUpdateTime=getDate()");
            updatesql.append("  where fid in (");
            for (int i = 0; i < infolist.size(); ++i) {
                String assitantId = infolist.get(i).getId().toString();
                updatesql.append(" '").append(assitantId.toString()).append("'");
                if (i == infolist.size() - 1) continue;
                updatesql.append(",");
            }
            updatesql.append(")");
            String updateSql = updatesql.toString();
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    private int multiAssitantProfitCenterApprove(Context ctx, List<MaterialProfitCenterInfoInfo> baselist, String tableName) throws BOSException, EASBizException {
        int count = 0;
        if (baselist != null && !baselist.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            IMaterial ima = MaterialFactory.getLocalInstance(ctx);
            for (int i = 0; i < baselist.size(); ++i) {
                MaterialInfo mainfo;
                MaterialProfitCenterInfoInfo info = baselist.get(i);
                if (info == null || (mainfo = ima.getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()))) == null || mainfo.getStatus() == UsedStatusEnum.UNAPPROVE || mainfo.getStatus() == UsedStatusEnum.FREEZED || info.getStatus() != UsedStatusEnum.UNAPPROVE) continue;
                list.add(info.getId().toString());
            }
            count = list.size();
            if (list != null && !list.isEmpty()) {
                this.multiAssitantApproveSql(ctx, list, tableName);
            }
        }
        return count;
    }

    @Override
    protected void multiAssitantApproveSql(Context ctx, List infolist, String tableName) throws BOSException, EASBizException {
        StringBuffer updatesql = new StringBuffer();
        if (infolist != null && !infolist.isEmpty()) {
            updatesql.append(" update " + tableName + " set FStatus = ").append(String.valueOf(1));
            updatesql.append("  where fid in (");
            for (int i = 0; i < infolist.size(); ++i) {
                String assitantId = infolist.get(i).toString();
                updatesql.append(" '").append(assitantId).append("'");
                if (i == infolist.size() - 1) continue;
                updatesql.append(",");
            }
            updatesql.append(")");
            String updateSql = updatesql.toString();
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }
}

