/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.webservice.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.VerifyHelper;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.EquipmentPropertyEnum;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialOtherParameter;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupDetialInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialOtherParameterCollection;
import com.kingdee.eas.basedata.master.material.MaterialOtherParameterFactory;
import com.kingdee.eas.basedata.master.material.MaterialOtherParameterInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportMaterial;
import com.kingdee.eas.basedata.master.material.app.webservice.webservice.WSDataImportTools;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.MaterialTrademarkInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.Null;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WSDataImportMaterial
extends DataImportMaterial {
    protected Boolean importDataByRule = null;
    private Map cacheUnit = new HashMap();
    private Map casheMaterialGroup = new HashMap();
    private Logger logger = Logger.getLogger(DataImportMaterial.class);
    Map casheMaterialGroupStd = new HashMap();
    Map casheAsstAttrType = new HashMap();
    Map casheOrgUnit = new HashMap();
    MaterialOtherParameterInfo materialOtherParam = null;
    public static final String resClassName = "com.kingdee.eas.basedata.master.material.MaterialResource";
    private boolean needUpdate = true;
    private Map cacheCU = new HashMap();
    private Map cacheTrademark = new HashMap();
    Map cacheMap = new HashMap();
    private Boolean isMaterialUsedCodingRule = null;
    private static final String[] mainFields = new String[]{"FNumber", "Fname_L1", "Fname_L2", "Fname_L3", "FForeignName", "FHelpCode", "FBarCode", "FModel"};

    @Override
    protected MaterialGroupInfo getMaterialGroup(Context ctx, String str, String mgroupNumber) throws BOSException {
        String key = str + "!" + mgroupNumber;
        Object rst = this.casheMaterialGroup.get(key);
        if (rst == null) {
            rst = WSDataImportTools.getGroupInfoByNumber(ctx, str, mgroupNumber);
            this.casheMaterialGroup.put(key, rst);
        }
        return (MaterialGroupInfo)rst;
    }

    @Override
    protected String getDataString(Hashtable hsData, String fieldName) {
        return WSDataImportTools.getDataString(hsData, fieldName);
    }

    protected boolean isSltImportUpdate() {
        return true;
    }

    @Override
    protected BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        return WSDataImportTools.getDataBigDecimal(hsData, fieldName);
    }

    @Override
    protected MaterialGroupStandardInfo getGroupStandardInfo(Context ctx, String str) throws BOSException {
        Object rst = this.casheMaterialGroupStd.get(str);
        if (rst == null) {
            rst = WSDataImportTools.getGroupStandardInfoByNumber(ctx, str);
            this.casheMaterialGroupStd.put(str, rst);
        }
        return (MaterialGroupStandardInfo)rst;
    }

    @Override
    protected OrgUnitInfo getOrgUnitByNumber(Context ctx, String freezeOrgUnitNumber) throws TaskExternalException {
        Object rst = this.casheOrgUnit.get(freezeOrgUnitNumber);
        if (rst == null) {
            rst = WSDataImportTools.getOrgUnitInfo(ctx, freezeOrgUnitNumber);
            this.casheOrgUnit.put(freezeOrgUnitNumber, rst);
        }
        return (OrgUnitInfo)rst;
    }

    @Override
    protected AsstAttrTypeInfo getAsstAttrTypeByNumber(Context ctx, String assistAttrnumber) throws TaskExternalException {
        Object rst = this.casheAsstAttrType.get(assistAttrnumber);
        if (rst == null) {
            rst = WSDataImportTools.getAsstAttrTypeInfo(ctx, assistAttrnumber);
            this.casheAsstAttrType.put(assistAttrnumber, rst);
        }
        return (AsstAttrTypeInfo)rst;
    }

    @Override
    protected MeasureUnitInfo getMesureUnitByNumber(Context ctx, String volumnUnitNumber) throws TaskExternalException {
        Object rst = this.cacheUnit.get(volumnUnitNumber);
        if (rst == null) {
            rst = WSDataImportTools.getMeasureUnitInfo(ctx, volumnUnitNumber);
            this.cacheUnit.put(volumnUnitNumber, rst);
        }
        return (MeasureUnitInfo)rst;
    }

    @Override
    protected MaterialInfo getMaterialByNumber(Context ctx, String number) throws BOSException {
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        WSDataImportTools.AddFilterItemInfo(filter, "number", number);
        IMaterial iMat = MaterialFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = WSDataImportTools.getViewInfo(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("materialGroupDetails.materialGroupStandard.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("materialGroupDetails.materialGroup.*"));
        MaterialCollection matCollection = iMat.getMaterialCollection(viewInfo);
        MaterialInfo info = null;
        if (matCollection != null && matCollection.size() > 0) {
            info = matCollection.get(0);
            info.setId(matCollection.get(0).getId());
            info.setCU(matCollection.get(0).getCU());
            info.setAdminCU(matCollection.get(0).getAdminCU());
        }
        return info;
    }

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    @Override
    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            CtrlUnitInfo cu;
            MaterialOtherParameterInfo param;
            String strMsg;
            ICodingRuleManager iCodingRuleManager;
            String orgId;
            MaterialInfo materialInfo = (MaterialInfo)coreBaseInfo;
            if (materialInfo != null && materialInfo.getName() != null && materialInfo.getName().indexOf(";") != -1) {
                throw new MaterialBaseException(MaterialBaseException.SEMICOLONNOTALLOW4IMPORT);
            }
            if (materialInfo.getId() == null && this.isMaterialUsedCodingRule(ctx, orgId = (iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).getCurrentAppOUID((IObjectValue)coreBaseInfo)) && this.importDataByRule.booleanValue()) {
                String number = this.getNumberByCodingRule(ctx, (IObjectValue)coreBaseInfo);
                if (number != null && number.trim().length() != 0) {
                    materialInfo.setNumber(number);
                } else {
                    if (this.importDataByRule.booleanValue()) {
                        throw new TaskExternalException(WSDataImportTools.getResString(resClassName, "DataImport_HasNoRule_WithPara", ctx.getLocale()));
                    }
                    VerifyHelper.checkBlank((Context)ctx, (IObjectValue)materialInfo, (String)"number");
                }
            }
            if ((strMsg = this.checkBaseInfoDup(ctx, param = this.getMaterialOtherParam(ctx, (cu = ContextUtil.getCurrentCtrlUnit((Context)ctx)).getId().toString()), materialInfo)) != null && strMsg.trim().length() > 0) {
                strMsg = strMsg + ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"CannotSubmit_Dup", (Locale)ctx.getOriginLocale());
                throw new BOSException(strMsg);
            }
            materialInfo.put("isImport", "true");
            long beginTime = System.currentTimeMillis();
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                if (!this.needUpdate) {
                    return;
                }
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("import submit cost:" + (endTime - beginTime) + "ms."));
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    @Override
    protected CoreBaseInfo createHead(Hashtable hsData, Context ctx) throws Exception {
        try {
            return this.innerTransmit(hsData, ctx);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private MaterialOtherParameterInfo getMaterialOtherParam(Context ctx, String cuId) {
        if (this.materialOtherParam != null) {
            return this.materialOtherParam;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu", (Object)cuId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        try {
            IMaterialOtherParameter iMaterialOtherParam = MaterialOtherParameterFactory.getLocalInstance(ctx);
            MaterialOtherParameterCollection collection = iMaterialOtherParam.getMaterialOtherParameterCollection(viewInfo);
            this.materialOtherParam = collection != null && collection.size() != 0 ? collection.get(0) : MaterialOtherParameterInfo.getDefaultParam();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return this.materialOtherParam;
    }

    private FilterInfo getFilterDup(MaterialInfo info, String fieldName, Object compareValue, CompareType compareType) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo(fieldName, compareValue, compareType);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3), CompareType.NOTEQUALS));
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        return filter;
    }

    private String checkBaseInfoDup(Context ctx, MaterialOtherParameterInfo currentMaterialOtherPara, MaterialInfo info) throws Exception {
        String strMsg = "";
        IMaterial iMat = MaterialFactory.getLocalInstance(ctx);
        if (currentMaterialOtherPara.isNameSelected() && info.getName() != null && !"".equals(info.getName()) && iMat.exists(this.getFilterDup(info, "name", info.getName(), CompareType.EQUALS))) {
            strMsg = ResourceBase.getString((String)resClassName, (String)"Dup_Name", (Locale)ctx.getOriginLocale()) + "\r\n";
        }
        if (currentMaterialOtherPara.isEnglishSelected() && info.getForeignname() != null && !"".equals(info.getForeignname()) && iMat.exists(this.getFilterDup(info, "foreignname", info.getForeignname(), CompareType.EQUALS))) {
            strMsg = strMsg + ResourceBase.getString((String)resClassName, (String)"Dup_Foreignname", (Locale)ctx.getOriginLocale()) + "\r\n";
        }
        if (currentMaterialOtherPara.isHelpSelected() && info.getHelpCode() != null && !"".equals(info.getHelpCode()) && iMat.exists(this.getFilterDup(info, "helpcode", info.getHelpCode(), CompareType.EQUALS))) {
            strMsg = strMsg + ResourceBase.getString((String)resClassName, (String)"Dup_HelpCode", (Locale)ctx.getOriginLocale()) + "\r\n";
        }
        if (currentMaterialOtherPara.isBarCodeSelected() && info.getBarCode() != null && !"".equals(info.getBarCode()) && iMat.exists(this.getFilterDup(info, "barcode", info.getBarCode(), CompareType.EQUALS))) {
            strMsg = strMsg + ResourceBase.getString((String)resClassName, (String)"Dup_BarCode", (Locale)ctx.getOriginLocale()) + "\r\n";
        }
        if (currentMaterialOtherPara.isModeSelected() && info.getModel() != null && !"".equals(info.getModel()) && iMat.exists(this.getFilterDup(info, "model", info.getModel(), CompareType.EQUALS))) {
            strMsg = strMsg + ResourceBase.getString((String)resClassName, (String)"Dup_Model", (Locale)ctx.getOriginLocale()) + "\r\n";
        }
        if (currentMaterialOtherPara.isMameAndMode() && info.getName() != null && !"".equals(info.getName())) {
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterNameEQ = new FilterItemInfo("name", (Object)info.getName(), CompareType.EQUALS);
            FilterItemInfo filterIDNotEQ = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filterInfo.getFilterItems().add(filterNameEQ);
            filterInfo.getFilterItems().add(filterIDNotEQ);
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3), CompareType.NOTEQUALS));
            FilterItemInfo filterModelEQ = null;
            FilterItemInfo filterModelNull = null;
            if (info.getModel() != null && !"".equals(info.getModel())) {
                filterModelEQ = new FilterItemInfo("model", (Object)info.getModel(), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterModelEQ);
                filterInfo.setMaskString("#0 and #1 and #2 and #3)");
            } else {
                filterModelEQ = new FilterItemInfo("model", (Object)"", CompareType.EQUALS);
                filterModelNull = new FilterItemInfo("model", null, CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterModelEQ);
                filterInfo.getFilterItems().add(filterModelNull);
                filterInfo.setMaskString("#0 and #1 and #2 and (#3 or #4)");
            }
            if (iMat.exists(filterInfo)) {
                strMsg = strMsg + ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"Dup_Name_And_Model", (Locale)ctx.getOriginLocale()) + "\r\n";
            }
        }
        return strMsg;
    }

    private CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws Exception {
        String str = null;
        MaterialInfo oldInfo = null;
        if (this.importDataByRule == null) {
            this.importDataByRule = DataImportUtils.getImportParamBooleanObject((Context)ctx);
        }
        str = (String)hsData.get("FNumber");
        if (this.isSltImportUpdate()) {
            oldInfo = this.getMaterialByNumber(ctx, str);
        }
        if (this.isSltImportUpdate() && oldInfo != null) {
            if (!oldInfo.getCU().equalsPK((IObjectValue)ContextUtil.getCurrentCtrlUnit((Context)ctx))) {
                throw new TaskExternalException(WSDataImportTools.getResString(resClassName, "CANNOT_UPDATE_OTHER_CU", ctx.getLocale()));
            }
            if (oldInfo.getStatus() == UsedStatusEnum.FREEZED) {
                throw new MaterialBaseException(MaterialBaseException.FREEZED_INVALID, new Object[]{oldInfo.getName()});
            }
            if (UsedStatusEnum.DELETED == oldInfo.getStatus()) {
                throw new MaterialBaseException(MaterialBaseException.CANNOT_UPDATE);
            }
        }
        MaterialInfo info = null;
        info = oldInfo == null ? new MaterialInfo() : (MaterialInfo)oldInfo.clone();
        if (str != null) {
            info.setNumber(str.trim());
        }
        if (info.getId() != null) {
            this.handleInfoForUpdate(hsData, ctx, info, oldInfo);
        } else {
            this.handleInfoForAddNew(hsData, ctx, info);
        }
        return info;
    }

    private void handleInfoForUpdate(Hashtable hsData, Context ctx, MaterialInfo info, MaterialInfo oldInfo) throws Exception {
        this.handleInfoForAddAndUpdate(hsData, ctx, info);
        String str = null;
        str = this.getDataString(hsData, "FBaseUnit");
        if (str == null || "".equals(str)) {
            throw new TaskExternalException(WSDataImportTools.getResString(resClassName, "DataImport_BaseUnit_NotNull", ctx.getLocale()));
        }
        MeasureUnitInfo baseUnit = this.getMesureUnitByNumber(ctx, str);
        this.checkBaseUnit(ctx, baseUnit);
        info.setBaseUnit(baseUnit);
        info.setAssistUnit(this.getMesureUnitByNumber(ctx, this.getDataString(hsData, "FAssistUnit")));
        MeasureUnitInfo mesureUnitInfo = this.getMesureUnitByNumber(ctx, this.getDataString(hsData, "FSeqUnitID"));
        this.checkMulUnit(ctx, info, mesureUnitInfo);
        info.setSeqUnit(mesureUnitInfo);
        str = this.getDataString(hsData, "Fname_" + "l2".toUpperCase());
        if (str != null && str.trim().length() > 0) {
            info.setName(str, new Locale("l2"));
        }
        if ((str = this.getDataString(hsData, "Fname_" + "l3".toUpperCase())) != null && str.trim().length() > 0) {
            info.setName(str, new Locale("l3"));
        }
        if ((str = this.getDataString(hsData, "Fname_" + "l1".toUpperCase())) != null && str.trim().length() > 0) {
            info.setName(str, new Locale("l1"));
        }
        info.setAssistUnit(this.getMesureUnitByNumber(ctx, this.getDataString(hsData, "FAssistUnit")));
        String importDataModel = DataImportUtils.getImportDataModel((Context)ctx);
        boolean baseEquals = true;
        if (importDataModel.equals("0")) {
            if (oldInfo != null && oldInfo.getStatus() == UsedStatusEnum.APPROVED) {
                MaterialInfo oldMaterial = null;
                MaterialInfo newMaterial = null;
                MaterialInfo tempOldMat = null;
                MaterialInfo tempNewMat = null;
                if (info != null) {
                    oldMaterial = (MaterialInfo)oldInfo.clone();
                    newMaterial = (MaterialInfo)info.clone();
                    tempOldMat = (MaterialInfo)oldInfo.clone();
                    tempNewMat = (MaterialInfo)info.clone();
                    oldMaterial.getMaterialGroupDetails().clear();
                    newMaterial.getMaterialGroupDetails().clear();
                    if (!this.compare(oldMaterial, newMaterial)) {
                        baseEquals = false;
                        throw new MaterialBaseException(MaterialBaseException.APPROVE_INVALID, new Object[]{info.getName()});
                    }
                    baseEquals = true;
                    this.needUpdate = !this.compare(tempOldMat, tempNewMat) ? baseEquals : false;
                }
            } else {
                this.needUpdate = !this.compare(oldInfo, info);
            }
        } else if (importDataModel.equals("1")) {
            this.needUpdate = !this.compare(oldInfo, info);
            info.setStatus(UsedStatusEnum.UNAPPROVE);
        } else if (importDataModel.equals("2")) {
            this.needUpdate = !this.compare(oldInfo, info);
        }
    }

    private boolean compare(MaterialInfo oldInfo, MaterialInfo newInfo) {
        oldInfo.keys();
        Enumeration keys = oldInfo.keys();
        String key = null;
        boolean isEqual = false;
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            isEqual = WSDataImportMaterial.compareValue(oldInfo.get(key), newInfo.get(key));
            if (isEqual) continue;
            return false;
        }
        return true;
    }

    private boolean compare(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (!(obj1 instanceof Map) || !(obj2 instanceof Map)) {
            return false;
        }
        Map value1 = null;
        Map value2 = null;
        if (((Map)obj1).size() < ((Map)obj2).size()) {
            value1 = (Map)obj2;
            value2 = (Map)obj1;
        } else {
            value1 = (Map)obj1;
            value2 = (Map)obj2;
        }
        try {
            for (Map.Entry e : value1.entrySet()) {
                boolean isEqual;
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value instanceof AbstractObjectCollection ? !(isEqual = ((AbstractObjectCollection)value).compareNewToOld()) : !(isEqual = WSDataImportMaterial.compareValue(value, value2.get(key))))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    private static boolean isEmptyObject(Object s) {
        if (s instanceof String) {
            return ((String)s).trim().length() == 0;
        }
        return s == null || s == Null.NULL;
    }

    private static boolean compareValue(Object value1, Object value2) {
        if (value1 instanceof Boolean || value2 instanceof Boolean) {
            Boolean bool1 = value1 == null ? Boolean.FALSE : (Boolean)value1;
            Boolean bool2 = value2 == null ? Boolean.FALSE : (Boolean)value2;
            return bool1.booleanValue() == bool2.booleanValue();
        }
        if (WSDataImportMaterial.isEmptyObject(value1) && WSDataImportMaterial.isEmptyObject(value2)) {
            return true;
        }
        if (WSDataImportMaterial.isEmptyObject(value1) || WSDataImportMaterial.isEmptyObject(value2)) {
            return false;
        }
        if (value1 instanceof Byte) {
            return ((Byte)value1).compareTo((Byte)value2) == 0;
        }
        if (value1 instanceof Short) {
            return ((Short)value1).compareTo((Short)value2) == 0;
        }
        if (value1 instanceof Integer) {
            return ((Integer)value1).compareTo((Integer)value2) == 0;
        }
        if (value1 instanceof Long) {
            return ((Long)value1).compareTo((Long)value2) == 0;
        }
        if (value1 instanceof Float) {
            return ((Float)value1).compareTo((Float)value2) == 0;
        }
        if (value1 instanceof Double) {
            return ((Double)value1).compareTo((Double)value2) == 0;
        }
        if (value1 instanceof BigDecimal) {
            return ((BigDecimal)value1).compareTo((BigDecimal)value2) == 0;
        }
        if (value1 instanceof String) {
            return ((String)value1).equals((String)value2);
        }
        if (value1 instanceof Date) {
            return DateTimeUtils.dayEquals((Date)((Date)value1), (Date)((Date)value2));
        }
        if (value1 instanceof Time) {
            return ((Time)value1).compareTo((Time)value2) == 0;
        }
        if (value1 instanceof Timestamp) {
            return DateTimeUtils.dayEquals((Date)((Date)value1), (Date)((Date)value2));
        }
        if (value1 instanceof Object[]) {
            Object[] arrValue1 = (Object[])value1;
            Object[] arrValue2 = (Object[])value2;
            if (arrValue1.length != arrValue2.length) {
                return false;
            }
            boolean retValue = true;
            for (int i = 0; i < arrValue1.length && retValue; ++i) {
                retValue = WSDataImportMaterial.compareValue(arrValue1[i], arrValue2[i]);
            }
            return retValue;
        }
        if (value1 instanceof AbstractObjectValue) {
            AbstractObjectValue objectValue1 = (AbstractObjectValue)value1;
            AbstractObjectValue objectValue2 = (AbstractObjectValue)value2;
            String pkField1 = objectValue1.getPKField();
            String pkField2 = objectValue1.getPKField();
            if (pkField1 != null && pkField2 != null) {
                if (pkField1.equals(pkField2)) {
                    return WSDataImportMaterial.compareValue(objectValue1.get(pkField1), objectValue2.get(pkField2));
                }
                return false;
            }
        }
        return value1.equals(value2);
    }

    private void checkBaseUnit(Context ctx, MeasureUnitInfo baseUnit) throws TaskExternalException {
        if (baseUnit.isIsDisabled()) {
            String pattern = ResourceBase.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"UnitDisabled", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(MessageFormat.format(pattern, baseUnit.getNumber()));
        }
    }

    private void handleInfoForAddNew(Hashtable hsData, Context ctx, MaterialInfo info) throws Exception {
        String str = this.getDataString(hsData, "Fname_" + "l2".toUpperCase());
        info.setName(str, new Locale("l2"));
        str = this.getDataString(hsData, "Fname_" + "l3".toUpperCase());
        info.setName(str, new Locale("l3"));
        str = this.getDataString(hsData, "Fname_" + "l1".toUpperCase());
        info.setName(str, new Locale("l1"));
        str = this.getDataString(hsData, "FBaseUnit");
        if (str == null || "".equals(str)) {
            throw new TaskExternalException(WSDataImportTools.getResString(resClassName, "DataImport_BaseUnit_NotNull", ctx.getLocale()));
        }
        MeasureUnitInfo baseUnit = this.getMesureUnitByNumber(ctx, str);
        this.checkBaseUnit(ctx, baseUnit);
        info.setBaseUnit(baseUnit);
        info.setAssistUnit(this.getMesureUnitByNumber(ctx, this.getDataString(hsData, "FAssistUnit")));
        MeasureUnitInfo mesureUnitInfo = this.getMesureUnitByNumber(ctx, this.getDataString(hsData, "FSeqUnitID"));
        if (mesureUnitInfo != null && !mesureUnitInfo.getMeasureUnitGroup().getId().equals((Object)info.getBaseUnit().getMeasureUnitGroup().getId())) {
            throw new TaskExternalException(WSDataImportTools.getResString(resClassName, "seqUnitNotMulUnit", ctx.getLocale()));
        }
        info.setSeqUnit(mesureUnitInfo);
        String assistAttrnumber = this.getDataString(hsData, "FAssistAttr");
        info.setAssistAttr(this.getAsstAttrTypeByNumber(ctx, assistAttrnumber));
        String cuNumber = this.getDataString(hsData, "FControlUnitID");
        info.setCU(this.getCUByNumber(ctx, cuNumber));
        info.setEffectedStatus(2);
        this.handleInfoForAddAndUpdate(hsData, ctx, info);
    }

    protected CtrlUnitInfo getCUByNumber(Context ctx, String cuNumber) throws TaskExternalException, BOSException {
        Object rst = this.cacheCU.get(cuNumber);
        if (rst == null) {
            rst = WSDataImportTools.getCtrlUnitInfoFromNumber(ctx, cuNumber);
            this.cacheCU.put(cuNumber, rst);
            if (rst == null) {
                return ContextUtil.getCurrentCtrlUnit((Context)ctx);
            }
        }
        return (CtrlUnitInfo)rst;
    }

    private void handleInfoForAddAndUpdate(Hashtable hsData, Context ctx, MaterialInfo info) throws Exception {
        info.setForeignname(this.getDataString(hsData, "FForeignName"));
        info.setShortName(this.getDataString(hsData, "FShortName"));
        info.setAlias(this.getDataString(hsData, "FAlias"));
        info.setModel(this.getDataString(hsData, "FModel"));
        info.setHelpCode(this.getDataString(hsData, "FHelpCode"));
        info.setBarCode(this.getDataString(hsData, "FBarCode"));
        info.setRegisteredmark(this.getDataString(hsData, "FRegisteredMark"));
        info.setWarrantnumber(this.getDataString(hsData, "FWarrantNumber"));
        info.setPictureNumber(this.getDataString(hsData, "FPictureNumber"));
        info.setIsOutsourcedPart(WSDataImportTools.getDataboolean(hsData, "FIsOutsourcedPart"));
        info.setUseAsstAttrRelation(WSDataImportTools.getDataboolean(hsData, "FUseAsstAttrRelation"));
        String str = this.getDataString(hsData, "FVersion");
        int pricePre = WSDataImportTools.getDataint(hsData, "FPricePrecision");
        if (pricePre <= 0) {
            pricePre = 6;
        }
        info.setPricePrecision(pricePre);
        if (str != null && !"".equals(str)) {
            info.setVersion(new Integer(str));
        } else {
            info.setVersion(0);
        }
        String WeightUnitNumber = this.getDataString(hsData, "FWeightUnit");
        info.setWeightUnit(this.getMesureUnitByNumber(ctx, WeightUnitNumber));
        info.setGrossWeight(this.getDataBigDecimal(hsData, "FGrossWeight"));
        info.setNetWeight(this.getDataBigDecimal(hsData, "FNetWeight"));
        BigDecimal bgGross = info.getGrossWeight();
        BigDecimal bgNet = info.getNetWeight();
        if (bgGross != null && bgNet != null && bgNet.compareTo(bgGross) > 0) {
            throw new TaskExternalException(WSDataImportTools.getResString(resClassName, "Gross_Net_Compair", ctx.getLocale()));
        }
        String lengthUnitNumber = this.getDataString(hsData, "FLengthUnit");
        info.setLengthUnit(this.getMesureUnitByNumber(ctx, lengthUnitNumber));
        info.setLength(this.getDataBigDecimal(hsData, "FLength"));
        info.setWidth(this.getDataBigDecimal(hsData, "FWidth"));
        info.setHeight(this.getDataBigDecimal(hsData, "FHeight"));
        info.setEquipProperty(WSDataImportTools.getEquipmentPropertyEnum(this.getDataString(hsData, "FEquipProperty"), ctx));
        String volumnUnitNumber = this.getDataString(hsData, "FVolumnUnit");
        info.setVolumnUnit(this.getMesureUnitByNumber(ctx, volumnUnitNumber));
        info.setVolume(this.getDataBigDecimal(hsData, "FVolume"));
        if (info.getVolume() != null && info.getVolumnUnit() == null) {
            throw new TaskExternalException(WSDataImportTools.getResString(resClassName, "VolumeUnit_Not_Null", ctx.getLocale()));
        }
        String freezeOrgUnitNumber = this.getDataString(hsData, "FFreezeOrgUnit");
        OrgUnitInfo ou = this.getOrgUnitByNumber(ctx, freezeOrgUnitNumber);
        if (ou != null) {
            info.setFreezeOrgUnit(ou.castToFullOrgUnitInfo());
            info.setStatus(UsedStatusEnum.FREEZED);
        } else {
            info.setFreezeOrgUnit(null);
            info.setStatus(WSDataImportTools.getStatusEnum(this.getDataString(hsData, "FStatus"), ctx));
            if (info.getStatus() != null && UsedStatusEnum.FREEZED.equals((Object)info.getStatus()) && ou == null) {
                throw new TaskExternalException(WSDataImportTools.getResString(resClassName, "DataImport_FreezeOU_NotNull", ctx.getLocale()));
            }
        }
        String assistAttrnumber = this.getDataString(hsData, "FAssistAttr");
        info.setAssistAttr(this.getAsstAttrTypeByNumber(ctx, assistAttrnumber));
        String materialTrademarkNumber = this.getDataString(hsData, "FMaterialTrademark");
        MaterialTrademarkInfo trademarkInfo = null;
        if (materialTrademarkNumber != null && materialTrademarkNumber.trim().length() > 0) {
            CtrlUnitInfo cu = info.getCU() == null ? ContextUtil.getCurrentCtrlUnit((Context)ctx) : info.getCU();
            trademarkInfo = this.getTrademarkInfoByNumber(ctx, cu, materialTrademarkNumber);
        }
        info.setMaterialTrademark(trademarkInfo);
    }

    protected MaterialTrademarkInfo getTrademarkInfoByNumber(Context ctx, CtrlUnitInfo cu, String materialTrademarkNumber) throws TaskExternalException {
        Object rst = this.cacheTrademark.get(materialTrademarkNumber);
        if (rst == null) {
            rst = WSDataImportTools.getMaterialTrademark(ctx, cu, materialTrademarkNumber);
            this.cacheTrademark.put(materialTrademarkNumber, rst);
        }
        return (MaterialTrademarkInfo)rst;
    }

    private void checkMulUnit(Context ctx, MaterialInfo info, MeasureUnitInfo mesureUnitInfo) throws BOSException, EASBizException, TaskExternalException {
        if (mesureUnitInfo != null) {
            String materialId = info.getId().toString();
            String mesureUnitId = mesureUnitInfo.getId().toString();
            MultiMeasureUnitInfo multiUnit = MultiMeasureUnitFactory.getLocalInstance(ctx).getMultiUnit(materialId, mesureUnitId);
            if (multiUnit == null) {
                throw new TaskExternalException(WSDataImportTools.getResString(resClassName, "seqUnitNotMulUnit", ctx.getLocale()));
            }
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("materialGroupDetails.id"));
        sic.add(new SelectorItemInfo("materialGroupDetails.materialGroupStandard.*"));
        sic.add(new SelectorItemInfo("materialGroupDetails.materialGroup.*"));
        sic.add(new SelectorItemInfo("materialGroupDetails.material.*"));
        return sic;
    }

    @Override
    protected void createEntry(CoreBaseInfo head, Hashtable hsData, Context ctx) throws Exception {
        int pos;
        MaterialInfo materialInfo = (MaterialInfo)head;
        MaterialGroupDetialInfo detailInfo = new MaterialGroupDetialInfo();
        Object data = null;
        data = hsData.get("FMaterialGroupStandardID");
        if (data == null || data.toString().trim().length() == 0) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"standardNotExist", (Context)ctx));
        }
        String groupStandardNumber = data.toString();
        MaterialGroupStandardInfo groupStandardInfo = (MaterialGroupStandardInfo)this.cacheMap.get("standard:" + groupStandardNumber);
        if (groupStandardInfo == null) {
            groupStandardInfo = WSDataImportTools.getGroupStandardInfoByNumber(ctx, groupStandardNumber);
            this.cacheMap.put("standard:" + groupStandardNumber, groupStandardInfo);
        }
        if (groupStandardInfo == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"standardNotExist", (Context)ctx));
        }
        detailInfo.setMaterialGroupStandard(groupStandardInfo);
        data = hsData.get("FMaterialGroupID");
        if (data == null || data.toString().trim().length() == 0) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"groupNotExist", (Context)ctx));
        }
        MaterialGroupInfo groupInfo = (MaterialGroupInfo)this.cacheMap.get("group:" + data.toString() + groupStandardNumber);
        if (groupInfo == null) {
            groupInfo = WSDataImportTools.getGroupInfoByNumber(ctx, data.toString(), groupStandardNumber);
            this.cacheMap.put("group:" + data.toString() + groupStandardNumber, groupInfo);
        }
        if (groupInfo == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"groupNotExist", (Context)ctx));
        }
        if (groupInfo.getCU() != null && groupInfo.getCU().getLongNumber() != null && materialInfo.getCU() != null && materialInfo.getCU().getLongNumber() != null && (materialInfo.getCU().getLongNumber() + "!").indexOf(groupInfo.getCU().getLongNumber() + "!") < 0) {
            throw new MaterialBaseException(MaterialBaseException.GROUP_INVALID, new Object[]{groupInfo.getNumber(), materialInfo.getCU().getNumber()});
        }
        detailInfo.setMaterialGroup(groupInfo);
        if (MaterialGroupStandardTypeEnum.BasicStandard == groupStandardInfo.getStandardType()) {
            materialInfo.setMaterialGroup(groupInfo);
        }
        if ((pos = CSSPUtils.isInCollection((IObjectValue)detailInfo, (IObjectCollection)materialInfo.getMaterialGroupDetails(), (String)"materialGroupStandard")) < 0) {
            materialInfo.getMaterialGroupDetails().add(detailInfo);
        } else {
            detailInfo.setId(materialInfo.getMaterialGroupDetails().get(pos).getId());
            materialInfo.getMaterialGroupDetails().set(pos, detailInfo);
        }
    }

    @Override
    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String multiName = "Fname_" + WSDataImportTools.getLoc(ctx);
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, multiName, rs.getString("name"));
            this.putTable(result, "FForeignName", rs.getString("foreignname"));
            this.putTable(result, "FMaterialGroupStandardID", rs.getString("materialGroupStandard.number"));
            this.putTable(result, "FMaterialGroupID", rs.getString("BrowserGroup.number"));
            this.putTable(result, "FShortName", rs.getString("shortName"));
            this.putTable(result, "FAlias", rs.getString("alias"));
            this.putTable(result, "FModel", rs.getString("model"));
            this.putTable(result, "FBaseUnit", rs.getString("baseUnit.number"));
            this.putTable(result, "FAssistUnit", rs.getString("assistUnit.number"));
            this.putTable(result, "FSeqUnitID", rs.getString("seqUnit.number"));
            this.putTable(result, "FPricePrecision", rs.getString("pricePrecision"));
            this.putTable(result, "FHelpCode", rs.getString("helpCode"));
            this.putTable(result, "FBarCode", rs.getString("barCode"));
            this.putTable(result, "FRegisteredMark", rs.getString("registeredmark"));
            this.putTable(result, "FWarrantNumber", rs.getString("warrantnumber"));
            this.putTable(result, "FPictureNumber", rs.getString("pictureNumber"));
            this.putTable(result, "FAssistAttr", rs.getString("assistAttr.number"));
            this.putTable(result, "FVersion", rs.getString("version"));
            this.putTable(result, "FGrossWeight", rs.getString("grossWeight"));
            this.putTable(result, "FNetWeight", rs.getString("netWeight"));
            this.putTable(result, "FWeightUnit", rs.getString("weightUnit.number"));
            this.putTable(result, "FLength", rs.getString("length"));
            this.putTable(result, "FWidth", rs.getString("width"));
            this.putTable(result, "FHeight", rs.getString("height"));
            this.putTable(result, "FLengthUnit", rs.getString("lengthUnit.number"));
            this.putTable(result, "FVolume", rs.getString("volume"));
            this.putTable(result, "FVolumnUnit", rs.getString("volumnUnit.number"));
            this.putTable(result, "FFreezeOrgUnit", rs.getString("freezeOrgUnit.number"));
            this.putTable(result, "FStatus", UsedStatusEnum.getEnum(rs.getInt("status")).getAlias(ctx.getLocale()));
            this.putTable(result, "FEquipProperty", EquipmentPropertyEnum.getEnum(rs.getInt("equipProperty")).getAlias(ctx.getLocale()));
            result.put("FIsOutsourcedPart", DataImportUtils.transformValue((Object)rs.getString("isOutsourcedPart")));
            result.put("FUseAsstAttrRelation", DataImportUtils.transformValue((Object)rs.getString("useAsstAttrRelation")));
            this.putTable(result, "FCreatorNumber", rs.getString("creator.number"));
            this.putTable(result, "FCreateTime", DataImportUtils.getDateStrByLocale((Context)ctx, (Date)rs.getDate("createTime")));
            this.putTable(result, "FMaterialTrademark", rs.getString("materialTrademark.number"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    @Override
    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        try {
            IMaterial imat = MaterialFactory.getLocalInstance(ctx);
            pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo = imat.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    @Override
    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.material.app.ExpMaterialQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        WSDataImportTools.putToHashtable(htable, key, value);
    }

    private boolean isMaterialUsedCodingRule(Context ctx, String orgId) throws CodingRuleException, EASBizException, BOSException {
        if (this.isMaterialUsedCodingRule != null) {
            return this.isMaterialUsedCodingRule;
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        MaterialInfo info = new MaterialInfo();
        boolean exist = iCodingRuleManager.isExist((IObjectValue)info, orgId);
        this.isMaterialUsedCodingRule = exist;
        return exist;
    }

    @Override
    protected String getNumberByCodingRule(Context ctx, IObjectValue caller) throws BOSException, CodingRuleException, EASBizException {
        String number = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String orgId = iCodingRuleManager.getCurrentAppOUID(caller);
        if (this.isMaterialUsedCodingRule(ctx, orgId)) {
            if (orgId == null || orgId.trim().length() == 0) {
                orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            }
            if (this.isMaterialUsedCodingRule(ctx, orgId)) {
                IMaterial iMaterial = MaterialFactory.getLocalInstance(ctx);
                MaterialInfo materialInfo = (MaterialInfo)caller;
                number = iMaterial.readNewNumber(orgId, materialInfo);
            }
        }
        return number;
    }

    @Override
    protected String[] getMainFields() {
        if (super.isSltImportUpdate()) {
            return new String[]{"FNumber"};
        }
        return mainFields;
    }
}

