/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.tools.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.basedata.master.material.tools.app.AbstractSqlEditorServerControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.CodeSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SqlEditorServerControllerBean
extends AbstractSqlEditorServerControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.tools.SqlEditorServerControllerBean");

    @Override
    protected Object _invokeMethod(Context ctx, String methodName, Object[] parameters) throws BOSException, EASBizException {
        Object returnValue = null;
        if (methodName == null || "".equals(methodName)) {
            return null;
        }
        if (methodName.equals("getDBType")) {
            returnValue = this.getDBType(ctx);
        }
        if (methodName.equals("getDatacenterMap")) {
            returnValue = this.getDatacenterMap(ctx);
        }
        if (methodName.equals("getCodeSource")) {
            try {
                Class<?> c = Class.forName((String)parameters[0]);
                returnValue = this.getCodeSource(c);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e);
                returnValue = e;
            }
            catch (NoClassDefFoundError e) {
                logger.error((Object)e);
                returnValue = e;
            }
            catch (Exception e) {
                logger.error((Object)e);
                returnValue = e;
            }
        }
        if (methodName.equals("getSysProperty")) {
            returnValue = this.getSysProperty(ctx, parameters);
        }
        if (methodName.equals("getMetaPath")) {
            returnValue = this.getMetaPath(ctx);
        }
        return returnValue;
    }

    protected String getMetaPath(Context ctx) {
        return System.getProperty("metadata.path");
    }

    protected Map getDatacenterMap(Context ctx) throws BOSException {
        Map map = new HashMap();
        try {
            String path = System.getProperty("datacenter.config");
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxFactory.newSAXParser();
            File file = new File(path);
            DataCenterHandler dh = new DataCenterHandler(ctx);
            saxParser.parse(file, (DefaultHandler)dh);
            map = dh.getAttributeMap();
        }
        catch (ParserConfigurationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SAXException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    protected Object getDBType(Context ctx) throws BOSException {
        Integer returnValue;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            returnValue = KSqlUtil.getDbType((Connection)con);
        }
        catch (SQLDataException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return returnValue;
    }

    protected String getSysProperty(Context ctx, Object[] parameters) {
        String proName = (String)parameters[0];
        return System.getProperty(proName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getCodeSource(Class c) throws Exception {
        String returnValue = "";
        CodeSource cs = c.getProtectionDomain().getCodeSource();
        if (cs != null) {
            returnValue = returnValue + cs.getLocation().getFile() + "\n";
            returnValue = returnValue + "show jar info:\n";
            try (ZipFile jf = null;){
                jf = new JarFile(cs.getLocation().getFile());
                JarEntry entry = ((JarFile)jf).getJarEntry("META-INF/MANIFEST.MF");
                InputStream input = ((JarFile)jf).getInputStream(entry);
                String info = this.readFile(input);
                returnValue = returnValue + info + "\n";
                jf.close();
            }
        }
        return returnValue;
    }

    private String readFile(InputStream input) throws Exception {
        String returnValue = "";
        InputStreamReader isr = new InputStreamReader(input);
        BufferedReader reader = new BufferedReader(isr);
        String line = "";
        while ((line = reader.readLine()) != null) {
            returnValue = returnValue + line + "\n";
        }
        reader.close();
        return returnValue;
    }

    class DataCenterHandler
    extends DefaultHandler {
        Context ctx = null;
        Map attributeMap = new HashMap();

        DataCenterHandler(Context ctx) {
            this.ctx = ctx;
        }

        @Override
        public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
            super.startElement(arg0, arg1, arg2, arg3);
            if (arg3.getValue("id") != null && arg3.getValue("id").equals(this.ctx.getAIS())) {
                this.attributeMap.put("dbuser", arg3.getValue("dbuser"));
            }
        }

        public Map getAttributeMap() {
            return this.attributeMap;
        }
    }
}

