/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.UnAssign2CheckResult;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MaterialUtils {
    private static final String PRODUCT_SERVICE_NAME = "com.kingdee.eas.tm.im.util.invoice.ProductCodeSyncService";
    private static final String PRODUCT_METHOD_NAME = "syncProductCode";
    public static final BOSObjectType MATERIAL_BOSTYPE = BOSObjectType.create((String)"4409E7F0");
    private static final Logger logger = Logger.getLogger((String)MaterialUtils.class.getSimpleName());

    public static void checkCU(Context ctx, String infoCuId) throws BOSException, EASBizException {
        CtrlUnitInfo curCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (curCU != null && !curCU.getId().toString().equals(infoCuId)) {
            throw new MaterialBaseException(MaterialBaseException.CANNOT_MODIFY_OTHER_CU);
        }
    }

    public static String getReferedExcMsg(ObjectReferedException exc, Context ctx) {
        StringBuffer msg = new StringBuffer();
        String commonResource = "com.kingdee.eas.common.CommonResource";
        BizReference ref = (BizReference)exc.getReferingObject();
        if (ref != null) {
            Object[] objects = new Object[]{ref.getRefEntityAlias(ctx.getLocale())};
            String template = ResourceBase.getString((String)commonResource, (String)"isReferedError", (Locale)ctx.getOriginLocale());
            msg.append(MessageFormat.format(template, objects));
        }
        return msg.toString();
    }

    public static String createUnAssign2FailTable(Context ctx) throws BOSException {
        String tbl = null;
        try {
            StringBuffer createTableSql = new StringBuffer();
            createTableSql.append("CREATE TABLE SysTable");
            createTableSql.append("\t(");
            createTableSql.append("FID varchar(44),");
            createTableSql.append("FOID varchar(44)");
            createTableSql.append(")");
            tbl = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tbl;
    }

    public static boolean fillUnAssign2FailTable(Context ctx, String tableName, StringEnum tab, List<UnAssign2CheckResult> checkResultList) throws BOSException {
        boolean errorOnThisTab = false;
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            String insertSql = "insert into " + tableName + "(FID,FOID) values (?,?)";
            stmt = cn.prepareStatement(insertSql);
            for (UnAssign2CheckResult checkResult : checkResultList) {
                Map<String, List> failOrgMap = checkResult.get(tab);
                if (failOrgMap == null || failOrgMap.size() <= 0) continue;
                errorOnThisTab = true;
                for (String orgId : failOrgMap.keySet()) {
                    List dataList = failOrgMap.get(orgId);
                    for (Object data : dataList) {
                        stmt.setString(1, data.toString());
                        stmt.setString(2, orgId);
                        stmt.addBatch();
                    }
                }
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return errorOnThisTab;
    }

    public static void afterApproveMaterialList(Context ctx, String bosType, String cuID, List<String> idList) throws BOSException, EASDBException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("cuid", cuID);
        param.put("idList", idList);
        try {
            Class<?> c = Class.forName(PRODUCT_SERVICE_NAME);
            Object obj = c.newInstance();
            Method method = c.getMethod(PRODUCT_METHOD_NAME, Context.class, String.class, Map.class);
            method.invoke(obj, ctx, bosType, param);
            logger.info((Object)"\u8c03\u7528\u7a0e\u52a1\u63a5\u53e3\uff1acom.kingdee.eas.tm.im.util.invoice.ProductCodeSyncService");
        }
        catch (Exception e) {
            logger.error((Object)("\u8c03\u7528\u7a0e\u52a1\u63a5\u53e3\u5931\u8d25\u4f46\u6838\u51c6\u7ee7\u7eed\u8fdb\u884c\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    public static void afterApproveMaterialDeal(Context ctx, String cuID, MaterialInfo info) throws BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("cuid", cuID);
        param.put("info", info);
        try {
            Class<?> c = Class.forName(PRODUCT_SERVICE_NAME);
            Object obj = c.newInstance();
            Method method = c.getMethod(PRODUCT_METHOD_NAME, Context.class, String.class, Map.class);
            method.invoke(obj, ctx, "4409E7F0", param);
            logger.info((Object)"\u8c03\u7528\u7a0e\u52a1\u63a5\u53e3\uff1acom.kingdee.eas.tm.im.util.invoice.ProductCodeSyncService");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static String[] getDeals(Context ctx, String bosType, Class inf) throws EASDBException {
        Vector<String> vec = new Vector<String>();
        Object[] deals = null;
        String sql = "select fdeal from T_BD_bizDeals where FBosType= ? and FInterface= ?";
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        try {
            conn = MaterialUtils.getConnection(ctx);
            stat = conn.prepareStatement(sql);
            stat.setString(1, bosType);
            stat.setString(2, inf.getName());
            rs = stat.executeQuery();
            while (rs.next()) {
                vec.addElement(rs.getString(1));
                deals = new String[vec.size()];
                vec.copyInto(deals);
            }
        }
        catch (SQLException e2) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e2);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stat, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stat, (Connection)conn);
        return deals;
    }

    protected static Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }
}

