/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.eas.basedata.master.material.BatchPolicyEnum;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.common.EASBizException;
import java.math.BigDecimal;

public class BatchPolicyDataCheck {
    public static void submitCheckBatchPolicy(MaterialPlanInfo info) throws EASBizException {
        BatchPolicyEnum batchPolicy = info.getBatchPolicy();
        if (batchPolicy == null) {
            return;
        }
        BigDecimal zero = new BigDecimal("0.00");
        if (BatchPolicyEnum.FIXATIONBATCH.equals((Object)batchPolicy)) {
            if (info.getFixationBatchQty() == null || zero.compareTo(info.getFixationBatchQty()) == 0) {
                throw new MaterialBaseException(MaterialBaseException.BATCHPOLICY_QTY_NULL);
            }
            MaterialBaseException exception = new MaterialBaseException(MaterialBaseException.BATCHQTY_ROUNDINGQTY_ERROR);
            if (info.getRoundUpMulitpleQty() != null && zero.compareTo(info.getRoundUpMulitpleQty()) < 0) {
                if (info.getRoundUpMulitpleQty().compareTo(info.getFixationBatchQty()) > 0) {
                    throw exception;
                }
                BatchPolicyDataCheck.checkBatchQtyAndRound(info.getRoundUpMulitpleQty(), info.getFixationBatchQty(), exception);
            }
        } else {
            BigDecimal maxBatchQty = info.getMaxBatchQty();
            BigDecimal minBatchQty = info.getMinBatchQty();
            BigDecimal roundQty = info.getRoundUpMulitpleQty();
            if (info.getPartitionDays() != null && info.getPartitionDays().compareTo(zero) > 0 && (info.getMinBatchQty() == null || zero.compareTo(info.getMinBatchQty()) == 0)) {
                throw new MaterialBaseException(MaterialBaseException.MIN_BATCHQTY_NULL);
            }
            if (roundQty != null && roundQty.compareTo(zero) > 0) {
                BatchPolicyDataCheck.checkBatchQtyAndRound(minBatchQty, roundQty, new MaterialBaseException(MaterialBaseException.MAXMIN_BATCH_WRONG));
                BatchPolicyDataCheck.checkBatchQtyAndRound(maxBatchQty, roundQty, new MaterialBaseException(MaterialBaseException.MAXMIN_BATCH_WRONG));
            }
            if (minBatchQty != null && minBatchQty.compareTo(zero) > 0 && maxBatchQty != null && maxBatchQty.compareTo(zero) > 0 && minBatchQty.compareTo(maxBatchQty) > 0) {
                throw new MaterialBaseException(MaterialBaseException.MAXBATCHQTY_LESSTHAN_MINQTY);
            }
            if (!(BatchPolicyEnum.STRAIGHTBATCH.equals((Object)batchPolicy) || info.getBatchCycle() != null && info.getBatchCycle().compareTo(zero) != 0)) {
                throw new MaterialBaseException(MaterialBaseException.BATCH_CYCLE_NULL);
            }
        }
    }

    private static void checkBatchQtyAndRound(BigDecimal batchQty, BigDecimal roundQty, MaterialBaseException exception) throws EASBizException {
        BigDecimal temp = null;
        BigDecimal tempInt = null;
        BigDecimal zero = new BigDecimal("0.00");
        if (batchQty == null || batchQty.compareTo(zero) == 0) {
            return;
        }
        if (batchQty.compareTo(roundQty) > 0 ? (temp = batchQty.divide(roundQty, 8, 2)).compareTo(tempInt = batchQty.divide(roundQty, 0, 2)) != 0 : (temp = roundQty.divide(batchQty, 8, 2)).compareTo(tempInt = roundQty.divide(batchQty, 0, 2)) != 0) {
            throw exception;
        }
    }
}

