/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.master.material.BatchPolicyEnum;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialBaseDispersionEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialScrapRateExpressionEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import java.util.HashMap;

public class MaterialPlanAutoCreateProcessor
extends AbstractBusinessProcessor {
    public MaterialPlanAutoCreateProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ApplicationContext ac = this.getExecuteContext().getApplicationContext();
        MaterialInfo matInfo = (MaterialInfo)ac.getData("matInfo");
        HashMap errors = (HashMap)ac.getData("errors");
        CtrlUnitInfo cuInfo = (CtrlUnitInfo)ac.getData("cuInfo");
        FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)ac.getData("ouInfo");
        MaterialPlanInfo PlanInfo = new MaterialPlanInfo();
        boolean requiredFieldIsNull = false;
        IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        OrgUnitCollection adminOrgCollection = iUtilRel.getToUnit(cuInfo.getId().toString(), 4, 0);
        if (adminOrgCollection.size() == 0) {
            requiredFieldIsNull = true;
        } else {
            IPositionMember PositionMember = PositionMemberFactory.getLocalInstance((Context)this.ctx);
            StringBuffer oql = new StringBuffer("select person,position.adminOrgUnit ");
            for (int i = 0; i < adminOrgCollection.size(); ++i) {
                OrgUnitInfo orgUnitInfo = adminOrgCollection.get(i);
                if (i == 0) {
                    oql.append(" where position.adminOrgUnit='").append(orgUnitInfo.getId().toString()).append("'");
                    continue;
                }
                oql.append(" or position.adminOrgUnit='").append(orgUnitInfo.getId().toString()).append("'");
            }
            PositionMemberCollection positionMemberCollection = PositionMember.getPositionMemberCollection(oql.toString());
            if (positionMemberCollection.size() == 0) {
                requiredFieldIsNull = true;
            }
        }
        if (!requiredFieldIsNull) {
            PlanInfo.setMaterial(matInfo);
            PlanInfo.setStatus(UsedStatusEnum.UNAPPROVE);
            PlanInfo.setEffectedStatus(2);
            PlanInfo.setOrgUnit(ouInfo);
            PlanInfo.setMaterialAttr(MaterialAttributeEnum.FABRICATEDPART);
            PlanInfo.setProductUnit(matInfo.getBaseUnit());
            PlanInfo.setProvideType(MaterialProvideTypeEnum.CURRENTORGPROVIDE);
            PlanInfo.setScrapRateExpression(MaterialScrapRateExpressionEnum.MUTIPLE);
            PlanInfo.setBatchPolicy(BatchPolicyEnum.STRAIGHTBATCH);
            PlanInfo.setIssMode(MaterialIssueModeEnum.PRODUCEISSMODE);
            PlanInfo.setRcvDispersionBase(MaterialBaseDispersionEnum.PRODUCTIONPLANQTY);
            try {
                IMaterialPlan imatPlan = MaterialPlanFactory.getLocalInstance(this.ctx);
                ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                imatPlan.addnew(PlanInfo);
            }
            catch (PermissionException e5) {
                errors.put("plan", e5);
            }
        }
    }
}

