/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IKAClassfication;
import com.kingdee.eas.basedata.assistant.KAClassficationCollection;
import com.kingdee.eas.basedata.assistant.KAClassficationFactory;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterialProfitCenterInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoInfo;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataImportMaterialProfit
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger(DataImportMaterialProfit.class);
    Map profitCenterMap = new HashMap();
    private Set PerminssionCheckCUIds = new HashSet();
    Map cacheOrg = new HashMap();
    Map casheKAClass = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialProfitCenterInfoFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FMaterialName", rs.getString("name"));
            this.putTable(result, "FProfitCenterNumber", rs.getString("orgUnit.number"));
            this.putTable(result, "FAccountType", AccountType.getEnum((int)rs.getInt("materialProfit.accountType")).getAlias(ctx.getLocale()));
            this.putTable(result, "FFreezeOrgUnit", rs.getString("freezeOrgUnit.number"));
            this.putTable(result, "FKAClassNumber", rs.getString("KAClass.number"));
            this.putTable(result, "FIsLot", DataImportTools.boolToString((boolean)rs.getBoolean("materialProfit.isLot")));
            this.putTable(result, "FIsAssistProperty", DataImportTools.boolToString((boolean)rs.getBoolean("materialProfit.isAssistProperty")));
            this.putTable(result, "FIsProject", DataImportTools.boolToString((boolean)rs.getBoolean("materialProfit.isProject")));
            this.putTable(result, "FIsTrackNumber", DataImportTools.boolToString((boolean)rs.getBoolean("materialProfit.isTrackNumber")));
            this.putTable(result, "FStatus", UsedStatusEnum.getEnum((int)rs.getInt("materialProfit.status")).getAlias(ctx.getLocale()));
            this.putTable(result, "FCreatorNumber", rs.getString("creatorUser.number"));
            this.putTable(result, "FCreateTime", rs.getString("materialProfit.createTime"));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this.innerTransmit(hsData, ctx);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new TaskExternalException("", (Throwable)ex);
        }
    }

    private CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        ProfitCenterOrgUnitInfo profitCenterOrgUnitInfo = null;
        Object data = ((DataToken)hsData.get((Object)"FProfitCenterNumber")).data;
        if (data == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"ProOU_NOT_NULL", (Context)ctx));
        }
        profitCenterOrgUnitInfo = this.getProfitCenterByNumber(ctx, data.toString());
        if (profitCenterOrgUnitInfo == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetBizOrgUnitFailed", (Context)ctx));
        }
        try {
            this.checkProfitCenterOrgPerm(ctx, profitCenterOrgUnitInfo);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        MaterialInfo materialInfo = DataImportTools.getMaterialInfo((Context)ctx, (CtrlUnitInfo)profitCenterOrgUnitInfo.getCU(), (String)this.getDataString(hsData, "FNumber"));
        MaterialProfitCenterInfoInfo info = new MaterialProfitCenterInfoInfo();
        if (this.isSltImportUpdate()) {
            FilterInfo filter = new FilterInfo();
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"profitcenter.id", (Object)profitCenterOrgUnitInfo.getId().toString());
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"material.number", (Object)this.getDataString(hsData, "FNumber"));
            filter.setMaskString("#0 and #1");
            IMaterialProfitCenterInfo iMaterialProfitCenterInfo = MaterialProfitCenterInfoFactory.getLocalInstance((Context)ctx);
            MaterialProfitCenterInfoCollection proCollection = iMaterialProfitCenterInfo.getMaterialProfitCenterInfoCollection(DataImportTools.getViewInfo((FilterInfo)filter));
            if (proCollection != null && proCollection.size() > 0) {
                info.setId(proCollection.get(0).getId());
                info.setCU(proCollection.get(0).getCU());
            }
        }
        info.setMaterial(materialInfo);
        info.setProfitCenter(profitCenterOrgUnitInfo);
        info.setCU(profitCenterOrgUnitInfo.getCU());
        return this.handleInfo(ctx, hsData, info, materialInfo.getId().toString());
    }

    private CoreBaseInfo handleInfo(Context ctx, Hashtable hsData, MaterialProfitCenterInfoInfo info, String string) throws TaskExternalException {
        OrgUnitInfo ou = this.getOrgByNumber(ctx, this.getDataString(hsData, "FFreezeOrgUnit"));
        info.setStatus(DataImportTools.getStatusEnum((String)this.getDataString(hsData, "FStatus"), (Context)ctx));
        if (ou != null) {
            info.setFreezeOrgUnit(ou.castToFullOrgUnitInfo());
        } else if (info.getStatus() == UsedStatusEnum.FREEZED) {
            info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        } else {
            info.setFreezeOrgUnit(null);
        }
        String strKA = this.getDataString(hsData, "FKAClassNumber");
        KAClassficationInfo kaClassficationInfo = null;
        try {
            kaClassficationInfo = this.getKAClassByNumber(ctx, strKA, info.getProfitCenter());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        info.setKAClass(kaClassficationInfo);
        info.setAccountType(this.checkAccountTypeAndReturn(ctx, hsData, "FAccountType"));
        info.setIsLot(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsLot"));
        info.setIsAssistProperty(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsAssistProperty"));
        info.setIsProject(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsProject"));
        info.setIsTrackNumber(DataImportTools.getDataboolean((Hashtable)hsData, (String)"FIsTrackNumber"));
        return info;
    }

    private ProfitCenterOrgUnitInfo getProfitCenterByNumber(Context ctx, String number) {
        Object result = this.profitCenterMap.get(number);
        if (result == null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            try {
                ProfitCenterOrgUnitCollection profitCols = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitCollection(viewInfo);
                if (profitCols.size() > 0) {
                    result = profitCols.get(0);
                    this.profitCenterMap.put(number, result);
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return (ProfitCenterOrgUnitInfo)result;
    }

    private void checkProfitCenterOrgPerm(Context ctx, ProfitCenterOrgUnitInfo profitCenterOrgUnitInfo) throws TaskExternalException, EASBizException, BOSException {
        if (profitCenterOrgUnitInfo == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetProfitCenterOrgUnitFailed", (Context)ctx));
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (!PerminsionUtil.isUserBizOrgRange((Context)ctx, (String)userId, (String)profitCenterOrgUnitInfo.getId().toString())) {
            throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{profitCenterOrgUnitInfo.getName()}).getMessage());
        }
        String CuId = profitCenterOrgUnitInfo.getCU().getId().toString();
        if (!this.PerminssionCheckCUIds.contains(CuId)) {
            try {
                PerminsionUtil.checkCUPerminsion((Context)ctx, (String)CuId, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), (String)"bd_materialPro_import");
            }
            catch (EASBizException ee) {
                throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
            }
            this.PerminssionCheckCUIds.add(CuId);
        }
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataString((Hashtable)hsData, (String)fieldName);
    }

    private OrgUnitInfo getOrgByNumber(Context ctx, String number) throws TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        Object result = this.cacheOrg.get(number);
        if (result == null) {
            result = DataImportTools.getOrgUnitInfo((Context)ctx, (String)number);
            this.cacheOrg.put(number, result);
        }
        return (OrgUnitInfo)result;
    }

    private KAClassficationInfo getKAClassByNumber(Context ctx, String number, ProfitCenterOrgUnitInfo profitcenter) throws BOSException, EASBizException, TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        if (profitcenter == null) {
            return null;
        }
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection companyInfoCollection = iOrgUnitRelation.getToUnit(profitcenter.getId().toString(), 6, 1);
        KAClassficationInfo result = null;
        if (companyInfoCollection != null && companyInfoCollection.size() > 0) {
            String comOrgID = companyInfoCollection.get(0).getId().toString();
            String key = number + "&&" + comOrgID;
            result = (KAClassficationInfo)this.casheKAClass.get(key);
            if (result == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("where number = '" + number + "'");
                stringBuffer.append("And currencyCompany = '" + comOrgID + "' ");
                stringBuffer.append(" AND  typelink.objectType.objectTypeID='4409E7F0'");
                IKAClassfication iKa = KAClassficationFactory.getLocalInstance((Context)ctx);
                KAClassficationCollection kaCollection = iKa.getKAClassficationCollection(stringBuffer.toString());
                if (kaCollection == null || kaCollection.size() <= 0) {
                    throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_FA_Error", (Locale)ctx.getLocale()));
                }
                result = kaCollection.get(0);
                this.casheKAClass.put(key, result);
            }
        } else {
            throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_FA_Error", (Locale)ctx.getLocale()));
        }
        return result;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private AccountType checkAccountTypeAndReturn(Context ctx, Hashtable hsData, String feildName) throws TaskExternalException {
        AccountType accountType = null;
        String accountTypeValue = hsData.get(feildName).toString();
        try {
            accountType = DataImportTools.getAccountTypeEnum((String)accountTypeValue, (Context)ctx);
        }
        catch (TaskExternalException e) {
            accountType = null;
        }
        if (accountType != null) {
            if (!accountType.equals((Object)AccountType.ADD_AVERAGE) && !accountType.equals((Object)AccountType.MOVE_WEIGHTED_AVERAGE)) {
                throw new TaskExternalException(DataImportTools.getResString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DataImport_FA_DISABLED", (Locale)ctx.getLocale()));
            }
        } else {
            accountType = AccountType.ADD_AVERAGE;
        }
        return accountType;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.material.app.DataImpExpProfitQuery";
    }
}

