/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.ncm.AUXOverheadTreeInfo;
import com.kingdee.eas.basedata.ncm.app.AbstractAUXOverheadTreeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;

public class AUXOverheadTreeControllerBean
extends AbstractAUXOverheadTreeControllerBean {
    private static final long serialVersionUID = -7581157260771044049L;

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        AUXOverheadTreeInfo treeInfo = (AUXOverheadTreeInfo)model;
        this.checkBlank(treeInfo);
        this.checkNumberDup(ctx, treeInfo);
        this.checkNameDup(ctx, treeInfo);
        super._update(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AUXOverheadTreeInfo treeInfo = (AUXOverheadTreeInfo)model;
        this.checkBlank(treeInfo);
        this.checkNumberDup(ctx, treeInfo);
        this.checkNameDup(ctx, treeInfo);
        return super._addnew(ctx, model);
    }

    private void checkBlank(AUXOverheadTreeInfo treeInfo) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)treeInfo.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        if (StringUtils.isEmpty((String)treeInfo.getName())) {
            throw new EASBizException(EASBizException.CHECKNAMEBLANK);
        }
    }

    private void checkNumberDup(Context ctx, AUXOverheadTreeInfo treeInfo) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)treeInfo.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)treeInfo.getBOSUuid("id"), CompareType.NOTEQUALS));
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{treeInfo.getNumber()});
        }
    }

    private void checkNameDup(Context ctx, AUXOverheadTreeInfo treeInfo) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)treeInfo.getName()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)treeInfo.getBOSUuid("id"), CompareType.NOTEQUALS));
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{treeInfo.getName()});
        }
    }
}

