/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.ncm.ActivityChainCollection;
import com.kingdee.eas.basedata.ncm.ActivityChainEntryCollection;
import com.kingdee.eas.basedata.ncm.ActivityChainEntryInfo;
import com.kingdee.eas.basedata.ncm.ActivityChainException;
import com.kingdee.eas.basedata.ncm.ActivityChainInfo;
import com.kingdee.eas.basedata.ncm.ActivityChainTreeInfo;
import com.kingdee.eas.basedata.ncm.ActivityInfo;
import com.kingdee.eas.basedata.ncm.DataStatusEnum;
import com.kingdee.eas.basedata.ncm.OrderTypeEnum;
import com.kingdee.eas.basedata.ncm.app.AbstractActivityChainControllerBean;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryCollection;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryInfo;
import com.kingdee.eas.mm.basedata.MaterialRootingInfo;
import com.kingdee.eas.mm.basedata.OperationCollection;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.StandardRootingCollection;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ActivityChainControllerBean
extends AbstractActivityChainControllerBean {
    private static final long serialVersionUID = -2052809945721378985L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ncm.app.ActivityChainControllerBean");
    private static final String RES_CLASSNAME = "com.kingdee.eas.basedata.ncm.ActivityChainResource";

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ActivityChainInfo info = (ActivityChainInfo)model;
        if (DataStatusEnum.SUBMITED.equals((Object)info.getStatus())) {
            this._checkNameBlank(ctx, model);
        }
        if (!StringUtils.isEmpty((String)info.getName())) {
            this._checkNameDup(ctx, model);
        }
        this._checkNumber(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ActivityChainInfo info = (ActivityChainInfo)model;
        if (info.getStatus() == null || info.getStatus().equals((Object)DataStatusEnum.ADD)) {
            info.setStatus(DataStatusEnum.TEMPORARILYSAVED);
        }
        return super._save(ctx, model);
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._save(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ActivityChainInfo info = (ActivityChainInfo)model;
        info.setStatus(DataStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._submit(ctx, pk, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ActivityChainInfo info = (ActivityChainInfo)model;
        if (DataStatusEnum.SUBMITED.equals((Object)info.getStatus())) {
            this._checkNameBlank(ctx, model);
        }
        if (!StringUtils.isEmpty((String)info.getName())) {
            this._checkNameDup(ctx, model);
        }
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        HashSet ids = new HashSet();
        ids.addAll(Arrays.asList((Object[])arrayPK));
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        selector.add("status");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(selector);
        ActivityChainCollection coll = this.getActivityChainCollection(ctx, view);
        if (coll.size() <= 0) {
            return;
        }
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            ActivityChainInfo info = (ActivityChainInfo)it.next();
            if (DataStatusEnum.TEMPORARILYSAVED.equals((Object)info.getStatus()) || DataStatusEnum.SUBMITED.equals((Object)info.getStatus())) continue;
            throw new ActivityChainException(ActivityChainException.CHECK_REMOVE_ERROR);
        }
        HashMap<String, BizReference> map = new HashMap<String, BizReference>();
        ActivityChainInfo activityChain = null;
        BizReference ref = null;
        Iterator it2 = coll.iterator();
        while (it2.hasNext()) {
            activityChain = (ActivityChainInfo)it2.next();
            ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)BOSUuid.read((String)activityChain.getId().toString()));
            if (ref == null) continue;
            map.put(activityChain.getName() + "[" + activityChain.getNumber() + "]", ref);
        }
        if (map.size() > 0) {
            throw new ObjectReferedException(map);
        }
        ActivityChainInfo info = coll.get(0);
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus((IObjectValue)info, companyId);
        if (ruleStatus.isExist() && ruleStatus.isUseIntermitNumber()) {
            String[] numbers = new String[coll.size()];
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                numbers[i] = coll.get(i).getNumber();
            }
            iCodingRuleManager.recycleBatchNumber((IObjectValue)info, companyId, numbers);
        }
        super._delete(ctx, arrayPK);
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        super._deleteBatchData(ctx, pkArray);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        ActivityChainInfo info = (ActivityChainInfo)model;
        FilterInfo filter = new FilterInfo();
        String companyId = info == null || info.getCompany() == null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : info.getCompany().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        return filter;
    }

    protected void _checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ActivityChainInfo info = (ActivityChainInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String orgId = null;
        if (info.getCompany() != null) {
            orgId = info.getCompany().getId().toString();
        }
        if (orgId == null) {
            orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(model, orgId);
        if (StringUtils.isEmpty((String)info.getNumber())) {
            if (ruleStatus.isExist()) {
                this.setNewNumber(ctx, info, iCodingRuleManager, null);
            } else {
                this._checkNumberBlank(ctx, model);
            }
        } else if (ruleStatus.isExist()) {
            if (ruleStatus.isAddView()) {
                if (ruleStatus.isModifiable()) {
                    this._checkNumberDup(ctx, model);
                } else if (this.isNumberUsed(ctx, info)) {
                    this.setNewNumber(ctx, info, iCodingRuleManager, null);
                }
            } else if (ruleStatus.isAddNoBreak()) {
                this.setNewNumber(ctx, info, iCodingRuleManager, null);
            }
        } else {
            this._checkNumberDup(ctx, model);
        }
    }

    protected boolean isNumberUsed(Context ctx, ActivityChainInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getCompany() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        boolean exist = super._exists(ctx, filter);
        return exist;
    }

    protected void setNewNumber(Context ctx, ActivityChainInfo info, ICodingRuleManager iCodingRuleManager, String customString) throws BOSException, EASBizException {
        String number = iCodingRuleManager.getNumber((IObjectValue)info, info.getCompany().getId().toString(), customString);
        info.setNumber(number);
        if (this.isNumberUsed(ctx, info)) {
            this.setNewNumber(ctx, info, iCodingRuleManager, customString);
        }
    }

    @Override
    protected Map _submit(Context ctx, Set pks) throws BOSException, EASBizException {
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"doMonth", (BOSObjectType)this.getBOSType(), null, (String)this.getLogInfo(ctx, pks), (String)"OC_ActivityChain_Submit");
        try {
            String id;
            String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String idsSql = BDCMUtils.buildSqlFromIds(pks);
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 1 from T_NCM_ActivityChain \n");
            sql.append("where FID in " + idsSql + " \n");
            sql.append("and FStatus not in ( \n");
            sql.append("2, 3 \n");
            sql.append(") \n");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowset.next() && rowset.getString(1) != null) {
                throw new ActivityChainException(ActivityChainException.CHECK_SUBMIT_ERROR);
            }
            HashMap report = new HashMap();
            sql.setLength(0);
            sql.append("select \n");
            sql.append("FID \n");
            sql.append("from T_NCM_ActivityChain \n");
            sql.append("where FID in " + idsSql + " \n");
            sql.append("and (FName_" + locale + " is null) \n");
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowset.next()) {
                id = rowset.getString("FID");
                this.addErrorItem(report, id, ResourceBase.getString((String)RES_CLASSNAME, (String)"CHECK_NAME_EMPTY", (Locale)ctx.getLocale()));
            }
            sql.setLength(0);
            sql.append("select \n");
            sql.append("ac.FID \n");
            sql.append("from T_NCM_ActivityChain ac \n");
            sql.append("where ac.FID in " + idsSql + " \n");
            sql.append("and not exists ( \n");
            sql.append("    select top 1 1 from T_NCM_ActivityChainEntry where  FParentID = ac.FID \n");
            sql.append(") \n");
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowset.next()) {
                id = rowset.getString("FID");
                this.addErrorItem(report, id, ResourceBase.getString((String)RES_CLASSNAME, (String)"CHECK_ENTRY_EMPTY", (Locale)ctx.getLocale()));
            }
            sql.setLength(0);
            sql.append("select \n");
            sql.append("FParentID, FActivityID, FIntegratedQty, FSeq \n");
            sql.append("from T_NCM_ActivityChainEntry \n");
            sql.append("where FParentID in " + idsSql + " \n");
            sql.append("and (FActivityID is null or FIntegratedQty is null or FIntegratedQty <= 0) \n");
            sql.append("order by FParentID, FSeq \n");
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowset.next()) {
                BigDecimal integratedQty;
                id = rowset.getString("FParentID");
                if (StringUtils.isEmpty((String)rowset.getString("FActivityID"))) {
                    this.addErrorItem(report, id, MessageFormat.format(ResourceBase.getString((String)RES_CLASSNAME, (String)"CHECK_AC_EMPTY", (Locale)ctx.getLocale()), rowset.getString("FSeq")));
                }
                if ((integratedQty = rowset.getBigDecimal("FIntegratedQty")) != null && integratedQty.compareTo(SysConstant.BIGZERO) > 0) continue;
                this.addErrorItem(report, id, MessageFormat.format(ResourceBase.getString((String)RES_CLASSNAME, (String)"CHECK_IntegratedQty_MUSTMORETHAN_ZERO2", (Locale)ctx.getLocale()), rowset.getString("FSeq")));
            }
            if (report.size() > 0) {
                sql.setLength(0);
                sql.append("select FID, FNumber \n");
                sql.append("from T_NCM_ActivityChain \n");
                sql.append("where FID in " + idsSql + " \n");
                rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                HashMap<String, String> idToNumbers = new HashMap<String, String>();
                while (rowset.next()) {
                    idToNumbers.put(rowset.getString("FID"), rowset.getString("FNumber"));
                }
                HashMap newReport = new HashMap();
                Set entrys = report.entrySet();
                for (Map.Entry map : entrys) {
                    id = (String)map.getKey();
                    if (!idToNumbers.containsKey(id)) continue;
                    newReport.put(idToNumbers.get(id), map.getValue());
                }
                return newReport;
            }
            sql.setLength(0);
            sql.append("update T_NCM_ActivityChain set \n");
            sql.append("FStatus = 3 \n");
            sql.append("where FID in " + idsSql + " \n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (SQLException e) {
            logger.debug((Object)e);
            throw new BOSException((Throwable)e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return null;
    }

    private void addErrorItem(Map report, String id, String error) {
        ArrayList<String> errors = (ArrayList<String>)report.get(id);
        if (errors == null) {
            errors = new ArrayList<String>();
            report.put(id, errors);
        }
        errors.add(error);
    }

    @Override
    protected Map _audit(Context ctx, Set pks) throws BOSException, EASBizException {
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"doMonth", (BOSObjectType)this.getBOSType(), null, (String)this.getLogInfo(ctx, pks), (String)"OC_ActivityChain_Audit");
        try {
            String idsSql = BDCMUtils.buildSqlFromIds(pks);
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 1 from T_NCM_ActivityChain \n");
            sql.append("where FID in " + idsSql + " \n");
            sql.append("and FStatus <> 3 \n");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowset.next() && rowset.getString(1) != null) {
                throw new ActivityChainException(ActivityChainException.CHECK_AUDIT_ERROR);
            }
            sql.setLength(0);
            sql.append("update T_NCM_ActivityChain set \n");
            sql.append("FStatus = 4 \n");
            sql.append("where FID in " + idsSql + " \n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (SQLException e) {
            logger.debug((Object)e);
            throw new BOSException((Throwable)e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return null;
    }

    @Override
    protected Map _unaudit(Context ctx, Set pks) throws BOSException, EASBizException {
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"doMonth", (BOSObjectType)this.getBOSType(), null, (String)this.getLogInfo(ctx, pks), (String)"OC_ActivityChain_Unaudit");
        try {
            String idsSql = BDCMUtils.buildSqlFromIds(pks);
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 1 from T_NCM_ActivityChain \n");
            sql.append("where FID in " + idsSql + " \n");
            sql.append("and FStatus <> 4 \n");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowset.next() && rowset.getString(1) != null) {
                throw new ActivityChainException(ActivityChainException.CHECK_UNAUDIT_ERROR);
            }
            sql.setLength(0);
            sql.append("update T_NCM_ActivityChain set \n");
            sql.append("FStatus = 2 \n");
            sql.append("where FID in " + idsSql + " \n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (SQLException e) {
            logger.debug((Object)e);
            throw new BOSException((Throwable)e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return null;
    }

    @Override
    protected Map _unforbid(Context ctx, Set pks) throws BOSException, EASBizException {
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"doMonth", (BOSObjectType)this.getBOSType(), null, (String)this.getLogInfo(ctx, pks), (String)"OC_ActivityChain_Unforbid");
        try {
            String idsSql = BDCMUtils.buildSqlFromIds(pks);
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 1 from T_NCM_ActivityChain \n");
            sql.append("where FID in " + idsSql + " \n");
            sql.append("and FIsForbiden <> 1 \n");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowset.next() && rowset.getString(1) != null) {
                throw new ActivityChainException(ActivityChainException.CHECK_UNFORBID_ERROR);
            }
            sql.setLength(0);
            sql.append("update T_NCM_ActivityChain set \n");
            sql.append("FIsForbiden = 0 \n");
            sql.append("where FID in " + idsSql + " \n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (SQLException e) {
            logger.debug((Object)e);
            throw new BOSException((Throwable)e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return null;
    }

    @Override
    protected Map _forbid(Context ctx, Set pks) throws BOSException, EASBizException {
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"doMonth", (BOSObjectType)this.getBOSType(), null, (String)this.getLogInfo(ctx, pks), (String)"OC_ActivityChain_Forbid");
        try {
            String idsSql = BDCMUtils.buildSqlFromIds(pks);
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 1 from T_NCM_ActivityChain \n");
            sql.append("where FID in " + idsSql + " \n");
            sql.append("and FIsForbiden <> 0 \n");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowset.next() && rowset.getString(1) != null) {
                throw new ActivityChainException(ActivityChainException.CHECK_FORBID_ERROR);
            }
            sql.setLength(0);
            sql.append("update T_NCM_ActivityChain set \n");
            sql.append("FIsForbiden = 1 \n");
            sql.append("where FID in " + idsSql + " \n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (SQLException e) {
            logger.debug((Object)e);
            throw new BOSException((Throwable)e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return null;
    }

    @Override
    public void genData(Context ctx, Map param) throws BOSException, EASBizException {
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"doMonth", (BOSObjectType)this.getBOSType(), null, null, (String)"OC_ActivityChain_Generate");
        super.genData(ctx, param);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    @Override
    protected void _genData(Context ctx, Map param) throws BOSException, EASBizException {
        ActivityInfo activity;
        Set storageOrgUnitIds;
        Set standardRootingIds;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyId = company.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)60));
        boolean hasRootingId = false;
        if (param.get("standardRooting.id") != null && (standardRootingIds = (Set)param.get("standardRooting.id")).size() > 0) {
            hasRootingId = true;
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)standardRootingIds, CompareType.INCLUDE));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct \n");
        sql.append("FStandardRootingID \n");
        sql.append("from T_NCM_ActivityChain \n");
        sql.append("where FCompanyID = '" + companyId + "' and FStandardRootingID is not null \n");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
        if (!hasRootingId && (storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany(ctx, companyId)).size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitIds, CompareType.INCLUDE));
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("materialRooting.workProcess.operation.id"));
        selector.add(new SelectorItemInfo("materialRooting.workProcess.operation.name"));
        selector.add(new SelectorItemInfo("materialRooting.workProcess.operation.number"));
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("materialRooting.workProcess.wpSeq");
        sorterItem.setSortType(SortType.ASCEND);
        sorter.add(sorterItem);
        view.setFilter(filter);
        view.setSelector(selector);
        view.setSorter(sorter);
        StandardRootingCollection coll = StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingCollection(view);
        if (coll.size() <= 0) {
            return;
        }
        HashSet<StandardRootingInfo> srs = new HashSet<StandardRootingInfo>();
        HashMap<StandardRootingInfo, OperationCollection> oss = new HashMap<StandardRootingInfo, OperationCollection>();
        StandardRootingInfo standardRooting2 = null;
        MaterialRootingInfo materialRooting = null;
        MRWorkProcesEntryCollection workProceses = null;
        MRWorkProcesEntryInfo mrWorkProcesEntry2 = null;
        OperationCollection operations2 = null;
        for (StandardRootingInfo standardRooting2 : coll) {
            materialRooting = standardRooting2.getMaterialRooting();
            if (materialRooting == null || (workProceses = materialRooting.getWorkProcess()) == null || workProceses.size() <= 0) continue;
            operations2 = new OperationCollection();
            for (MRWorkProcesEntryInfo mrWorkProcesEntry2 : workProceses) {
                if (mrWorkProcesEntry2 == null || mrWorkProcesEntry2.getOperation() == null) continue;
                operations2.add(mrWorkProcesEntry2.getOperation());
            }
            if (operations2.size() <= 0) continue;
            srs.add(standardRooting2);
            oss.put(standardRooting2, operations2);
        }
        if (srs.size() <= 0) {
            return;
        }
        HashSet<String> oids = new HashSet<String>();
        for (OperationCollection operations2 : oss.values()) {
            Iterator itwps = operations2.iterator();
            while (itwps.hasNext()) {
                oids.add(((OperationInfo)itwps.next()).getId().toString());
            }
        }
        sql.setLength(0);
        sql.append("select a.FID, a.FAmount, ap.FOperationID \n");
        sql.append("from T_NCM_Activity a \n");
        sql.append("left join T_NCM_ActivityOperation ap on ap.FParentID = a.FID \n");
        sql.append("where a.FCompanyID = '" + companyId + "' \n");
        sql.append("and a.FDeletedStatus = 1 \n");
        sql.append("and ap.FOperationID in " + BDCMUtils.buildSqlFromIds(oids) + " \n");
        sql.append("and ( \n");
        sql.append("    select count(*) from T_NCM_Activity a2 \n");
        sql.append("    left join T_NCM_ActivityOperation ap2 on ap2.FParentID = a2.FID \n");
        sql.append("    where a2.FCompanyID = '" + companyId + "' \n");
        sql.append("    and a2.FDeletedStatus = 1 \n");
        sql.append("    and a2.FID = a.FID \n");
        sql.append(") = 1 \n");
        sql.append("and ( \n");
        sql.append("    select count(*) from T_NCM_Activity a2 \n");
        sql.append("    left join T_NCM_ActivityOperation ap2 on ap2.FParentID = a2.FID \n");
        sql.append("    where a2.FCompanyID = '" + companyId + "' \n");
        sql.append("    and a2.FDeletedStatus = 1 \n");
        sql.append("    and ap2.FOperationID = ap.FOperationID \n");
        sql.append(") = 1 \n");
        HashMap<String, ActivityInfo> activities = new HashMap<String, ActivityInfo>();
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowset.next()) {
                activity = new ActivityInfo();
                activity.setId(BOSUuid.read((String)rowset.getString("FID")));
                activity.setAmount(rowset.getBigDecimal("FAmount"));
                activities.put(rowset.getString("FOperationID"), activity);
            }
        }
        catch (SQLException e) {
            logger.debug((Object)e);
            throw new BOSException((Throwable)e);
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean existsRule = iCodingRuleManager.isExist((IObjectValue)new ActivityChainInfo(), companyId);
        ActivityChainTreeInfo tree = null;
        if (param.get("tree.id") != null) {
            tree = new ActivityChainTreeInfo();
            tree.setId(BOSUuid.read((String)((String)param.get("tree.id"))));
        }
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        ActivityChainInfo activityChain = null;
        ActivityChainEntryCollection activityChainEntrys = null;
        ActivityChainEntryInfo activityChainEntry = null;
        OperationInfo operation2 = null;
        for (StandardRootingInfo standardRooting2 : srs) {
            operations2 = (OperationCollection)oss.get(standardRooting2);
            activityChainEntrys = new ActivityChainEntryCollection();
            int i = 0;
            for (OperationInfo operation2 : operations2) {
                activity = (ActivityInfo)activities.get(operation2.getId().toString());
                if (activity != null) {
                    activityChainEntry = new ActivityChainEntryInfo();
                    activityChainEntry.setActivity(activity);
                    activityChainEntry.setIntegratedQty(new BigDecimal(0));
                    activityChainEntry.setSeq(++i);
                    activityChainEntrys.add(activityChainEntry);
                    continue;
                }
                activityChainEntrys.clear();
                break;
            }
            if (activityChainEntrys.size() <= 0) continue;
            activityChain = new ActivityChainInfo();
            activityChain.setCompany(company);
            activityChain.setStandardRooting(standardRooting2);
            activityChain.setStatus(DataStatusEnum.TEMPORARILYSAVED);
            activityChain.setOrderType(OrderTypeEnum.MANUFACTURE);
            activityChain.setIsForbiden(false);
            activityChain.setCU(cu);
            activityChain.setTree(tree);
            if (!existsRule) {
                activityChain.setNumber(standardRooting2.getNumber());
            }
            activityChain.setName(standardRooting2.getName());
            activityChain.getEntries().addCollection(activityChainEntrys);
            this.addnew(ctx, (CoreBaseInfo)activityChain);
        }
    }

    private String getLogInfo(Context ctx, Set pks) throws BOSException {
        String osql = "select number, name where id in " + BDCMUtils.buildSqlFromIds(pks);
        ActivityChainCollection coll = this.getActivityChainCollection(ctx, osql);
        StringBuffer loginfo = new StringBuffer();
        ActivityChainInfo activityChainInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            if (i == 3) {
                loginfo.append(",...");
                break;
            }
            activityChainInfo = coll.get(0);
            if (loginfo.length() > 0) {
                loginfo.append(",");
            }
            loginfo.append(activityChainInfo.getNumber()).append(" ").append(activityChainInfo.getName());
        }
        return loginfo.toString();
    }
}

