/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.ncm.ActivityException;
import com.kingdee.eas.basedata.ncm.ActivityGroupInfo;
import com.kingdee.eas.basedata.ncm.ActivityInfo;
import com.kingdee.eas.basedata.ncm.ActivityOperationInfo;
import com.kingdee.eas.basedata.ncm.ActivityTypeEnum;
import com.kingdee.eas.basedata.ncm.DeletedStatusEnum;
import com.kingdee.eas.basedata.ncm.app.AbstractActivityControllerBean;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.OperationCollection;
import com.kingdee.eas.mm.basedata.OperationFactory;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ActivityControllerBean
extends AbstractActivityControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ncm.app.ActivityControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ActivityInfo info = (ActivityInfo)model;
        this._checkNameDup(ctx, (IObjectValue)info);
        this._checkNumber(ctx, (IObjectValue)info);
        this.checkRefOperation(ctx, (IObjectValue)info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ActivityInfo info = (ActivityInfo)model;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId(), CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
            filterInfo.setMaskString("#0 and #1 and #2");
        } else {
            filterInfo.setMaskString("#0 and #1");
        }
        if (this.exists(ctx, filterInfo)) {
            throw new ActivityException(ActivityException.CHECKNUMBERDUP, new Object[]{info.getNumber()});
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ActivityInfo info = (ActivityInfo)model;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId(), CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
            filterInfo.setMaskString("#0 and #1 and #2");
        } else {
            filterInfo.setMaskString("#0 and #1");
        }
        if (this.exists(ctx, filterInfo)) {
            throw new ActivityException(ActivityException.CHECKNAMEDUP, new Object[]{info.getName()});
        }
    }

    protected void _checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ActivityInfo info = (ActivityInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String orgId = null;
        if (info.getCompany() != null) {
            orgId = info.getCompany().getId().toString();
        }
        if (orgId == null) {
            orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(model, orgId);
        if (StringUtils.isEmpty((String)info.getNumber())) {
            if (ruleStatus.isExist()) {
                this.setNewNumber(ctx, info, iCodingRuleManager, null);
            } else {
                this._checkNumberBlank(ctx, model);
            }
        } else if (ruleStatus.isExist()) {
            if (ruleStatus.isAddView()) {
                if (ruleStatus.isModifiable()) {
                    this._checkNumberDup(ctx, model);
                } else if (this.isNumberUsed(ctx, info)) {
                    this.setNewNumber(ctx, info, iCodingRuleManager, null);
                }
            } else if (ruleStatus.isAddNoBreak()) {
                this.setNewNumber(ctx, info, iCodingRuleManager, null);
            }
        } else {
            this._checkNumberDup(ctx, model);
        }
    }

    protected boolean isNumberUsed(Context ctx, ActivityInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getCompany() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        boolean exist = super._exists(ctx, filter);
        return exist;
    }

    protected void setNewNumber(Context ctx, ActivityInfo info, ICodingRuleManager iCodingRuleManager, String customString) throws BOSException, EASBizException {
        String number = iCodingRuleManager.getNumber((IObjectValue)info, info.getCompany().getId().toString(), customString);
        info.setNumber(number);
        if (this.isNumberUsed(ctx, info)) {
            this.setNewNumber(ctx, info, iCodingRuleManager, customString);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.isReferenced(ctx, pk);
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ActivityInfo info = (ActivityInfo)model;
        this._checkNameDup(ctx, (IObjectValue)info);
        this._checkNumberDup(ctx, (IObjectValue)info);
        this.checkReferenced(ctx, (IObjectValue)info);
        this.checkRefOperation(ctx, (IObjectValue)info);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void checkReferenced(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ActivityInfo info = (ActivityInfo)model;
        BOSUuid id = BOSUuid.read((String)info.getId().toString());
        ObjectUuidPK pk = new ObjectUuidPK(id.toString());
        try {
            this._isReferenced(ctx, (IObjectPK)pk);
        }
        catch (ObjectReferedException ex) {
            throw new ActivityException(ActivityException.CHECKUPDATE);
        }
    }

    protected void checkRefOperation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ActivityInfo info = (ActivityInfo)model;
        if (info.getOperation().size() <= 0) {
            return;
        }
        HashMap<String, OperationInfo> optMap = new HashMap<String, OperationInfo>();
        StringBuffer optStr = new StringBuffer();
        OperationInfo operationInfo = null;
        Object operationColl = null;
        for (int i = 0; i < info.getOperation().size(); ++i) {
            operationInfo = info.getOperation().get(i).getOperation();
            if (optMap.containsKey(operationInfo.getId().toString())) continue;
            optMap.put(operationInfo.getId().toString(), operationInfo);
            optStr.append("'" + operationInfo.getId().toString() + "',");
        }
        String where = optStr.substring(0, optStr.length() - 1);
        StringBuffer sql = new StringBuffer();
        sql.append(" select act.Fnumber as activity, o.Fnumber as operation from T_NCM_Activity act left join T_NCM_ActivityOperation ao ").append(" on act.Fid = ao.FParentID ").append(" left join T_MM_Operation o on ao.FOperationID = o.Fid ").append(" where act.FDeletedStatus = 1 ").append(" and FCompanyID = '").append(info.getCompany().getId().toString()).append("'").append(" and ao.FOperationID in (").append(where).append(") ");
        if (info.getId() != null) {
            sql.append(" and act.Fid <> '").append(info.getId()).append("'");
        }
        IRowSet _Data = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (_Data.next()) {
                Object[] param = new Object[]{_Data.getString("operation"), _Data.getString("activity")};
                throw new ActivityException(ActivityException.CHECK_REF_OPERATION, param);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.setStatus(ctx, pks, 2);
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        for (int i = 0; i < pks.length; ++i) {
            this.checkRefOperation(ctx, (IObjectValue)this.getActivityInfo(ctx, pks[i]));
        }
        this.setStatus(ctx, pks, 1);
    }

    private void setStatus(Context ctx, IObjectPK[] pks, int status) throws EASBizException, BOSException {
        if (pks.length <= 0) {
            return;
        }
        String sql = "update T_NCM_Activity set FDeletedStatus=" + status + " where FID IN(";
        StringBuffer where = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            where.append("'" + pks[i] + (i == pks.length - 1 ? "'" : "',"));
        }
        where.append(")");
        DbUtil.execute((Context)ctx, (String)(sql + where.toString()));
    }

    @Override
    protected void _genData(Context ctx, Map param) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Set storageIds = (Set)param.get("storage.id");
        if (storageIds == null || storageIds.size() <= 0) {
            storageIds = BDCMUtils.getStorageOrgUnitIdsOfCompany(ctx, companyId);
        }
        if (storageIds == null || storageIds.size() <= 0) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageIds, CompareType.INCLUDE));
        Set operationIds = (Set)param.get("operation.id");
        if (operationIds != null && operationIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)operationIds, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)20, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("workCenter.id", null, CompareType.NOTEQUALS));
        Set costCenterIds = BDCMUtils.getCostCenterIdsOfCompany(ctx, companyId);
        if (costCenterIds == null || costCenterIds.size() <= 0) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("workCenter.costCenter.id", (Object)costCenterIds, CompareType.INCLUDE));
        StringBuffer ksql = new StringBuffer();
        ksql.append("select FOperationID \n");
        ksql.append("from T_NCM_Activity a \n");
        ksql.append("join T_NCM_ActivityOperation ao on ao.FParentID = a.FID \n");
        ksql.append("where a.FCompanyID = '" + companyId + "' \n");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ksql.toString(), CompareType.NOTINNER));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("workCenter.costCenter.id");
        OperationCollection operations = OperationFactory.getLocalInstance((Context)ctx).getOperationCollection(view);
        if (operations.size() <= 0) {
            return;
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean existsRule = iCodingRuleManager.isExist((IObjectValue)new ActivityInfo(), companyId);
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        ActivityGroupInfo group = null;
        if (param.get("group.id") != null) {
            group = new ActivityGroupInfo();
            group.setId(BOSUuid.read((String)((String)param.get("group.id"))));
        }
        ActivityInfo activity = null;
        OperationInfo operation2 = null;
        ActivityOperationInfo activityOperation = null;
        CostCenterOrgUnitInfo costCenter = null;
        for (OperationInfo operation2 : operations) {
            if (operation2.getWorkCenter() != null) {
                costCenter = operation2.getWorkCenter().getCostCenter();
            }
            activity = new ActivityInfo();
            activity.setCompany(company);
            activity.setCU(cu);
            activity.setGroup(group);
            activity.setType(ActivityTypeEnum.MANUFACTURE);
            activity.setDeletedStatus(DeletedStatusEnum.CLOSE);
            activity.setCostCenter(costCenter);
            if (!existsRule) {
                activity.setNumber(operation2.getNumber());
            }
            activity.setName(operation2.getName());
            activityOperation = new ActivityOperationInfo();
            activityOperation.setOperation(operation2);
            activityOperation.setCostCenter(costCenter);
            activityOperation.setSeq(1);
            activity.getOperation().addObject((IObjectValue)activityOperation);
            this.addnew(ctx, activity);
        }
    }
}

