/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.framework.IDataBaseDAssign;
import com.kingdee.eas.basedata.framework.app.DataBaseDNewImpl;
import com.kingdee.eas.basedata.ncm.AllocStdException;
import com.kingdee.eas.basedata.ncm.CostDriverException;
import com.kingdee.eas.basedata.ncm.app.AbstractCostDriverControllerBean;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.RefChkFilter;
import com.kingdee.eas.common.RefChkFilterItemEnum;
import com.kingdee.eas.common.RefChkFilterSet;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CostDriverControllerBean
extends AbstractCostDriverControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ncm.app.CostDriverControllerBean");

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkDuplicateField(ctx, model, "number");
        this.checkDuplicateField(ctx, model, "name");
        super._addnew(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDuplicateField(ctx, model, "number");
        this.checkDuplicateField(ctx, model, "name");
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK dataBaseDPK, IObjectValue model) throws BOSException, EASBizException {
        this.checkDuplicateField(ctx, model, "number");
        this.checkDuplicateField(ctx, model, "name");
        super._update(ctx, dataBaseDPK, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK dataBaseDPK) throws BOSException, EASBizException {
        this.isReferenced(ctx, dataBaseDPK);
        super._delete(ctx, dataBaseDPK);
    }

    protected void checkDuplicateField(Context ctx, IObjectValue model, String fld) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("admincu.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(fld, (Object)model.getString(fld), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("costDriverType", model.get("costDriverType"), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        if (this._exists(ctx, filter)) {
            throw new AllocStdException(AllocStdException.EXC_ITEM_EXIST_DATA, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.basedata.ncm.BDNcmResource", (String)fld, (Locale)ctx.getLocale()), model.getString(fld)});
        }
    }

    @Override
    protected void _testFormula(Context ctx, String formula) throws BOSException, CostDriverException {
        String sql = "select (" + formula + ") As test ";
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            throw new CostDriverException(CostDriverException.EXCEPTION3);
        }
    }

    protected Map _batchUnAssignReturnFail(Context ctx, String[] diddata, String[] cuiddata) throws BOSException, EASBizException {
        Map unAssignFail = new HashMap();
        String[][] data = this.cuAndDids(cuiddata, diddata);
        if (this.useOptimizedBatchAssginAndUnassign()) {
            DataBaseDNewImpl newImpl = new DataBaseDNewImpl();
            unAssignFail = newImpl.batchUnAssignReturnFail(ctx, this.getBOSType(), data);
            return unAssignFail;
        }
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            this.deleteDataBaseDInfo(ctx, (IObjectPK)new ObjectUuidPK(data[i][0]), (IObjectPK)new ObjectUuidPK(data[i][1]));
        }
        return unAssignFail;
    }

    private String[][] cuAndDids(String[] cuiddata, String[] diddata) {
        int size = diddata.length;
        int cuSize = cuiddata.length;
        String[][] data = new String[size * cuSize][2];
        for (int i = 0; i < cuSize; ++i) {
            for (int j = 0; j < size; ++j) {
                data[i * size + j] = this.parsePairOfCUIDAndDataID(cuiddata[i].toString(), diddata[j].toString());
            }
        }
        return data;
    }

    private String[] parsePairOfCUIDAndDataID(String cuid, String dataid) {
        String[] aPair = new String[]{cuid, dataid};
        return aPair;
    }

    protected void _deleteDataBaseDInfo(Context ctx, IObjectPK ctrlUnitPK, IObjectPK dataBaseDPK) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("CU.id"));
        DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)super._getValue(ctx, dataBaseDPK, sic);
        boolean hasAdminRight = ctrlUnitPK.toString().equals(dataBaseDInfo.getCU().getId().toString());
        IDataBaseDAssign iDataBaseDAssign = DataBaseDAssignFactory.getLocalInstance((Context)ctx);
        if (hasAdminRight) {
            boolean isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
            if (isAssigned) {
                throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
            }
            super._delete(ctx, dataBaseDPK);
        } else {
            boolean isAssigned = iDataBaseDAssign.existAssignment(dataBaseDPK);
            if (isAssigned) {
                this.checkDelPolicy(ctx, ctrlUnitPK, dataBaseDInfo.getBOSType(), dataBaseDPK);
                iDataBaseDAssign.delete(ctrlUnitPK, dataBaseDPK);
                this.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataBaseDPK, (IObjectPK)new ObjectUuidPK(dataBaseDInfo.getCU().getId().toString()), ctrlUnitPK);
            } else {
                throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_UNASSIGNED_DATABASED);
            }
        }
    }

    private void checkDelPolicy(Context ctx, IObjectPK ctrlUnitPK, BOSObjectType objectType, IObjectPK dataPK) throws EASBizException, BOSException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK.toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateDeletable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        boolean isReferencedInCU = false;
        HashSet<String> filterValues = new HashSet<String>();
        filterValues.add(ctrlUnitPK.toString());
        RefChkFilterSet filters = new RefChkFilterSet();
        filters.add(new RefChkFilter(RefChkFilterItemEnum.IncludedCUIDList, filterValues));
        BOSUuid dataID = BOSUuid.read((String)dataPK.toString());
        isReferencedInCU = ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)dataID, (RefChkFilterSet)filters);
        if (isReferencedInCU) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE_IN_THIS_CU);
        }
    }
}

