/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoInfo;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.ExpenseTreeCollection;
import com.kingdee.eas.basedata.ncm.ExpenseTreeFactory;
import com.kingdee.eas.basedata.ncm.ExpenseTreeInfo;
import com.kingdee.eas.basedata.ncm.IExpenseCompanyInfo;
import com.kingdee.eas.basedata.ncm.app.AbstractExpenseControllerBean;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExpenseControllerBean
extends AbstractExpenseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ncm.app.ExpenseControllerBean");

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK dataBaseDPK, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, dataBaseDPK, model);
    }

    protected void assignBizOrgRelatedInfosOfTypeD3(Context ctx, IObjectPK dataID, IObjectPK sourceCUID, IObjectPK targetCUID) throws BOSException, EASBizException {
        super.assignBizOrgRelatedInfosOfTypeD3(ctx, dataID, sourceCUID, targetCUID);
        FullOrgUnitInfo sourceOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(sourceCUID);
        FullOrgUnitInfo targetOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(targetCUID);
        if (sourceOrgUnitInfo.isIsCompanyOrgUnit() && targetOrgUnitInfo.isIsCompanyOrgUnit()) {
            IObjectPK expenseCompanyInfoInfoPK = this.getExpenseCompanyInfoPK(ctx, dataID, (IObjectPK)new ObjectUuidPK(sourceOrgUnitInfo.getId()));
            IObjectPK targetCompanyInfoInfoPK = this.getExpenseCompanyInfoPK(ctx, dataID, (IObjectPK)new ObjectUuidPK(targetOrgUnitInfo.getId()));
            if (expenseCompanyInfoInfoPK != null && targetCompanyInfoInfoPK == null) {
                ExpenseCompanyInfoInfo expenseCompanyInfoInfo = ExpenseCompanyInfoFactory.getLocalInstance(ctx).getExpenseCompanyInfoInfo(expenseCompanyInfoInfoPK);
                CompanyOrgUnitInfo companyorg = new CompanyOrgUnitInfo();
                companyorg.setId(targetOrgUnitInfo.getId());
                expenseCompanyInfoInfo.setCompanyOrgUnit(companyorg);
            }
        }
    }

    private IObjectPK getExpenseCompanyInfoPK(Context ctx, IObjectPK csBasePK, IObjectPK companyOrgPK) throws BOSException, EASBizException {
        IExpenseCompanyInfo iexpenseCompanyInfo = ExpenseCompanyInfoFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("expense.id", (Object)csBasePK.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyOrgPK.toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        IObjectPK[] pks = iexpenseCompanyInfo.getPKList(filter, null);
        if (pks.length > 0) {
            return pks[0];
        }
        return null;
    }

    protected void unassignBizOrgRelatedInfosOfTypeD3(Context ctx, IObjectPK dataID, IObjectPK sourceCUID, IObjectPK targetCUID) throws BOSException, EASBizException {
        super.unassignBizOrgRelatedInfosOfTypeD3(ctx, dataID, sourceCUID, targetCUID);
        FullOrgUnitInfo targetOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(targetCUID);
        StringBuffer companyBuffer = new StringBuffer();
        companyBuffer.append(" delete from T_NCM_expenseCompanyInfo").append("  where FexpenseID = ").append("'" + dataID.toString() + "'").append(" and FCompanyOrgUnitID in(").append("select fid from T_ORG_BaseUnit ").append(" where FLongNumber like '").append("%!" + targetOrg.getNumber() + "%'").append(")");
        DbUtil.execute((Context)ctx, (String)companyBuffer.toString());
    }

    @Override
    protected Map _transformToTree(Context ctx, Set databaseIDs, int groupLevel) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)databaseIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("treeid", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("treeid", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("treeid.level", (Object)groupLevel, CompareType.GREATER_EQUALS));
        filter.setMaskString("#0 and (#1 or(#2 and #3))");
        view.getSelector().add("*");
        view.getSelector().add("treeid.*");
        ExpenseCollection expenseCollection = this.getExpenseCollection(ctx, view);
        HashMap<BOSUuid, String> expenseFIDToTypeLongNumberMap = new HashMap<BOSUuid, String>();
        HashSet<String> typeLongNumberSet = new HashSet<String>();
        HashSet<String> rootSet = new HashSet<String>();
        int count = expenseCollection.size();
        for (int i = 0; i < count; ++i) {
            ExpenseInfo expenseInfo = expenseCollection.get(i);
            if (expenseInfo.getTreeid() == null) {
                rootSet.add(expenseInfo.getId().toString());
                continue;
            }
            String desLongNumber = this.getDestindationTypeLongNumber(expenseInfo.getTreeid().getLongNumber(), groupLevel);
            expenseFIDToTypeLongNumberMap.put(expenseInfo.getId(), desLongNumber);
            typeLongNumberSet.add(desLongNumber);
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("longNumber", typeLongNumberSet, CompareType.INCLUDE));
        ExpenseTreeCollection expenseTreeCollection = ExpenseTreeFactory.getLocalInstance(ctx).getExpenseTreeCollection(view);
        HashMap<String, BOSUuid> expenseTreeLongNumberToFIDMap = new HashMap<String, BOSUuid>();
        int count2 = expenseTreeCollection.size();
        for (int i = 0; i < count2; ++i) {
            ExpenseTreeInfo expenseTreeInfo = expenseTreeCollection.get(i);
            expenseTreeLongNumberToFIDMap.put(expenseTreeInfo.getLongNumber(), expenseTreeInfo.getId());
        }
        HashMap<String, HashSet<String>> returnExpenseTreeFIDToExpenseIDSetMap = new HashMap<String, HashSet<String>>();
        if (rootSet.size() > 0) {
            returnExpenseTreeFIDToExpenseIDSetMap.put("RootID", rootSet);
        }
        int count3 = expenseCollection.size();
        for (int i = 0; i < count3; ++i) {
            ExpenseInfo expenseInfo = expenseCollection.get(i);
            Object longNumber = expenseFIDToTypeLongNumberMap.get(expenseInfo.getId());
            if (longNumber == null) continue;
            Object typeId = expenseTreeLongNumberToFIDMap.get(longNumber);
            HashSet<String> expenseIDSet = (HashSet<String>)returnExpenseTreeFIDToExpenseIDSetMap.get(typeId.toString());
            if (expenseIDSet == null) {
                expenseIDSet = new HashSet<String>();
                returnExpenseTreeFIDToExpenseIDSetMap.put(typeId.toString(), expenseIDSet);
            }
            expenseIDSet.add(expenseInfo.getId().toString());
        }
        return returnExpenseTreeFIDToExpenseIDSetMap;
    }

    private String getDestindationTypeLongNumber(String srcLongNumber, int groupLevel) {
        String desLongNumber = srcLongNumber;
        for (int i = 1; i < groupLevel && desLongNumber.lastIndexOf("!") > 0; ++i) {
            desLongNumber = desLongNumber.substring(0, desLongNumber.lastIndexOf("!"));
        }
        return desLongNumber;
    }

    protected boolean useOptimizedBatchAssginAndUnassign() {
        return true;
    }

    protected void _delete(Context ctx, IObjectPK dataBaseDPK) throws BOSException, EASBizException {
        StringBuffer companyBuffer = new StringBuffer();
        companyBuffer.append(" delete from T_NCM_expenseCompanyInfo").append("  where FexpenseID = ").append("'" + dataBaseDPK.toString() + "'");
        DbUtil.execute((Context)ctx, (String)companyBuffer.toString());
        super._delete(ctx, dataBaseDPK);
    }

    @Override
    protected boolean _isUsed(Context ctx, IObjectPK pk) throws BOSException {
        BizReference ref = null;
        try {
            ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new ObjectReferedException((Object)ref, (Throwable)e);
        }
        return ref != null;
    }
}

