/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.ncm.PeriodCollection;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.PeriodTypeInfo;
import com.kingdee.eas.basedata.ncm.app.AbstractPeriodControllerBean;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.RefCheckInfo;
import com.kingdee.eas.common.RefChkFilterSet;
import com.kingdee.eas.common.app.dao.ReferenceCheckSqlBuilder;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.Collection2StrSuper;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PeriodControllerBean
extends AbstractPeriodControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ncm.app.PeriodControllerBean");

    @Override
    protected Date _getEndDataInPeriod(Context ctx, IObjectPK typePK) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TOP 1 FENDDATE FROM T_NCM_PERIOD WHERE FPERIODTYPEID = '");
        sql.append(typePK);
        sql.append("' ORDER BY FENDDATE DESC");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                return rs.getDate("FENDDATE");
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        return null;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.isReferenced(ctx, pk);
        super._delete(ctx, pk);
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        PeriodCollection coll = this.getPeriodCollection(ctx, view);
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            PeriodInfo period = coll.get(i);
            ids.add(period.getId().toString());
        }
        this.isReferenced(ctx, ids, null);
        return super._delete(ctx, filter);
    }

    public void isReferenced(Context ctx, List bizObjList, RefChkFilterSet refCheckFilterSet) throws BizReferenceException, BOSException {
        HashSet retSet = new HashSet();
        if (bizObjList == null || bizObjList.isEmpty()) {
            return;
        }
        BOSObjectType bizObjType = BOSUuid.read((String)((String)bizObjList.get(0))).getType();
        List refList = PeriodControllerBean.isRefenceInRefTable(ctx, bizObjType, refCheckFilterSet);
        if (refList == null || refList.isEmpty()) {
            return;
        }
        int size = refList.size();
        for (int i = 0; i < size; ++i) {
            RefCheckInfo refCheckInfo = (RefCheckInfo)refList.get(i);
            Set alreadySet = this.addRefInfoNoLimits(ctx, refCheckInfo.getTableName(), refCheckInfo.getFieldName(), bizObjList, refCheckFilterSet);
            if (alreadySet == null || alreadySet.isEmpty()) continue;
            retSet.addAll(alreadySet);
        }
        if (retSet.size() != 0) {
            BizReference ref = null;
            try {
                ref = ReferenceDAO.getReference((Context)ctx, (BOSUuid)BOSUuid.read((String)((String)bizObjList.get(0))));
            }
            catch (Exception e) {
                throw new ObjectReferedException(ref, (Throwable)e);
            }
            throw new ObjectReferedException((Object)ref);
        }
    }

    private static List isRefenceInRefTable(Context ctx, BOSObjectType bizObjType, RefChkFilterSet refCheckFilterSet) {
        ArrayList<RefCheckInfo> retList = new ArrayList<RefCheckInfo>();
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        String matched = "select FRefTableName,FRefFieldName from T_SYS_EntityRef  where FIsBosFK=1 and FBosType=? ";
        if (refCheckFilterSet != null) {
            matched = matched + refCheckFilterSet.getSQL4RefTableName();
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(matched);
            ps.setString(1, bizObjType.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                RefCheckInfo refCheckInfo = new RefCheckInfo();
                refCheckInfo.setTableName(rs.getString("FRefTableName"));
                refCheckInfo.setFieldName(rs.getString("FRefFieldName"));
                retList.add(refCheckInfo);
            }
        }
        catch (SQLException e1) {
            try {
                logger.error((Object)"BizReferenceException", (Throwable)new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e1));
                throw new RuntimeException((Throwable)new BizReferenceException(BizReferenceException.REFERENCE_DATA_ERROR, (Throwable)e1));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return retList;
    }

    private Set addRefInfoNoLimits(Context ctx, String table, String fieldName, List bizObjList, RefChkFilterSet refCheckFilterSet) throws BOSException, BizReferenceException {
        HashSet retSet = new HashSet();
        Collection2StrSuper superCol = new Collection2StrSuper((Collection)bizObjList);
        while (superCol.hasNext()) {
            Set partSet = this.addRefInfo(ctx, table, fieldName, ToolUtils.trans2List((Collection)superCol.next()), refCheckFilterSet);
            retSet.addAll(partSet);
        }
        return retSet;
    }

    private Set addRefInfo(Context ctx, String table, String fieldName, List bizObjList, RefChkFilterSet refCheckFilterSet) throws BOSException {
        HashSet<String> retSet = new HashSet<String>();
        String sqlStr = "";
        try {
            sqlStr = this.formSql4Ref(ctx, table, fieldName, ToolUtils.aryToStr((List)bizObjList, (boolean)true), refCheckFilterSet);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            while (rowSet.next()) {
                retSet.add(rowSet.getString(1));
            }
        }
        catch (Exception se) {
            logger.error((Object)("check obj ref, sql of form is error,but it's not mind! sql is:" + sqlStr), (Throwable)se);
        }
        return retSet;
    }

    private String formSql4Ref(Context ctx, String table, String fieldName, String idParamInfoStr, RefChkFilterSet refCheckFilterSet) {
        String sql4CU = null;
        if (refCheckFilterSet != null && refCheckFilterSet.getSQL4CU() != null) {
            sql4CU = refCheckFilterSet.getSQL4CU();
        }
        return ReferenceCheckSqlBuilder.getCheckSqlWithInCU((Context)ctx, (String)table, (String)fieldName, (String)sql4CU, (String)idParamInfoStr, (boolean)false);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeModel = (TreeBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        if (treeModel.innerGetParent() == null) {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1 and #2");
            }
        } else {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            if (treeModel.innerGetParent().getId() != null) {
                filterItem = new FilterItemInfo("parent", (Object)treeModel.innerGetParent().getId().toString(), CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1");
            }
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                if (treeModel.innerGetParent().getId() != null) {
                    filter.setMaskString("#0 and #1 and #2");
                } else {
                    filter.setMaskString("#0 and #1");
                }
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterType = this.getFilterForPeriodType(ctx, treeModel);
        if (FilterUtility.hasFilterItem((FilterInfo)filterType)) {
            if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
                filter.mergeFilter(filterType, "AND");
            } else {
                filter = filterType;
            }
        }
        view.setFilter(filter);
        TreeBaseCollection results = this.getTreeBaseCollection(ctx, view);
        if (results != null && results.size() > 0) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeModel.getNumber()});
        }
    }

    private FilterInfo getFilterForPeriodType(Context ctx, TreeBaseInfo treeModel) {
        PeriodTypeInfo type = (PeriodTypeInfo)treeModel.get("periodType");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)type.getId()));
        return filter;
    }

    @Override
    protected int _synchronization(Context ctx, IObjectValue periodType) throws BOSException, EASBizException {
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        UserInfo UserInfo2 = (UserInfo)ctx.get((Object)"UserInfo");
        PeriodTypeInfo type = (PeriodTypeInfo)periodType;
        List orgids = this.getOrgUnitIds(ctx, type);
        for (int i = 0; i < orgids.size(); ++i) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT P.FID FROM T_NCM_PERIOD P WHERE P.FID NOT IN ");
            sql.append("(SELECT S.FPERIODID FROM T_NCM_PERIODSTATUS S ");
            sql.append("WHERE S.FCompanyId =? )");
            sql.append("AND P.FPeriodTypeId = ?");
            sql.append(" ORDER BY P.FNUMBER");
            Object[] params = new Object[]{orgids.get(i), type.getId().toString()};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            try {
                while (rs.next()) {
                    sql.setLength(0);
                    sql.append("insert into T_NCM_PeriodStatus(FID,FPeriodID,FStatu,FCreatorID,FCreateTime,").append("FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FPeriodTypeID,FCompanyID)").append(" values(?,?,'1',?,GetDate(),?,GetDate(),?,?,?)");
                    params = new Object[]{BOSUuid.create((String)"698916A4").toString(), rs.getString("FID"), UserInfo2.getId().toString(), params[2], DefaultCU.getId().toString(), type.getId().toString(), orgids.get(i)};
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
                }
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return 1;
    }

    public List getOrgUnitIds(Context ctx, PeriodTypeInfo type) throws BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        String sql = "select distinct FCompanyID from T_NCM_PeriodStatus where FPeriodTypeID = '" + type.getId() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String company = rs.getString("FCompanyID");
                ids.add(company);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ids;
    }
}

