/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.ncm.PeriodStatuEnum;
import com.kingdee.eas.basedata.ncm.PeriodStatusInfo;
import com.kingdee.eas.basedata.ncm.PeriodTypeInfo;
import com.kingdee.eas.basedata.ncm.app.AbstractPeriodStatusControllerBean;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PeriodStatusControllerBean
extends AbstractPeriodStatusControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ncm.app.PeriodStatusControllerBean");

    @Override
    protected int _synchronization(Context ctx, IObjectValue company, IObjectValue periodType) throws BOSException, EASBizException {
        CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)company;
        PeriodTypeInfo type = (PeriodTypeInfo)periodType;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT P.FID FROM T_NCM_PERIOD P WHERE P.FID NOT IN ");
        sql.append("(SELECT S.FPERIODID FROM T_NCM_PERIODSTATUS S ");
        sql.append("WHERE S.FCompanyId =? AND S.FPeriodTypeId = ?)");
        sql.append("AND P.FPeriodTypeId = ?");
        sql.append(" ORDER BY P.FNUMBER");
        Object[] params = new Object[3];
        params[0] = org.getId().toString();
        params[1] = params[2] = type.getId().toString();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        PeriodStatusInfo info = null;
        try {
            while (rs.next()) {
                info = new PeriodStatusInfo();
                PeriodInfo period = PeriodFactory.getLocalInstance(ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(rs.getString("FID")));
                info.setCompany(org);
                info.setPeriod(period);
                info.setStatu(PeriodStatuEnum.OPEN);
                info.setPeriodType(type);
                super.addnew(ctx, (CoreBaseInfo)info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rs.size();
    }

    @Override
    protected int _getPeriodCount(Context ctx, IObjectValue company, IObjectValue periodType) throws BOSException {
        CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)company;
        PeriodTypeInfo type = (PeriodTypeInfo)periodType;
        String sql = "SELECT COUNT(FID) as TOTAL FROM T_NCM_PERIODSTATUS WHERE FCompanyID = ? and FPeriodTypeID = ?";
        Object[] params = new Object[]{org.getId().toString(), type.getId().toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            if (rs.next()) {
                return rs.getInt("TOTAL");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return 0;
    }
}

