/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ncm.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class PeriodUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ncm.utils.PeriodUtils");
    public static final String STRRESOURCE = "com.kingdee.eas.ma.budget.client.BgPeriodResource";
    public static final Calendar calendar = Calendar.getInstance();
    public static final String YearCode = "Y";
    public static final int YearLevel = 1;
    public static final String SEPARATOR = ".";
    public static final String DayCode = "D";
    public static final String LONGSEPARATOR = "!";
    public static final String MonthCode = "M";
    public static final int MonthLevel = 4;

    public static Date getDayEnd(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        Date ds = new Date(cal.getTimeInMillis());
        return ds;
    }

    public static Date getDayBegin(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date ds = new Date(cal.getTimeInMillis());
        return ds;
    }

    public static Date getDay(int Year, int Month, int Day) {
        calendar.clear();
        calendar.set(Year, Month - 1, Day);
        return calendar.getTime();
    }

    public static Date getDay(String bgPeriodNumber) {
        if (bgPeriodNumber == null) {
            return null;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        try {
            year = new Integer(bgPeriodNumber.substring(0, 4));
            month = new Integer(bgPeriodNumber.substring(6, 8));
            day = new Integer(bgPeriodNumber.substring(10, 12));
            return PeriodUtils.getDay(year, month, day);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static Date getFirstDayOfYear(int year) {
        calendar.clear();
        calendar.set(year, 0, 1);
        return calendar.getTime();
    }

    public static int getCurrentlyYear() {
        calendar.clear();
        calendar.setTime(new Date());
        return calendar.get(1);
    }

    public static int getCurrentlyYear(Date date) {
        if (date != null) {
            calendar.clear();
            calendar.setTime(date);
            return calendar.get(1);
        }
        return 0;
    }

    public static int getCurrentlyMonth(Date date) {
        if (date != null) {
            calendar.clear();
            calendar.setTime(date);
            return calendar.get(2) + 1;
        }
        return 0;
    }

    public static Date getFirstDayOfMonth(int year, int month) {
        calendar.clear();
        calendar.set(year, PeriodUtils.processMonth(month), 1);
        return calendar.getTime();
    }

    public static Date getLastDayOfMonth(int year, int month) {
        calendar.clear();
        calendar.set(year, PeriodUtils.processMonth(month), 1);
        calendar.add(6, calendar.getActualMaximum(5) - 1);
        return calendar.getTime();
    }

    public static Date getStartDate(Date day) {
        calendar.clear();
        calendar.setTime(day);
        PeriodUtils.processClearTime(calendar);
        return calendar.getTime();
    }

    private static void processClearTime(Calendar cal) {
        if (cal != null) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        }
    }

    public static Date getBeoverDate(Date day) {
        calendar.setTime(day);
        PeriodUtils.processSetMaxTime(calendar);
        return calendar.getTime();
    }

    private static void processSetMaxTime(Calendar cal) {
        if (cal != null) {
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 0);
        }
    }

    public static int getDaysOfMonth(int year, int month) {
        calendar.clear();
        calendar.set(year, PeriodUtils.processMonth(month), 1);
        return calendar.getActualMaximum(5);
    }

    private static int processMonth(int month) {
        if (month <= 1) {
            return 0;
        }
        if (month >= 12) {
            return 11;
        }
        int CALENDAR_PROCESS = 0;
        switch (month) {
            case 2: {
                CALENDAR_PROCESS = 1;
                break;
            }
            case 3: {
                CALENDAR_PROCESS = 2;
                break;
            }
            case 4: {
                CALENDAR_PROCESS = 3;
                break;
            }
            case 5: {
                CALENDAR_PROCESS = 4;
                break;
            }
            case 6: {
                CALENDAR_PROCESS = 5;
                break;
            }
            case 7: {
                CALENDAR_PROCESS = 6;
                break;
            }
            case 8: {
                CALENDAR_PROCESS = 7;
                break;
            }
            case 9: {
                CALENDAR_PROCESS = 8;
                break;
            }
            case 10: {
                CALENDAR_PROCESS = 9;
                break;
            }
            case 11: {
                CALENDAR_PROCESS = 10;
            }
        }
        return CALENDAR_PROCESS;
    }
}

