/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.di;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUPartProfitCenterInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.app.di.BizOrgDIBase;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Locale;

public class ProfitCenterDI
extends BizOrgDIBase {
    protected CoreBaseInfo createNewData(Hashtable hsData, Context ctx) throws Exception {
        String number = this.getFieldValue(hsData, "FNumber");
        String parent = this.getFieldValue(hsData, "FParentID");
        String isBizUnit = this.getFieldValue(hsData, "FIsBizUnit");
        String address = this.getFieldValue(hsData, "FAddressID");
        String leader = this.getFieldValue(hsData, "FLeader");
        this.checkRequeiredField(ctx, "FNumber", number);
        this.checkRequeiredField(ctx, "FParentID", parent);
        if (number.equals(parent)) {
            Locale currentLocale = ctx.getLocale();
            throw new Exception(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"ADD_BIZ_NUMBER_NOTEQ_PARENT", (Locale)currentLocale));
        }
        FullOrgUnitInfo unitInfo = this.getFullOrgUnitInfo4BizOrg(ctx, number);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)parent));
        filterInfo.getFilterItems().add(new FilterItemInfo("partProfitCenter.isBizUnit", (Object)Boolean.TRUE));
        if (this.getBizInterface(ctx).exists(filterInfo)) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.basedata.orgext.ORGEXTAutoGenerateResource", (String)"2_CompanyDI", (Locale)ctx.getLocale()));
        }
        unitInfo.setIsProfitOrgUnit(true);
        BizParentAndDelegateInfo pdInfo = this.getBizParentAndDelegationInfo(unitInfo);
        ProfitCenterOrgUnitInfo parentProfitInfo = (ProfitCenterOrgUnitInfo)this.getBizOrgUnitInfo(ctx, OrgType.ProfitCenter, parent);
        pdInfo.setParentOrg(OrgType.ProfitCenter, (OrgUnitInfo)parentProfitInfo);
        OUPartProfitCenterInfo partProfitCenterInfo = unitInfo.getPartProfitCenter();
        if (partProfitCenterInfo == null) {
            partProfitCenterInfo = new OUPartProfitCenterInfo();
            partProfitCenterInfo.setUnit(unitInfo);
            unitInfo.setPartProfitCenter(partProfitCenterInfo);
        }
        if ("1".equalsIgnoreCase(isBizUnit) || "Y".equalsIgnoreCase(isBizUnit)) {
            partProfitCenterInfo.setIsBizUnit(true);
        } else {
            partProfitCenterInfo.setIsBizUnit(false);
        }
        if (address != null && address.length() != 0) {
            AddressInfo addressInfo = (AddressInfo)this.getCoreBaseInfo((ICoreBase)AddressFactory.getLocalInstance((Context)ctx), address);
            if (addressInfo == null) {
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
                message.append(address);
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"ADDRESS_NOT_EXISTED", (Locale)ctx.getLocale()));
                throw new Exception(message.toString());
            }
            partProfitCenterInfo.setAdress(addressInfo);
        }
        if (leader != null && leader.length() != 0) {
            PersonInfo leadInfo = (PersonInfo)this.getCoreBaseInfo((ICoreBase)PersonFactory.getLocalInstance((Context)ctx), leader);
            if (leadInfo == null) {
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
                message.append(leader);
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"LEADER_NOT_EXISTED", (Locale)ctx.getLocale()));
                throw new Exception(message.toString());
            }
            partProfitCenterInfo.setLeader(leadInfo);
        }
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
        orgTypeHelper.addOrgType(OrgType.ProfitCenter);
        unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        return unitInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            Timestamp createTime;
            String creatorNumber;
            String addressNumber;
            String leaderNumber;
            boolean isBizUnit;
            result.put("FNumber", rs.getString("number"));
            String parentNumber = rs.getString("parent.number");
            if (parentNumber != null) {
                result.put("FParentID", parentNumber);
            }
            if (isBizUnit = rs.getBoolean("isBizUnit")) {
                result.put("FIsBizUnit", "Y");
            }
            if ((leaderNumber = rs.getString("leader.number")) != null) {
                result.put("FLeader", leaderNumber);
            }
            if ((addressNumber = rs.getString("address.number")) != null) {
                result.put("FAddressID", addressNumber);
            }
            if ((creatorNumber = rs.getString("creator.number")) != null) {
                result.put("FCreatorNumber", creatorNumber);
            }
            if ((createTime = rs.getTimestamp("createTime")) != null) {
                result.put("FCreateTime", ExcelUtil.formatNationalTime((Context)ctx, (Object)createTime));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"DB_ACCESS_ERROR", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.org.app.ProfitCenterExportQuery";
    }
}

