/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.di;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUPartUnionGroupInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.app.di.OrgDIBase;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Locale;

public class UnionGroupDI
extends OrgDIBase {
    protected CoreBaseInfo createNewData(Hashtable hsData, Context ctx) throws Exception {
        String treeNumber = this.getFieldValue(hsData, "TreeNumber");
        String number = this.getFieldValue(hsData, "FNumber");
        String parent = this.getFieldValue(hsData, "FParentID");
        String name_l1 = this.getFieldValue(hsData, "FName_L1");
        String name_l2 = this.getFieldValue(hsData, "FName_L2");
        String name_l3 = this.getFieldValue(hsData, "FName_L3");
        String simpleName = this.getFieldValue(hsData, "FSimpleName");
        String desc_l1 = this.getFieldValue(hsData, "FDescription_L1");
        String desc_l2 = this.getFieldValue(hsData, "FDescription_L2");
        String desc_l3 = this.getFieldValue(hsData, "FDescription_L3");
        String stockCompany = this.getFieldValue(hsData, "FStockControlCompanyID");
        this.checkRequeiredField(ctx, "TreeNumber", treeNumber);
        this.checkRequeiredField(ctx, "FNumber", number);
        this.checkParentExisted(ctx, parent);
        if (new Locale("L1").equals(ctx.getLocale())) {
            this.checkRequeiredField(ctx, "FName_L1", name_l1);
        } else if (new Locale("L2").equals(ctx.getLocale())) {
            this.checkRequeiredField(ctx, "FName_L2", name_l2);
        } else {
            this.checkRequeiredField(ctx, "FName_L3", name_l3);
        }
        FullOrgUnitInfo unitInfo = new FullOrgUnitInfo();
        unitInfo.setIsUnion(true);
        unitInfo.setIsGrouping(true);
        OrgTreeCollection treeCol = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeCollection("select id, cu.id where number = '" + treeNumber + "'");
        if (treeCol.size() == 0) {
            StringBuffer message = new StringBuffer();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
            message.append(treeNumber);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"UNION_RANGE_NOT_EXISTED", (Locale)ctx.getLocale()));
            throw new Exception(message.toString());
        }
        if (treeCol.size() > 1) {
            StringBuffer message = new StringBuffer();
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
            message.append(treeNumber);
            message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"UNION_RANGE_HAS_VERSION", (Locale)ctx.getLocale()));
            throw new Exception(message.toString());
        }
        unitInfo.put("OrgTreeInfo", (Object)treeCol.get(0));
        if (parent == null || parent.trim().length() == 0 || "null".equalsIgnoreCase(parent)) {
            unitInfo.put("ParentNode", null);
        } else {
            OrgStructureCollection parentStructureCol = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("select id,longNumber,level,displayName,sortCode where tree.number = '" + treeNumber + "' and unit.number = '" + parent + "'");
            if (parentStructureCol.size() == 0) {
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"atCode", (Locale)ctx.getLocale()));
                message.append(treeNumber);
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"unionRange", (Locale)ctx.getLocale()));
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"parentGroup", (Locale)ctx.getLocale()));
                message.append(parent);
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"notExist", (Locale)ctx.getLocale()));
                throw new Exception(message.toString());
            }
            unitInfo.put("ParentNode", (Object)parentStructureCol.get(0));
        }
        OUPartUnionGroupInfo partUnionGroupInfo = unitInfo.getPartUnionGroup();
        if (partUnionGroupInfo == null) {
            partUnionGroupInfo = new OUPartUnionGroupInfo();
            partUnionGroupInfo.setUnit(unitInfo);
            unitInfo.setPartUnionGroup(partUnionGroupInfo);
        }
        if (stockCompany != null && stockCompany.length() != 0) {
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.getCoreBaseInfo((ICoreBase)CompanyOrgUnitFactory.getLocalInstance(ctx), stockCompany);
            if (companyInfo == null) {
                StringBuffer message = new StringBuffer();
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"CODE", (Locale)ctx.getLocale()));
                message.append(stockCompany);
                message.append(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"COMPANY_NOT_EXISTED", (Locale)ctx.getLocale()));
            } else {
                partUnionGroupInfo.setStockControlCompany(companyInfo);
            }
        }
        unitInfo.setNumber(number);
        unitInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        if (name_l1 != null && name_l1.length() != 0) {
            unitInfo.setName(name_l1, new Locale("L1"));
        }
        if (name_l2 != null && name_l2.length() != 0) {
            unitInfo.setName(name_l2, new Locale("L2"));
        }
        if (name_l3 != null && name_l3.length() != 0) {
            unitInfo.setName(name_l3, new Locale("L3"));
        }
        if (simpleName != null && simpleName.length() != 0) {
            unitInfo.setSimpleName(simpleName);
        }
        if (desc_l1 != null && desc_l1.length() != 0) {
            unitInfo.setDescription(desc_l1, new Locale("L1"));
        }
        if (desc_l2 != null && desc_l2.length() != 0) {
            unitInfo.setDescription(desc_l2, new Locale("L2"));
        }
        if (desc_l3 != null && desc_l3.length() != 0) {
            unitInfo.setDescription(desc_l3, new Locale("L3"));
        }
        unitInfo.setMaintainCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
        orgTypeHelper.addOrgType(OrgType.UnionDebt);
        unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        return unitInfo;
    }

    protected void injectIDWhenUpdate(CoreBaseInfo newData, Context ctx) throws Exception {
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            Timestamp createTime;
            String creatorNumber;
            String stockCompanyNumber;
            String desciption;
            String simpleName;
            String parentNumber;
            String fnumber;
            String treeNumber = rs.getString("tree.number");
            if (treeNumber != null) {
                result.put("TreeNumber", treeNumber);
            }
            if ((fnumber = rs.getString("unit.number")) != null) {
                result.put("FNumber", fnumber);
            }
            if ((parentNumber = rs.getString("unit1.number")) != null) {
                result.put("FParentID", parentNumber);
            }
            Locale currentLocale = ctx.getLocale();
            String name = rs.getString("unit.name");
            if (name != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FName_L1", name);
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FName_L2", name);
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FName_L3", name);
                }
            }
            if ((simpleName = rs.getString("unit.simpleName")) != null) {
                result.put("FSimpleName", simpleName);
            }
            if ((desciption = rs.getString("unit.description")) != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FDescription_L1", desciption);
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FDescription_L2", desciption);
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FDescription_L3", desciption);
                }
            }
            if ((stockCompanyNumber = rs.getString("stockControlCompany.number")) != null) {
                result.put("FStockControlCompanyID", stockCompanyNumber);
            }
            if ((creatorNumber = rs.getString("creator.number")) != null) {
                result.put("FCreatorNumber", creatorNumber);
            }
            if ((createTime = rs.getTimestamp("unit.createTime")) != null) {
                result.put("FCreateTime", ExcelUtil.formatNationalTime((Context)ctx, (Object)createTime));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"DB_ACCESS_ERROR", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.org.app.UnionGroupExportQuery";
    }
}

