/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper.orgtypeimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.EconomicTypeEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOUPartFI;
import com.kingdee.eas.basedata.org.IOrgDelegateFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OUPartFICollection;
import com.kingdee.eas.basedata.org.OUPartFIFactory;
import com.kingdee.eas.basedata.org.OUPartFIInfo;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ReportCurrencyConvertMode;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.app.OUPartReference;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.IOrgQueryInfo;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgDBHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.AbstractDefaultOrgTypeImpl;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.QueryCompanyInfo;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.basedata.orgext.OUExtException;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgAppCompanyImpl
extends AbstractDefaultOrgTypeImpl
implements IOrgAppHelper {
    private static Logger logger = Logger.getLogger((String)OrgAppCompanyImpl.class.getName());

    void _checkExistGroup(Context ctx) throws OrgException, EASBizException, BOSException {
        IOUPartFI iPartFI = OUPartFIFactory.getLocalInstance(ctx);
        if (!iPartFI.exists("SELECT id WHERE isGroup = 1")) {
            throw new OUException(OUException.MUST_EXIST_ONE_GROUP);
        }
    }

    private void _checkIsOneGroup(Context ctx, IObjectValue model) throws OrgException, EASBizException, BOSException {
        FullOrgUnitInfo info = (FullOrgUnitInfo)model;
        OUPartFIInfo fiInfo = info.getPartFI();
        if (!fiInfo.isIsGroup()) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isGroup", (Object)new Integer(1), CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filterInfo.setMaskString("#0 and #1");
        }
        if (OUPartFIFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new OrgException(OrgException.ONLY_ONE_GROUP_BYCOMPANY);
        }
    }

    private boolean isFIBizUnitChanged(Context ctx, OUPartFIInfo newInfo, OUPartFIInfo oldInfo) throws BOSException, EASBizException {
        if (newInfo.getId() == null) {
            return false;
        }
        return oldInfo.isIsBizUnit() ^ newInfo.isIsBizUnit();
    }

    private boolean isDelegatedByOthers(Context ctx, FullOrgUnitInfo unit, int orgTypeValue) throws BOSException, EASBizException {
        return OrgDBHelper.isDelegatedByOthers((Context)ctx, (FullOrgUnitInfo)unit, (int)orgTypeValue);
    }

    private void processFIProperties(Context ctx, FullOrgUnitInfo unitInfo, OUPartFIInfo newFIInfo, OUPartFIInfo oldFIInfo, boolean isOrgStart) throws BOSException, EASBizException {
        if (!unitInfo.isIsCU()) {
            return;
        }
        if (newFIInfo.getId() == null) {
            return;
        }
        PeriodTypeInfo oldPeriodType = oldFIInfo.getAccountPeriodType();
        PeriodTypeInfo newPeriodType = newFIInfo.getAccountPeriodType();
        if (oldPeriodType == null && newPeriodType != null || oldPeriodType != null && newPeriodType == null || oldPeriodType != null && newPeriodType != null && !oldPeriodType.getId().toString().equals(newPeriodType.getId().toString())) {
            boolean hasSetStartPeriod = this.checkStartPeriod(ctx, unitInfo);
            if (hasSetStartPeriod) {
                throw new OUExtException(OUExtException.STARTPERIOD_IS_SETED, new Object[]{unitInfo.getNumber()});
            }
            String updateSql = new StringBuffer("UPDATE T_ORG_OUPartFI SET FAccountPeriodID = '").append(newPeriodType.getId().toString()).append("' WHERE FUnitID = '").append(unitInfo.getId().toString()).append("'").toString();
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    private boolean checkStartPeriod(Context ctx, FullOrgUnitInfo unitInfo) throws EASBizException, BOSException {
        String oql = "select * where company.id='" + unitInfo.getId() + "' and startPeriod.id <> null";
        ISystemStatusCtrol iSysStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        return iSysStatusCtrol.exists(oql);
    }

    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
        if (unitInfo.isIsCompanyOrgUnit()) {
            OUPartFIInfo newFIInfo = unitInfo.getPartFI();
            if (!newFIInfo.isIsGroup()) {
                this._checkExistGroup(ctx);
            }
            this._checkIsOneGroup(ctx, (IObjectValue)unitInfo);
            IOUPartFI iPartFI = OUPartFIFactory.getLocalInstance(ctx);
            OUPartFIInfo oldFIInfo = null;
            if (newFIInfo.getId() != null) {
                oldFIInfo = iPartFI.getOUPartFIInfo((IObjectPK)new ObjectUuidPK(newFIInfo.getId()));
            }
            this.processFIProperties(ctx, unitInfo, newFIInfo, oldFIInfo, isOrgStart);
            if (this.isFIBizUnitChanged(ctx, newFIInfo, oldFIInfo)) {
                if (newFIInfo.isIsBizUnit()) {
                    INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
                    if (iNOV.isBizChildrenExist(unitInfo, "00000000-0000-0000-0000-0000000000024F2827FD")) {
                        throw new OUException(OUException.FI_BIZUNIT_CHILDREN);
                    }
                } else if (this.isDelegatedByOthers(ctx, unitInfo, 1)) {
                    throw new OUException(OUException.FI_BIZUNIT_DELEGATED);
                }
            }
            newFIInfo.setUnit(unitInfo);
            OrgDBHelper.updateParameter((Context)ctx);
            if ((newFIInfo.getReportConvertMode() == null || ReportCurrencyConvertMode.Zero.equals((Object)newFIInfo.getReportConvertMode())) && oldFIInfo != null && oldFIInfo.getReportConvertMode() != null && !ReportCurrencyConvertMode.Zero.equals((Object)oldFIInfo.getReportConvertMode())) {
                newFIInfo.setReportConvertMode(oldFIInfo.getReportConvertMode());
            }
            this.checkCurrencyConvertMode(ctx, unitInfo, newFIInfo);
            if (iPartFI.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                if (newFIInfo.getId() == null) {
                    BOSUuid partID = iPartFI.getOUPartFIInfo("Select id Where unit.id = '" + pk.toString() + "'").getId();
                    newFIInfo.setId(partID);
                }
                iPartFI.update((IObjectPK)new ObjectUuidPK(newFIInfo.getId()), newFIInfo);
            } else {
                if (!unitInfo.isIsCU() && !currentCUInfo.isIsCompanyOrgUnit()) {
                    Object[] param = new Object[]{OrgType.Company.getAlias(), OrgType.Company.getAlias()};
                    throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
                }
                newFIInfo.setVersionNumber(versionNumber);
                iPartFI.addnew(newFIInfo);
                unitInfo.setPartFI(newFIInfo);
            }
        } else {
            IOUPartFI iPartFI = OUPartFIFactory.getLocalInstance(ctx);
            if (iPartFI.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                OUPartReference.isReferenced((Context)ctx, (String)new OUPartFIInfo().getBOSType().toString(), (String)pk.toString());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
                iPartFI.delete(filter);
            }
            unitInfo.setPartFI(null);
        }
    }

    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws BOSException, EASBizException {
        if (unitInfo.isIsCompanyOrgUnit()) {
            String versionNumber = unitInfo.getVersionNumber();
            if (!unitInfo.isIsCU() && !currentCUInfo.isIsCompanyOrgUnit()) {
                Object[] param = new Object[]{OrgType.Company.getAlias(), OrgType.Company.getAlias()};
                throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
            }
            OUPartFIInfo ouComInfo = unitInfo.getPartFI();
            if (!ouComInfo.isIsGroup()) {
                this._checkExistGroup(ctx);
            }
            this._checkIsOneGroup(ctx, (IObjectValue)unitInfo);
            ouComInfo.setUnit(unitInfo);
            ouComInfo.setVersionNumber(versionNumber);
            this.checkCurrencyConvertMode(ctx, unitInfo, ouComInfo);
            IOUPartFI iCom = OUPartFIFactory.getLocalInstance(ctx);
            IObjectPK comPK = iCom.addnew(ouComInfo);
            ObjectStringPK pk = new ObjectStringPK(unitInfo.getId().toString());
            this.setAccountTable(ctx, (IObjectValue)unitInfo, (IObjectPK)pk);
            OrgDBHelper.updateParameter((Context)ctx);
            unitInfo.setPartFI(ouComInfo);
        }
    }

    private void checkCurrencyConvertMode(Context ctx, FullOrgUnitInfo unitInfo, OUPartFIInfo fiInfo) throws OUExtException {
        ObjectUuidPK orgUnitId = new ObjectUuidPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
        String paramValue = null;
        try {
            paramValue = ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"G001", (IObjectPK)orgUnitId, (boolean)false);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (paramValue != null && paramValue.trim().equalsIgnoreCase("true") && (fiInfo.getReportConvertMode() == null || ReportCurrencyConvertMode.Zero.equals((Object)fiInfo.getReportConvertMode()))) {
            throw new OUExtException(OUExtException.CURRENCY_CONVERT_MODE_NULL, new Object[]{unitInfo.getNumber()});
        }
    }

    private void setAccountTable(Context ctx, IObjectValue model, IObjectPK pk) throws EASBizException, BOSException {
        OUPartFIInfo fiInfo = ((FullOrgUnitInfo)model).getPartFI();
        if (fiInfo.getAccountTable() != null) {
            IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
            iAccountView.addAccountByCompany(pk);
        }
    }

    public void delOrgInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
        if (deleteInfo.isIsCompanyOrgUnit()) {
            INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
            IOrgDelegateFacade iDelegate = OrgDelegateFacadeFactory.getLocalInstance((Context)ctx);
            Object[] params = new String[]{OrgType.Company.getAlias()};
            if (iNOV.isBizChildrenExist(deleteInfo, "00000000-0000-0000-0000-0000000000024F2827FD")) {
                throw new OUException(OUException.EXISTCHILDREN_NOTDELETE, params);
            }
            if (iDelegate.isDelegatedByOthers(deleteInfo.getId().toString(), 1)) {
                throw new OUException(OUException.DELEGATEDBYOTHERS_NOTDELETE, params);
            }
            ObjectStringPK pk = new ObjectStringPK(deleteInfo.getId().toString());
            OUPartReference.isReferenced((Context)ctx, (String)"5C40E07B", (String)pk.toString());
            OUPartReference.isReferenced((Context)ctx, (String)"16FD9F90", (String)pk.toString());
            IOUPartFI iFI = OUPartFIFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iFI.delete(filter);
        }
    }

    public String[] getRebuildSql() {
        StringBuffer sb = new StringBuffer(800);
        sb.append("insert into T_ORG_Company (\n").append("FID,\n").append("FName_L1,\n").append("FName_L2,\n").append("FName_L3,\n").append("FNumber,\n").append("FDescription_L1,\n").append("FDescription_L2,\n").append("FDescription_L3,\n").append("FSimpleName,\n").append("FIsGrouping,\n").append("FEffectDate,\n").append("FInvalidDate,\n").append("FIsFreeze,\n").append("FIsCompanyOrgUnit,\n").append("FIsAdminOrgUnit,\n").append("FIsSaleOrgUnit,\n").append("FIsPurchaseOrgUnit,\n").append("FIsStorageOrgUnit,\n").append("FIsProfitOrgUnit,\n").append("FIsCostOrgUnit,\n").append("FIsCU,\n").append("FIsUnion,\n").append("FIsHROrgUnit,\n").append("FCreatorID,\n").append("FCreateTime,\n").append("FLastUpdateUserID,\n").append("FLastUpdateTime,\n").append("FControlUnitID,\n").append("FIsLeaf,\n").append("FLevel,\n").append("FLongNumber,\n").append("FParentID,\n").append("FTaxNumber,\n").append("FIsGroup,\n").append("FIsOnlyUnion,\n").append("FIndustry,\n").append("FBankID,\n").append("FReportCurrencyID,\n").append("FAccountPeriodID,\n").append("FJuridicalPersonID,\n").append("FAccountTableID,\n").append("FAddressID,\n").append("FBaseCurrencyID,\n").append("FBaseExgTableID,\n").append("FAdjustExgTableID,\n").append("FReportConvertMode,\n").append("FReportExgTableID,\n").append("FIsSealUp,\n").append("FIsBizUnit,\n").append("FIsStart,\n").append("FIsOUSealUp,\n").append("FDisplayName_L1,\n").append("FDisplayName_L2,\n").append("FDisplayName_L3,\n").append("FCompanyID, \n").append("FRegion,\n").append("FEconomicType,\n").append("FRegisteredCapital,\n").append("FSetupDate,\n").append("FEndupDate,\n").append("FTerritory_L1,\n").append("FTerritory_L2,\n").append("FTerritory_L3,\n").append("FIsChurchyard,\n").append("FRegisteredCode,\n").append("FPropertySealUpDate,\n").append("FVersionNumber,\n").append("FCode,\n").append("FIsAssistantOrg,\n").append("FMainOrgID,\n").append("FAccountSchemeID,\n").append("FIsTransportOrgUnit,\n").append("forgTypeStr,\n").append("FIsQualityOrgUnit,\n").append("FTaxRegisterName,\n").append("FTaxpayerID,\n").append("FAuthorizationCode,\n").append("FAuthorizationKey,\n").append("FEncryptionKey,\n").append("FActivityDate,\n").append("FContact,\n").append("FInvoiceNumber,\n").append("FInvoiceCount,\n").append("FTaxType,\n").append("FBankName,\n").append("FTaxCode,\n").append("FContactPhone,\n").append("FBankAccount,\n").append("FTaxAddress)\n").append("SELECT\n").append("ou.FID,\n").append("ou.FName_L1,\n").append("ou.FName_L2,\n").append("ou.FName_L3,\n").append("ou.FNumber,\n").append("ou.FDescription_L1,\n").append("ou.FDescription_L2,\n").append("ou.FDescription_L3,\n").append("ou.FSimpleName,\n").append("ou.FIsGrouping,\n").append("ou.FEffectDate,\n").append("ou.FInvalidDate,\n").append("ou.FIsFreeze,\n").append("ou.FIsCompanyOrgUnit,\n").append("ou.FIsAdminOrgUnit,\n").append("ou.FIsSaleOrgUnit,\n").append("ou.FIsPurchaseOrgUnit,\n").append("ou.FIsStorageOrgUnit,\n").append("ou.FIsProfitOrgUnit,\n").append("ou.FIsCostOrgUnit,\n").append("ou.FIsCU,\n").append("ou.FIsUnion,\n").append("ou.FIsHROrgUnit,\n").append("ou.FCreatorID,\n").append("ou.FCreateTime,\n").append("ou.FLastUpdateUserID,\n").append("ou.FLastUpdateTime,\n").append("ou.FControlUnitID,\n").append("stru.FIsLeaf,\n").append("stru.FLevel,\n").append("stru.FLongNumber,\n").append("stru1.FUnitId AS FParentID,\n").append("fi.FTaxNumber,\n").append("fi.FIsGroup,\n").append("fi.FIsOnlyUnion,\n").append("fi.FIndustry,\n").append("fi.FBankID,\n").append("fi.FReportCurrencyID,\n").append("fi.FAccountPeriodID,\n").append("fi.FJuridicalPersonID,\n").append("fi.FAccountTableID,\n").append("fi.FAddressID,\n").append("fi.FBaseCurrencyID,\n").append("fi.FBaseExgTableID,\n").append("fi.FAdjustExgTableID,\n").append("fi.FReportConvertMode,\n").append("fi.FReportExgTableID,\n").append("fi.FIsSealUp,\n").append("fi.FIsBizUnit,\n").append("ou.FIsStart,\n").append("ou.FIsOUSealUp,\n").append("stru.FDisplayName_L1,\n").append("stru.FDisplayName_L2,\n").append("stru.FDisplayName_L3,\n").append("NULL AS FCompanyID, \n").append("fi.FRegion,\n").append("fi.FEconomicType,\n").append("fi.FRegisteredCapital,\n").append("fi.FSetupDate,\n").append("fi.FEndupDate,\n").append("fi.FTerritory_L1,\n").append("fi.FTerritory_L2,\n").append("fi.FTerritory_L3,\n").append("fi.FIsChurchyard,\n").append("fi.FRegisteredCode,\n").append("fi.FPropertySealUpDate,\n").append("ou.FVersionNumber,\n").append("ou.FCode,\n").append("ou.FIsAssistantOrg,\n").append("ou.FMainOrgID,\n").append("fi.FAccountSchemeID,\n").append("ou.FIsTransportOrgUnit,\n").append("ou.forgTypeStr,\n").append("ou.FIsQualityOrgUnit,\n").append("fi.FTaxRegisterName,\n").append("fi.FTaxpayerID,\n").append("fi.FAuthorizationCode,\n").append("fi.FAuthorizationKey,\n").append("fi.FEncryptionKey,\n").append("fi.FActivityDate,\n").append("fi.FContact,\n").append("fi.FInvoiceNumber,\n").append("fi.FInvoiceCount,\n").append("fi.FTaxType,\n").append("fi.FBankName,\n").append("fi.FTaxCode,\n").append("fi.FContactPhone,\n").append("fi.FBankAccount,\n").append("FTaxAddress\n").append("FROM T_ORG_BaseUnit ou INNER JOIN\n").append("T_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\n").append("T_ORG_Structure stru1 ON stru.FParentID = stru1.FID INNER JOIN\n").append("T_ORG_OUPartFI fi ON ou.FID = fi.FUnitID\n").append("WHERE (stru.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD')\n");
        return new String[]{"delete from T_ORG_Company", sb.toString()};
    }

    public OrgTypeSelfInfo getOrgTypeSelfInfo() {
        OrgTypeSelfInfo orgInfo = new OrgTypeSelfInfo();
        orgInfo.setTableName("t_org_oupartfi");
        orgInfo.setTableNameAlias("partFI");
        orgInfo.setViewTableName("t_org_company");
        orgInfo.setViewTableAlias("fi");
        orgInfo.setViewTableNameHis("t_org_company_his");
        orgInfo.setTableNameHis("t_org_oupartfi_his");
        orgInfo.setIOrgQueryInfo((IOrgQueryInfo)new QueryCompanyInfo());
        orgInfo.setOuPartInfo((OUPartCoreBaseInfo)new OUPartFIInfo());
        orgInfo.setOrgUnitViewInfo((OrgUnitInfo)new CompanyOrgUnitInfo());
        orgInfo.setOrgViewBosType(new CompanyOrgUnitInfo().getBOSType());
        orgInfo.setOrgTableBosType(new OUPartFIInfo().getBOSType());
        orgInfo.setOrgType(OrgType.Company);
        return orgInfo;
    }

    protected OrgUnitInfo _getCompanyOrgUnitVersionInfo(Context ctx, String versionNumber, BOSUuid id) throws BOSException, EASBizException {
        return this.getUnitVersionInfo(ctx, new VersionPK(versionNumber, id));
    }

    protected OrgUnitCollection _getCompanyOrgUnitVersionCollection(Context ctx, String versionNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Company_His WHERE FVersionNumber = '").append(versionNumber).append("'").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    protected OUPartFICollection _getOUPartFIVersionCollection(Context ctx) throws BOSException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartFI_His").toString();
        try {
            OUPartFICollection partFIVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            OUPartFICollection oUPartFICollection = partFIVersionCol = OrgAppCompanyImpl.createOUPartFIVersionCollection(ctx, (ResultSet)rs);
            return oUPartFICollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public static OUPartFICollection createOUPartFIVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OUPartFICollection partCompanyVersionCol = new OUPartFICollection();
        while (rs.next()) {
            OUPartFIInfo partCompanyVersionInfo = OrgAppCompanyImpl.createOUPartFIVersionInfo(ctx, rs);
            partCompanyVersionCol.add(partCompanyVersionInfo);
        }
        return partCompanyVersionCol;
    }

    public static OUPartFIInfo createOUPartFIVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String adjustExgTableId;
        String baseExgTableId;
        String baseCurrencyId;
        String addressId;
        String accountTableId;
        String juridicalPersonId;
        String accountPeriodId;
        String reportCurrencyId;
        String bankId;
        String versionNumber = rs.getString("FVersionNumber");
        String id = rs.getString("FID");
        OUPartFIInfo partFIVersionInfo = new OUPartFIInfo(versionNumber, BOSUuid.read((String)id));
        String unitId = rs.getString("FUnitID");
        if (unitId != null && unitId.trim().length() != 0) {
            FullOrgUnitInfo fullVersionInfo = new FullOrgUnitInfo(versionNumber, BOSUuid.read((String)unitId));
            partFIVersionInfo.setUnit(fullVersionInfo);
        }
        partFIVersionInfo.setTaxNumber(rs.getString("FTaxNumber"));
        partFIVersionInfo.setIsGroup(rs.getBoolean("FIsGroup"));
        partFIVersionInfo.setIsOnlyUnion(rs.getBoolean("FIsOnlyUnion"));
        String industryId = rs.getString("FIndustry");
        if (industryId != null && industryId.trim().length() != 0) {
            partFIVersionInfo.setIndustry((IndustryInfo)OrgHelper.getVO((Context)ctx, (String)industryId));
        }
        if ((bankId = rs.getString("FBankID")) != null && bankId.trim().length() != 0) {
            partFIVersionInfo.setBank((BankInfo)OrgHelper.getVO((Context)ctx, (String)bankId));
        }
        if ((reportCurrencyId = rs.getString("FReportCurrencyID")) != null && reportCurrencyId.trim().length() != 0) {
            partFIVersionInfo.setReportCurrency((CurrencyInfo)OrgHelper.getVO((Context)ctx, (String)reportCurrencyId));
        }
        if ((accountPeriodId = rs.getString("FAccountPeriodID")) != null && accountPeriodId.trim().length() != 0) {
            partFIVersionInfo.setAccountPeriodType((PeriodTypeInfo)OrgHelper.getVO((Context)ctx, (String)accountPeriodId));
        }
        if ((juridicalPersonId = rs.getString("FJuridicalPersonID")) != null && juridicalPersonId.trim().length() != 0) {
            partFIVersionInfo.setJuridicalPerson((PersonInfo)OrgHelper.getVO((Context)ctx, (String)juridicalPersonId));
        }
        if ((accountTableId = rs.getString("FAccountTableID")) != null && accountTableId.trim().length() != 0) {
            partFIVersionInfo.setAccountTable((AccountTableInfo)OrgHelper.getVO((Context)ctx, (String)accountTableId));
        }
        if ((addressId = rs.getString("FAddressID")) != null && addressId.trim().length() != 0) {
            partFIVersionInfo.setAddress((AddressInfo)OrgHelper.getVO((Context)ctx, (String)addressId));
        }
        if ((baseCurrencyId = rs.getString("FBaseCurrencyID")) != null && baseCurrencyId.trim().length() != 0) {
            partFIVersionInfo.setBaseCurrency((CurrencyInfo)OrgHelper.getVO((Context)ctx, (String)baseCurrencyId));
        }
        if ((baseExgTableId = rs.getString("FBaseExgTableID")) != null && baseExgTableId.trim().length() != 0) {
            partFIVersionInfo.setBaseExchangeTable((ExchangeTableInfo)OrgHelper.getVO((Context)ctx, (String)baseExgTableId));
        }
        if ((adjustExgTableId = rs.getString("FAdjustExgTableID")) != null && adjustExgTableId.trim().length() != 0) {
            partFIVersionInfo.setAdjustExchangeTable((ExchangeTableInfo)OrgHelper.getVO((Context)ctx, (String)adjustExgTableId));
        }
        partFIVersionInfo.setReportConvertMode(ReportCurrencyConvertMode.getEnum(rs.getInt("FReportConvertMode")));
        String reportExgTableId = rs.getString("FReportExgTableID");
        if (reportExgTableId != null && reportExgTableId.trim().length() != 0) {
            partFIVersionInfo.setReportExchangeTable((ExchangeTableInfo)OrgHelper.getVO((Context)ctx, (String)reportExgTableId));
        }
        partFIVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        partFIVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        String regionId = rs.getString("FRegion");
        if (regionId != null && regionId.trim().length() != 0) {
            RegionInfo regionInfo = new RegionInfo();
            regionInfo.setId(BOSUuid.read((String)regionId));
            partFIVersionInfo.setRegion(regionInfo);
        }
        partFIVersionInfo.setEconomicType(EconomicTypeEnum.getEnum(rs.getInt("FEconomicType")));
        partFIVersionInfo.setRegisteredCapital(rs.getBigDecimal("FRegisteredCapital"));
        partFIVersionInfo.setSetupDate(rs.getTimestamp("FSetupDate"));
        partFIVersionInfo.setEndupDate(rs.getTimestamp("FEndupDate"));
        LanguageCollection lc = OrgVersionServerUtils.getLanguageCollection((Context)ctx);
        String strTerritory = "FTerritory_";
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo langInfo = lc.get(i);
            String territory = strTerritory + langInfo.getPostfix();
            partFIVersionInfo.setTerritory(rs.getString(territory), langInfo.getLocale());
        }
        partFIVersionInfo.setIsChurchyard(rs.getBoolean("FIsChurchyard"));
        partFIVersionInfo.setRegisteredCode(rs.getString("FRegisteredCode"));
        partFIVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        String strCompanyDescription = "FCompanyDescription_";
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo langInfo = lc.get(i);
            String companyDescription = strCompanyDescription + langInfo.getPostfix();
            partFIVersionInfo.setCompanyDescription(rs.getString(companyDescription), langInfo.getLocale());
        }
        return partFIVersionInfo;
    }

    public static OrgUnitCollection createCompanyOrgUnitVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OrgUnitCollection companyVersionCol = new OrgUnitCollection();
        while (rs.next()) {
            CompanyOrgUnitInfo companyVersionInfo = OrgAppCompanyImpl.createCompanyOrgUnitVersionInfo(ctx, rs);
            companyVersionCol.add((OrgUnitInfo)companyVersionInfo);
        }
        return companyVersionCol;
    }

    public static CompanyOrgUnitInfo createCompanyOrgUnitVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String parentId;
        String adjustExgTableId;
        String baseExgTableId;
        String baseCurrencyId;
        String addressId;
        String accountTableId;
        String juridicalPersonId;
        String accountPeriodId;
        String reportCurrencyId;
        String bankId;
        CompanyOrgUnitInfo companyVersionInfo = (CompanyOrgUnitInfo)OrgVersionServerUtils.createOrgUnitVersionInfo((Context)ctx, (OrgUnitInfo)new CompanyOrgUnitInfo(), (ResultSet)rs);
        String versionNumber = companyVersionInfo.getVersionNumber();
        companyVersionInfo.setTaxNumber(rs.getString("FTaxNumber"));
        companyVersionInfo.setIsGroup(rs.getBoolean("FIsGroup"));
        companyVersionInfo.setIsOnlyUnion(rs.getBoolean("FIsOnlyUnion"));
        String industryId = rs.getString("FIndustry");
        if (industryId != null && industryId.trim().length() != 0) {
            IndustryInfo industryInfo = new IndustryInfo();
            industryInfo.setId(BOSUuid.read((String)industryId));
            companyVersionInfo.setIndustry(industryInfo);
        }
        if ((bankId = rs.getString("FBankID")) != null && bankId.trim().length() != 0) {
            AccountBankInfo accountBankInfo = new AccountBankInfo();
            accountBankInfo.setId(BOSUuid.read((String)bankId));
            companyVersionInfo.setAccountBank(accountBankInfo);
        }
        if ((reportCurrencyId = rs.getString("FReportCurrencyID")) != null && reportCurrencyId.trim().length() != 0) {
            CurrencyInfo reportCurrencyInfo = new CurrencyInfo();
            reportCurrencyInfo.setId(BOSUuid.read((String)reportCurrencyId));
            companyVersionInfo.setReportCurrency(reportCurrencyInfo);
        }
        if ((accountPeriodId = rs.getString("FAccountPeriodID")) != null && accountPeriodId.trim().length() != 0) {
            PeriodTypeInfo accountPeriodInfo = new PeriodTypeInfo();
            accountPeriodInfo.setId(BOSUuid.read((String)accountPeriodId));
            companyVersionInfo.setAccountPeriodType(accountPeriodInfo);
        }
        if ((juridicalPersonId = rs.getString("FJuridicalPersonID")) != null && juridicalPersonId.trim().length() != 0) {
            PersonInfo juridicalPersonInfo = new PersonInfo();
            juridicalPersonInfo.setId(BOSUuid.read((String)juridicalPersonId));
            companyVersionInfo.setJuridicalPerson(juridicalPersonInfo);
        }
        if ((accountTableId = rs.getString("FAccountTableID")) != null && accountTableId.trim().length() != 0) {
            AccountTableInfo accountTableInfo = new AccountTableInfo();
            accountTableInfo.setId(BOSUuid.read((String)accountTableId));
            companyVersionInfo.setAccountTable(accountTableInfo);
        }
        if ((addressId = rs.getString("FAddressID")) != null && addressId.trim().length() != 0) {
            AddressInfo addressInfo = new AddressInfo();
            addressInfo.setId(BOSUuid.read((String)addressId));
            companyVersionInfo.setAddress(addressInfo);
        }
        if ((baseCurrencyId = rs.getString("FBaseCurrencyID")) != null && baseCurrencyId.trim().length() != 0) {
            CurrencyInfo baseCurrencyInfo = new CurrencyInfo();
            baseCurrencyInfo.setId(BOSUuid.read((String)baseCurrencyId));
            companyVersionInfo.setBaseCurrency(baseCurrencyInfo);
        }
        if ((baseExgTableId = rs.getString("FBaseExgTableID")) != null && baseExgTableId.trim().length() != 0) {
            ExchangeTableInfo baseExgTableInfo = new ExchangeTableInfo();
            baseExgTableInfo.setId(BOSUuid.read((String)baseExgTableId));
            companyVersionInfo.setBaseExchangeTable(baseExgTableInfo);
        }
        if ((adjustExgTableId = rs.getString("FAdjustExgTableID")) != null && adjustExgTableId.trim().length() != 0) {
            ExchangeTableInfo adjustExgTableInfo = new ExchangeTableInfo();
            adjustExgTableInfo.setId(BOSUuid.read((String)adjustExgTableId));
            companyVersionInfo.setAdjustExchangeTable(adjustExgTableInfo);
        }
        companyVersionInfo.setReportConvertMode(ReportCurrencyConvertMode.getEnum(rs.getInt("FReportConvertMode")));
        String reportExgTableId = rs.getString("FReportExgTableID");
        if (reportExgTableId != null && reportExgTableId.trim().length() != 0) {
            ExchangeTableInfo reportExgTableInfo = new ExchangeTableInfo();
            reportExgTableInfo.setId(BOSUuid.read((String)reportExgTableId));
            companyVersionInfo.setReportExchangeTable(reportExgTableInfo);
        }
        if ((parentId = rs.getString("FParentID")) != null && parentId.trim().length() != 0) {
            CompanyOrgUnitInfo parentVersionInfo = new CompanyOrgUnitInfo(versionNumber, BOSUuid.read((String)parentId));
            companyVersionInfo.setParent(parentVersionInfo);
        }
        companyVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        companyVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        String regionId = rs.getString("FRegion");
        if (regionId != null && regionId.trim().length() != 0) {
            RegionInfo regionInfo = new RegionInfo();
            regionInfo.setId(BOSUuid.read((String)regionId));
            companyVersionInfo.setRegion(regionInfo);
        }
        companyVersionInfo.setEconomicType(EconomicTypeEnum.getEnum(rs.getInt("FEconomicType")));
        companyVersionInfo.setRegisteredCapital(rs.getBigDecimal("FRegisteredCapital"));
        companyVersionInfo.setSetupDate(rs.getTimestamp("FSetupDate"));
        companyVersionInfo.setEndupDate(rs.getTimestamp("FEndupDate"));
        LanguageCollection lc = OrgVersionServerUtils.getLanguageCollection((Context)ctx);
        String strTerritory = "FTerritory_";
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo langInfo = lc.get(i);
            String territory = strTerritory + langInfo.getPostfix();
            companyVersionInfo.setTerritory(rs.getString(territory), langInfo.getLocale());
        }
        companyVersionInfo.setIsChurchyard(rs.getBoolean("FIsChurchyard"));
        companyVersionInfo.setRegisteredCode(rs.getString("FRegisteredCode"));
        companyVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return companyVersionInfo;
    }

    public List getInsertHisDataSql() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("INSERT INTO T_ORG_OUPartFI_His(FID,FUnitID,FTaxNumber,FIsGroup,FIsOnlyUnion,FReportCurrencyID,FJuridicalPersonID,FAccountTableID,FAddressID,FBaseCurrencyID,FReportConvertMode,FIndustry,FBankID,FAccountPeriodID,FBaseExgTableID,FAdjustExgTableID,FReportExgTableID,FIsBizUnit,FIsSealUp,FCompanyID,FRegion,FEconomicType,FRegisteredCapital,FSetupDate,FEndupDate,FCompanyDescription_L1,FCompanyDescription_L2,FCompanyDescription_L3, FTerritory_L1, FTerritory_L2, FTerritory_L3, FIsChurchyard, FRegisteredCode, FPropertySealUpDate,FVersionNumber,FTaxRegisterName,FTaxpayerID,FAuthorizationCode,FAuthorizationKey,FEncryptionKey) SELECT FID,FUnitID,FTaxNumber,FIsGroup,FIsOnlyUnion,FReportCurrencyID,FJuridicalPersonID,FAccountTableID,FAddressID,FBaseCurrencyID,FReportConvertMode,FIndustry,FBankID,FAccountPeriodID,FBaseExgTableID,FAdjustExgTableID,FReportExgTableID,FIsBizUnit,FIsSealUp,FCompanyID,FRegion,FEconomicType,FRegisteredCapital,FSetupDate,FEndupDate,FCompanyDescription_L1,FCompanyDescription_L2,FCompanyDescription_L3, FTerritory_L1, FTerritory_L2, FTerritory_L3, FIsChurchyard, FRegisteredCode, FPropertySealUpDate,FVersionNumber,FTaxRegisterName,FTaxpayerID,FAuthorizationCode,FAuthorizationKey,FEncryptionKey FROM T_ORG_OUPartFI");
        retList.add("INSERT INTO T_ORG_Company_His(FID,FName_L1,FName_L2,FName_L3,FNumber,FDescription_L1,FDescription_L2,FDescription_L3,FSimpleName,FIsGrouping,FEffectDate,FInvalidDate,FIsFreeze,FIsCompanyOrgUnit,FIsAdminOrgUnit,FIsSaleOrgUnit,FIsPurchaseOrgUnit,FIsStorageOrgUnit,FIsProfitOrgUnit,FIsCostOrgUnit,FIsCU,FIsUnion,FIsHROrgUnit,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FIsLeaf,FLevel,FLongNumber,FParentID,FTaxNumber,FIsGroup,FIsOnlyUnion,FIndustry,FBankID,FReportCurrencyID,FAccountPeriodID,FJuridicalPersonID,FAccountTableID,FAddressID,FBaseCurrencyID,FBaseExgTableID,FAdjustExgTableID,FReportConvertMode,FReportExgTableID,FIsSealUp,FIsBizUnit,FIsStart,FIsOUSealUp,FDisplayName_L1,FDisplayName_L2,FDisplayName_L3,FCompanyID,FRegion,FEconomicType,FRegisteredCapital,FSetupDate,FEndupDate,FTerritory_L1,FTerritory_L2,FTerritory_L3,FIsChurchyard,FRegisteredCode,FPropertySealUpDate,FVersionNumber, FCode, FIsAssistantOrg, FMainOrgID, FAccountSchemeID, FIsTransportOrgUnit,forgTypeStr,FTaxRegisterName,FTaxpayerID,FAuthorizationCode,FAuthorizationKey,FEncryptionKey) SELECT FID,FName_L1,FName_L2,FName_L3,FNumber,FDescription_L1,FDescription_L2,FDescription_L3,FSimpleName,FIsGrouping,FEffectDate,FInvalidDate,FIsFreeze,FIsCompanyOrgUnit,FIsAdminOrgUnit,FIsSaleOrgUnit,FIsPurchaseOrgUnit,FIsStorageOrgUnit,FIsProfitOrgUnit,FIsCostOrgUnit,FIsCU,FIsUnion,FIsHROrgUnit,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FIsLeaf,FLevel,FLongNumber,FParentID,FTaxNumber,FIsGroup,FIsOnlyUnion,FIndustry,FBankID,FReportCurrencyID,FAccountPeriodID,FJuridicalPersonID,FAccountTableID,FAddressID,FBaseCurrencyID,FBaseExgTableID,FAdjustExgTableID,FReportConvertMode,FReportExgTableID,FIsSealUp,FIsBizUnit,FIsStart,FIsOUSealUp,FDisplayName_L1,FDisplayName_L2,FDisplayName_L3,FCompanyID,FRegion,FEconomicType,FRegisteredCapital,FSetupDate,FEndupDate,FTerritory_L1,FTerritory_L2,FTerritory_L3,FIsChurchyard,FRegisteredCode,FPropertySealUpDate,FVersionNumber, FCode, FIsAssistantOrg, FMainOrgID, FAccountSchemeID, FIsTransportOrgUnit,forgTypeStr,FTaxRegisterName,FTaxpayerID,FAuthorizationCode,FAuthorizationKey,FEncryptionKey FROM T_ORG_Company");
        return retList;
    }

    public List getOrgVersioningUpdateStmts(String inValidateStr, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(new StringBuffer().append("UPDATE T_ORG_Company_His SET FInvalidDate = {ts'").append(inValidateStr).append("'}").append(" WHERE FVersionNumber = '").append(versionNumber).append("'").toString());
        return retList;
    }

    public OrgUnitInfo createOrgUnitVersionInfo(String versionNumber, String id) {
        return new CompanyOrgUnitInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadSuperiorHisOrgUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        if (fullVersionInfo.isIsCompanyOrgUnit()) {
            CompanyOrgUnitInfo companyVersionInfo = (CompanyOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(fullVersionInfo.getVersionNumber(), fullVersionInfo.getId()));
            if (companyVersionInfo == null) {
                throw new OUException(OUException.NONE_FI_SUPERIOR);
            }
            CompanyOrgUnitInfo info = companyVersionInfo.getParent();
            pdInfo.setParentOrg(OrgType.Company, (OrgUnitInfo)((CompanyOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(info.getVersionNumber(), info.getId()))));
        }
    }

    public CoreBaseInfo createOUPartOrgUnitVersionInfo(String versionNumber, String id) {
        return new OUPartFIInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadOUPartVersion(Context ctx, FullOrgUnitInfo fullVersionInfo, ResultSet rs) throws BOSException, EASBizException, SQLException {
        String versionNumber = fullVersionInfo.getVersionNumber();
        String partFIId = rs.getString("FPartFIID");
        if (partFIId != null && partFIId.trim().length() != 0) {
            OUPartFIInfo partFIVersionInfo = new OUPartFIInfo(versionNumber, BOSUuid.read((String)partFIId));
            fullVersionInfo.setPartFI(partFIVersionInfo);
        }
    }

    public OrgUnitInfo getUnitVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Company_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OrgUnitInfo orgUnitInfo = null;
                return orgUnitInfo;
            }
            CompanyOrgUnitInfo companyVersionInfo = OrgAppCompanyImpl.createCompanyOrgUnitVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with pk: " + pk);
            }
            CompanyOrgUnitInfo companyOrgUnitInfo = companyVersionInfo;
            return companyOrgUnitInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        if (longNumber == null || longNumber.trim().length() == 0) {
            throw new BOSException("longNumber can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Company_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND (FLongNumber = '").append(longNumber).append("'").append(" OR FLongNumber LIKE '").append(longNumber + "!%").append("')").append(" ORDER BY FLongNumber").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    private OrgUnitCollection getOrgUnitVersionCollectionBySql(Context ctx, String sql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            OrgUnitCollection companyVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            OrgUnitCollection orgUnitCollection = companyVersionCol = OrgAppCompanyImpl.createCompanyOrgUnitVersionCollection(ctx, (ResultSet)rs);
            return orgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, IObjectPK cuOrgPK, String versionNumber) throws BOSException, EASBizException {
        String tableName = this.getOrgTypeSelfInfo().getViewTableNameHis();
        String sql = "SELECT FID, FVersionNumber FROM " + tableName + " WHERE FControlUnitID = '" + cuOrgPK + "' and forgTypeStr like '%" + this.getOrgTypeSelfInfo().getOrgType().getName() + "%' FVersionNumber = '" + versionNumber + "'";
        return this.getOrgUnitVersionCollectionBySql(ctx, sql);
    }

    private OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String selectSql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OUPartCoreBaseInfo oUPartCoreBaseInfo = null;
                return oUPartCoreBaseInfo;
            }
            OUPartFIInfo partFIVersionInfo = OrgAppCompanyImpl.createOUPartFIVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with selectSql: " + selectSql);
            }
            OUPartFIInfo oUPartFIInfo = partFIVersionInfo;
            return oUPartFIInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartFI_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String version, String orgId) throws BOSException, EASBizException {
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartFI_His WHERE ").append("FVersionNumber = '").append(version).append("'").append(" AND FUNITID = '").append(orgId).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public void batchDelOrgInfo(Context ctx, FullOrgUnitCollection unitCol) throws BOSException, EASBizException {
        for (int i = 0; i < unitCol.size(); ++i) {
            FullOrgUnitInfo unitInfo = unitCol.get(i);
            if (!unitInfo.isIsCompanyOrgUnit()) {
                return;
            }
            Object[] params = new String[]{OrgType.Company.getAlias(), OrgType.Company.getAlias()};
            if (OrgAppHelper.isCUBizPropertyExistInOU((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)1)) {
                throw new OUException(OUException.EXISTINCU_NOTDELETE, params);
            }
            unitInfo.setIsCompanyOrgUnit(false);
            ObjectStringPK pk = new ObjectStringPK(unitInfo.getId().toString());
            OUPartReference.delReferenced((Context)ctx, (String)"5C40E07B", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getTableName());
            OUPartReference.delReferenced((Context)ctx, (String)"16FD9F90", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getViewTableName());
            IOUPartFI iCom = OUPartFIFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iCom.delete(filter);
            unitInfo.setPartFI(null);
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
            orgTypeHelper.removeOrgType(OrgType.Company);
            unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        }
    }
}

