/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper.orgtypeimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOUPartCostCenter;
import com.kingdee.eas.basedata.org.IOrgDelegateFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OUPartCostCenterCollection;
import com.kingdee.eas.basedata.org.OUPartCostCenterFactory;
import com.kingdee.eas.basedata.org.OUPartCostCenterInfo;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.app.OUPartReference;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgDBHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.AbstractDefaultOrgTypeImpl;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgAppCostImpl
extends AbstractDefaultOrgTypeImpl
implements IOrgAppHelper {
    private static Logger logger = Logger.getLogger((String)OrgAppCostImpl.class.getName());

    private boolean isCostBizUnitChanged(Context ctx, OUPartCostCenterInfo newInfo) throws BOSException, EASBizException {
        if (newInfo.getId() == null) {
            return false;
        }
        IOUPartCostCenter iPartCost = OUPartCostCenterFactory.getLocalInstance(ctx);
        OUPartCostCenterInfo oldInfo = iPartCost.getOUPartCostCenterInfo((IObjectPK)new ObjectUuidPK(newInfo.getId()));
        return oldInfo.isIsBizUnit() ^ newInfo.isIsBizUnit();
    }

    private boolean isDelegatedByOthers(Context ctx, FullOrgUnitInfo unit, int orgTypeValue) throws BOSException, EASBizException {
        return OrgDBHelper.isDelegatedByOthers((Context)ctx, (FullOrgUnitInfo)unit, (int)orgTypeValue);
    }

    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
        if (unitInfo.isIsCostOrgUnit()) {
            OUPartCostCenterInfo partCostInfo = unitInfo.getPartCostCenter();
            if (this.isCostBizUnitChanged(ctx, partCostInfo)) {
                if (partCostInfo.isIsBizUnit()) {
                    INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
                    if (iNOV.isBizChildrenExist(unitInfo, "00000000-0000-0000-0000-0000000000054F2827FD")) {
                        throw new OUException(OUException.COST_BIZUNIT_CHILDREN);
                    }
                } else if (this.isDelegatedByOthers(ctx, unitInfo, 5)) {
                    throw new OUException(OUException.COST_BIZUNIT_DELEGATED);
                }
            }
            partCostInfo.setUnit(unitInfo);
            IOUPartCostCenter iPartCost = OUPartCostCenterFactory.getLocalInstance(ctx);
            if (iPartCost.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                if (partCostInfo.getId() == null) {
                    BOSUuid partID = iPartCost.getOUPartCostCenterInfo("Select id Where unit.id = '" + pk.toString() + "'").getId();
                    partCostInfo.setId(partID);
                }
                iPartCost.update((IObjectPK)new ObjectUuidPK(partCostInfo.getId()), partCostInfo);
            } else {
                if (!unitInfo.isIsCU() && !currentCUInfo.isIsCostOrgUnit()) {
                    Object[] param = new Object[]{OrgType.CostCenter.getAlias(), OrgType.CostCenter.getAlias()};
                    throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
                }
                partCostInfo.setVersionNumber(versionNumber);
                iPartCost.addnew(partCostInfo);
                unitInfo.setPartCostCenter(partCostInfo);
            }
        } else {
            IOUPartCostCenter iPartCost = OUPartCostCenterFactory.getLocalInstance(ctx);
            if (iPartCost.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                OUPartReference.isReferenced((Context)ctx, (String)new OUPartCostCenterInfo().getBOSType().toString(), (String)pk.toString());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
                iPartCost.delete(filter);
            }
            unitInfo.setPartCostCenter(null);
        }
    }

    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws BOSException, EASBizException {
        if (unitInfo.isIsCostOrgUnit()) {
            if (!unitInfo.isIsCU() && !currentCUInfo.isIsCostOrgUnit()) {
                Object[] param = new Object[]{OrgType.CostCenter.getAlias(), OrgType.CostCenter.getAlias()};
                throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
            }
            OUPartCostCenterInfo ouCostInfo = unitInfo.getPartCostCenter();
            ouCostInfo.setUnit(unitInfo);
            ouCostInfo.setVersionNumber(unitInfo.getVersionNumber());
            IOUPartCostCenter iCost = OUPartCostCenterFactory.getLocalInstance(ctx);
            IObjectPK newPK = iCost.addnew(ouCostInfo);
            unitInfo.setPartCostCenter(ouCostInfo);
        }
    }

    public void delOrgInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
        if (deleteInfo.isIsCostOrgUnit()) {
            INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
            IOrgDelegateFacade iDelegate = OrgDelegateFacadeFactory.getLocalInstance((Context)ctx);
            Object[] params = new String[]{OrgType.CostCenter.getAlias()};
            if (iNOV.isBizChildrenExist(deleteInfo, "00000000-0000-0000-0000-0000000000054F2827FD")) {
                throw new OUException(OUException.EXISTCHILDREN_NOTDELETE, params);
            }
            if (iDelegate.isDelegatedByOthers(deleteInfo.getId().toString(), 5)) {
                throw new OUException(OUException.DELEGATEDBYOTHERS_NOTDELETE, params);
            }
            ObjectStringPK pk = new ObjectStringPK(deleteInfo.getId().toString());
            OUPartReference.isReferenced((Context)ctx, (String)"2EC9A165", (String)pk.toString());
            OUPartReference.isReferenced((Context)ctx, (String)"7FAFDF41", (String)pk.toString());
            IOUPartCostCenter iCost = OUPartCostCenterFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iCost.delete(filter);
        }
    }

    public String[] getRebuildSql() {
        StringBuffer sb = new StringBuffer(800);
        sb.append("insert into T_ORG_CostCenter (\n").append("FID,\n").append("FName_L1,\n").append("FName_L2,\n").append("FName_L3,\n").append("FNumber,\n").append("FDescription_L1,\n").append("FDescription_L2,\n").append("FDescription_L3,\n").append("FSimpleName,\n").append("FIsGrouping,\n").append("FEffectDate,\n").append("FInvalidDate,\n").append("FIsFreeze,\n").append("FIsCompanyOrgUnit,\n").append("FIsAdminOrgUnit,\n").append("FIsSaleOrgUnit,\n").append("FIsPurchaseOrgUnit,\n").append("FIsStorageOrgUnit,\n").append("FIsProfitOrgUnit,\n").append("FIsCostOrgUnit,\n").append("FIsCU,\n").append("FIsUnion,\n").append("FIsHROrgUnit,\n").append("FCreatorID,\n").append("FCreateTime,\n").append("FLastUpdateUserID,\n").append("FLastUpdateTime,\n").append("FControlUnitID,\n").append("FIsLeaf,\n").append("FLevel,\n").append("FLongNumber,\n").append("FParentID,\n").append("FCostCenterType,\n").append("FLeader,\n").append("FIsBizUnit,\n").append("FIsSealUp ,\n").append("FIsStart,\n").append("FIsOUSealUp,\n").append("FDisplayName_L1,\n").append("FDisplayName_L2,\n").append("FDisplayName_L3,\n").append("FPropertySealUpDate,\n").append("FVersionNumber,\n").append("FCode,\n").append("FIsTransportOrgUnit,\n").append("forgTypeStr,\n").append("FIsQualityOrgUnit)\n").append("SELECT\n").append("ou.FID,\n").append("ou.FName_L1,\n").append("ou.FName_L2,\n").append("ou.FName_L3,\n").append("ou.FNumber,\n").append("ou.FDescription_L1,\n").append("ou.FDescription_L2,\n").append("ou.FDescription_L3,\n").append("ou.FSimpleName,\n").append("ou.FIsGrouping,\n").append("ou.FEffectDate,\n").append("ou.FInvalidDate,\n").append("ou.FIsFreeze,\n").append("ou.FIsCompanyOrgUnit,\n").append("ou.FIsAdminOrgUnit,\n").append("ou.FIsSaleOrgUnit,\n").append("ou.FIsPurchaseOrgUnit,\n").append("ou.FIsStorageOrgUnit,\n").append("ou.FIsProfitOrgUnit,\n").append("ou.FIsCostOrgUnit,\n").append("ou.FIsCU,\n").append("ou.FIsUnion,\n").append("ou.FIsHROrgUnit,\n").append("ou.FCreatorID,\n").append("ou.FCreateTime,\n").append("ou.FLastUpdateUserID,\n").append("ou.FLastUpdateTime,\n").append("ou.FControlUnitID,\n").append("stru.FIsLeaf,\n").append("stru.FLevel,\n").append("stru.FLongNumber,\n").append("stru1.FUnitId AS FParentID,\n").append("cost.FCostCenterType,\n").append("cost.FLeader,\n").append("cost.FIsBizUnit,\n").append("cost.FIsSealUp ,\n").append("ou.FIsStart,\n").append("ou.FIsOUSealUp,\n").append("stru.FDisplayName_L1,\n").append("stru.FDisplayName_L2,\n").append("stru.FDisplayName_L3,\n").append("cost.FPropertySealUpDate,\n").append("ou.FVersionNumber,\n").append("ou.FCode,\n").append("ou.FIsTransportOrgUnit,\n").append("ou.forgTypeStr,\n").append("ou.FIsQualityOrgUnit\n").append("FROM T_ORG_BaseUnit ou INNER JOIN\n").append("T_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\n").append("T_ORG_Structure stru1 ON stru.FParentID = stru1.FID INNER JOIN\n").append("T_ORG_OUPartCostCenter cost ON ou.FID = cost.FUnitID\n").append("WHERE (stru.FTreeId = '00000000-0000-0000-0000-0000000000054F2827FD')\n");
        return new String[]{"delete from T_ORG_CostCenter", sb.toString()};
    }

    boolean valideOrg(IObjectValue orgValue) {
        CostCenterOrgUnitInfo costInfo = (CostCenterOrgUnitInfo)orgValue;
        return !costInfo.isIsSealUp() && costInfo.isIsBizUnit();
    }

    public OrgTypeSelfInfo getOrgTypeSelfInfo() {
        OrgTypeSelfInfo orgInfo = new OrgTypeSelfInfo();
        orgInfo.setTableName("T_ORG_OUPartCostCenter");
        orgInfo.setTableNameAlias("PtCost");
        orgInfo.setViewTableName("T_ORG_CostCenter");
        orgInfo.setViewTableAlias("Cost");
        orgInfo.setViewTableNameHis("T_ORG_CostCenter_his");
        orgInfo.setTableNameHis("T_ORG_OUPartCostCenter_his");
        orgInfo.setOrgViewBosType(new CostCenterOrgUnitInfo().getBOSType());
        orgInfo.setOrgTableBosType(new OUPartCostCenterInfo().getBOSType());
        orgInfo.setOuPartInfo((OUPartCoreBaseInfo)new OUPartCostCenterInfo());
        orgInfo.setOrgUnitViewInfo((OrgUnitInfo)new CostCenterOrgUnitInfo());
        orgInfo.setOrgType(OrgType.CostCenter);
        return orgInfo;
    }

    protected OrgUnitCollection _getCostCenterOrgUnitVersionCollection(Context ctx, String versionNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_CostCenter_His WHERE FVersionNumber = '").append(versionNumber).append("'").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    protected OUPartCostCenterCollection _getOUPartCostCenterVersionCollection(Context ctx) throws BOSException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartCostCenter_His").toString();
        try {
            OUPartCostCenterCollection partCostCenterVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            OUPartCostCenterCollection oUPartCostCenterCollection = partCostCenterVersionCol = OrgAppCostImpl.createOUPartCostCenterVersionCollection(ctx, (ResultSet)rs);
            return oUPartCostCenterCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public static CostCenterOrgUnitInfo createCostCenterOrgUnitVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String parentId;
        CostCenterOrgUnitInfo costCenterVersionInfo = (CostCenterOrgUnitInfo)OrgVersionServerUtils.createOrgUnitVersionInfo((Context)ctx, (OrgUnitInfo)new CostCenterOrgUnitInfo(), (ResultSet)rs);
        String versionNumber = costCenterVersionInfo.getVersionNumber();
        costCenterVersionInfo.setCostCenterType(CostCenterType.getEnum(rs.getInt("FCostCenterType")));
        String leaderId = rs.getString("FLeader");
        if (leaderId != null && leaderId.trim().length() != 0) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)leaderId));
            costCenterVersionInfo.setLeader(personInfo);
        }
        if ((parentId = rs.getString("FParentID")) != null && parentId.trim().length() != 0) {
            CostCenterOrgUnitInfo parentVersionInfo = new CostCenterOrgUnitInfo(versionNumber, BOSUuid.read((String)parentId));
            costCenterVersionInfo.setParent(parentVersionInfo);
        }
        costCenterVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        costCenterVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        costCenterVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return costCenterVersionInfo;
    }

    public static OrgUnitCollection createCostCenterOrgUnitVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OrgUnitCollection costCenterVersionCol = new OrgUnitCollection();
        while (rs.next()) {
            CostCenterOrgUnitInfo costCenterVersionInfo = OrgAppCostImpl.createCostCenterOrgUnitVersionInfo(ctx, rs);
            costCenterVersionCol.add((OrgUnitInfo)costCenterVersionInfo);
        }
        return costCenterVersionCol;
    }

    public static OUPartCostCenterInfo createOUPartCostCenterVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String versionNumber = rs.getString("FVersionNumber");
        String id = rs.getString("FID");
        OUPartCostCenterInfo partCostCenterVersionInfo = new OUPartCostCenterInfo(versionNumber, BOSUuid.read((String)id));
        String unitId = rs.getString("FUnitID");
        if (unitId != null && unitId.trim().length() != 0) {
            FullOrgUnitInfo fullVersionInfo = new FullOrgUnitInfo(versionNumber, BOSUuid.read((String)unitId));
            partCostCenterVersionInfo.setUnit(fullVersionInfo);
        }
        partCostCenterVersionInfo.setCostCenterType(CostCenterType.getEnum(rs.getInt("FCostCenterType")));
        String leaderId = rs.getString("FLeader");
        if (leaderId != null && leaderId.trim().length() != 0) {
            partCostCenterVersionInfo.setLeader((PersonInfo)OrgHelper.getVO((Context)ctx, (String)leaderId));
        }
        partCostCenterVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        partCostCenterVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        partCostCenterVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return partCostCenterVersionInfo;
    }

    public static OUPartCostCenterCollection createOUPartCostCenterVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OUPartCostCenterCollection partCostCenterVersionCol = new OUPartCostCenterCollection();
        while (rs.next()) {
            OUPartCostCenterInfo partCostCenterVersionInfo = OrgAppCostImpl.createOUPartCostCenterVersionInfo(ctx, rs);
            partCostCenterVersionCol.add(partCostCenterVersionInfo);
        }
        return partCostCenterVersionCol;
    }

    public List getInsertHisDataSql() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("INSERT INTO T_ORG_OUPartCostCenter_His(FID,FUnitID,FCostCenterType,FLeader,FIsSealUp,FIsBizUnit, FPropertySealUpDate, FVersionNumber) SELECT FID,FUnitID,FCostCenterType,FLeader,FIsSealUp,FIsBizUnit, FPropertySealUpDate, FVersionNumber FROM T_ORG_OUPartCostCenter");
        retList.add("INSERT INTO T_ORG_CostCenter_His(FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FCostCenterType, FLeader, FIsBizUnit, FIsSealUp, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr) SELECT FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FCostCenterType, FLeader, FIsBizUnit, FIsSealUp, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr FROM T_ORG_CostCenter");
        return retList;
    }

    public List getOrgVersioningUpdateStmts(String inValidateStr, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(new StringBuffer().append("UPDATE T_ORG_CostCenter_His SET FInvalidDate = {ts'").append(inValidateStr).append("'}").append(" WHERE FVersionNumber = '").append(versionNumber).append("'").toString());
        return retList;
    }

    public OrgUnitInfo createOrgUnitVersionInfo(String versionNumber, String id) {
        return new CostCenterOrgUnitInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadSuperiorHisOrgUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        if (fullVersionInfo.isIsCostOrgUnit()) {
            CostCenterOrgUnitInfo costVersionInfo = (CostCenterOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(fullVersionInfo.getVersionNumber(), fullVersionInfo.getId()));
            if (costVersionInfo == null) {
                throw new OUException(OUException.NONE_COST_SUPERIOR);
            }
            CostCenterOrgUnitInfo info = costVersionInfo.getParent();
            pdInfo.setParentOrg(OrgType.CostCenter, (OrgUnitInfo)((CostCenterOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(info.getVersionNumber(), info.getId()))));
        }
    }

    public CoreBaseInfo createOUPartOrgUnitVersionInfo(String versionNumber, String id) {
        return new OUPartCostCenterInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadOUPartVersion(Context ctx, FullOrgUnitInfo fullVersionInfo, ResultSet rs) throws BOSException, EASBizException, SQLException {
        String versionNumber = fullVersionInfo.getVersionNumber();
        String partCostCenterId = rs.getString("FPartCostCenterID");
        if (partCostCenterId != null && partCostCenterId.trim().length() != 0) {
            OUPartCostCenterInfo partCostCenterVersionInfo = new OUPartCostCenterInfo(versionNumber, BOSUuid.read((String)partCostCenterId));
            fullVersionInfo.setPartCostCenter(partCostCenterVersionInfo);
        }
    }

    public OrgUnitInfo getUnitVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_CostCenter_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OrgUnitInfo orgUnitInfo = null;
                return orgUnitInfo;
            }
            CostCenterOrgUnitInfo costCenterVersionInfo = OrgAppCostImpl.createCostCenterOrgUnitVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with pk: " + pk);
            }
            CostCenterOrgUnitInfo costCenterOrgUnitInfo = costCenterVersionInfo;
            return costCenterOrgUnitInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        if (longNumber == null || longNumber.trim().length() == 0) {
            throw new BOSException("longNumber can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_CostCenter_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND (FLongNumber = '").append(longNumber).append("'").append(" OR FLongNumber LIKE '").append(longNumber + "!%").append("')").append(" ORDER BY FLongNumber").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    private OrgUnitCollection getOrgUnitVersionCollectionBySql(Context ctx, String sql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            OrgUnitCollection costVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            OrgUnitCollection orgUnitCollection = costVersionCol = OrgAppCostImpl.createCostCenterOrgUnitVersionCollection(ctx, (ResultSet)rs);
            return orgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, IObjectPK cuOrgPK, String versionNumber) throws BOSException, EASBizException {
        String tableName = this.getOrgTypeSelfInfo().getViewTableNameHis();
        String sql = "SELECT FID, FVersionNumber FROM " + tableName + " WHERE FControlUnitID = '" + cuOrgPK + "' and forgTypeStr like '%" + this.getOrgTypeSelfInfo().getOrgType().getName() + "%' FVersionNumber = '" + versionNumber + "'";
        return this.getOrgUnitVersionCollectionBySql(ctx, sql);
    }

    private OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String selectSql) throws BOSException, EASBizException {
        if (selectSql == null) {
            throw new BOSException("selectSql can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OUPartCoreBaseInfo oUPartCoreBaseInfo = null;
                return oUPartCoreBaseInfo;
            }
            OUPartCostCenterInfo partCostCenterVersionInfo = OrgAppCostImpl.createOUPartCostCenterVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with selectSql: " + selectSql);
            }
            OUPartCostCenterInfo oUPartCostCenterInfo = partCostCenterVersionInfo;
            return oUPartCostCenterInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartCostCenter_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String version, String orgId) throws BOSException, EASBizException {
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartCostCenter_His WHERE ").append("FVersionNumber = '").append(version).append("'").append(" AND FUNITID = '").append(orgId).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public void batchDelOrgInfo(Context ctx, FullOrgUnitCollection unitCol) throws BOSException, EASBizException {
        for (int i = 0; i < unitCol.size(); ++i) {
            FullOrgUnitInfo unitInfo = unitCol.get(i);
            if (!unitInfo.isIsCostOrgUnit()) {
                return;
            }
            Object[] params = new String[]{OrgType.CostCenter.getAlias(), OrgType.CostCenter.getAlias()};
            if (OrgAppHelper.isCUBizPropertyExistInOU((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)5)) {
                throw new OUException(OUException.EXISTINCU_NOTDELETE, params);
            }
            unitInfo.setIsCostOrgUnit(false);
            unitInfo.put("isCostOrgUnit", (Object)new Boolean(false));
            ObjectStringPK pk = new ObjectStringPK(unitInfo.getId().toString());
            OUPartReference.delReferenced((Context)ctx, (String)"2EC9A165", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getTableName());
            OUPartReference.delReferenced((Context)ctx, (String)"7FAFDF41", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getViewTableName());
            IOUPartCostCenter iCost = OUPartCostCenterFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iCost.delete(filter);
            unitInfo.setPartCostCenter(null);
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
            orgTypeHelper.removeOrgType(OrgType.CostCenter);
            unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        }
    }
}

