/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper.orgtypeimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOUPartSale;
import com.kingdee.eas.basedata.org.IOrgDelegateFacade;
import com.kingdee.eas.basedata.org.ISaleOrgRefProcess;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OUPartSaleCollection;
import com.kingdee.eas.basedata.org.OUPartSaleFactory;
import com.kingdee.eas.basedata.org.OUPartSaleInfo;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.app.OUPartReference;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgDBHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.AbstractDefaultOrgTypeImpl;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgAppSaleImpl
extends AbstractDefaultOrgTypeImpl
implements IOrgAppHelper {
    private static Logger logger = Logger.getLogger((String)OrgAppSaleImpl.class.getName());

    private boolean isSaleBizUnitChanged(Context ctx, OUPartSaleInfo newInfo) throws BOSException, EASBizException {
        if (newInfo.getId() == null) {
            return false;
        }
        IOUPartSale iPartSale = OUPartSaleFactory.getLocalInstance(ctx);
        OUPartSaleInfo oldInfo = iPartSale.getOUPartSaleInfo((IObjectPK)new ObjectUuidPK(newInfo.getId()));
        return oldInfo.isIsBizUnit() ^ newInfo.isIsBizUnit();
    }

    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
        if (unitInfo.isIsSaleOrgUnit()) {
            OUPartSaleInfo partSaleInfo = unitInfo.getPartSale();
            if (this.isSaleBizUnitChanged(ctx, partSaleInfo)) {
                if (partSaleInfo.isIsBizUnit()) {
                    INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
                    if (iNOV.isBizChildrenExist(unitInfo, "00000000-0000-0000-0000-0000000000064F2827FD")) {
                        throw new OUException(OUException.SALE_BIZUNIT_CHILDREN);
                    }
                } else {
                    boolean isDelegatedByOthers = OrgDBHelper.isDelegatedByOthers((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)2);
                    if (isDelegatedByOthers) {
                        throw new OUException(OUException.SALE_BIZUNIT_DELEGATED);
                    }
                }
            }
            partSaleInfo.setUnit(unitInfo);
            IOUPartSale iPartSale = OUPartSaleFactory.getLocalInstance(ctx);
            if (iPartSale.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                if (partSaleInfo.getId() == null) {
                    BOSUuid partID = iPartSale.getOUPartSaleInfo("Select id Where unit.id = '" + pk.toString() + "'").getId();
                    partSaleInfo.setId(partID);
                }
                iPartSale.update((IObjectPK)new ObjectUuidPK(partSaleInfo.getId()), partSaleInfo);
            } else {
                if (!unitInfo.isIsCU() && !currentCUInfo.isIsSaleOrgUnit()) {
                    Object[] param = new Object[]{OrgType.Sale.getAlias(), OrgType.Sale.getAlias()};
                    throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
                }
                partSaleInfo.setVersionNumber(versionNumber);
                iPartSale.addnew(partSaleInfo);
                unitInfo.setPartSale(partSaleInfo);
            }
        } else {
            IOUPartSale iPartSale = OUPartSaleFactory.getLocalInstance(ctx);
            if (iPartSale.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                OUPartReference.isReferenced((Context)ctx, (String)new OUPartSaleInfo().getBOSType().toString(), (String)pk.toString());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
                iPartSale.delete(filter);
            }
            unitInfo.setPartSale(null);
        }
    }

    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws BOSException, EASBizException {
        if (unitInfo.isIsSaleOrgUnit()) {
            if (!unitInfo.isIsCU() && !currentCUInfo.isIsSaleOrgUnit()) {
                Object[] param = new Object[]{OrgType.Sale.getAlias(), OrgType.Sale.getAlias()};
                throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
            }
            OUPartSaleInfo ouSaleInfo = unitInfo.getPartSale();
            ouSaleInfo.setUnit(unitInfo);
            ouSaleInfo.setVersionNumber(unitInfo.getVersionNumber());
            IOUPartSale iSale = OUPartSaleFactory.getLocalInstance(ctx);
            IObjectPK newPK = iSale.addnew(ouSaleInfo);
            unitInfo.setPartSale(ouSaleInfo);
        }
    }

    public void delOrgInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
        if (deleteInfo.isIsSaleOrgUnit()) {
            INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
            IOrgDelegateFacade iDelegate = OrgDelegateFacadeFactory.getLocalInstance((Context)ctx);
            Object[] params = new String[]{OrgType.Sale.getAlias()};
            if (iNOV.isBizChildrenExist(deleteInfo, "00000000-0000-0000-0000-0000000000064F2827FD")) {
                throw new OUException(OUException.EXISTCHILDREN_NOTDELETE, params);
            }
            if (iDelegate.isDelegatedByOthers(deleteInfo.getId().toString(), 2)) {
                throw new OUException(OUException.DELEGATEDBYOTHERS_NOTDELETE, params);
            }
            this.delCheck(ctx, deleteInfo.getId().toString());
            ObjectStringPK pk = new ObjectStringPK(deleteInfo.getId().toString());
            OUPartReference.isReferenced((Context)ctx, (String)"BB7FE4DF", (String)pk.toString());
            OUPartReference.isReferenced((Context)ctx, (String)"6F9FB21C", (String)pk.toString());
            IOUPartSale iSale = OUPartSaleFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iSale.delete(filter);
        }
    }

    private void delCheck(Context ctx, String saleOrgId) throws EASBizException, BOSException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)"6F9FB21C", ISaleOrgRefProcess.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers != null) {
            String checkerName = "";
            for (int i = 0; i < checkers.length; ++i) {
                checkerName = checkers[i];
                try {
                    ((ISaleOrgRefProcess)Class.forName(checkerName).newInstance()).delCheck(ctx, saleOrgId);
                    continue;
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (EASBizException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    public String[] getRebuildSql() {
        StringBuffer sb = new StringBuffer(800);
        sb.append("insert into T_ORG_Sale (\n").append("FID,\n").append("FName_L1,\n").append("FName_L2,\n").append("FName_L3,\n").append("FNumber,\n").append("FDescription_L1,\n").append("FDescription_L2,\n").append("FDescription_L3,\n").append("FSimpleName,\n").append("FIsGrouping,\n").append("FEffectDate,\n").append("FInvalidDate,\n").append("FIsFreeze,\n").append("FIsCompanyOrgUnit,\n").append("FIsAdminOrgUnit,\n").append("FIsSaleOrgUnit,\n").append("FIsPurchaseOrgUnit,\n").append("FIsStorageOrgUnit,\n").append("FIsProfitOrgUnit,\n").append("FIsCostOrgUnit,\n").append("FIsCU,\n").append("FIsUnion,\n").append("FIsHROrgUnit,\n").append("FCreatorID,\n").append("FCreateTime,\n").append("FLastUpdateUserID,\n").append("FLastUpdateTime,\n").append("FControlUnitID,\n").append("FIsLeaf,\n").append("FLevel,\n").append("FLongNumber,\n").append("FParentID,\n").append("FLeader,\n").append("FAddressID,\n").append("FIsSealUp,\n").append("FIsBizUnit ,\n").append("FIsStart,\n").append("FIsOUSealUp,\n").append("FDisplayName_L1,\n").append("FDisplayName_L2,\n").append("FDisplayName_L3,\n").append("FPropertySealUpDate,\n").append("FVersionNumber,\n").append("FCode,\n").append("FIsTransportOrgUnit,\n").append("forgTypeStr,\n").append("FIsQualityOrgUnit)\n").append("SELECT\n").append("ou.FID,\n").append("ou.FName_L1,\n").append("ou.FName_L2,\n").append("ou.FName_L3,\n").append("ou.FNumber,\n").append("ou.FDescription_L1,\n").append("ou.FDescription_L2,\n").append("ou.FDescription_L3,\n").append("ou.FSimpleName,\n").append("ou.FIsGrouping,\n").append("ou.FEffectDate,\n").append("ou.FInvalidDate,\n").append("ou.FIsFreeze,\n").append("ou.FIsCompanyOrgUnit,\n").append("ou.FIsAdminOrgUnit,\n").append("ou.FIsSaleOrgUnit,\n").append("ou.FIsPurchaseOrgUnit,\n").append("ou.FIsStorageOrgUnit,\n").append("ou.FIsProfitOrgUnit,\n").append("ou.FIsCostOrgUnit,\n").append("ou.FIsCU,\n").append("ou.FIsUnion,\n").append("ou.FIsHROrgUnit,\n").append("ou.FCreatorID,\n").append("ou.FCreateTime,\n").append("ou.FLastUpdateUserID,\n").append("ou.FLastUpdateTime,\n").append("ou.FControlUnitID,\n").append("stru.FIsLeaf,\n").append("stru.FLevel,\n").append("stru.FLongNumber,\n").append("stru1.FUnitId AS FParentID,\n").append("sale.FLeader,\n").append("sale.FAddressID,\n").append("sale.FIsSealUp,\n").append("sale.FIsBizUnit ,\n").append("ou.FIsStart,\n").append("ou.FIsOUSealUp,\n").append("stru.FDisplayName_L1,\n").append("stru.FDisplayName_L2,\n").append("stru.FDisplayName_L3,\n").append("sale.FPropertySealUpDate,\n").append("ou.FVersionNumber,\n").append("ou.FCode,\n").append("ou.FIsTransportOrgUnit,\n").append("ou.forgTypeStr,\n").append("ou.FIsQualityOrgUnit\n").append("FROM T_ORG_BaseUnit ou INNER JOIN\n").append("T_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\n").append("T_ORG_Structure stru1 ON stru.FParentID = stru1.FID INNER JOIN\n").append("T_ORG_OUPartSale sale ON ou.FID = sale.FUnitID\n").append("WHERE (stru.FTreeId = '00000000-0000-0000-0000-0000000000064F2827FD')\n");
        return new String[]{"delete from T_ORG_Sale", sb.toString()};
    }

    boolean valideOrg(IObjectValue orgValue) {
        SaleOrgUnitInfo saleInfo = (SaleOrgUnitInfo)orgValue;
        return !saleInfo.isIsSealUp() && saleInfo.isIsBizUnit();
    }

    public OrgTypeSelfInfo getOrgTypeSelfInfo() {
        OrgTypeSelfInfo orgInfo = new OrgTypeSelfInfo();
        orgInfo.setTableName("T_ORG_OUPartSale");
        orgInfo.setTableNameHis("T_ORG_OUPartSale_his");
        orgInfo.setTableNameAlias("PtSale");
        orgInfo.setViewTableName("T_ORG_Sale");
        orgInfo.setViewTableNameHis("T_ORG_Sale_his");
        orgInfo.setViewTableAlias("Sale");
        orgInfo.setOrgViewBosType(new SaleOrgUnitInfo().getBOSType());
        orgInfo.setOrgTableBosType(new OUPartSaleInfo().getBOSType());
        orgInfo.setOuPartInfo((OUPartCoreBaseInfo)new OUPartSaleInfo());
        orgInfo.setOrgUnitViewInfo((OrgUnitInfo)new SaleOrgUnitInfo());
        orgInfo.setOrgType(OrgType.Sale);
        return orgInfo;
    }

    protected OrgUnitCollection _getSaleOrgUnitVersionCollection(Context ctx, String versionNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        String selectSql = new StringBuffer().append("SELECT *,b.number as addressNumber ,c.number as personNumber FROM T_ORG_Sale_His a  ").append(" left join t_bd_address  b on a.FAddressID = b.fid").append(" left join t_bd_person c on a.FLeader = c.fid ").append("WHERE FVersionNumber = '").append(versionNumber).append("'").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    protected OUPartSaleCollection _getOUPartSaleVersionCollection(Context ctx) throws BOSException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartSale_His").toString();
        try {
            OUPartSaleCollection partSaleVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            OUPartSaleCollection oUPartSaleCollection = partSaleVersionCol = OrgAppSaleImpl.createOUPartSaleVersionCollection(ctx, (ResultSet)rs);
            return oUPartSaleCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public static SaleOrgUnitInfo createSaleOrgUnitVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String parentId;
        String addressId;
        SaleOrgUnitInfo saleVersionInfo = (SaleOrgUnitInfo)OrgVersionServerUtils.createOrgUnitVersionInfo((Context)ctx, (OrgUnitInfo)new SaleOrgUnitInfo(), (ResultSet)rs);
        String versionNumber = saleVersionInfo.getVersionNumber();
        String leaderId = rs.getString("FLeader");
        if (leaderId != null && leaderId.trim().length() != 0) {
            saleVersionInfo.setLeader((PersonInfo)OrgHelper.getVO((Context)ctx, (String)leaderId));
        }
        if ((addressId = rs.getString("FAddressID")) != null && addressId.trim().length() != 0) {
            saleVersionInfo.setAddress((AddressInfo)OrgHelper.getVO((Context)ctx, (String)addressId));
        }
        if ((parentId = rs.getString("FParentID")) != null && parentId.trim().length() != 0) {
            SaleOrgUnitInfo parentVersionInfo = new SaleOrgUnitInfo(versionNumber, BOSUuid.read((String)parentId));
            saleVersionInfo.setParent(parentVersionInfo);
        }
        saleVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        saleVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        saleVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return saleVersionInfo;
    }

    public static OrgUnitCollection createSaleOrgUnitVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OrgUnitCollection saleVersionCol = new OrgUnitCollection();
        while (rs.next()) {
            SaleOrgUnitInfo saleVersionInfo = OrgAppSaleImpl.createSaleOrgUnitVersionInfo(ctx, rs);
            saleVersionCol.add((OrgUnitInfo)saleVersionInfo);
        }
        return saleVersionCol;
    }

    public static OUPartSaleInfo createOUPartSaleVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String addressId;
        String leaderId;
        String versionNumber = rs.getString("FVersionNumber");
        String id = rs.getString("FID");
        OUPartSaleInfo partSaleVersionInfo = new OUPartSaleInfo(versionNumber, BOSUuid.read((String)id));
        String unitId = rs.getString("FUnitID");
        if (unitId != null && unitId.trim().length() != 0) {
            FullOrgUnitInfo fullVersionInfo = new FullOrgUnitInfo(versionNumber, BOSUuid.read((String)unitId));
            partSaleVersionInfo.setUnit(fullVersionInfo);
        }
        if ((leaderId = rs.getString("FLeader")) != null && leaderId.trim().length() != 0) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)leaderId));
            partSaleVersionInfo.setLeader(personInfo);
        }
        if ((addressId = rs.getString("FAddressID")) != null && addressId.trim().length() != 0) {
            AddressInfo addressInfo = new AddressInfo();
            addressInfo.setId(BOSUuid.read((String)addressId));
            partSaleVersionInfo.setAddress(addressInfo);
        }
        partSaleVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        partSaleVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        return partSaleVersionInfo;
    }

    public static OUPartSaleCollection createOUPartSaleVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OUPartSaleCollection partSaleVersionCol = new OUPartSaleCollection();
        while (rs.next()) {
            OUPartSaleInfo partSaleVersionInfo = OrgAppSaleImpl.createOUPartSaleVersionInfo(ctx, rs);
            partSaleVersionCol.add(partSaleVersionInfo);
        }
        return partSaleVersionCol;
    }

    public List getInsertHisDataSql() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("INSERT INTO T_ORG_OUPartSale_His(FID,FUnitID,FAddressID,FLeader,FIsBizUnit,FIsSealUp, FPropertySealUpDate, FVersionNumber) SELECT FID,FUnitID,FAddressID,FLeader,FIsBizUnit,FIsSealUp, FPropertySealUpDate, FVersionNumber FROM T_ORG_OUPartSale");
        retList.add("INSERT INTO T_ORG_Sale_His(FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FLeader, FAddressID, FIsSealUp, FIsBizUnit, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr) SELECT FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FLeader, FAddressID, FIsSealUp, FIsBizUnit, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr FROM T_ORG_Sale");
        return retList;
    }

    public List getOrgVersioningUpdateStmts(String inValidateStr, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(new StringBuffer().append("UPDATE T_ORG_Sale_His SET FInvalidDate = {ts'").append(inValidateStr).append("'}").append(" WHERE FVersionNumber = '").append(versionNumber).append("'").toString());
        return retList;
    }

    public OrgUnitInfo createOrgUnitVersionInfo(String versionNumber, String id) {
        return new SaleOrgUnitInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadSuperiorHisOrgUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        if (fullVersionInfo.isIsSaleOrgUnit()) {
            SaleOrgUnitInfo saleVersionInfo = (SaleOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(fullVersionInfo.getVersionNumber(), fullVersionInfo.getId()));
            if (saleVersionInfo == null) {
                throw new OUException(OUException.NONE_SALE_SUPERIOR);
            }
            SaleOrgUnitInfo info = saleVersionInfo.getParent();
            pdInfo.setParentOrg(OrgType.Sale, (OrgUnitInfo)((SaleOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(info.getVersionNumber(), info.getId()))));
        }
    }

    public CoreBaseInfo createOUPartOrgUnitVersionInfo(String versionNumber, String id) {
        return new OUPartSaleInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadOUPartVersion(Context ctx, FullOrgUnitInfo fullVersionInfo, ResultSet rs) throws BOSException, EASBizException, SQLException {
        String versionNumber = fullVersionInfo.getVersionNumber();
        String partSaleId = rs.getString("FPartSaleID");
        if (partSaleId != null && partSaleId.trim().length() != 0) {
            OUPartSaleInfo partSaleVersionInfo = new OUPartSaleInfo(versionNumber, BOSUuid.read((String)partSaleId));
            fullVersionInfo.setPartSale(partSaleVersionInfo);
        }
    }

    public OrgUnitInfo getUnitVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Sale_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OrgUnitInfo orgUnitInfo = null;
                return orgUnitInfo;
            }
            SaleOrgUnitInfo saleVersionInfo = OrgAppSaleImpl.createSaleOrgUnitVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with pk: " + pk);
            }
            SaleOrgUnitInfo saleOrgUnitInfo = saleVersionInfo;
            return saleOrgUnitInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        if (longNumber == null || longNumber.trim().length() == 0) {
            throw new BOSException("longNumber can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Sale_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND (FLongNumber = '").append(longNumber).append("'").append(" OR FLongNumber LIKE '").append(longNumber + "!%").append("')").append(" ORDER BY FLongNumber").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    private OrgUnitCollection getOrgUnitVersionCollectionBySql(Context ctx, String sql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            OrgUnitCollection orgUnitCollection = OrgAppSaleImpl.createSaleOrgUnitVersionCollection(ctx, (ResultSet)rs);
            return orgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, IObjectPK cuOrgPK, String versionNumber) throws BOSException, EASBizException {
        String tableName = this.getOrgTypeSelfInfo().getViewTableNameHis();
        String sql = "SELECT FID, FVersionNumber FROM " + tableName + " WHERE FControlUnitID = '" + cuOrgPK + "' and forgTypeStr like '%" + this.getOrgTypeSelfInfo().getOrgType().getName() + "%' FVersionNumber = '" + versionNumber + "'";
        return this.getOrgUnitVersionCollectionBySql(ctx, sql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String selectSql) throws BOSException, EASBizException {
        if (selectSql == null) {
            throw new BOSException("selectSql can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OUPartCoreBaseInfo oUPartCoreBaseInfo = null;
                return oUPartCoreBaseInfo;
            }
            OUPartSaleInfo partSaleVersionInfo = OrgAppSaleImpl.createOUPartSaleVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with selectSql: " + selectSql);
            }
            OUPartSaleInfo oUPartSaleInfo = partSaleVersionInfo;
            return oUPartSaleInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartSale_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String version, String orgId) throws BOSException, EASBizException {
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartSale_His WHERE ").append("FVersionNumber = '").append(version).append("'").append(" AND FUNITID = '").append(orgId).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public void batchDelOrgInfo(Context ctx, FullOrgUnitCollection unitCol) throws BOSException, EASBizException {
        for (int i = 0; i < unitCol.size(); ++i) {
            FullOrgUnitInfo unitInfo = unitCol.get(i);
            if (!unitInfo.isIsSaleOrgUnit()) {
                return;
            }
            Object[] params = new String[]{OrgType.Sale.getAlias(), OrgType.Sale.getAlias()};
            if (OrgAppHelper.isCUBizPropertyExistInOU((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)2)) {
                throw new OUException(OUException.EXISTINCU_NOTDELETE, params);
            }
            unitInfo.setIsSaleOrgUnit(false);
            ObjectStringPK pk = new ObjectStringPK(unitInfo.getId().toString());
            OUPartReference.delReferenced((Context)ctx, (String)"BB7FE4DF", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getTableName());
            OUPartReference.delReferenced((Context)ctx, (String)"6F9FB21C", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getViewTableName());
            IOUPartSale iSale = OUPartSaleFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iSale.delete(filter);
            unitInfo.setPartSale(null);
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
            orgTypeHelper.removeOrgType(OrgType.Sale);
            unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        }
    }
}

