/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper.orgtypeimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOUPartStorage;
import com.kingdee.eas.basedata.org.IOrgDelegateFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OUPartStorageCollection;
import com.kingdee.eas.basedata.org.OUPartStorageFactory;
import com.kingdee.eas.basedata.org.OUPartStorageInfo;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStorageStatus;
import com.kingdee.eas.basedata.org.OrgStorageType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.app.OUPartReference;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgDBHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.AbstractDefaultOrgTypeImpl;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgAppStorgeImpl
extends AbstractDefaultOrgTypeImpl
implements IOrgAppHelper {
    private static Logger logger = Logger.getLogger((String)OrgAppStorgeImpl.class.getName());

    private boolean isStorageBizUnitChanged(Context ctx, OUPartStorageInfo newInfo) throws BOSException, EASBizException {
        if (newInfo.getId() == null) {
            return false;
        }
        IOUPartStorage iPartStorage = OUPartStorageFactory.getLocalInstance(ctx);
        OUPartStorageInfo oldInfo = iPartStorage.getOUPartStorageInfo((IObjectPK)new ObjectUuidPK(newInfo.getId()));
        return oldInfo.isIsBizUnit() ^ newInfo.isIsBizUnit();
    }

    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
        if (unitInfo.isIsStorageOrgUnit()) {
            OUPartStorageInfo partStorageInfo = unitInfo.getPartStorage();
            if (this.isStorageBizUnitChanged(ctx, partStorageInfo)) {
                if (partStorageInfo.isIsBizUnit()) {
                    INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
                    if (iNOV.isBizChildrenExist(unitInfo, "00000000-0000-0000-0000-0000000000074F2827FD")) {
                        throw new OUException(OUException.STORAGE_BIZUNIT_CHILDREN);
                    }
                } else {
                    boolean isDelegatedByOthers = OrgDBHelper.isDelegatedByOthers((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)4);
                    if (isDelegatedByOthers) {
                        throw new OUException(OUException.STORAGE_BIZUNIT_DELEGATED);
                    }
                }
            }
            partStorageInfo.setUnit(unitInfo);
            IOUPartStorage iPartStorage = OUPartStorageFactory.getLocalInstance(ctx);
            if (iPartStorage.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                if (partStorageInfo.getId() == null) {
                    BOSUuid partID = iPartStorage.getOUPartStorageInfo("Select id Where unit.id = '" + pk.toString() + "'").getId();
                    partStorageInfo.setId(partID);
                }
                iPartStorage.update((IObjectPK)new ObjectUuidPK(partStorageInfo.getId()), partStorageInfo);
            } else {
                if (!unitInfo.isIsCU() && !currentCUInfo.isIsStorageOrgUnit()) {
                    Object[] param = new Object[]{OrgType.Storage.getAlias(), OrgType.Storage.getAlias()};
                    throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
                }
                partStorageInfo.setVersionNumber(versionNumber);
                iPartStorage.addnew(partStorageInfo);
                unitInfo.setPartStorage(partStorageInfo);
            }
        } else {
            IOUPartStorage iPartStorage = OUPartStorageFactory.getLocalInstance(ctx);
            if (iPartStorage.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                OUPartReference.isReferenced((Context)ctx, (String)new OUPartStorageInfo().getBOSType().toString(), (String)pk.toString());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
                iPartStorage.delete(filter);
            }
            unitInfo.setPartStorage(null);
        }
    }

    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws BOSException, EASBizException {
        if (unitInfo.isIsStorageOrgUnit()) {
            if (!unitInfo.isIsCU() && !currentCUInfo.isIsStorageOrgUnit()) {
                Object[] param = new Object[]{OrgType.Storage.getAlias(), OrgType.Storage.getAlias()};
                throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
            }
            OUPartStorageInfo ouStorageInfo = unitInfo.getPartStorage();
            ouStorageInfo.setUnit(unitInfo);
            ouStorageInfo.setVersionNumber(unitInfo.getVersionNumber());
            IOUPartStorage iStorage = OUPartStorageFactory.getLocalInstance(ctx);
            IObjectPK newPK = iStorage.addnew(ouStorageInfo);
            unitInfo.setPartStorage(ouStorageInfo);
        }
    }

    public void delOrgInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
        if (deleteInfo.isIsStorageOrgUnit()) {
            INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
            IOrgDelegateFacade iDelegate = OrgDelegateFacadeFactory.getLocalInstance((Context)ctx);
            Object[] params = new String[]{OrgType.Storage.getAlias()};
            if (iNOV.isBizChildrenExist(deleteInfo, "00000000-0000-0000-0000-0000000000074F2827FD")) {
                throw new OUException(OUException.EXISTCHILDREN_NOTDELETE, params);
            }
            if (iDelegate.isDelegatedByOthers(deleteInfo.getId().toString(), 4)) {
                throw new OUException(OUException.DELEGATEDBYOTHERS_NOTDELETE, params);
            }
            ObjectStringPK pk = new ObjectStringPK(deleteInfo.getId().toString());
            OUPartReference.isReferenced((Context)ctx, (String)"399BE2E9", (String)pk.toString());
            OUPartReference.isReferenced((Context)ctx, (String)"EB1F7FD2", (String)pk.toString());
            IOUPartStorage iStorage = OUPartStorageFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iStorage.delete(filter);
        }
    }

    public String[] getRebuildSql() {
        StringBuffer sb = new StringBuffer(800);
        sb.append("insert into T_ORG_Storage (\n").append("FID,\n").append("FName_L1,\n").append("FName_L2,\n").append("FName_L3,\n").append("FNumber,\n").append("FDescription_L1,\n").append("FDescription_L2,\n").append("FDescription_L3,\n").append("FSimpleName,\n").append("FIsGrouping,\n").append("FEffectDate,\n").append("FInvalidDate,\n").append("FIsFreeze,\n").append("FIsCompanyOrgUnit,\n").append("FIsAdminOrgUnit,\n").append("FIsSaleOrgUnit,\n").append("FIsPurchaseOrgUnit,\n").append("FIsStorageOrgUnit,\n").append("FIsProfitOrgUnit,\n").append("FIsCostOrgUnit,\n").append("FIsCU,\n").append("FIsUnion,\n").append("FIsHROrgUnit,\n").append("FCreatorID,\n").append("FCreateTime,\n").append("FLastUpdateUserID,\n").append("FLastUpdateTime,\n").append("FControlUnitID,\n").append("FIsLeaf,\n").append("FLevel,\n").append("FLongNumber,\n").append("FParentID,\n").append("FLeader,\n").append("FAddressID,\n").append("FIsSealUp,\n").append("FIsBizUnit,\n").append("FType,\n").append("FStatus,\n").append("FIsStart,\n").append("FIsOUSealUp,\n").append("FDisplayName_L1,\n").append("FDisplayName_L2,\n").append("FDisplayName_L3,\n").append("FPropertySealUpDate, \n").append("FLocation,\n").append("FVersionNumber,\n").append("FCode,\n").append("FIsTransportOrgUnit,\n").append("forgTypeStr,\n").append("FIsQualityOrgUnit)\n").append("SELECT\n").append("ou.FID,\n").append("ou.FName_L1,\n").append("ou.FName_L2,\n").append("ou.FName_L3,\n").append("ou.FNumber,\n").append("ou.FDescription_L1,\n").append("ou.FDescription_L2,\n").append("ou.FDescription_L3,\n").append("ou.FSimpleName,\n").append("ou.FIsGrouping,\n").append("ou.FEffectDate,\n").append("ou.FInvalidDate,\n").append("ou.FIsFreeze,\n").append("ou.FIsCompanyOrgUnit,\n").append("ou.FIsAdminOrgUnit,\n").append("ou.FIsSaleOrgUnit,\n").append("ou.FIsPurchaseOrgUnit,\n").append("ou.FIsStorageOrgUnit,\n").append("ou.FIsProfitOrgUnit,\n").append("ou.FIsCostOrgUnit,\n").append("ou.FIsCU,\n").append("ou.FIsUnion,\n").append("ou.FIsHROrgUnit,\n").append("ou.FCreatorID,\n").append("ou.FCreateTime,\n").append("ou.FLastUpdateUserID,\n").append("ou.FLastUpdateTime,\n").append("ou.FControlUnitID,\n").append("stru.FIsLeaf,\n").append("stru.FLevel,\n").append("stru.FLongNumber,\n").append("stru1.FUnitId AS FParentID,\n").append("stor.FLeader,\n").append("stor.FAddressID,\n").append("stor.FIsSealUp,\n").append("stor.FIsBizUnit,\n").append("stor.FType,\n").append("stor.FStatus,\n").append("ou.FIsStart,\n").append("ou.FIsOUSealUp,\n").append("stru.FDisplayName_L1,\n").append("stru.FDisplayName_L2,\n").append("stru.FDisplayName_L3,\n").append("stor.FPropertySealUpDate, \n").append("stor.FLocation,\n").append("ou.FVersionNumber,\n").append("ou.FCode,\n").append("ou.FIsTransportOrgUnit,\n").append("ou.forgTypeStr,\n").append("ou.FIsQualityOrgUnit\n").append("FROM T_ORG_BaseUnit ou INNER JOIN\n").append("T_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\n").append("T_ORG_Structure stru1 ON stru.FParentID = stru1.FID INNER JOIN\n").append("T_ORG_OUPartStorage stor ON ou.FID = stor.FUnitID\n").append("WHERE (stru.FTreeId = '00000000-0000-0000-0000-0000000000074F2827FD')\n");
        return new String[]{"delete from T_ORG_Storage", sb.toString()};
    }

    public OrgTypeSelfInfo getOrgTypeSelfInfo() {
        OrgTypeSelfInfo orgInfo = new OrgTypeSelfInfo();
        orgInfo.setTableName("T_ORG_OUPartStorage");
        orgInfo.setTableNameHis("T_ORG_OUPartStorage_his");
        orgInfo.setTableNameAlias("PtStor");
        orgInfo.setViewTableName("T_ORG_Storage");
        orgInfo.setViewTableNameHis("T_ORG_Storage_his");
        orgInfo.setViewTableAlias("Stor");
        orgInfo.setOrgViewBosType(new StorageOrgUnitInfo().getBOSType());
        orgInfo.setOrgTableBosType(new OUPartStorageInfo().getBOSType());
        orgInfo.setOuPartInfo((OUPartCoreBaseInfo)new OUPartStorageInfo());
        orgInfo.setOrgUnitViewInfo((OrgUnitInfo)new StorageOrgUnitInfo());
        orgInfo.setOrgType(OrgType.Storage);
        return orgInfo;
    }

    protected OrgUnitCollection _getStorageOrgUnitVersionCollection(Context ctx, String versionNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Storage_His WHERE FVersionNumber = '").append(versionNumber).append("'").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    protected OUPartStorageCollection _getOUPartStorageVersionCollection(Context ctx) throws BOSException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartStorage_His").toString();
        try {
            OUPartStorageCollection partStorageVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            OUPartStorageCollection oUPartStorageCollection = partStorageVersionCol = OrgAppStorgeImpl.createOUPartStorageVersionCollection(ctx, (ResultSet)rs);
            return oUPartStorageCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public static StorageOrgUnitInfo createStorageOrgUnitVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String parentId;
        String addressId;
        StorageOrgUnitInfo storageVersionInfo = (StorageOrgUnitInfo)OrgVersionServerUtils.createOrgUnitVersionInfo((Context)ctx, (OrgUnitInfo)new StorageOrgUnitInfo(), (ResultSet)rs);
        String versionNumber = storageVersionInfo.getVersionNumber();
        String leaderId = rs.getString("FLeader");
        if (leaderId != null && leaderId.trim().length() != 0) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)leaderId));
            storageVersionInfo.setLeader(personInfo);
        }
        if ((addressId = rs.getString("FAddressID")) != null && addressId.trim().length() != 0) {
            AddressInfo addressInfo = new AddressInfo();
            addressInfo.setId(BOSUuid.read((String)addressId));
            storageVersionInfo.setAddress(addressInfo);
        }
        if ((parentId = rs.getString("FParentID")) != null && parentId.trim().length() != 0) {
            StorageOrgUnitInfo parentVersionInfo = new StorageOrgUnitInfo(versionNumber, BOSUuid.read((String)parentId));
            storageVersionInfo.setParent(parentVersionInfo);
        }
        storageVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        storageVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        storageVersionInfo.setType(OrgStorageType.getEnum((int)rs.getInt("FType")));
        storageVersionInfo.setStatus(OrgStorageStatus.getEnum((int)rs.getInt("FStatus")));
        storageVersionInfo.setLocation(rs.getString("FLocation"));
        storageVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return storageVersionInfo;
    }

    public static OrgUnitCollection createStorageOrgUnitVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OrgUnitCollection storageVersionCol = new OrgUnitCollection();
        while (rs.next()) {
            StorageOrgUnitInfo storageVersionInfo = OrgAppStorgeImpl.createStorageOrgUnitVersionInfo(ctx, rs);
            storageVersionCol.add((OrgUnitInfo)storageVersionInfo);
        }
        return storageVersionCol;
    }

    private static OUPartStorageInfo createOUPartStorageVersionInfo(Context ctx, ResultSet rs) throws Exception {
        String addressId;
        String leaderId;
        String versionNumber = rs.getString("FVersionNumber");
        String id = rs.getString("FID");
        OUPartStorageInfo partStorageVersionInfo = new OUPartStorageInfo(versionNumber, BOSUuid.read((String)id));
        String unitId = rs.getString("FUnitID");
        if (unitId != null && unitId.trim().length() != 0) {
            FullOrgUnitInfo fullVersionInfo = new FullOrgUnitInfo(versionNumber, BOSUuid.read((String)unitId));
            partStorageVersionInfo.setUnit(fullVersionInfo);
        }
        if ((leaderId = rs.getString("FLeader")) != null && leaderId.trim().length() != 0) {
            partStorageVersionInfo.setLeader((PersonInfo)OrgHelper.getVO((Context)ctx, (String)leaderId));
        }
        if ((addressId = rs.getString("FAddressID")) != null && addressId.trim().length() != 0) {
            partStorageVersionInfo.setAddress((AddressInfo)OrgHelper.getVO((Context)ctx, (String)addressId));
        }
        partStorageVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        partStorageVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        partStorageVersionInfo.setType(OrgStorageType.getEnum((int)rs.getInt("FType")));
        partStorageVersionInfo.setStatus(OrgStorageStatus.getEnum((int)rs.getInt("FStatus")));
        partStorageVersionInfo.setLocation(rs.getString("FLocation"));
        partStorageVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return partStorageVersionInfo;
    }

    public static OUPartStorageCollection createOUPartStorageVersionCollection(Context ctx, ResultSet rs) throws Exception {
        OUPartStorageCollection partStorageVersionCol = new OUPartStorageCollection();
        while (rs.next()) {
            OUPartStorageInfo partStorageVersionInfo = OrgAppStorgeImpl.createOUPartStorageVersionInfo(ctx, rs);
            partStorageVersionCol.add(partStorageVersionInfo);
        }
        return partStorageVersionCol;
    }

    public List getInsertHisDataSql() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("INSERT INTO T_ORG_OUPartStorage_His(FID,FUnitID,FAddressID,FLeader,FIsBizUnit,FIsSealUp,FType,FStatus, FLocation, FPropertySealUpDate, FVersionNumber) SELECT FID,FUnitID,FAddressID,FLeader,FIsBizUnit,FIsSealUp,FType,FStatus, FLocation, FPropertySealUpDate, FVersionNumber FROM T_ORG_OUPartStorage");
        retList.add("INSERT INTO T_ORG_Storage_His(FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FLeader, FAddressID, FIsSealUp, FIsBizUnit, FType, FStatus, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FLocation, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr) SELECT FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FLeader, FAddressID, FIsSealUp, FIsBizUnit, FType, FStatus, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FLocation, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr FROM T_ORG_Storage");
        return retList;
    }

    public List getOrgVersioningUpdateStmts(String inValidateStr, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(new StringBuffer().append("UPDATE T_ORG_Storage_His SET FInvalidDate = {ts'").append(inValidateStr).append("'}").append(" WHERE FVersionNumber = '").append(versionNumber).append("'").toString());
        return retList;
    }

    public OrgUnitInfo createOrgUnitVersionInfo(String versionNumber, String id) {
        return new StorageOrgUnitInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadSuperiorHisOrgUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        if (fullVersionInfo.isIsStorageOrgUnit()) {
            StorageOrgUnitInfo storageVersionInfo = (StorageOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(fullVersionInfo.getVersionNumber(), fullVersionInfo.getId()));
            if (storageVersionInfo == null) {
                throw new OUException(OUException.NONE_STORAGE_SUPERIOR);
            }
            StorageOrgUnitInfo info = storageVersionInfo.getParent();
            pdInfo.setParentOrg(OrgType.Storage, (OrgUnitInfo)((StorageOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(info.getVersionNumber(), info.getId()))));
        }
    }

    public CoreBaseInfo createOUPartOrgUnitVersionInfo(String versionNumber, String id) {
        return new OUPartStorageInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadOUPartVersion(Context ctx, FullOrgUnitInfo fullVersionInfo, ResultSet rs) throws BOSException, EASBizException, SQLException {
        String versionNumber = fullVersionInfo.getVersionNumber();
        String partStorageId = rs.getString("FPartStorageID");
        if (partStorageId != null && partStorageId.trim().length() != 0) {
            OUPartStorageInfo partStorageVersionInfo = new OUPartStorageInfo(versionNumber, BOSUuid.read((String)partStorageId));
            fullVersionInfo.setPartStorage(partStorageVersionInfo);
        }
    }

    public OrgUnitInfo getUnitVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Storage_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OrgUnitInfo orgUnitInfo = null;
                return orgUnitInfo;
            }
            StorageOrgUnitInfo storageVersionInfo = OrgAppStorgeImpl.createStorageOrgUnitVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with pk: " + pk);
            }
            StorageOrgUnitInfo storageOrgUnitInfo = storageVersionInfo;
            return storageOrgUnitInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        if (longNumber == null || longNumber.trim().length() == 0) {
            throw new BOSException("longNumber can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Storage_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND (FLongNumber = '").append(longNumber).append("'").append(" OR FLongNumber LIKE '").append(longNumber + "!%").append("')").append(" ORDER BY FLongNumber").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    private OrgUnitCollection getOrgUnitVersionCollectionBySql(Context ctx, String sql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            OrgUnitCollection orgUnitCollection = OrgAppStorgeImpl.createStorageOrgUnitVersionCollection(ctx, (ResultSet)rs);
            return orgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, IObjectPK cuOrgPK, String versionNumber) throws BOSException, EASBizException {
        String tableName = this.getOrgTypeSelfInfo().getViewTableNameHis();
        String sql = "SELECT FID, FVersionNumber FROM " + tableName + " WHERE FControlUnitID = '" + cuOrgPK + "' and forgTypeStr like '%" + this.getOrgTypeSelfInfo().getOrgType().getName() + "%' FVersionNumber = '" + versionNumber + "'";
        return this.getOrgUnitVersionCollectionBySql(ctx, sql);
    }

    private OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String selectSql) throws BOSException, EASBizException {
        if (selectSql == null) {
            throw new BOSException("selectSql can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OUPartCoreBaseInfo oUPartCoreBaseInfo = null;
                return oUPartCoreBaseInfo;
            }
            OUPartStorageInfo partStorageVersionInfo = OrgAppStorgeImpl.createOUPartStorageVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with selectSql: " + selectSql);
            }
            OUPartStorageInfo oUPartStorageInfo = partStorageVersionInfo;
            return oUPartStorageInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartStorage_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String version, String orgId) throws BOSException, EASBizException {
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartStorage_His WHERE ").append("FVersionNumber = '").append(version).append("'").append(" AND FUNITID = '").append(orgId).append("'").toString();
        return this.getOUPartVersionInfo(ctx, selectSql);
    }

    public void batchDelOrgInfo(Context ctx, FullOrgUnitCollection unitCol) throws BOSException, EASBizException {
        for (int i = 0; i < unitCol.size(); ++i) {
            FullOrgUnitInfo unitInfo = unitCol.get(i);
            if (!unitInfo.isIsStorageOrgUnit()) {
                return;
            }
            Object[] params = new String[]{OrgType.Storage.getAlias(), OrgType.Storage.getAlias()};
            if (OrgAppHelper.isCUBizPropertyExistInOU((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)4)) {
                throw new OUException(OUException.EXISTINCU_NOTDELETE, params);
            }
            unitInfo.setIsStorageOrgUnit(false);
            ObjectStringPK pk = new ObjectStringPK(unitInfo.getId().toString());
            OUPartReference.delReferenced((Context)ctx, (String)"399BE2E9", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getTableName());
            OUPartReference.delReferenced((Context)ctx, (String)"EB1F7FD2", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getViewTableName());
            IOUPartStorage iStorage = OUPartStorageFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iStorage.delete(filter);
            unitInfo.setPartStorage(null);
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
            orgTypeHelper.removeOrgType(OrgType.Storage);
            unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        }
    }
}

