/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper.orgtypeimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOUPartTransport;
import com.kingdee.eas.basedata.org.IOrgDelegateFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartBaseInfo;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OUPartTransportFactory;
import com.kingdee.eas.basedata.org.OUPartTransportInfo;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.app.OUPartReference;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgDBHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.AbstractDefaultOrgTypeImpl;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.IOrgUnitInfoFactory;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgQueryHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OrgAppTransportImpl
extends AbstractDefaultOrgTypeImpl
implements IOrgAppHelper {
    private static Logger logger = Logger.getLogger((String)OrgAppTransportImpl.class.getName());

    private boolean isTransportBizUnitChanged(Context ctx, OUPartTransportInfo newInfo) throws BOSException, EASBizException {
        if (newInfo.getId() == null) {
            return false;
        }
        IOUPartTransport iPartTransport = OUPartTransportFactory.getLocalInstance(ctx);
        OUPartTransportInfo oldInfo = iPartTransport.getOUPartTransportInfo((IObjectPK)new ObjectUuidPK(newInfo.getId()));
        return oldInfo.isIsBizUnit() ^ newInfo.isIsBizUnit();
    }

    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
        if (unitInfo.isIsTransportOrgUnit()) {
            OUPartTransportInfo ouTransportInfo = unitInfo.getPartTransport();
            if (this.isTransportBizUnitChanged(ctx, ouTransportInfo)) {
                if (ouTransportInfo.isIsBizUnit()) {
                    INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
                    if (iNOV.isBizChildrenExist(unitInfo, "00000000-0000-0000-0000-0000000000114F2827FD")) {
                        throw new OUException(OUException.TRANSPORT_BIZUNIT_CHILDREN);
                    }
                } else {
                    boolean isDelegatedByOthers = OrgDBHelper.isDelegatedByOthers((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)24);
                    if (isDelegatedByOthers) {
                        throw new OUException(OUException.TRANSPORT_BIZUNIT_DELEGATED);
                    }
                }
            }
            ouTransportInfo.setUnit(unitInfo);
            IOUPartTransport iTransport = OUPartTransportFactory.getLocalInstance(ctx);
            if (iTransport.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                if (ouTransportInfo.getId() == null) {
                    BOSUuid partID = iTransport.getOUPartTransportInfo("Select id Where unit.id = '" + pk.toString() + "'").getId();
                    ouTransportInfo.setId(partID);
                }
                iTransport.update((IObjectPK)new ObjectUuidPK(ouTransportInfo.getId()), ouTransportInfo);
            } else {
                if (!unitInfo.isIsCU() && !currentCUInfo.isIsTransportOrgUnit()) {
                    Object[] param = new String[]{OrgType.Transport.getAlias(), OrgType.Transport.getAlias()};
                    throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
                }
                ouTransportInfo.setVersionNumber(versionNumber);
                iTransport.addnew(ouTransportInfo);
                unitInfo.setPartTransport(ouTransportInfo);
            }
        } else {
            IOUPartTransport iTransport = OUPartTransportFactory.getLocalInstance(ctx);
            if (iTransport.exists("Select id Where unit.id = '" + pk.toString() + "'")) {
                OUPartReference.isReferenced((Context)ctx, (String)"8355C0AB", (String)pk.toString());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
                iTransport.delete(filter);
            }
            unitInfo.setPartTransport(null);
        }
    }

    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws BOSException, EASBizException {
        if (unitInfo.isIsTransportOrgUnit()) {
            if (!unitInfo.isIsCU() && !currentCUInfo.isIsTransportOrgUnit()) {
                Object[] param = new String[]{OrgType.Quality.getAlias(), OrgType.Quality.getAlias()};
                throw new OUException(OUException.ORGTYPE_NOTEXISTINCU, param);
            }
            OUPartTransportInfo ouTransportInfo = unitInfo.getPartTransport();
            ouTransportInfo.setUnit(unitInfo);
            ouTransportInfo.setVersionNumber(unitInfo.getVersionNumber());
            IOUPartTransport iTransport = OUPartTransportFactory.getLocalInstance(ctx);
            IObjectPK newPK = iTransport.addnew(ouTransportInfo);
            unitInfo.setPartTransport(ouTransportInfo);
        }
    }

    public void delOrgInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
        if (deleteInfo.isIsTransportOrgUnit()) {
            INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
            IOrgDelegateFacade iDelegate = OrgDelegateFacadeFactory.getLocalInstance((Context)ctx);
            if (iNOV.isBizChildrenExist(deleteInfo, "00000000-0000-0000-0000-0000000000114F2827FD")) {
                Object[] params = new String[]{OrgType.Transport.getAlias()};
                throw new OUException(OUException.EXISTCHILDREN_NOTDELETE, params);
            }
            if (iDelegate.isDelegatedByOthers(deleteInfo.getId().toString(), 24)) {
                throw new OUException(OUException.TRANSPORT_DELEGATEDBYOTHERS_NTDELETE);
            }
            ObjectStringPK pk = new ObjectStringPK(deleteInfo.getId().toString());
            OUPartReference.isReferenced((Context)ctx, (String)"8355C0AB", (String)pk.toString());
            OUPartReference.isReferenced((Context)ctx, (String)"5CEBCE24", (String)pk.toString());
            IOUPartTransport iTransport = OUPartTransportFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iTransport.delete(filter);
        }
    }

    public String[] getRebuildSql() {
        StringBuffer sb = new StringBuffer(800);
        sb.append("insert into T_ORG_Transport (\n").append("FID,\n").append("FName_L1,\n").append("FName_L2,\n").append("FName_L3,\n").append("FNumber,\n").append("FDescription_L1,\n").append("FDescription_L2,\n").append("FDescription_L3,\n").append("FSimpleName,\n").append("FIsGrouping,\n").append("FEffectDate,\n").append("FInvalidDate,\n").append("FIsFreeze,\n").append("FIsCompanyOrgUnit,\n").append("FIsAdminOrgUnit,\n").append("FIsSaleOrgUnit,\n").append("FIsPurchaseOrgUnit,\n").append("FIsStorageOrgUnit,\n").append("FIsProfitOrgUnit,\n").append("FIsCostOrgUnit,\n").append("FIsCU,\n").append("FIsUnion,\n").append("FIsHROrgUnit,\n").append("FCreatorID,\n").append("FCreateTime,\n").append("FLastUpdateUserID,\n").append("FLastUpdateTime,\n").append("FControlUnitID,\n").append("FIsLeaf,\n").append("FLevel,\n").append("FLongNumber,\n").append("FParentID,\n").append("FIsSealUp,\n").append("FIsBizUnit ,\n").append("FIsStart,\n").append("FIsOUSealUp,\n").append("FDisplayName_L1,\n").append("FDisplayName_L2,\n").append("FDisplayName_L3,\n").append("FPropertySealUpDate,\n").append("FVersionNumber,\n").append("FCode,\n").append("FIsTransportOrgUnit,\n").append("forgTypeStr,\n").append("FIsQualityOrgUnit)\n").append("SELECT\n").append("ou.FID,\n").append("ou.FName_L1,\n").append("ou.FName_L2,\n").append("ou.FName_L3,\n").append("ou.FNumber,\n").append("ou.FDescription_L1,\n").append("ou.FDescription_L2,\n").append("ou.FDescription_L3,\n").append("ou.FSimpleName,\n").append("ou.FIsGrouping,\n").append("ou.FEffectDate,\n").append("ou.FInvalidDate,\n").append("ou.FIsFreeze,\n").append("ou.FIsCompanyOrgUnit,\n").append("ou.FIsAdminOrgUnit,\n").append("ou.FIsSaleOrgUnit,\n").append("ou.FIsPurchaseOrgUnit,\n").append("ou.FIsStorageOrgUnit,\n").append("ou.FIsProfitOrgUnit,\n").append("ou.FIsCostOrgUnit,\n").append("ou.FIsCU,\n").append("ou.FIsUnion,\n").append("ou.FIsHROrgUnit,\n").append("ou.FCreatorID,\n").append("ou.FCreateTime,\n").append("ou.FLastUpdateUserID,\n").append("ou.FLastUpdateTime,\n").append("ou.FControlUnitID,\n").append("stru.FIsLeaf,\n").append("stru.FLevel,\n").append("stru.FLongNumber,\n").append("stru1.FUnitId AS FParentID,\n").append("transport.FIsSealUp,\n").append("transport.FIsBizUnit ,\n").append("ou.FIsStart,\n").append("ou.FIsOUSealUp,\n").append("stru.FDisplayName_L1,\n").append("stru.FDisplayName_L2,\n").append("stru.FDisplayName_L3,\n").append("transport.FPropertySealUpDate,\n").append("ou.FVersionNumber,\n").append("ou.FCode,\n").append("ou.FIsTransportOrgUnit,\n").append("ou.forgTypeStr,\n").append("ou.FIsQualityOrgUnit\n").append("FROM T_ORG_BaseUnit ou INNER JOIN\n").append("T_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\n").append("T_ORG_Structure stru1 ON stru.FParentID = stru1.FID INNER JOIN\n").append("T_ORG_OUPartTransport transport ON ou.FID = transport.FUnitID\n").append("WHERE (stru.FTreeId = '00000000-0000-0000-0000-0000000000114F2827FD')\n");
        return new String[]{"delete from T_ORG_Transport", sb.toString()};
    }

    public OrgTypeSelfInfo getOrgTypeSelfInfo() {
        OrgTypeSelfInfo orgInfo = new OrgTypeSelfInfo();
        orgInfo.setTableName("T_ORG_OUPartTransport");
        orgInfo.setTableNameHis("T_ORG_OUPartTransport_his");
        orgInfo.setTableNameAlias("PtTrans");
        orgInfo.setViewTableName("T_ORG_Transport");
        orgInfo.setViewTableNameHis("T_ORG_Transport_his");
        orgInfo.setViewTableAlias("Trans");
        orgInfo.setOrgViewBosType(new TransportOrgUnitInfo().getBOSType());
        orgInfo.setOrgTableBosType(new OUPartTransportInfo().getBOSType());
        orgInfo.setOuPartInfo((OUPartCoreBaseInfo)new OUPartTransportInfo());
        orgInfo.setOrgUnitViewInfo((OrgUnitInfo)new TransportOrgUnitInfo());
        orgInfo.setOrgType(OrgType.Transport);
        return orgInfo;
    }

    public static TransportOrgUnitInfo createTransportOrgUnitVersionInfo(Context ctx, ResultSet rs) throws Exception {
        TransportOrgUnitInfo transportVersionInfo = (TransportOrgUnitInfo)OrgVersionServerUtils.createOrgUnitVersionInfo((Context)ctx, (OrgUnitInfo)new TransportOrgUnitInfo(), (ResultSet)rs);
        String versionNumber = transportVersionInfo.getVersionNumber();
        String parentId = rs.getString("FParentID");
        if (parentId != null && parentId.trim().length() != 0) {
            TransportOrgUnitInfo parentVersionInfo = new TransportOrgUnitInfo(versionNumber, BOSUuid.read((String)parentId));
            parentVersionInfo.setId(BOSUuid.read((String)parentId));
            transportVersionInfo.setParent(parentVersionInfo);
        }
        transportVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        transportVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        transportVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return transportVersionInfo;
    }

    public List getInsertHisDataSql() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("INSERT INTO T_ORG_OUPartTransport_His(FID,FUnitID,FIsBizUnit,FIsSealUp, FPropertySealUpDate, FVersionNumber) SELECT FID,FUnitID,FIsBizUnit,FIsSealUp, FPropertySealUpDate, FVersionNumber FROM T_ORG_OUPartTransport");
        retList.add("INSERT INTO T_ORG_Transport_His(FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FIsSealUp, FIsBizUnit, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr) SELECT FID, FName_L1, FName_L2, FName_L3, FNumber, FDescription_L1, FDescription_L2, FDescription_L3, FSimpleName, FIsGrouping, FEffectDate, FInvalidDate, FIsFreeze, FIsCompanyOrgUnit, FIsAdminOrgUnit, FIsSaleOrgUnit, FIsPurchaseOrgUnit, FIsStorageOrgUnit, FIsProfitOrgUnit, FIsCostOrgUnit, FIsCU, FIsUnion, FIsHROrgUnit, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FIsLeaf, FLevel, FLongNumber, FParentID, FIsSealUp, FIsBizUnit, FIsStart, FIsOUSealUp, FDisplayName_L1, FDisplayName_L2, FDisplayName_L3, FPropertySealUpDate, FVersionNumber, FCode, FIsTransportOrgUnit,forgTypeStr FROM T_ORG_Transport");
        return retList;
    }

    public List getOrgVersioningUpdateStmts(String inValidateStr, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(new StringBuffer().append("UPDATE T_ORG_Transport_His SET FInvalidDate = {ts'").append(inValidateStr).append("'}").append(" WHERE FVersionNumber = '").append(versionNumber).append("'").toString());
        return retList;
    }

    public OrgUnitInfo createOrgUnitVersionInfo(String versionNumber, String id) {
        return new TransportOrgUnitInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadSuperiorHisOrgUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        if (OrgTypeHelper.isOrgType((String)fullVersionInfo.getOrgTypeStr(), (OrgType)OrgType.Transport)) {
            TransportOrgUnitInfo transPortVersionInfo = (TransportOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(fullVersionInfo.getVersionNumber(), fullVersionInfo.getId()));
            if (transPortVersionInfo == null) {
                throw new OUException(OUException.NONE_HR_SUPERIOR);
            }
            TransportOrgUnitInfo info = transPortVersionInfo.getParent();
            pdInfo.setParentOrg(OrgType.Transport, (OrgUnitInfo)((TransportOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(info.getVersionNumber(), info.getId()))));
        }
    }

    public CoreBaseInfo createOUPartOrgUnitVersionInfo(String versionNumber, String id) {
        return new OUPartTransportInfo(versionNumber, BOSUuid.read((String)id));
    }

    public void loadOUPartVersion(Context ctx, FullOrgUnitInfo fullVersionInfo, ResultSet rs) throws BOSException, EASBizException, SQLException {
        String versionNumber = fullVersionInfo.getVersionNumber();
        String partTransPortId = rs.getString("FPartTransportID");
        if (partTransPortId != null && partTransPortId.trim().length() != 0) {
            OUPartTransportInfo partTransVersionInfo = new OUPartTransportInfo(versionNumber, BOSUuid.read((String)partTransPortId));
            fullVersionInfo.setPartTransport(partTransVersionInfo);
        }
    }

    public OrgUnitInfo getUnitVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Transport_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OrgUnitInfo orgUnitInfo = null;
                return orgUnitInfo;
            }
            TransportOrgUnitInfo transportVersionInfo = OrgAppTransportImpl.createTransportOrgUnitVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with pk: " + pk);
            }
            TransportOrgUnitInfo transportOrgUnitInfo = transportVersionInfo;
            return transportOrgUnitInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        if (longNumber == null || longNumber.trim().length() == 0) {
            throw new BOSException("longNumber can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_Transport_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND (FLongNumber = '").append(longNumber).append("'").append(" OR FLongNumber LIKE '").append(longNumber + "!%").append("')").append(" ORDER BY FLongNumber").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    private OrgUnitCollection getOrgUnitVersionCollectionBySql(Context ctx, String sql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            OrgUnitCollection hrVersionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            OrgUnitCollection orgUnitCollection = hrVersionCol = OrgQueryHelper.createOrgUnitVersionCollection((Context)ctx, (ResultSet)rs, (IOrgUnitInfoFactory)new IOrgUnitInfoFactory(){

                public OrgUnitInfo createOrgInfo() {
                    return new TransportOrgUnitInfo();
                }
            });
            return orgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, IObjectPK cuOrgPK, String versionNumber) throws BOSException, EASBizException {
        String tableName = this.getOrgTypeSelfInfo().getViewTableNameHis();
        String sql = "SELECT FID, FVersionNumber FROM " + tableName + " WHERE FControlUnitID = '" + cuOrgPK + "' and forgTypeStr like '%" + this.getOrgTypeSelfInfo().getOrgType().getName() + "%' FVersionNumber = '" + versionNumber + "'";
        return this.getOrgUnitVersionCollectionBySql(ctx, sql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String selectSql) throws BOSException, EASBizException {
        if (selectSql == null) {
            throw new BOSException("selectSql can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OUPartCoreBaseInfo oUPartCoreBaseInfo = null;
                return oUPartCoreBaseInfo;
            }
            OUPartBaseInfo partHRVersionInfo = OrgQueryHelper.createOUPartVersionInfo((Context)ctx, (ResultSet)rs, (OUPartBaseInfo)new OUPartTransportInfo());
            if (rs.next()) {
                throw new BOSException("Too many records with selectSql: " + selectSql);
            }
            OUPartBaseInfo oUPartBaseInfo = partHRVersionInfo;
            return oUPartBaseInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        OUPartTransportInfo retInfo = new OUPartTransportInfo();
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartTransport_his WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        return OrgQueryHelper.getOUPartVersionInfo((Context)ctx, (String)selectSql, (OUPartBaseInfo)retInfo);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String version, String orgId) throws BOSException, EASBizException {
        OUPartTransportInfo retInfo = new OUPartTransportInfo();
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartTransport_his WHERE ").append("FVersionNumber = '").append(version).append("'").append(" AND FUNITID = '").append(orgId).append("'").toString();
        return OrgQueryHelper.getOUPartVersionInfo((Context)ctx, (String)selectSql, (OUPartBaseInfo)retInfo);
    }

    public void batchDelOrgInfo(Context ctx, FullOrgUnitCollection unitCol) throws BOSException, EASBizException {
        for (int i = 0; i < unitCol.size(); ++i) {
            FullOrgUnitInfo unitInfo = unitCol.get(i);
            if (!unitInfo.isIsTransportOrgUnit()) {
                return;
            }
            Object[] params = new String[]{OrgType.Transport.getAlias(), OrgType.Transport.getAlias()};
            if (OrgAppHelper.isCUBizPropertyExistInOU((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)24)) {
                throw new OUException(OUException.EXISTINCU_NOTDELETE, params);
            }
            unitInfo.setIsTransportOrgUnit(false);
            ObjectStringPK pk = new ObjectStringPK(unitInfo.getId().toString());
            OUPartReference.delReferenced((Context)ctx, (String)"8355C0AB", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getTableName());
            OUPartReference.delReferenced((Context)ctx, (String)"5CEBCE24", (String)pk.toString(), (String)this.getOrgTypeSelfInfo().getViewTableName());
            IOUPartTransport iTransport = OUPartTransportFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
            iTransport.delete(filter);
            unitInfo.setPartTransport(null);
            OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
            orgTypeHelper.removeOrgType(OrgType.Transport);
            unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        }
    }
}

