/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.orgext.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUPartBaseInfo;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgDBHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.AbstractDefaultOrgTypeImpl;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.IOrgUnitInfoFactory;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgQueryHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.basedata.orgext.IOUPartShareCenter;
import com.kingdee.eas.basedata.orgext.OUExtException;
import com.kingdee.eas.basedata.orgext.OUPartShareCenterCollection;
import com.kingdee.eas.basedata.orgext.OUPartShareCenterFactory;
import com.kingdee.eas.basedata.orgext.OUPartShareCenterInfo;
import com.kingdee.eas.basedata.orgext.ShareCenterOrgTypeAddNewInfo;
import com.kingdee.eas.basedata.orgext.ShareCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ShareCenterOrgAppHelper
extends AbstractDefaultOrgTypeImpl
implements IOrgAppHelper {
    private static Logger logger = Logger.getLogger((String)ShareCenterOrgAppHelper.class.getName());

    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws BOSException, EASBizException {
        if (!OrgTypeHelper.isOrgType((String)unitInfo.getOrgTypeStr(), (OrgType)ShareCenterOrgTypeAddNewInfo.newOrgType)) {
            return;
        }
        OUPartShareCenterInfo ShareCenterOrgInfo = (OUPartShareCenterInfo)unitInfo.get(ShareCenterOrgTypeAddNewInfo.newOrgType.getName());
        if (ShareCenterOrgInfo != null) {
            IOUPartShareCenter iOUPartShareCenter = OUPartShareCenterFactory.getLocalInstance(ctx);
            String versionNumber = unitInfo.getVersionNumber();
            ShareCenterOrgInfo.setVersionNumber(versionNumber);
            IObjectPK pk = iOUPartShareCenter.addnew(ShareCenterOrgInfo);
            ShareCenterOrgInfo.setId(BOSUuid.read((String)pk.toString()));
            unitInfo.put(ShareCenterOrgTypeAddNewInfo.newOrgType.getName(), (Object)ShareCenterOrgInfo);
            unitInfo.setOUPart(ShareCenterOrgTypeAddNewInfo.newOrgType, (OUPartCoreBaseInfo)ShareCenterOrgInfo);
        }
    }

    public void delOrgInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
        IOUPartShareCenter iOUPartShareCenter = OUPartShareCenterFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)deleteInfo.getId().toString()));
        iOUPartShareCenter.delete(filter);
    }

    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
        if (!orgTypeHelper.isOrgType(ShareCenterOrgTypeAddNewInfo.newOrgType)) {
            this.delOrgInfo(ctx, unitInfo);
        } else {
            IOUPartShareCenter iOUPartShareCenter = OUPartShareCenterFactory.getLocalInstance(ctx);
            OUPartShareCenterInfo ShareCenterOrgInfo = (OUPartShareCenterInfo)unitInfo.get(ShareCenterOrgTypeAddNewInfo.newOrgType.getName());
            if (ShareCenterOrgInfo == null) {
                logger.info((Object)" ShareCenterOrgInfo is null!");
            }
            if (ShareCenterOrgInfo != null) {
                OUPartShareCenterCollection ouPartMarCol = iOUPartShareCenter.getOUPartShareCenterCollection(" where unit.id = '" + ShareCenterOrgInfo.getUnit().getId().toString() + "'");
                if (!ouPartMarCol.isEmpty()) {
                    ShareCenterOrgInfo.setId(ouPartMarCol.get(0).getId());
                }
                if (this.isShareCenterBizUnitChanged(ctx, ShareCenterOrgInfo)) {
                    if (ShareCenterOrgInfo.isIsBizUnit()) {
                        INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
                        if (iNOV.isBizChildrenExist(unitInfo, ShareCenterOrgTypeAddNewInfo.getTreeId())) {
                            throw new OUExtException(OUExtException.SHARE_CENTER_BIZUNIT_CHILDREN);
                        }
                    } else {
                        boolean isDelegatedByOthers = OrgDBHelper.isDelegatedByOthers((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)ShareCenterOrgTypeAddNewInfo.getOrgTypeInfo().getOrgType().getValue());
                        if (isDelegatedByOthers) {
                            throw new OUExtException(OUExtException.SHARE_CENTER_BIZUNIT_DELEGATED);
                        }
                    }
                }
                iOUPartShareCenter.submit((CoreBaseInfo)ShareCenterOrgInfo);
            }
        }
    }

    private boolean isShareCenterBizUnitChanged(Context ctx, OUPartShareCenterInfo newInfo) throws BOSException, EASBizException {
        if (newInfo.getId() == null) {
            return false;
        }
        IOUPartShareCenter iOUPartShareCenter = OUPartShareCenterFactory.getLocalInstance(ctx);
        OUPartShareCenterInfo oldInfo = iOUPartShareCenter.getOUPartShareCenterInfo((IObjectPK)new ObjectUuidPK(newInfo.getId()));
        return oldInfo.isIsBizUnit() ^ newInfo.isIsBizUnit();
    }

    public OrgTypeSelfInfo getOrgTypeSelfInfo() {
        OrgTypeSelfInfo orgInfo = new OrgTypeSelfInfo();
        orgInfo.setTableName("T_ORG_OUPartShareCenter");
        orgInfo.setTableNameAlias("PtSC");
        orgInfo.setViewTableName("T_ORG_ShareCenterOrgUnit");
        orgInfo.setViewTableAlias("ShareCenterOrgUnit");
        orgInfo.setOrgViewBosType(new ShareCenterOrgUnitInfo().getBOSType());
        orgInfo.setOrgTableBosType(new OUPartShareCenterInfo().getBOSType());
        orgInfo.setOrgType(ShareCenterOrgTypeAddNewInfo.newOrgType);
        orgInfo.setOuPartInfo((OUPartCoreBaseInfo)new OUPartShareCenterInfo());
        orgInfo.setOrgUnitViewInfo((OrgUnitInfo)new ShareCenterOrgUnitInfo());
        return orgInfo;
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String sql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            OrgUnitCollection versionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            OrgUnitCollection orgUnitCollection = versionCol = OrgQueryHelper.createOrgUnitVersionCollection((Context)ctx, (ResultSet)rs, (IOrgUnitInfoFactory)new IOrgUnitInfoFactory(){

                public OrgUnitInfo createOrgInfo() {
                    return new ShareCenterOrgUnitInfo();
                }
            });
            return orgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public List getOrgUpdateStmts(String versionNumber) {
        return null;
    }

    public List getOrgVersioningUpdateStmts(String inValidateStr, String versionNumber) {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(new StringBuffer().append("UPDATE T_ORG_ShareCenterOrgUnit_His SET FInvalidDate = {ts'").append(inValidateStr).append("'}").append(" WHERE FVersionNumber = '").append(versionNumber).append("'").toString());
        return retList;
    }

    public String[] getRebuildSql() {
        StringBuffer sb = new StringBuffer(800);
        sb.append("insert into T_ORG_ShareCenterOrgUnit (\n").append("FID,\n").append("FName_L1,\n").append("FName_L2,\n").append("FName_L3,\n").append("FNumber,\n").append("FDescription_L1,\n").append("FDescription_L2,\n").append("FDescription_L3,\n").append("FSimpleName,\n").append("FIsGrouping,\n").append("FEffectDate,\n").append("FInvalidDate,\n").append("FIsFreeze,\n").append("FIsCompanyOrgUnit,\n").append("FIsAdminOrgUnit,\n").append("FIsSaleOrgUnit,\n").append("FIsPurchaseOrgUnit,\n").append("FIsStorageOrgUnit,\n").append("FIsProfitOrgUnit,\n").append("FIsCostOrgUnit,\n").append("FIsCU,\n").append("FIsUnion,\n").append("FIsHROrgUnit,\n").append("FCreatorID,\n").append("FCreateTime,\n").append("FLastUpdateUserID,\n").append("FLastUpdateTime,\n").append("FControlUnitID,\n").append("FIsLeaf,\n").append("FLevel,\n").append("FLongNumber,\n").append("FParentID,\n").append("FIsBizUnit,\n").append("FIsSealUp,\n").append("FIsStart,\n").append("FIsOUSealUp,\n").append("FDisplayName_L1,\n").append("FDisplayName_L2,\n").append("FDisplayName_L3,\n").append("FPropertySealUpDate,\n").append("FVersionNumber,\n").append("FCode,\n").append("FIsTransportOrgUnit,\n").append("forgTypeStr,\n").append("FIsQualityOrgUnit)\n").append("SELECT\n").append("ou.FID,\n").append("ou.FName_L1,\n").append("ou.FName_L2,\n").append("ou.FName_L3,\n").append("ou.FNumber,\n").append("ou.FDescription_L1,\n").append("ou.FDescription_L2,\n").append("ou.FDescription_L3,\n").append("ou.FSimpleName,\n").append("ou.FIsGrouping,\n").append("ou.FEffectDate,\n").append("ou.FInvalidDate,\n").append("ou.FIsFreeze,\n").append("ou.FIsCompanyOrgUnit,\n").append("ou.FIsAdminOrgUnit,\n").append("ou.FIsSaleOrgUnit,\n").append("ou.FIsPurchaseOrgUnit,\n").append("ou.FIsStorageOrgUnit,\n").append("ou.FIsProfitOrgUnit,\n").append("ou.FIsCostOrgUnit,\n").append("ou.FIsCU,\n").append("ou.FIsUnion,\n").append("ou.FIsHROrgUnit,\n").append("ou.FCreatorID,\n").append("ou.FCreateTime,\n").append("ou.FLastUpdateUserID,\n").append("ou.FLastUpdateTime,\n").append("ou.FControlUnitID,\n").append("stru.FIsLeaf,\n").append("stru.FLevel,\n").append("stru.FLongNumber,\n").append("stru1.FUnitId AS FParentID,\n").append("shareCenter.FIsBizUnit,\n").append("shareCenter.FIsSealUp,\n").append("ou.FIsStart,\n").append("ou.FIsOUSealUp,\n").append("stru.FDisplayName_L1,\n").append("stru.FDisplayName_L2,\n").append("stru.FDisplayName_L3,\n").append("shareCenter.FPropertySealUpDate,\n").append("ou.FVersionNumber,\n").append("ou.FCode,\n").append("ou.FIsTransportOrgUnit,\n").append("ou.forgTypeStr,\n").append("ou.FIsQualityOrgUnit\n").append("FROM T_ORG_BaseUnit ou INNER JOIN\n").append("T_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\n").append("T_ORG_Structure stru1 ON stru.FParentID = stru1.FID INNER JOIN\n").append("T_ORG_OUPartShareCenter shareCenter ON ou.FID = shareCenter.FUnitID\n").append("WHERE (stru.FTreeId = '").append(ShareCenterOrgTypeAddNewInfo.getTreeId()).append("')\n");
        return new String[]{"delete from T_ORG_ShareCenterOrgUnit", sb.toString()};
    }

    public OrgUnitInfo getUnitVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_ShareCenterOrgUnit_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OrgUnitInfo orgUnitInfo = null;
                return orgUnitInfo;
            }
            ShareCenterOrgUnitInfo ShareCenterVersionInfo = ShareCenterOrgAppHelper.createShareCenterOrgUnitVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with pk: " + pk);
            }
            ShareCenterOrgUnitInfo shareCenterOrgUnitInfo = ShareCenterVersionInfo;
            return shareCenterOrgUnitInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public static ShareCenterOrgUnitInfo createShareCenterOrgUnitVersionInfo(Context ctx, ResultSet rs) throws Exception {
        ShareCenterOrgUnitInfo ShareCenterVersionInfo = (ShareCenterOrgUnitInfo)OrgVersionServerUtils.createOrgUnitVersionInfo((Context)ctx, (OrgUnitInfo)new ShareCenterOrgUnitInfo(), (ResultSet)rs);
        String versionNumber = ShareCenterVersionInfo.getVersionNumber();
        String parentId = rs.getString("FParentID");
        if (parentId != null && parentId.trim().length() != 0) {
            ShareCenterOrgUnitInfo parentVersionInfo = new ShareCenterOrgUnitInfo(versionNumber, BOSUuid.read((String)parentId));
            parentVersionInfo.setId(BOSUuid.read((String)parentId));
            ShareCenterVersionInfo.setParent(parentVersionInfo);
        }
        ShareCenterVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        ShareCenterVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        ShareCenterVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return ShareCenterVersionInfo;
    }

    public void loadOUPartVersion(Context ctx, FullOrgUnitInfo fullVersionInfo, ResultSet rs) throws BOSException, EASBizException, SQLException {
        String versionNumber = fullVersionInfo.getVersionNumber();
        String partShareCenterId = rs.getString("FPartTransportID");
        if (partShareCenterId != null && partShareCenterId.trim().length() != 0) {
            OUPartShareCenterInfo partShareCenterVersionInfo = new OUPartShareCenterInfo(versionNumber, BOSUuid.read((String)partShareCenterId));
            fullVersionInfo.setOUPart(ShareCenterOrgTypeAddNewInfo.newOrgType, (OUPartCoreBaseInfo)partShareCenterVersionInfo);
        }
    }

    public List getInsertHisDataSql() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.add("INSERT INTO T_ORG_OUPartShareCenter_His(FID,FUnitID,FIsBizUnit,FIsSealUp,FPropertySealUpDate,FVersionNumber) SELECT FID,FUnitID,FIsBizUnit,FIsSealUp,FPropertySealUpDate,FVersionNumber FROM T_ORG_OUPartShareCenter");
        retList.add("INSERT INTO T_ORG_ShareCenterOrgUnit_His(FIsSealUp,FIsBizUnit,FPropertySealUpDate,FIsGrouping,FEffectDate,FInvalidDate,FIsFreeze,FIsCompanyOrgUnit,FIsAdminOrgUnit,FIsSaleOrgUnit,FIsPurchaseOrgUnit,FIsStorageOrgUnit,FIsProfitOrgUnit,FIsCostOrgUnit,FIsCU,FIsUnion,FIsHROrgUnit,FIsTransportOrgUnit,FIsQualityOrgUnit,FIsStart,FIsOUSealUp,FCode,FVersionNumber,FOrgTypeStr,FIsLeaf,FLevel,FLongNumber,FDisplayName_l1,FDisplayName_l2,FDisplayName_l3,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID,FParentId) SELECT FIsSealUp,FIsBizUnit,FPropertySealUpDate,FIsGrouping,FEffectDate,FInvalidDate,FIsFreeze,FIsCompanyOrgUnit,FIsAdminOrgUnit,FIsSaleOrgUnit,FIsPurchaseOrgUnit,FIsStorageOrgUnit,FIsProfitOrgUnit,FIsCostOrgUnit,FIsCU,FIsUnion,FIsHROrgUnit,FIsTransportOrgUnit,FIsQualityOrgUnit,FIsStart,FIsOUSealUp,FCode,FVersionNumber,FOrgTypeStr,FIsLeaf,FLevel,FLongNumber,FDisplayName_l1,FDisplayName_l2,FDisplayName_l3,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID,FParentId FROM T_ORG_ShareCenterOrgUnit");
        return retList;
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        OUPartShareCenterInfo retInfo = new OUPartShareCenterInfo();
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartShareCenter_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        return OrgQueryHelper.getOUPartVersionInfo((Context)ctx, (String)selectSql, (OUPartBaseInfo)retInfo);
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        if (longNumber == null || longNumber.trim().length() == 0) {
            throw new BOSException("longNumber can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_ShareCenterOrgUnit_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND (FLongNumber = '").append(longNumber).append("'").append(" OR FLongNumber LIKE '").append(longNumber + "!%").append("')").append(" ORDER BY FLongNumber").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    private OrgUnitCollection getOrgUnitVersionCollectionBySql(Context ctx, String sql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            OrgUnitCollection versionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            OrgUnitCollection orgUnitCollection = versionCol = OrgQueryHelper.createOrgUnitVersionCollection((Context)ctx, (ResultSet)rs, (IOrgUnitInfoFactory)new IOrgUnitInfoFactory(){

                public OrgUnitInfo createOrgInfo() {
                    return new ShareCenterOrgUnitInfo();
                }
            });
            return orgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public void loadSuperiorHisOrgUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        if (OrgTypeHelper.isOrgType((String)fullVersionInfo.getOrgTypeStr(), (OrgType)ShareCenterOrgTypeAddNewInfo.newOrgType)) {
            ShareCenterOrgUnitInfo ShareCenterVersionInfo = (ShareCenterOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(fullVersionInfo.getVersionNumber(), fullVersionInfo.getId()));
            if (ShareCenterVersionInfo == null) {
                throw new OUExtException(OUExtException.NONE_SHARA_CENTER_SUPERIOR);
            }
            ShareCenterOrgUnitInfo info = ShareCenterVersionInfo.getParent();
            pdInfo.setParentOrg(ShareCenterOrgTypeAddNewInfo.newOrgType, (OrgUnitInfo)((ShareCenterOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(info.getVersionNumber(), info.getId()))));
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, IObjectPK cuOrgPK, String versionNumber) throws BOSException, EASBizException {
        String tableName = this.getOrgTypeSelfInfo().getViewTableNameHis();
        String sql = "SELECT FID, FVersionNumber FROM " + tableName + " WHERE FControlUnitID = '" + cuOrgPK + "' and forgTypeStr like '%" + this.getOrgTypeSelfInfo().getOrgType().getName() + "%' FVersionNumber = '" + versionNumber + "'";
        return this.getOrgUnitVersionCollectionBySql(ctx, sql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String version, String orgId) throws BOSException, EASBizException {
        OUPartShareCenterInfo retInfo = new OUPartShareCenterInfo();
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartShareCenter_His WHERE ").append("FVersionNumber = '").append(version).append("'").append(" AND FUNITID = '").append(orgId).append("'").toString();
        return OrgQueryHelper.getOUPartVersionInfo((Context)ctx, (String)selectSql, (OUPartBaseInfo)retInfo);
    }
}

