/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.orgext.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUPartBaseInfo;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.VersionPK;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgDBHelper;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.AbstractDefaultOrgTypeImpl;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.IOrgUnitInfoFactory;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.OrgQueryHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.basedata.orgext.IOUPartTaxSubject;
import com.kingdee.eas.basedata.orgext.OUExtException;
import com.kingdee.eas.basedata.orgext.OUPartTaxSubjectCollection;
import com.kingdee.eas.basedata.orgext.OUPartTaxSubjectFactory;
import com.kingdee.eas.basedata.orgext.OUPartTaxSubjectInfo;
import com.kingdee.eas.basedata.orgext.TaxSubjectOrgTypeAddNewInfo;
import com.kingdee.eas.basedata.orgext.TaxSubjectOrgUnitCollection;
import com.kingdee.eas.basedata.orgext.TaxSubjectOrgUnitFactory;
import com.kingdee.eas.basedata.orgext.TaxSubjectOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import org.apache.log4j.Logger;

public class TaxSubjectOrgAppHelper
extends AbstractDefaultOrgTypeImpl
implements IOrgAppHelper {
    private static Logger logger = Logger.getLogger((String)TaxSubjectOrgAppHelper.class.getName());

    public void addNewInfo(Context ctx, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo) throws BOSException, EASBizException {
        if (!OrgTypeHelper.isOrgType((String)unitInfo.getOrgTypeStr(), (OrgType)TaxSubjectOrgTypeAddNewInfo.newOrgType)) {
            return;
        }
        OUPartTaxSubjectInfo TaxSubjectOrgInfo = (OUPartTaxSubjectInfo)unitInfo.get(TaxSubjectOrgTypeAddNewInfo.newOrgType.getName());
        this.checkProperties(ctx, TaxSubjectOrgInfo);
        this.checkTaxSubjectNameDup(ctx, TaxSubjectOrgInfo);
        this.checkTaxSubjectCreditCodeDup(ctx, TaxSubjectOrgInfo);
        if (TaxSubjectOrgInfo != null) {
            IOUPartTaxSubject iOUPartTaxSubject = OUPartTaxSubjectFactory.getLocalInstance(ctx);
            String versionNumber = unitInfo.getVersionNumber();
            TaxSubjectOrgInfo.setVersionNumber(versionNumber);
            IObjectPK pk = iOUPartTaxSubject.addnew(TaxSubjectOrgInfo);
            TaxSubjectOrgInfo.setId(BOSUuid.read((String)pk.toString()));
            unitInfo.put(TaxSubjectOrgTypeAddNewInfo.newOrgType.getName(), (Object)TaxSubjectOrgInfo);
            unitInfo.setOUPart(TaxSubjectOrgTypeAddNewInfo.newOrgType, (OUPartCoreBaseInfo)TaxSubjectOrgInfo);
        }
    }

    private void checkTaxSubjectNameDup(Context ctx, OUPartTaxSubjectInfo taxSubjectOrgInfo) throws OUExtException, EASBizException, BOSException {
        if (!taxSubjectOrgInfo.isIsBizUnit()) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taxSubjectName", (Object)taxSubjectOrgInfo.getTaxSubjectName(), CompareType.EQUALS));
        if (taxSubjectOrgInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)taxSubjectOrgInfo.getUnit().getId().toString(), CompareType.NOTEQUALS));
        }
        if (TaxSubjectOrgUnitFactory.getLocalInstance(ctx).exists(filter)) {
            throw new OUExtException(OUExtException.TAXSUJECT_NAME_DUP, new Object[]{taxSubjectOrgInfo.getTaxSubjectName()});
        }
    }

    private void checkTaxSubjectCreditCodeDup(Context ctx, OUPartTaxSubjectInfo taxSubjectOrgInfo) throws OUExtException, EASBizException, BOSException {
        if (!taxSubjectOrgInfo.isIsBizUnit()) {
            return;
        }
        if (taxSubjectOrgInfo.getCreditCode() == null || taxSubjectOrgInfo.getCreditCode().length() != 18) {
            throw new OUExtException(OUExtException.TAXSUBJECT_CREDIT_LENGTH_LIMIT);
        }
        char[] creditCode = taxSubjectOrgInfo.getCreditCode().toCharArray();
        boolean isMatch = true;
        for (int i = 0; i < creditCode.length; ++i) {
            if (creditCode[i] >= '0' && creditCode[i] <= '9' || creditCode[i] >= 'A' && creditCode[i] <= 'Z') continue;
            isMatch = false;
            break;
        }
        if (!isMatch) {
            throw new OUExtException(OUExtException.TAXSUBJECT_CREDIT_CONTENT_LIMIT);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("creditCode", (Object)taxSubjectOrgInfo.getCreditCode(), CompareType.EQUALS));
        if (taxSubjectOrgInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)taxSubjectOrgInfo.getUnit().getId().toString(), CompareType.NOTEQUALS));
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        TaxSubjectOrgUnitCollection coll = TaxSubjectOrgUnitFactory.getLocalInstance(ctx).getTaxSubjectOrgUnitCollection(ev);
        if (coll.size() > 0) {
            throw new OUExtException(OUExtException.TAXSUBJECT_CREDIT_DUP, new Object[]{coll.get(0).getName()});
        }
    }

    public void updateOrgInfo(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo, CtrlUnitInfo currentCUInfo, String versionNumber, boolean isOrgStart) throws BOSException, EASBizException {
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper((OrgUnitInfo)unitInfo);
        if (!orgTypeHelper.isOrgType(TaxSubjectOrgTypeAddNewInfo.newOrgType)) {
            this.delOrgInfo(ctx, unitInfo);
        } else {
            IOUPartTaxSubject iOUPartTaxSubject = OUPartTaxSubjectFactory.getLocalInstance(ctx);
            OUPartTaxSubjectInfo TaxSubjectOrgInfo = (OUPartTaxSubjectInfo)unitInfo.get(TaxSubjectOrgTypeAddNewInfo.newOrgType.getName());
            this.checkProperties(ctx, TaxSubjectOrgInfo);
            this.checkTaxSubjectNameDup(ctx, TaxSubjectOrgInfo);
            this.checkTaxSubjectCreditCodeDup(ctx, TaxSubjectOrgInfo);
            if (TaxSubjectOrgInfo == null) {
                logger.info((Object)" TaxSubjectOrgInfo is null!");
            }
            if (TaxSubjectOrgInfo != null) {
                OUPartTaxSubjectCollection ouPartMarCol = iOUPartTaxSubject.getOUPartTaxSubjectCollection(" where unit.id = '" + TaxSubjectOrgInfo.getUnit().getId().toString() + "'");
                if (!ouPartMarCol.isEmpty()) {
                    TaxSubjectOrgInfo.setId(ouPartMarCol.get(0).getId());
                }
                if (this.isTaxSubjectBizUnitChanged(ctx, TaxSubjectOrgInfo)) {
                    if (TaxSubjectOrgInfo.isIsBizUnit()) {
                        INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
                        if (iNOV.isBizChildrenExist(unitInfo, TaxSubjectOrgTypeAddNewInfo.getTreeId())) {
                            throw new OUExtException(OUExtException.SHARE_CENTER_BIZUNIT_CHILDREN);
                        }
                    } else {
                        boolean isDelegatedByOthers = OrgDBHelper.isDelegatedByOthers((Context)ctx, (FullOrgUnitInfo)unitInfo, (int)TaxSubjectOrgTypeAddNewInfo.getOrgTypeInfo().getOrgType().getValue());
                        if (isDelegatedByOthers) {
                            throw new OUExtException(OUExtException.SHARE_CENTER_BIZUNIT_DELEGATED);
                        }
                    }
                }
                iOUPartTaxSubject.submit((CoreBaseInfo)TaxSubjectOrgInfo);
            }
        }
    }

    private void checkProperties(Context ctx, OUPartTaxSubjectInfo taxSubjectOrgInfo) throws OUExtException {
        if (!taxSubjectOrgInfo.isIsBizUnit()) {
            if (StringUtils.isEmpty((String)taxSubjectOrgInfo.getTaxSubjectName())) {
                throw new OUExtException(OUExtException.TAXSUBJECT_VIRTUAL_NAME_NOTEMPTY);
            }
            return;
        }
        if (StringUtils.isEmpty((String)taxSubjectOrgInfo.getTaxSubjectName())) {
            throw new OUExtException(OUExtException.TAXSUJECT_NAME_NOTEMPTY);
        }
        if (StringUtils.isEmpty((String)taxSubjectOrgInfo.getCreditCode())) {
            throw new OUExtException(OUExtException.TAXSUJECT_CREDITCODE_NOTEMPTY);
        }
        if (taxSubjectOrgInfo.getBussinessStartDate() == null) {
            throw new OUExtException(OUExtException.TAXSUJECT_BUSINESSSTART_NOTEMPTY);
        }
        if (StringUtils.isEmpty((String)taxSubjectOrgInfo.getCompetentTaxAuthority())) {
            throw new OUExtException(OUExtException.TAXSUJECT_COMPETENT_TAX_AUTHORITY_NOTEMPTY);
        }
        if (StringUtils.isEmpty((String)taxSubjectOrgInfo.getRepresentative())) {
            throw new OUExtException(OUExtException.TAXSUJECT_REPRESENTIVE_NOTEMPTY);
        }
        if (taxSubjectOrgInfo.getRegistrationType() == null) {
            throw new OUExtException(OUExtException.TAXSUJECT_REGISTRATIONTYPE_NOTEMPTY);
        }
        if (StringUtils.isEmpty((String)taxSubjectOrgInfo.getBusinessScope())) {
            throw new OUExtException(OUExtException.TAXSUJECT_BUSINESSSCOPE_NOTEMPTY);
        }
        if (taxSubjectOrgInfo.getRegCapitalCurrency() == null) {
            throw new OUExtException(OUExtException.TAXSUJECT_REGCAPITALCURRENCY_NOTEMPTY);
        }
        if (taxSubjectOrgInfo.getRegCapital() == null) {
            throw new OUExtException(OUExtException.TAXSUJECT_REGCAPITAL_NOTEMPTY);
        }
        if (taxSubjectOrgInfo.getInvestmentCurrency() == null) {
            throw new OUExtException(OUExtException.TAXSUJECT_INVESTMENTCURRENCY_NOTEMPTY);
        }
        if (taxSubjectOrgInfo.getInvestmentAmount() == null) {
            throw new OUExtException(OUExtException.TAXSUJECT_INVESTMENTAMOUNT_NOTEMPTY);
        }
        if (taxSubjectOrgInfo.getEstablelisingData() == null) {
            throw new OUExtException(OUExtException.TAXSUJECT_ESTABLELISINGDATA_NOTEMPTY);
        }
        if (taxSubjectOrgInfo.getRegAddress() == null) {
            throw new OUExtException(OUExtException.TAXSUJECT_REGADDRESS_NOTEMPTY);
        }
        if (taxSubjectOrgInfo.getBusinessAddress() == null) {
            throw new OUExtException(OUExtException.TAXSUJECT_BUSINESSADDRESS_NOTEMPTY);
        }
        if (taxSubjectOrgInfo.getIndustry() == null) {
            throw new OUExtException(OUExtException.TAXSUJECT_INDUSTRY_NOTEMPTY);
        }
        Timestamp bussinessEndDate = taxSubjectOrgInfo.getBussinessEndDate();
        if (bussinessEndDate != null && bussinessEndDate.compareTo(taxSubjectOrgInfo.getBussinessStartDate()) < 0) {
            throw new OUExtException(OUExtException.TAXSUJECT_BUSDATE_LESS_ENDDATE);
        }
    }

    public void delOrgInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
        IOUPartTaxSubject iOUPartTaxSubject = OUPartTaxSubjectFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)deleteInfo.getId().toString()));
        iOUPartTaxSubject.delete(filter);
    }

    public String[] getRebuildSql() {
        StringBuffer sb = new StringBuffer(800);
        sb.append("insert into T_ORG_taxSubject (\n").append("FID,\n").append("FName_L1,\n").append("FName_L2,\n").append("FName_L3,\n").append("FNumber,\n").append("FDescription_L1,\n").append("FDescription_L2,\n").append("FDescription_L3,\n").append("FSimpleName,\n").append("FIsGrouping,\n").append("FEffectDate,\n").append("FInvalidDate,\n").append("FIsFreeze,\n").append("FIsCompanyOrgUnit,\n").append("FIsAdminOrgUnit,\n").append("FIsSaleOrgUnit,\n").append("FIsPurchaseOrgUnit,\n").append("FIsStorageOrgUnit,\n").append("FIsProfitOrgUnit,\n").append("FIsCostOrgUnit,\n").append("FIsCU,\n").append("FIsUnion,\n").append("FIsHROrgUnit,\n").append("FCreatorID,\n").append("FCreateTime,\n").append("FLastUpdateUserID,\n").append("FLastUpdateTime,\n").append("FControlUnitID,\n").append("FIsLeaf,\n").append("FLevel,\n").append("FLongNumber,\n").append("FParentID,\n").append("FIsBizUnit,\n").append("FIsSealUp,\n").append("FIsStart,\n").append("FIsOUSealUp,\n").append("FDisplayName_L1,\n").append("FDisplayName_L2,\n").append("FDisplayName_L3,\n").append("FPropertySealUpDate,\n").append("FVersionNumber,\n").append("FCode,\n").append("FIsTransportOrgUnit,\n").append("forgTypeStr,\n").append("FTaxSubjectName,\n").append("FCreditCode,\n").append("FTaxSubjectEnName,\n").append("FIsVaild,\n").append("FBussinessStartDate,\n").append("FBussinessEndDate,\n").append("FIndAndCommRegAuthority,\n").append("FCompetentTaxAuthority,\n").append("FCompetentTaxAuthorityContact,\n").append("FRepresentative,\n").append("FRegCapital,\n").append("FRegCapitalCurrencyID,\n").append("FInvestmentAmount,\n").append("FInvestmentCurrencyID,\n").append("FEstablelisingData,\n").append("FCancellationDate,\n").append("FBusinessScope,\n").append("FIndustryID,\n").append("FRegistrationTypeID,\n").append("FRegAddressID,\n").append("FBusinessAddressID,\n").append("FIsQualityOrgUnit)\n").append("SELECT\n").append("ou.FID,\n").append("ou.FName_L1,\n").append("ou.FName_L2,\n").append("ou.FName_L3,\n").append("ou.FNumber,\n").append("ou.FDescription_L1,\n").append("ou.FDescription_L2,\n").append("ou.FDescription_L3,\n").append("ou.FSimpleName,\n").append("ou.FIsGrouping,\n").append("ou.FEffectDate,\n").append("ou.FInvalidDate,\n").append("ou.FIsFreeze,\n").append("ou.FIsCompanyOrgUnit,\n").append("ou.FIsAdminOrgUnit,\n").append("ou.FIsSaleOrgUnit,\n").append("ou.FIsPurchaseOrgUnit,\n").append("ou.FIsStorageOrgUnit,\n").append("ou.FIsProfitOrgUnit,\n").append("ou.FIsCostOrgUnit,\n").append("ou.FIsCU,\n").append("ou.FIsUnion,\n").append("ou.FIsHROrgUnit,\n").append("ou.FCreatorID,\n").append("ou.FCreateTime,\n").append("ou.FLastUpdateUserID,\n").append("ou.FLastUpdateTime,\n").append("ou.FControlUnitID,\n").append("stru.FIsLeaf,\n").append("stru.FLevel,\n").append("stru.FLongNumber,\n").append("stru1.FUnitId AS FParentID,\n").append("taxSubject.FIsBizUnit,\n").append("taxSubject.FIsSealUp,\n").append("ou.FIsStart,\n").append("ou.FIsOUSealUp,\n").append("stru.FDisplayName_L1,\n").append("stru.FDisplayName_L2,\n").append("stru.FDisplayName_L3,\n").append("taxSubject.FPropertySealUpDate,\n").append("ou.FVersionNumber,\n").append("ou.FCode,\n").append("ou.FIsTransportOrgUnit,\n").append("ou.forgTypeStr,\n").append("taxSubject.FTaxSubjectName,\n").append("taxSubject.FCreditCode,\n").append("taxSubject.FTaxSubjectEnName,\n").append("taxSubject.FIsVaild,\n").append("taxSubject.FBussinessStartDate,\n").append("taxSubject.FBussinessEndDate,\n").append("taxSubject.FIndAndCommRegAuthority,\n").append("taxSubject.FCompetentTaxAuthority,\n").append("taxSubject.FCompetentTaxAuthorityContact,\n").append("taxSubject.FRepresentative,\n").append("taxSubject.FRegCapital,\n").append("taxSubject.FRegCapitalCurrencyID,\n").append("taxSubject.FInvestmentAmount,\n").append("taxSubject.FInvestmentCurrencyID,\n").append("taxSubject.FEstablelisingData,\n").append("taxSubject.FCancellationDate,\n").append("taxSubject.FBusinessScope,\n").append("taxSubject.FIndustryID,\n").append("taxSubject.FRegistrationTypeID,\n").append("FRegAddressID,\n").append("FBusinessAddressID,\n").append("ou.FIsQualityOrgUnit\n").append("FROM T_ORG_BaseUnit ou INNER JOIN\n").append("T_ORG_Structure stru ON ou.FID = stru.FUnitId LEFT OUTER JOIN\n").append("T_ORG_Structure stru1 ON stru.FParentID = stru1.FID INNER JOIN\n").append("T_ORG_OUParttaxSubject taxSubject ON ou.FID = taxSubject.FUnitID\n").append("WHERE (stru.FTreeId = '").append(TaxSubjectOrgTypeAddNewInfo.getTreeId()).append("')\n");
        return new String[]{"delete from T_ORG_taxSubject", sb.toString()};
    }

    public void loadSuperiorHisOrgUnits(Context ctx, FullOrgUnitInfo fullVersionInfo, BizParentAndDelegateInfo pdInfo) throws BOSException, EASBizException {
        if (OrgTypeHelper.isOrgType((String)fullVersionInfo.getOrgTypeStr(), (OrgType)TaxSubjectOrgTypeAddNewInfo.newOrgType)) {
            TaxSubjectOrgUnitInfo TaxSubjectVersionInfo = (TaxSubjectOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(fullVersionInfo.getVersionNumber(), fullVersionInfo.getId()));
            if (TaxSubjectVersionInfo == null) {
                throw new OUExtException(OUExtException.NONE_SHARA_CENTER_SUPERIOR);
            }
            TaxSubjectOrgUnitInfo info = TaxSubjectVersionInfo.getParent();
            pdInfo.setParentOrg(TaxSubjectOrgTypeAddNewInfo.newOrgType, (OrgUnitInfo)((TaxSubjectOrgUnitInfo)this.getUnitVersionInfo(ctx, new VersionPK(info.getVersionNumber(), info.getId()))));
        }
    }

    public List getInsertHisDataSql() {
        return null;
    }

    public OrgUnitInfo getUnitVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new BOSException("pk can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_TaxSubjectOrgUnit_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OrgUnitInfo orgUnitInfo = null;
                return orgUnitInfo;
            }
            TaxSubjectOrgUnitInfo TaxSubjectVersionInfo = this.createTaxSubjectOrgUnitVersionInfo(ctx, (ResultSet)rs);
            if (rs.next()) {
                throw new BOSException("Too many records with pk: " + pk);
            }
            TaxSubjectOrgUnitInfo taxSubjectOrgUnitInfo = TaxSubjectVersionInfo;
            return taxSubjectOrgUnitInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    private TaxSubjectOrgUnitInfo createTaxSubjectOrgUnitVersionInfo(Context ctx, ResultSet rs) throws Exception {
        TaxSubjectOrgUnitInfo TaxSubjectVersionInfo = (TaxSubjectOrgUnitInfo)OrgVersionServerUtils.createOrgUnitVersionInfo((Context)ctx, (OrgUnitInfo)new TaxSubjectOrgUnitInfo(), (ResultSet)rs);
        String versionNumber = TaxSubjectVersionInfo.getVersionNumber();
        String parentId = rs.getString("FParentID");
        if (parentId != null && parentId.trim().length() != 0) {
            TaxSubjectOrgUnitInfo parentVersionInfo = new TaxSubjectOrgUnitInfo(versionNumber, BOSUuid.read((String)parentId));
            parentVersionInfo.setId(BOSUuid.read((String)parentId));
            TaxSubjectVersionInfo.setParent(parentVersionInfo);
        }
        TaxSubjectVersionInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        TaxSubjectVersionInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        TaxSubjectVersionInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return TaxSubjectVersionInfo;
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, String versionNumber, String longNumber) throws BOSException, EASBizException {
        if (versionNumber == null) {
            throw new BOSException("versionNumber can't be null!");
        }
        if (versionNumber.trim().length() != 3) {
            throw new BOSException("versionNumber is illegal!");
        }
        if (longNumber == null || longNumber.trim().length() == 0) {
            throw new BOSException("longNumber can't be null!");
        }
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_TaxSubjectOrgUnit_His WHERE FVersionNumber = '").append(versionNumber).append("'").append(" AND (FLongNumber = '").append(longNumber).append("'").append(" OR FLongNumber LIKE '").append(longNumber + "!%").append("')").append(" ORDER BY FLongNumber").toString();
        return this.getOrgUnitVersionCollectionBySql(ctx, selectSql);
    }

    private OrgUnitCollection getOrgUnitVersionCollectionBySql(Context ctx, String sql) throws BOSException, EASBizException {
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            OrgUnitCollection versionCol;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            OrgUnitCollection orgUnitCollection = versionCol = OrgQueryHelper.createOrgUnitVersionCollection((Context)ctx, (ResultSet)rs, (IOrgUnitInfoFactory)new IOrgUnitInfoFactory(){

                public OrgUnitInfo createOrgInfo() {
                    return new TaxSubjectOrgUnitInfo();
                }
            });
            return orgUnitCollection;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }

    public OrgUnitCollection getOrgUnitVersionCollection(Context ctx, IObjectPK cuOrgPK, String versionNumber) throws BOSException, EASBizException {
        String tableName = this.getOrgTypeSelfInfo().getViewTableNameHis();
        String sql = "SELECT FID, FVersionNumber FROM " + tableName + " WHERE FControlUnitID = '" + cuOrgPK + "' and forgTypeStr like '%" + this.getOrgTypeSelfInfo().getOrgType().getName() + "%' FVersionNumber = '" + versionNumber + "'";
        return this.getOrgUnitVersionCollectionBySql(ctx, sql);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, VersionPK pk) throws BOSException, EASBizException {
        OUPartTaxSubjectInfo retInfo = new OUPartTaxSubjectInfo();
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartTaxSubject_His WHERE ").append("FVersionNumber = '").append(pk.getVersionNumber()).append("'").append(" AND FID = '").append(pk.getId().toString()).append("'").toString();
        return OrgQueryHelper.getOUPartVersionInfo((Context)ctx, (String)selectSql, (OUPartBaseInfo)retInfo);
    }

    public OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String version, String orgId) throws BOSException, EASBizException {
        OUPartTaxSubjectInfo retInfo = new OUPartTaxSubjectInfo();
        String selectSql = new StringBuffer().append("SELECT * FROM T_ORG_OUPartTaxSubject_His WHERE ").append("FVersionNumber = '").append(version).append("'").append(" AND FUNITID = '").append(orgId).append("'").toString();
        return OrgQueryHelper.getOUPartVersionInfo((Context)ctx, (String)selectSql, (OUPartBaseInfo)retInfo);
    }

    public OrgTypeSelfInfo getOrgTypeSelfInfo() {
        OrgTypeSelfInfo orgInfo = new OrgTypeSelfInfo();
        orgInfo.setTableName("T_ORG_OUPartTaxSubject");
        orgInfo.setTableNameAlias("PtSJ");
        orgInfo.setViewTableName("T_ORG_TaxSubject");
        orgInfo.setViewTableAlias("TaxSubjectOrgUnit");
        orgInfo.setOrgViewBosType(new TaxSubjectOrgUnitInfo().getBOSType());
        orgInfo.setOrgTableBosType(new OUPartTaxSubjectInfo().getBOSType());
        orgInfo.setOrgType(TaxSubjectOrgTypeAddNewInfo.newOrgType);
        orgInfo.setOuPartInfo((OUPartCoreBaseInfo)new OUPartTaxSubjectInfo());
        orgInfo.setOrgUnitViewInfo((OrgUnitInfo)new TaxSubjectOrgUnitInfo());
        return orgInfo;
    }

    private boolean isTaxSubjectBizUnitChanged(Context ctx, OUPartTaxSubjectInfo newInfo) throws BOSException, EASBizException {
        if (newInfo.getId() == null) {
            return false;
        }
        IOUPartTaxSubject iOUPartTaxSubject = OUPartTaxSubjectFactory.getLocalInstance(ctx);
        OUPartTaxSubjectInfo oldInfo = iOUPartTaxSubject.getOUPartTaxSubjectInfo((IObjectPK)new ObjectUuidPK(newInfo.getId()));
        return oldInfo.isIsBizUnit() ^ newInfo.isIsBizUnit();
    }
}

