/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionAdminCollection;
import com.kingdee.eas.basedata.org.PositionAdminException;
import com.kingdee.eas.basedata.org.PositionAdminInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.app.AbstractPositionAdminControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PositionAdminControllerBean
extends AbstractPositionAdminControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.org.app.PositionAdminControllerBean");
    private static final String POSITIONADMINRESOURCE = "com.kingdee.eas.basedata.org.PositionAdminResource";

    @Override
    protected void _savePositionAdminCollection(Context ctx, PositionAdminCollection positionAdminCollection, List deleteList) throws BOSException, EASBizException {
        if (deleteList != null) {
            for (int i = 0; i < deleteList.size(); ++i) {
                this._delete(ctx, (IObjectPK)new ObjectUuidPK(deleteList.get(i).toString()));
            }
        }
        if (positionAdminCollection != null && positionAdminCollection.size() != 0) {
            for (int i = 0; i < positionAdminCollection.size(); ++i) {
                PositionAdminInfo positionAdminInfo = positionAdminCollection.get(i);
                if (positionAdminInfo.getId() == null) {
                    this._addnew(ctx, (IObjectValue)positionAdminInfo);
                    continue;
                }
                this._update(ctx, (IObjectPK)new ObjectUuidPK(positionAdminInfo.getId()), (IObjectValue)positionAdminInfo);
            }
        }
    }

    @Override
    protected PositionAdminCollection _getPositionAdminCollectionByPositionId(Context ctx, String positionId) throws BOSException, EASBizException {
        return this.getPositionAdminCollection(ctx, " where position.id='" + positionId + "'");
    }

    @Override
    protected void _enable(Context ctx, String[] positionAdminIds) throws BOSException {
        if (positionAdminIds == null || positionAdminIds.length == 0) {
            return;
        }
        String sql = "update t_bd_positionAdmin set fdeletedstatus=1 where fid=?";
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        StringBuilder logMsg = new StringBuilder();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("position.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        for (int i = 0; i < positionAdminIds.length; ++i) {
            PositionAdminInfo pInfo;
            list.add(new Object[]{positionAdminIds[i]});
            try {
                pInfo = this.getPositionAdminInfo(ctx, (IObjectPK)new ObjectUuidPK(positionAdminIds[i]), sic);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                continue;
            }
            logMsg.append("\u3010");
            logMsg.append(pInfo.getPosition().getNumber());
            logMsg.append(" - ");
            logMsg.append(pInfo.getAdminOrgUnit().getNumber());
            logMsg.append("\u3011");
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_enable", (BOSObjectType)this.getBOSType(), null, (String)logMsg.toString(), (String)"PositionAdmin_Enable", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), null);
        DbUtil.executeBatch((Context)ctx, (String)sql, list);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _disable(Context ctx, String[] positionAdminIds) throws BOSException {
        if (positionAdminIds == null || positionAdminIds.length == 0) {
            return;
        }
        String sql = "update t_bd_positionAdmin set fdeletedstatus=2 where fid=?";
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        StringBuilder logMsg = new StringBuilder();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("position.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        for (int i = 0; i < positionAdminIds.length; ++i) {
            PositionAdminInfo pInfo;
            list.add(new Object[]{positionAdminIds[i]});
            try {
                pInfo = this.getPositionAdminInfo(ctx, (IObjectPK)new ObjectUuidPK(positionAdminIds[i]), sic);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                continue;
            }
            logMsg.append("\u3010");
            logMsg.append(pInfo.getPosition().getNumber());
            logMsg.append(" - ");
            logMsg.append(pInfo.getAdminOrgUnit().getNumber());
            logMsg.append("\u3011");
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_enable", (BOSObjectType)this.getBOSType(), null, (String)logMsg.toString(), (String)"PositionAdmin_Disable", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), null);
        DbUtil.executeBatch((Context)ctx, (String)sql, list);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void checkRepeat(Context ctx, PositionAdminInfo info) throws EASBizException, BOSException {
        String oql = " where position.id = '" + info.getPosition().getId().toString() + "' and adminOrgUnit.id = '" + info.getAdminOrgUnit().getId().toString() + "'";
        if (info.getId() != null) {
            oql = " and id <> '" + info.getId().toString() + "'";
        }
        if (this.exists(ctx, oql)) {
            throw new PositionAdminException(PositionAdminException.REPEAT);
        }
    }

    private void constructPositionAdminInfo(Context ctx, PositionAdminInfo info) throws BOSException, EASBizException {
        PositionInfo position = info.getPosition();
        AdminOrgUnitInfo adminOrgUnit = info.getAdminOrgUnit();
        if (position == null || adminOrgUnit == null) {
            throw new BOSException("adminOrgUnit,position is not exist!");
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        position = PositionFactory.getLocalInstance(ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(position.getId()), sic);
        adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnit.getId()), sic);
        info.setPosition(position);
        info.setAdminOrgUnit(adminOrgUnit);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PositionAdminInfo info = (PositionAdminInfo)model;
        this.checkRepeat(ctx, info);
        this.constructPositionAdminInfo(ctx, info);
        StringBuilder logMsg = new StringBuilder("\u3010");
        logMsg.append(info.getPosition().getNumber());
        logMsg.append(" - ");
        logMsg.append(info.getAdminOrgUnit().getNumber());
        logMsg.append(" - ");
        if (info.isIsIncludeSub()) {
            ResourceBase.getString((String)POSITIONADMINRESOURCE, (String)"ContainsSub", (Locale)ctx.getLocale());
        } else {
            ResourceBase.getString((String)POSITIONADMINRESOURCE, (String)"NotContainsSub", (Locale)ctx.getLocale());
        }
        logMsg.append("\u3011");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)this.getBOSType(), null, (String)logMsg.toString(), (String)"PositionAdmin_AddNew", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), null);
        IObjectPK pk = super._addnew(ctx, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PositionAdminInfo info = (PositionAdminInfo)model;
        this.constructPositionAdminInfo(ctx, info);
        PositionAdminInfo oldInfo = this.getPositionAdminInfo(ctx, pk);
        this.constructPositionAdminInfo(ctx, oldInfo);
        String containsSubSource = ResourceBase.getString((String)POSITIONADMINRESOURCE, (String)"ContainsSub", (Locale)ctx.getLocale());
        String notContainsSubSource = ResourceBase.getString((String)POSITIONADMINRESOURCE, (String)"NotContainsSub", (Locale)ctx.getLocale());
        String isContainsSubOldString = oldInfo.isIsIncludeSub() ? containsSubSource : notContainsSubSource;
        String isContainsSubNewString = info.isIsIncludeSub() ? containsSubSource : notContainsSubSource;
        String updateLogString = ResourceBase.getString((String)POSITIONADMINRESOURCE, (String)"PositionAdminUpdateLog", (Locale)ctx.getLocale());
        MessageFormat mf = new MessageFormat(updateLogString);
        String logMsg = mf.format(new String[]{oldInfo.getPosition().getNumber() + " - " + oldInfo.getAdminOrgUnit().getNumber() + " - " + isContainsSubOldString, info.getPosition().getNumber() + " - " + info.getAdminOrgUnit().getNumber() + " - " + isContainsSubNewString});
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_update", (BOSObjectType)this.getBOSType(), null, (String)logMsg, (String)"PositionAdmin_Update", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), null);
        super._update(ctx, pk, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PositionAdminInfo info = this.getPositionAdminInfo(ctx, pk);
        this.constructPositionAdminInfo(ctx, info);
        StringBuilder logMsg = new StringBuilder("\u3010");
        logMsg.append(info.getPosition().getNumber());
        logMsg.append(" - ");
        logMsg.append(info.getAdminOrgUnit().getNumber());
        logMsg.append("\u3011");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)this.getBOSType(), null, (String)logMsg.toString(), (String)"PositionAdmin_Delete", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), null);
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }
}

