/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.IJob;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.JobCollection;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PositionDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger(PositionDataImport.class);
    private static final String YES = "Y";
    private static final String NO = "N";
    private static final String resStr = "com.kingdee.eas.basedata.org.JobGradeResource";
    private ArrayList adminRangeList = null;
    private boolean isUserRange = true;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PositionFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"PositionDataImport:", (Throwable)ex);
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            String rangeValue = ParamManager.getParamValue((Context)ctx, null, (String)"CU_USERRANGE");
            this.isUserRange = "true".equalsIgnoreCase(rangeValue);
            this.adminRangeList = this.getAdminRange(ctx);
            IPosition iPosition = PositionFactory.getLocalInstance(ctx);
            PositionCollection posiColl = null;
            PositionInfo info = new PositionInfo();
            String str = null;
            str = (String)((DataToken)hsData.get((Object)"adminOrgUnit")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"P_I_Admin_NOT_NULL", (Locale)ctx.getLocale()));
            }
            AdminOrgUnitCollection adminColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where number = '" + str.trim() + "'");
            if (adminColl == null || adminColl.size() == 0) {
                throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"P_I_Admin_NOT_FOUND", (Locale)ctx.getLocale()));
            }
            if (this.adminRangeList != null) {
                if (this.isUserRange && !this.adminRangeList.contains(adminColl.get(0).getId().toString())) {
                    throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"P_I_NO_PERMISSON_MODIFY_POSITION", (Locale)ctx.getLocale()));
                }
                if (!this.isUserRange && !this.adminRangeList.contains(adminColl.get(0).getCU().getId().toString())) {
                    throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"P_I_NO_PERMISSON_MODIFY_POSITION", (Locale)ctx.getLocale()));
                }
            }
            info.setAdminOrgUnit(adminColl.get(0));
            info.put("adminiOrgUnit_importData", adminColl.get(0));
            info.setCU(adminColl.get(0).getCU());
            str = (String)((DataToken)hsData.get((Object)"number")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"P_I_Number_ERRPR", (Locale)ctx.getLocale()));
            }
            info.setNumber(str);
            posiColl = iPosition.getPositionCollection("where number = '" + str.trim() + "' and CU.id = '" + info.getCU().getId().toString() + "'");
            if (posiColl != null && posiColl.size() > 0) {
                int mode = (Integer)this.getContextMap().get("DATATASKMODE");
                if (mode == 8) {
                    throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"P_I_POSITION_EXIST", (Locale)ctx.getLocale()));
                }
                info.setId(posiColl.get(0).getId());
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"name_L1")).data))) {
                info.setName(str, new Locale("L1"));
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"name_L2")).data))) {
                info.setName(str, new Locale("L2"));
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"name_L3")).data))) {
                info.setName(str, new Locale("L3"));
            }
            if (StringUtils.isEmpty((String)info.getName(new Locale("L1"))) && StringUtils.isEmpty((String)info.getName(new Locale("L2"))) && StringUtils.isEmpty((String)info.getName(new Locale("L3")))) {
                throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"P_I_Name_ERRPR", (Locale)ctx.getLocale()));
            }
            str = (String)((DataToken)hsData.get((Object)"description_L1")).data;
            if (!StringUtils.isEmpty((String)str)) {
                info.setDescription(str, new Locale("L1"));
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"description_L2")).data))) {
                info.setDescription(str, new Locale("L2"));
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"description_L3")).data))) {
                info.setDescription(str, new Locale("L3"));
            }
            if (!(str = (String)((DataToken)hsData.get((Object)"effectDate")).data).trim().equalsIgnoreCase("")) {
                info.setEffectDate(DateTimeUtils.parseDate((String)str));
            }
            if (!(str = (String)((DataToken)hsData.get((Object)"valiDate")).data).trim().equalsIgnoreCase("")) {
                info.setValiDate(DateTimeUtils.parseDate((String)str));
            }
            if (StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"pAdminOrgUnit")).data))) {
                throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"P_I_PAdmin_NOT_NULL", (Locale)ctx.getLocale()));
            }
            AdminOrgUnitCollection pAdminColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where number = '" + str.trim() + "'");
            if (pAdminColl == null || pAdminColl.size() == 0) {
                throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"P_I_PAdmin_NOT_FOUND", (Locale)ctx.getLocale()));
            }
            str = (String)((DataToken)hsData.get((Object)"parent")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"P_I_Position_NOT_NULL", (Locale)ctx.getLocale()));
            }
            posiColl = iPosition.getPositionCollection("where number = '" + str.trim() + "' and CU.id = '" + pAdminColl.get(0).getCU().getId().toString() + "'");
            if (posiColl == null || posiColl.size() == 0) {
                throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"P_I_Position_NOT_FOUND", (Locale)ctx.getLocale()));
            }
            info.put("SuperPosition", posiColl.get(0));
            str = (String)((DataToken)hsData.get((Object)"job")).data;
            if (!StringUtils.isEmpty((String)str)) {
                IJob iJob = JobFactory.getLocalInstance(ctx);
                JobCollection jobColl = iJob.getJobCollection("where number = '" + str.trim() + "'");
                if (jobColl == null || jobColl.size() == 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"P_I_JOB_NOT_FOUND", (Locale)ctx.getLocale()));
                }
                info.setJob(jobColl.get(0));
            }
            if (StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"isRespPosition")).data))) {
                throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"P_I_IsRespPosition_NOT_NULL", (Locale)ctx.getLocale()));
            }
            info.put("PrimaryPosition", this.getBooleanFromAlias(str));
            return info;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new TaskExternalException(ResourceBase.getString((String)resStr, (String)"FormatError", (Locale)ctx.getLocale()));
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private Boolean getBooleanFromAlias(String isPrimary) {
        if (YES.equalsIgnoreCase(isPrimary)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, String[]> exportMap = new HashMap<String, String[]>();
        exportMap.put("queryFiled", new String[]{"number", "name", "adminOrgUnit.number", "effectDate", "valiDate", "isRespPosition", "deletedStatus", "description", "parent.number", "pAdminOrgUnit.number", "job.number"});
        exportMap.put("excelFiled", new String[]{"number", "name" + this.getLocal(ctx), "adminOrgUnit", "effectDate", "valiDate", "isRespPosition", "deletedStatus", "description" + this.getLocal(ctx), "parent", "pAdminOrgUnit", "job"});
        exportMap.put("FiledType", new String[0]);
        return this.transeExport(rs, exportMap);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.org.app.PositionExportQuery";
    }

    private String getLocal(Context ctx) {
        return "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toUpperCase();
    }

    private Hashtable<String, String> transeExport(IRowSet rs, Map map) throws TaskExternalException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] queryFiled = (String[])map.get("queryFiled");
        String[] excelFiled = (String[])map.get("excelFiled");
        try {
            int size = queryFiled.length;
            for (int i = 0; i < size; ++i) {
                if (rs.getString(queryFiled[i]) == null) continue;
                if ("false".equals(rs.getString(queryFiled[i])) || "true".equals(rs.getString(queryFiled[i]))) {
                    if ("false".equals(rs.getString(queryFiled[i]))) {
                        hashtable.put(excelFiled[i], NO);
                        continue;
                    }
                    hashtable.put(excelFiled[i], YES);
                    continue;
                }
                hashtable.put(excelFiled[i], rs.getString(queryFiled[i]));
            }
        }
        catch (SQLException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        return hashtable;
    }

    private ArrayList getAdminRange(Context ctx) throws TaskExternalException {
        ArrayList<String> list = new ArrayList<String>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (10 == userInfo.getType().getValue()) {
            return null;
        }
        if (this.isUserRange) {
            StringBuffer sql = new StringBuffer("SELECT T_ORG_Admin.FID AS FID");
            sql.append(" FROM T_ORG_Admin ");
            sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
            sql.append("WHERE T_PM_OrgRange.FType = 20 AND T_ORG_Admin.FIsSealUp = 0 AND T_PM_OrgRange.FUserID='");
            sql.append(userInfo.getId().toString());
            sql.append("'");
            try {
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rows.next()) {
                    list.add(rows.getString("FID"));
                }
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
            }
        } else if (ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
            list.add(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        }
        return list;
    }
}

