/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.IPositionAdmin;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.IPositionRole;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionAdminCollection;
import com.kingdee.eas.basedata.org.PositionAdminFactory;
import com.kingdee.eas.basedata.org.PositionAdminInfo;
import com.kingdee.eas.basedata.org.PositionException;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.org.PositionRoleCollection;
import com.kingdee.eas.basedata.org.PositionRoleFactory;
import com.kingdee.eas.basedata.org.PositionRoleInfo;
import com.kingdee.eas.basedata.org.app.AbstractPositionMemberControllerBean;
import com.kingdee.eas.basedata.org.app.processor.PositionBusinessProcessorBuilder;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.DynamicBusinessProcessHelper;
import com.kingdee.eas.dynbusiness.app.IBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.processor.BillsExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.hr.base.CheckStateEnum;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.org.HRInitForOrgBaseImpl;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PositionMemberControllerBean
extends AbstractPositionMemberControllerBean {
    private static Logger logger = Logger.getLogger(PositionMemberControllerBean.class);

    @Override
    protected IObjectCollection _getPositionsByPerson(Context ctx, BOSUuid personId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItemPosi = new FilterItemInfo("person.id", (Object)personId.toString());
        filter.getFilterItems().add(filterItemPosi);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.job.job"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.job.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        PositionMemberCollection posiMemColl = null;
        posiMemColl = this.getPositionMemberCollection(ctx, viewInfo);
        return posiMemColl;
    }

    private boolean existPrimaryPosition(Context ctx, BOSUuid personId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("person.id", (Object)personId.toString());
        FilterItemInfo filterItem2 = new FilterItemInfo("isPrimary", (Object)"1");
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        PositionMemberCollection posiMemColl = null;
        posiMemColl = this.getPositionMemberCollection(ctx, viewInfo);
        if (posiMemColl == null) {
            return false;
        }
        return posiMemColl.size() != 0;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._addnew(ctx, model, false);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model, boolean haveCheckPersonPlan) throws BOSException, EASBizException {
        PositionMemberInfo info = (PositionMemberInfo)model;
        if (info.isIsPrimary()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_ORG_PositionMember SET FIsPrimary = 0 WHERE FPersonID='" + info.getPerson().getId() + "'"));
        }
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (info.getCheckState() == null) {
            info.setCheckState(CheckStateEnum.NO_CHECK);
        }
        if (!this.exists(ctx, "where person='" + info.getPerson().getId() + "'")) {
            info.setIsPrimary(true);
        }
        if (info.getPosition() == null || info.getPosition().getId() == null) {
            return null;
        }
        this.existPosition(ctx, info);
        if (!haveCheckPersonPlan) {
            this.canAddPerson(ctx, info);
        }
        this.setDefaultValue(info);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        this.updatePrimaryPositionAndAdminUnit(ctx, info);
        this.addUserOrgRange(ctx, info);
        return pk;
    }

    private void addUserOrgRange(Context ctx, PositionMemberInfo info) throws EASBizException, BOSException {
        IPositionAdmin iPositionAdmin;
        PositionAdminCollection positionAdminCollection;
        String personId = info.getPerson().getId().toString();
        UserCollection userCollection = this.getUserCollectionByPersonId(ctx, personId);
        ArrayList<String> userIdList = new ArrayList<String>();
        for (int i = 0; i < userCollection.size(); ++i) {
            userIdList.add(userCollection.get(i).getId().toString());
        }
        if (userIdList.size() == 0) {
            logger.error((Object)(info.getPerson().getName() + ": userIdList.size == 0"));
            return;
        }
        IPositionRole iPositionRole = PositionRoleFactory.getLocalInstance(ctx);
        String sqlString = "select id ,position.id ,position.number ,role.id ,role.number ,orgUnit.id ,orgUnit.number where position.id = '" + info.getPosition().getId().toString() + "' and deletedStatus = 1";
        PositionRoleCollection positionRoleCollection = iPositionRole.getPositionRoleCollection(sqlString);
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
        if (positionRoleCollection.size() != 0) {
            for (int i = 0; i < positionRoleCollection.size(); ++i) {
                PositionRoleInfo positionRoleInfo = positionRoleCollection.get(i);
                BOSUuid orgId = positionRoleInfo.getOrgUnit().getId();
                BOSUuid roleId = positionRoleInfo.getRole().getId();
                ArrayList<String> addCuList = new ArrayList<String>();
                addCuList.add(orgId.toString());
                ArrayList<BOSUuid> roleList = new ArrayList<BOSUuid>();
                roleList.add(roleId);
                iOrgRange.addOrgRangeBatch(userIdList, addCuList, OrgRangeType.BIZ_ORG_TYPE);
                UserRoleOrgManagerFactory.getLocalInstance((Context)ctx).batchSaveUsersRolePerm(userIdList, addCuList, roleList, null);
            }
        }
        if ((positionAdminCollection = (iPositionAdmin = PositionAdminFactory.getLocalInstance(ctx)).getPositionAdminCollection(sqlString = "select id ,position.id ,position.number ,adminOrgUnit.id ,adminOrgUnit.number ,isIncludeSub where position.id = '" + info.getPosition().getId().toString() + "' and deletedStatus = 1")).size() != 0) {
            ArrayList<String> addAdminList = new ArrayList<String>();
            ArrayList<String> addAdminSubList = new ArrayList<String>();
            for (int i = 0; i < positionAdminCollection.size(); ++i) {
                PositionAdminInfo positionAdminInfo = positionAdminCollection.get(i);
                String orgIdString = positionAdminInfo.getAdminOrgUnit().getId().toString();
                if (positionAdminInfo.isIsIncludeSub()) {
                    if (addAdminSubList.contains(orgIdString)) continue;
                    addAdminSubList.add(orgIdString);
                    continue;
                }
                if (addAdminList.contains(orgIdString)) continue;
                addAdminList.add(orgIdString);
            }
            if (addAdminList.size() > 0) {
                iOrgRange.addOrgRangeBatch(userIdList, addAdminList, OrgRangeType.ADMIN_ORG_TYPE);
            }
            if (addAdminSubList.size() > 0) {
                OrgRangeIncludeSubOrgFactory.getLocalInstance((Context)ctx).addAdminOrgRangeByPosition(userIdList, addAdminSubList, true);
            }
        }
    }

    private UserCollection getUserCollectionByPersonId(Context ctx, String personId) throws BOSException {
        String userOql = "SELECT id,defOrgUnit.id,number where person.id = '" + personId + "'";
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserCollection userCollection = iUser.getUserCollection(userOql);
        return userCollection;
    }

    private void setDefaultValue(PositionMemberInfo info) {
        if (info.get("isCheck") == null) {
            info.setIsCheck(false);
        }
        if (info.get("checkLen") == null) {
            info.setCheckLen(0);
        }
    }

    private void updatePrimaryPositionAndAdminUnit(Context ctx, PositionMemberInfo info) throws BOSException, EASBizException {
        if (!info.isIsPrimary()) {
            return;
        }
        BillsExecuteContext executeContext = new BillsExecuteContext(ctx, this.getBOSType(), PositionBusinessProcessorBuilder.ACT_UPDATEPRIAMRYPOSITIONANDADMINUNIT, null, new Object[]{info});
        PositionBusinessProcessorBuilder builder = new PositionBusinessProcessorBuilder((ExecuteContext)executeContext);
        BatchActionResults batchResults = DynamicBusinessProcessHelper.batchExecute((ExecuteContext)executeContext, (IBusinessProcessorBuilder)builder);
        batchResults.throwExceptions();
        this.changeUserCuByPer(ctx, info);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._update(ctx, pk, model, false);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model, boolean haveCheckPersonPlan) throws BOSException, EASBizException {
        PositionMemberInfo info = (PositionMemberInfo)model;
        PositionMemberInfo oldInfo = this.getPositionMemberInfo(ctx, pk);
        this.existPosition(ctx, info);
        if (!haveCheckPersonPlan) {
            if (!oldInfo.getPosition().getId().toString().equals(info.getPosition().getId().toString())) {
                this.canAddPerson(ctx, info);
            } else if (info.isIsPrimary()) {
                this.canAddPerson(ctx, info);
            }
        }
        if (info.isIsPrimary() && !oldInfo.isIsPrimary()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_ORG_PositionMember SET FIsPrimary = 0 WHERE FPersonID = '" + info.getPerson().getId() + "' AND FPositionID != '" + info.getPosition().getId() + "'"));
        } else if (!info.isIsPrimary() && oldInfo.isIsPrimary() && info.get("NO_CHECK") == null) {
            throw new PositionException(PositionException.MUST_EXIST_PRIMARY_POSITION);
        }
        this.setDefaultValue(info);
        if (info.getCheckState() == null) {
            info.setCheckState(CheckStateEnum.NO_CHECK);
        }
        super._update(ctx, pk, (IObjectValue)info);
        this.updatePrimaryPositionAndAdminUnit(ctx, info);
        this.addUserOrgRange(ctx, info);
    }

    private void changeUserCuByPer(Context ctx, PositionMemberInfo pmInfo) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        IPosition iPosition = PositionFactory.getLocalInstance(ctx);
        String oql = "select id where person.id = '" + pmInfo.getPerson().getId().toString() + "'";
        UserCollection userColl = iUser.getUserCollection(oql);
        ObjectUuidPK userPk = null;
        oql = "select adminOrgUnit.id where id = '" + pmInfo.getPosition().getId().toString() + "'";
        PositionInfo pInfo = iPosition.getPositionCollection(oql).get(0);
        ObjectUuidPK adminPk = new ObjectUuidPK(pInfo.getAdminOrgUnit().getId());
        OrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)adminPk);
        ObjectUuidPK cuPk = new ObjectUuidPK(orgUnitInfo.getCU().getId());
        int size = userColl.size();
        for (int i = 0; i < size; ++i) {
            userPk = new ObjectUuidPK(userColl.get(i).getId());
            iUser.changeCtrlUnit((IObjectPK)cuPk, (IObjectPK)userPk);
        }
        PersonInfo personInfo = pmInfo.getPerson();
        if (personInfo.getNumber() == null) {
            personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personInfo.getId()));
        }
        String pnumbenr = personInfo.getNumber();
        this.addOrgRangeByUpdate(ctx, pnumbenr);
    }

    private void existPosition(Context ctx, PositionMemberInfo model) throws BOSException, EASBizException {
        if (model.get("IS_FROM_SHR_OPTAction") != null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("position.id", (Object)model.getPosition().getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem2 = new FilterItemInfo("person.id", (Object)model.getPerson().getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem2);
        if (model.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)model.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        PositionMemberCollection posiMemColl = this.getPositionMemberCollection(ctx, view);
        if (posiMemColl != null && posiMemColl.size() > 0) {
            throw new PositionException(PositionException.EXIST_POSITION);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PositionMemberInfo oldInfo = this.getPositionMemberInfo(ctx, pk);
        if (oldInfo.isIsPrimary()) {
            String personId = oldInfo.getPerson().getId().toString();
            String id = oldInfo.getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
            if (this._exists(ctx, filter)) {
                throw new PositionException(PositionException.MUST_EXIST_PRIMARY_POSITION);
            }
            DbUtil.execute((Context)ctx, (String)("update T_HR_PersonPosition set FPrimaryPositionID = null,FPersonDep = FgkAdminID where FPersonID = '" + personId + "'"));
        }
        this._delUserOrgRange(ctx, pk);
        super._delete(ctx, pk);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.name"));
        PositionMemberInfo info = (PositionMemberInfo)this.getValue(ctx, pk, selector);
        return info.getPerson().getNumber() + info.getPerson().getName();
    }

    @Override
    protected IObjectCollection _getAdminOrgUnitCollection(Context ctx, String hrOrgUnitID, boolean showSealUpOrg) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select \"A\".FID,\"A\".FNumber,\"A\".FIsVirtual,\"A\".FName_L1,\"A\".FName_L2,").append("\"A\".FName_L3,\"A\".FLongNumber,\"A\".FLevel, \"A\".FSortCode ").append("from T_ORG_Admin \"A\" left join T_ORG_UnitRelation \"B\" ").append("on \"A\".FID=\"B\".FFromUnitID ");
        if (!showSealUpOrg) {
            sql.append("where \"A\".FIsSealUp = 0 and (\"B\".FToUnitID=? and FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5') ");
        } else {
            sql.append("where (\"B\".FToUnitID=? and FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5') ");
        }
        sql.append(" order by FLongNumber asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{hrOrgUnitID});
        AdminOrgUnitCollection adminCol = new AdminOrgUnitCollection();
        AdminOrgUnitInfo adminInfo = null;
        Locale l = ctx.getLocale();
        String namePosition = "FName_L2";
        if (l.toString().equalsIgnoreCase("l1")) {
            namePosition = "FName_L1";
        } else if (l.toString().equalsIgnoreCase("l2")) {
            namePosition = "FName_L2";
        } else if (l.toString().equalsIgnoreCase("l3")) {
            namePosition = "FName_L3";
        }
        try {
            while (rs.next()) {
                adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                adminInfo.setNumber(rs.getString("FNumber"));
                adminInfo.setIsVirtual(rs.getBoolean("FIsVirtual"));
                String tempName = rs.getString(namePosition);
                adminInfo.setName(tempName, l);
                adminInfo.setName(tempName);
                adminInfo.setLongNumber(rs.getString("FLongNumber"));
                adminInfo.setLevel(rs.getInt("FLevel"));
                adminInfo.setSortCode(rs.getString("FSortCode"));
                adminCol.add(adminInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminCol;
    }

    @Override
    protected IObjectCollection _getAdminOrgUnitCollectionWithOrgRangeFilter(Context ctx, String hrOrgUnitID, boolean showSealUpOrg) throws BOSException, EASBizException {
        AdminOrgUnitCollection aouc1 = (AdminOrgUnitCollection)this._getAdminOrgUnitCollection(ctx, hrOrgUnitID, showSealUpOrg);
        OrgType ot = OrgType.Admin;
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)ot));
        IPermission ip = PermissionFactory.getLocalInstance((Context)ctx);
        HashMap hm = (HashMap)ip.getAuthorizedOrgs((IObjectPK)userPK, ot, (IObjectPK)treePK, null, null);
        AdminOrgUnitCollection aouc2 = new AdminOrgUnitCollection();
        AdminOrgUnitInfo oui = null;
        int n = aouc1.size();
        for (int i = 0; i < n; ++i) {
            oui = aouc1.get(i);
            if (!hm.containsKey(oui.getId().toString())) continue;
            aouc2.add(oui);
        }
        return aouc2;
    }

    private void canAddPerson(Context ctx, PositionMemberInfo info) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        String personID = info.getPerson().getId().toString();
        oql.append("select employeeType.isOnTheStrength where id='").append(personID).append("'");
        IPerson iperson = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection personCollection = iperson.getPersonCollection(oql.toString());
        PersonInfo personInfo = personCollection.get(0);
        EmployeeTypeInfo employeeType = personInfo.getEmployeeType();
        boolean isOnTheStrength = employeeType.isIsOnTheStrength();
        if (isOnTheStrength) {
            HRInitForOrgBaseImpl baseImpl = new HRInitForOrgBaseImpl(ctx);
            baseImpl.canAddPersonOnPosition(info.getPosition().getId().toString(), info.isIsPrimary());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrgRangeByUpdate(Context ctx, String pnumbenr) throws BOSException, EASBizException {
        block11: {
            Connection conn = this.getConnection(ctx);
            PreparedStatement userIDSqlSmt = null;
            PreparedStatement orgIDSqlSmt = null;
            PreparedStatement updateDefCUsqlsmt = null;
            try {
                String userIDQuerySql = "SELECT u.FID,u.FCONTROLUNITID as cfid FROM T_BD_PERSON p LEFT OUTER JOIN T_PM_USER u on p.FID = u.FPERSONID WHERE p.FNUMBER = ?";
                String orgIDQuerySql = "SELECT a.FID as afid FROM T_BD_PERSON p LEFT OUTER JOIN T_ORG_POSITIONMEMBER pm on p.FID = pm.FPERSONID LEFT OUTER JOIN T_ORG_POSITION po on po.FID = pm.FPOSITIONID LEFT OUTER JOIN T_ORG_ADMIN a on a.FID = po.FADMINORGUNITID WHERE p.FNUMBER = ? and pm.FISPRIMARY = 1";
                ArrayList<String> userIdList = new ArrayList<String>();
                ArrayList<String> orgList = new ArrayList<String>();
                ArrayList<String> cuList = new ArrayList<String>();
                userIDSqlSmt = conn.prepareStatement(userIDQuerySql);
                userIDSqlSmt.setString(1, pnumbenr);
                orgIDSqlSmt = conn.prepareStatement(orgIDQuerySql);
                orgIDSqlSmt.setString(1, pnumbenr);
                ResultSet userIDRows = userIDSqlSmt.executeQuery();
                ResultSet orgIDRows = orgIDSqlSmt.executeQuery();
                while (userIDRows.next()) {
                    if (userIDRows.getString("fid") != null) {
                        userIdList.add(userIDRows.getString("fid"));
                    }
                    if (cuList.size() != 0) continue;
                    cuList.add(userIDRows.getString("cfid"));
                }
                while (orgIDRows.next()) {
                    orgList.add(orgIDRows.getString("afid"));
                }
                if (userIdList.size() > 0) {
                    String rangeValue = ParamManager.getParamValue((Context)ctx, null, (String)"IS_DefaultCU_Change");
                    if ("true".equalsIgnoreCase(rangeValue)) {
                        String updateDefCUsql = "UPDATE T_PM_USER SET FDEFORGUNITID = ? WHERE FID = ?";
                        updateDefCUsqlsmt = conn.prepareStatement(updateDefCUsql);
                        for (int i = 0; i < userIdList.size(); ++i) {
                            updateDefCUsqlsmt.setString(1, (String)cuList.get(0));
                            updateDefCUsqlsmt.setString(2, (String)userIdList.get(i));
                            updateDefCUsqlsmt.execute();
                        }
                    }
                    IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
                    iOrgRange.addOrgRangeBatch(userIdList, orgList, OrgRangeType.ADMIN_ORG_TYPE);
                    iOrgRange.addOrgRangeBatch(userIdList, cuList, OrgRangeType.BIZ_ORG_TYPE);
                }
                SQLUtils.cleanup((Statement)userIDSqlSmt);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                break block11;
            }
            finally {
                SQLUtils.cleanup(userIDSqlSmt);
                SQLUtils.cleanup(orgIDSqlSmt);
                SQLUtils.cleanup(updateDefCUsqlsmt);
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((Statement)orgIDSqlSmt);
            SQLUtils.cleanup(updateDefCUsqlsmt);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void _delUserOrgRange(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IPositionAdmin iPositionAdmin;
        PositionAdminCollection positionAdminCollection;
        String isDelParam = ParamManager.getParamValue((Context)ctx, null, (String)"IS_DELETE_ORG");
        if (!"true".equalsIgnoreCase(isDelParam)) {
            return;
        }
        String oql = "SELECT id, person.id,person.number,position.id where id = '" + pk.toString() + "'";
        IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance(ctx);
        PositionMemberCollection positionMemberCollection = iPositionMember.getPositionMemberCollection(oql);
        if (positionMemberCollection.size() == 0) {
            return;
        }
        PositionMemberInfo positionMemberInfo = positionMemberCollection.get(0);
        String personId = positionMemberInfo.getPerson().getId().toString();
        IPositionRole iPositionRole = PositionRoleFactory.getLocalInstance(ctx);
        oql = "select id ,position.id ,position.number ,role.id ,role.number ,orgUnit.id ,orgUnit.number where position.id = '" + positionMemberInfo.getPosition().getId().toString() + "' and deletedStatus = 1";
        PositionRoleCollection delPRC = iPositionRole.getPositionRoleCollection(oql);
        UserCollection userCollection = this.getUserCollectionByPersonId(ctx, personId);
        ArrayList<String> userIdList = new ArrayList<String>();
        for (int i = 0; i < userCollection.size(); ++i) {
            userIdList.add(userCollection.get(i).getId().toString());
        }
        oql = "SELECT id, person.id,position.id where person.id = '" + personId + "' and id != '" + pk.toString() + "'";
        PositionMemberCollection otherPMC = iPositionMember.getPositionMemberCollection(oql);
        if (delPRC.size() != 0) {
            ArrayList<String> delOrgIdList = new ArrayList<String>();
            PositionRoleCollection otrherPRC = new PositionRoleCollection();
            if (otherPMC.size() != 0) {
                oql = "select id ,position.id ,position.number ,role.id ,role.number ,orgUnit.id ,orgUnit.number where position.id in (";
                for (int i = 0; i < otherPMC.size(); ++i) {
                    PositionMemberInfo pMemberInfo = otherPMC.get(i);
                    if (i != 0) {
                        oql = oql + ",";
                    }
                    oql = oql + "'";
                    oql = oql + pMemberInfo.getPosition().getId().toString();
                    oql = oql + "'";
                }
                oql = oql + ") and deletedStatus = 1";
                otrherPRC = iPositionRole.getPositionRoleCollection(oql);
            }
            for (int i = 0; i < delPRC.size(); ++i) {
                for (int j = 0; j < otrherPRC.size() && !delPRC.get(i).getOrgUnit().getId().toString().equals(otrherPRC.get(j).getOrgUnit().getId().toString()); ++j) {
                }
                delOrgIdList.add(delPRC.get(i).getOrgUnit().getId().toString());
            }
            IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
            iOrgRange.delOrgRangeBatch(userIdList, delOrgIdList, OrgRangeType.BIZ_ORG_TYPE);
        }
        if ((positionAdminCollection = (iPositionAdmin = PositionAdminFactory.getLocalInstance(ctx)).getPositionAdminCollection(oql = "select id ,position.id ,position.number ,adminOrgUnit.id ,adminOrgUnit.number ,isIncludeSub where position.id = '" + positionMemberInfo.getPosition().getId().toString() + "' and deletedStatus = 1")).size() != 0) {
            int i;
            ArrayList<String> delAdminList = new ArrayList<String>();
            for (i = 0; i < positionAdminCollection.size(); ++i) {
                PositionAdminInfo positionAdminInfo = positionAdminCollection.get(i);
                String orgId = positionAdminInfo.getAdminOrgUnit().getId().toString();
                if (delAdminList.contains(orgId)) continue;
                delAdminList.add(orgId);
            }
            if (delAdminList.size() > 0) {
                OrgRangeIncludeSubOrgFactory.getLocalInstance((Context)ctx).deleteAdminOrgRangeByPosition(userIdList, delAdminList);
            }
            for (i = 0; i < otherPMC.size(); ++i) {
                this.addUserOrgRange(ctx, otherPMC.get(i));
            }
            this.addOrgRangeByUpdate(ctx, positionMemberInfo.getPerson().getNumber());
        }
    }
}

