/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionRoleCollection;
import com.kingdee.eas.basedata.org.PositionRoleException;
import com.kingdee.eas.basedata.org.PositionRoleInfo;
import com.kingdee.eas.basedata.org.app.AbstractPositionRoleControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PositionRoleControllerBean
extends AbstractPositionRoleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.org.app.PositionRoleControllerBean");
    private static final String POSITIONROLERESOURCE = "com.kingdee.eas.basedata.org.PositionRoleResource";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PositionRoleInfo info = (PositionRoleInfo)model;
        this.checkRepeat(ctx, info);
        this.constructPositionRoleInfo(ctx, info);
        StringBuilder logMsg = new StringBuilder("\u3010");
        logMsg.append(info.getPosition().getNumber());
        logMsg.append(" - ");
        logMsg.append(info.getOrgUnit().getNumber());
        logMsg.append(" - ");
        logMsg.append(info.getRole().getNumber());
        logMsg.append("\u3011");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)this.getBOSType(), null, (String)logMsg.toString(), (String)"PositionRole_AddNew", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), null);
        IObjectPK pk = super._addnew(ctx, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PositionRoleInfo info = (PositionRoleInfo)model;
        this.constructPositionRoleInfo(ctx, info);
        PositionRoleInfo oldInfo = this.getPositionRoleInfo(ctx, pk);
        this.constructPositionRoleInfo(ctx, oldInfo);
        String updateLogString = ResourceBase.getString((String)POSITIONROLERESOURCE, (String)"PositionRoleUpdateLog", (Locale)ctx.getLocale());
        MessageFormat mf = new MessageFormat(updateLogString);
        String logMsg = mf.format(new String[]{oldInfo.getPosition().getNumber() + " - " + oldInfo.getOrgUnit().getNumber() + " - " + oldInfo.getRole().getNumber(), info.getPosition().getNumber() + " - " + info.getOrgUnit().getNumber() + " - " + info.getRole().getNumber()});
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_update", (BOSObjectType)this.getBOSType(), null, (String)logMsg, (String)"PositionRole_Update", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), null);
        super._update(ctx, pk, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _savePositionRoleCollection(Context ctx, PositionRoleCollection positionRoleCollection, List deleteList) throws BOSException, EASBizException {
        if (deleteList != null) {
            for (int i = 0; i < deleteList.size(); ++i) {
                this._delete(ctx, (IObjectPK)new ObjectUuidPK(deleteList.get(i).toString()));
            }
        }
        if (positionRoleCollection != null && positionRoleCollection.size() != 0) {
            for (int i = 0; i < positionRoleCollection.size(); ++i) {
                PositionRoleInfo positionRoleInfo = positionRoleCollection.get(i);
                if (positionRoleInfo.getId() == null) {
                    this._addnew(ctx, (IObjectValue)positionRoleInfo);
                    continue;
                }
                this._update(ctx, (IObjectPK)new ObjectUuidPK(positionRoleInfo.getId()), (IObjectValue)positionRoleInfo);
            }
        }
    }

    @Override
    protected PositionRoleCollection _getPositionRoleCollectionByPositionId(Context ctx, String positionId) throws BOSException, EASBizException {
        return this.getPositionRoleCollection(ctx, " where position.id='" + positionId + "'");
    }

    private void checkRepeat(Context ctx, PositionRoleInfo info) throws EASBizException, BOSException {
        String oql = " where position.id = '" + info.getPosition().getId().toString() + "' and role.id = '" + info.getRole().getId().toString() + "' and orgUnit.id = '" + info.getOrgUnit().getId().toString() + "'";
        if (info.getId() != null) {
            oql = " and id <> '" + info.getId().toString() + "'";
        }
        if (this.exists(ctx, oql)) {
            throw new PositionRoleException(PositionRoleException.REPEAT);
        }
    }

    @Override
    protected void _enable(Context ctx, String[] positionRoleIds) throws BOSException {
        if (positionRoleIds == null || positionRoleIds.length == 0) {
            return;
        }
        String sql = "update t_bd_positionRole set fdeletedstatus=1 where fid=?";
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        StringBuilder logMsg = new StringBuilder();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("position.number"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("role.number"));
        for (int i = 0; i < positionRoleIds.length; ++i) {
            PositionRoleInfo pInfo;
            list.add(new Object[]{positionRoleIds[i]});
            try {
                pInfo = this.getPositionRoleInfo(ctx, (IObjectPK)new ObjectUuidPK(positionRoleIds[i]), sic);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                continue;
            }
            logMsg.append("\u3010");
            logMsg.append(pInfo.getPosition().getNumber());
            logMsg.append(" - ");
            logMsg.append(pInfo.getOrgUnit().getNumber());
            logMsg.append(" - ");
            logMsg.append(pInfo.getRole().getNumber());
            logMsg.append("\u3011");
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_enable", (BOSObjectType)this.getBOSType(), null, (String)logMsg.toString(), (String)"PositionRole_Enable", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), null);
        DbUtil.executeBatch((Context)ctx, (String)sql, list);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _disable(Context ctx, String[] positionRoleIds) throws BOSException {
        if (positionRoleIds == null || positionRoleIds.length == 0) {
            return;
        }
        String sql = "update t_bd_positionRole set fdeletedstatus=2 where fid=?";
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        StringBuilder logMsg = new StringBuilder();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("position.number"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("role.number"));
        for (int i = 0; i < positionRoleIds.length; ++i) {
            PositionRoleInfo pInfo;
            list.add(new Object[]{positionRoleIds[i]});
            try {
                pInfo = this.getPositionRoleInfo(ctx, (IObjectPK)new ObjectUuidPK(positionRoleIds[i]), sic);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                continue;
            }
            logMsg.append("\u3010");
            logMsg.append(pInfo.getPosition().getNumber());
            logMsg.append(" - ");
            logMsg.append(pInfo.getOrgUnit().getNumber());
            logMsg.append(" - ");
            logMsg.append(pInfo.getRole().getNumber());
            logMsg.append("\u3011");
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_enable", (BOSObjectType)this.getBOSType(), null, (String)logMsg.toString(), (String)"PositionRole_Disable", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), null);
        DbUtil.executeBatch((Context)ctx, (String)sql, list);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void constructPositionRoleInfo(Context ctx, PositionRoleInfo info) throws BOSException, EASBizException {
        PositionInfo position = info.getPosition();
        RoleInfo role = info.getRole();
        FullOrgUnitInfo orgUnit = info.getOrgUnit();
        if (position == null || role == null || orgUnit == null) {
            throw new BOSException("role,orgUnit,position is not exist!");
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        position = PositionFactory.getLocalInstance(ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(position.getId()), sic);
        role = RoleFactory.getLocalInstance((Context)ctx).getRoleInfo((IObjectPK)new ObjectUuidPK(role.getId()), sic);
        orgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnit.getId()));
        info.setPosition(position);
        info.setRole(role);
        info.setOrgUnit(orgUnit);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PositionRoleInfo info = this.getPositionRoleInfo(ctx, pk);
        this.constructPositionRoleInfo(ctx, info);
        StringBuilder logMsg = new StringBuilder("\u3010");
        logMsg.append(info.getPosition().getNumber());
        logMsg.append(" - ");
        logMsg.append(info.getOrgUnit().getNumber());
        logMsg.append(" - ");
        logMsg.append(info.getRole().getNumber());
        logMsg.append("\u3011");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)this.getBOSType(), null, (String)logMsg.toString(), (String)"PositionRole_Delete", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), null);
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }
}

