/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionRoleException;
import com.kingdee.eas.basedata.org.PositionRoleFactory;
import com.kingdee.eas.basedata.org.PositionRoleInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PositionRoleDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger(PositionRoleDataImport.class);
    private static final String YES = "Y";
    private static final String NO = "N";
    private ArrayList adminRangeList = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PositionRoleFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"PositionRoleDataImport:", (Throwable)ex);
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public CoreBaseInfo transmit(Hashtable tableData, Context ctx) throws TaskExternalException {
        Object head = null;
        try {
            if (this.adminRangeList == null) {
                this.adminRangeList = this.getAdminRange(ctx);
            }
            return this.createHead(tableData, ctx);
        }
        catch (TaskExternalException te) {
            throw te;
        }
        catch (EASBizException ee) {
            throw new TaskExternalException(ee.getMessage());
        }
        catch (Exception e) {
            String excLinkStackTrace = ExceptionUtil.getExcLinkStackTrace((Throwable)e);
            throw new TaskExternalException(excLinkStackTrace);
        }
    }

    private ArrayList getAdminRange(Context ctx) throws TaskExternalException {
        ArrayList<String> list = new ArrayList<String>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (10 == userInfo.getType().getValue()) {
            return null;
        }
        try {
            StringBuilder sql;
            String rangeValue = ParamManager.getParamValue((Context)ctx, null, (String)"CU_USERRANGE");
            if ("true".equalsIgnoreCase(rangeValue)) {
                sql = new StringBuilder("SELECT T_ORG_Admin.FID AS FID");
                sql.append(" FROM T_ORG_Admin ");
                sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
                sql.append("WHERE T_PM_OrgRange.FType = 20 AND T_ORG_Admin.FIsSealUp = 0 AND T_PM_OrgRange.FUserID='");
                sql.append(userInfo.getId().toString());
                sql.append("'");
            } else {
                sql = new StringBuilder("SELECT FID from T_ORG_Admin where FCONTROLUNITID = '");
                sql.append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                sql.append("'");
            }
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rows.next()) {
                list.add(rows.getString("FID"));
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        return list;
    }

    protected CoreBaseInfo createHead(Hashtable hsData, Context ctx) throws Exception {
        PositionRoleInfo positionRoleInfo = new PositionRoleInfo();
        String positionNumber = (String)((DataToken)hsData.get((Object)"positionNumber")).data;
        IPosition iPosition = PositionFactory.getLocalInstance(ctx);
        if (!iPosition.exists("where number = '" + positionNumber + "'")) {
            throw new PositionRoleException(PositionRoleException.POSITIONNOTEXIST, new Object[]{positionNumber});
        }
        PositionInfo positionInfo = iPosition.getPositionCollection("where number = '" + positionNumber + "'").get(0);
        if (positionInfo.getAdminOrgUnit() != null && this.adminRangeList != null && !this.adminRangeList.contains(positionInfo.getAdminOrgUnit().getId().toString())) {
            throw new PositionRoleException(PositionRoleException.NOADMINRANGE, new Object[]{positionNumber});
        }
        positionRoleInfo.setPosition(positionInfo);
        String roleNumber = (String)((DataToken)hsData.get((Object)"roleNumber")).data;
        IRole iRole = RoleFactory.getLocalInstance((Context)ctx);
        if (!iRole.exists("where number = '" + roleNumber + "'")) {
            throw new PositionRoleException(PositionRoleException.ROLENOTEXIST, new Object[]{roleNumber});
        }
        positionRoleInfo.setRole(iRole.getRoleCollection("where number = '" + roleNumber + "'").get(0));
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        String orgNumber = (String)((DataToken)hsData.get((Object)"orgNumber")).data;
        if (!iFullOrgUnit.exists("where number = '" + orgNumber + "'")) {
            throw new PositionRoleException(PositionRoleException.ORGNOTEXIST, new Object[]{orgNumber});
        }
        positionRoleInfo.setOrgUnit(iFullOrgUnit.getFullOrgUnitCollection("where number = '" + orgNumber + "'").get(0));
        positionRoleInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        return positionRoleInfo;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return false;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, String[]> exportMap = new HashMap<String, String[]>();
        exportMap.put("queryFiled", new String[]{"position.number", "position.name", "adminOrgUnit.name", "role.number", "role.name", "orgUnit.number", "orgUnit.name", "deletedStatus"});
        exportMap.put("excelFiled", new String[]{"positionNumber", "positionName" + this.getLocal(ctx), "adminOrgUnitName" + this.getLocal(ctx), "roleNumber", "roleName" + this.getLocal(ctx), "orgNumber", "orgName" + this.getLocal(ctx), "deletedStatus"});
        exportMap.put("FiledType", new String[0]);
        return this.transeExport(rs, exportMap);
    }

    private String getLocal(Context ctx) {
        return "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toUpperCase();
    }

    private Hashtable<String, String> transeExport(IRowSet rs, Map map) throws TaskExternalException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] queryFiled = (String[])map.get("queryFiled");
        String[] excelFiled = (String[])map.get("excelFiled");
        try {
            int size = queryFiled.length;
            for (int i = 0; i < size; ++i) {
                if (rs.getString(queryFiled[i]) == null) continue;
                if ("false".equals(rs.getString(queryFiled[i])) || "true".equals(rs.getString(queryFiled[i]))) {
                    if ("false".equals(rs.getString(queryFiled[i]))) {
                        hashtable.put(excelFiled[i], NO);
                        continue;
                    }
                    hashtable.put(excelFiled[i], YES);
                    continue;
                }
                hashtable.put(excelFiled[i], rs.getString(queryFiled[i]));
            }
        }
        catch (SQLException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        return hashtable;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.org.app.PositionRoleQuery";
    }
}

