/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.pcacct;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountCheckResult;
import com.kingdee.eas.basedata.master.account.app.AcctRefContrastHelper;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.pcacct.IPcAccountView;
import com.kingdee.eas.basedata.pcacct.IPcAccount_Control;
import com.kingdee.eas.basedata.pcacct.PcAccountTableInfo;
import com.kingdee.eas.basedata.pcacct.PcAccountViewCollection;
import com.kingdee.eas.basedata.pcacct.PcAccountViewFactory;
import com.kingdee.eas.basedata.pcacct.PcAccountViewInfo;
import com.kingdee.eas.basedata.pcacct.PcAccount_ControlCollection;
import com.kingdee.eas.basedata.pcacct.PcAccount_ControlFactory;
import com.kingdee.eas.basedata.pcacct.PcAccount_ControlInfo;
import com.kingdee.eas.basedata.pcacct.app.PcAccountException;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.IBatchBizHasDeal;
import com.kingdee.eas.common.app.IBatchBizReference;
import com.kingdee.eas.common.app.IBizHasDeal;
import com.kingdee.eas.common.app.IBizReference;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import java.util.ArrayList;

public class PcAccountTools {
    public static PcAccount_ControlInfo getPcAcctCtrlInfo(Context ctx, PcAccountTableInfo info, ProfitCenterOrgUnitInfo destProfitCenter) throws BOSException {
        IPcAccount_Control acctCtrl = ctx == null ? PcAccount_ControlFactory.getRemoteInstance() : PcAccount_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("dc");
        evi.getSelector().add("currencyID");
        evi.getSelector().add("isQty");
        evi.getSelector().add("ac");
        evi.getSelector().add("acNotice");
        evi.getSelector().add("bw");
        evi.getSelector().add("control");
        evi.getSelector().add("isChangeCurrency");
        evi.getSelector().add("pcAccountTableID");
        evi.getSelector().add("srcProfitCenter");
        evi.getSelector().add("destProfitCenter");
        evi.getSelector().add("isDefaultForRef");
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("destProfitCenter", (Object)destProfitCenter.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRef", (Object)new Integer(0)));
            PcAccount_ControlCollection acctCtrlCols = acctCtrl.getPcAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() > 0) {
                return acctCtrlCols.get(0);
            }
        }
        return null;
    }

    public static boolean checkAccountCanAdd(Context ctx, PcAccountViewInfo acctInfo) throws BOSException, EASBizException {
        boolean checkinfo = false;
        if (acctInfo != null && acctInfo.getUpper() == null) {
            if (acctInfo.getParent() == null) {
                if (acctInfo.getPcAccountTableID() != null && acctInfo.getProfitCenterID() != null) {
                    boolean isSelfAcctTbl = PcAccountTools.checkPcAccountTableIsSelfConstructed(ctx, acctInfo.getProfitCenterID(), acctInfo.getPcAccountTableID());
                    if (!isSelfAcctTbl) {
                        checkinfo = false;
                    } else {
                        return true;
                    }
                }
                if (!checkinfo) {
                    throw new PcAccountException(PcAccountException.CANNOTADDBYSUPERIOR);
                }
                return checkinfo;
            }
            String parentAcctId = acctInfo.getParent().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("isUpperAllowCA");
            sic.add("gLevel");
            sic.add("level");
            IPcAccountView acct = ctx == null ? PcAccountViewFactory.getRemoteInstance() : PcAccountViewFactory.getLocalInstance(ctx);
            PcAccountViewInfo parent = acct.getPcAccountViewInfo((IObjectPK)new ObjectUuidPK(parentAcctId));
            if (parent != null) {
                if (!parent.isIsUpperAllowCA()) {
                    throw new PcAccountException(PcAccountException.CANNOTADDCHILDERS);
                }
                if (!PcAccountTools.checkAccountTableIsSelfConstructed(ctx, acctInfo.getProfitCenterID(), acctInfo.getPcAccountTableID())) {
                    if (!parent.isIsAllowCA()) {
                        throw new PcAccountException(PcAccountException.CANNOTADDCHILDERS);
                    }
                    if (parent.getGLevel() >= acctInfo.getLevel()) {
                        throw new PcAccountException(PcAccountException.PCACCOUNTCANNOTADD);
                    }
                    if (acctInfo.getLevel() <= parent.getControlLevel()) {
                        throw new PcAccountException(PcAccountException.CANNOTADDUPPERLEVER);
                    }
                }
            }
        }
        return true;
    }

    public static boolean checkAccountHasReference(Context ctx, PcAccountViewInfo info) throws EASBizException, BOSException {
        boolean ret = false;
        if (info.getId() != null && info.getId().toString().length() > 0) {
            IPcAccountView acct = ctx == null ? PcAccountViewFactory.getRemoteInstance() : PcAccountViewFactory.getLocalInstance(ctx);
            ret = acct.isHasDeal((IObjectPK)new ObjectUuidPK(info.getId()));
        }
        return ret;
    }

    public static boolean checkAccountHasInferior(Context ctx, PcAccountViewInfo info) throws BOSException, EASBizException {
        IPcAccountView acct = ctx == null ? PcAccountViewFactory.getRemoteInstance() : PcAccountViewFactory.getLocalInstance(ctx);
        return acct.checkPcAccountHasInferior(info);
    }

    public static PcAccount_ControlInfo getAcctCtrlInfo(Context ctx, PcAccountTableInfo info, ProfitCenterOrgUnitInfo destProfit) throws BOSException {
        IPcAccount_Control acctCtrl = ctx == null ? PcAccount_ControlFactory.getRemoteInstance() : PcAccount_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("dc");
        evi.getSelector().add("currencyID");
        evi.getSelector().add("isQty");
        evi.getSelector().add("ac");
        evi.getSelector().add("acNotice");
        evi.getSelector().add("bw");
        evi.getSelector().add("control");
        evi.getSelector().add("isChangeCurrency");
        evi.getSelector().add("pcAccountTableID");
        evi.getSelector().add("srcProfitCenter");
        evi.getSelector().add("destProfitCenter");
        evi.getSelector().add("isDefaultForRef");
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("destProfitCenter", (Object)destProfit.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRef", (Object)new Integer(0)));
            PcAccount_ControlCollection acctCtrlCols = acctCtrl.getPcAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() > 0) {
                return acctCtrlCols.get(0);
            }
        }
        return null;
    }

    public static EntityViewInfo getAsstPcAccountReferenceFilter(ProfitCenterOrgUnitInfo profitCenterInfo) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String profitCenterLongNumber = profitCenterInfo.getLongNumber();
        String[] profitCenterNumber = profitCenterLongNumber.split("!");
        StringBuffer compareLongNumber = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < profitCenterNumber.length; ++i) {
            if (i > 0) {
                sb.append("!");
                compareLongNumber.append(",");
            }
            sb.append(profitCenterNumber[i]);
            compareLongNumber.append(sb.toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("profitCenter.longNumber", (Object)compareLongNumber.toString(), CompareType.INCLUDE));
        evi.setFilter(filter);
        return evi;
    }

    public static boolean checkAccountTableIsSelfConstructed(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PcAccountTableInfo info) throws BOSException {
        IPcAccount_Control acctCtrl = ctx == null ? PcAccount_ControlFactory.getRemoteInstance() : PcAccount_ControlFactory.getLocalInstance(ctx);
        if (profitCenter != null && info != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("destProfitCenter", (Object)profitCenter.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("srcProfitCenter", null));
            filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRef", (Object)new Integer(0)));
            evi.setFilter(filter);
            PcAccount_ControlCollection acctCtrlCols = acctCtrl.getPcAccount_ControlCollection(evi);
            if (acctCtrlCols != null && acctCtrlCols.size() == 1) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkPcAccountTableIsSelfConstructed(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PcAccountTableInfo info) throws BOSException {
        IPcAccount_Control pcAcctCtrl = ctx == null ? PcAccount_ControlFactory.getRemoteInstance() : PcAccount_ControlFactory.getLocalInstance(ctx);
        if (profitCenter != null && info != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("destProfitCenter", (Object)profitCenter.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("srcProfitCenter", null));
            filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isDefaultForRef", (Object)new Integer(0)));
            evi.setFilter(filter);
            PcAccount_ControlCollection pcAcctCtrlCols = pcAcctCtrl.getPcAccount_ControlCollection(evi);
            if (pcAcctCtrlCols != null && pcAcctCtrlCols.size() == 1) {
                return true;
            }
        }
        return false;
    }

    public static BizCheckResult hasDeal(Context ctx, PcAccountViewCollection pcAccountViewCollection) throws BizHasDealException, EASBizException {
        if (pcAccountViewCollection == null || pcAccountViewCollection.size() == 0) {
            return BizCheckResult.NOTFOUND;
        }
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)pcAccountViewCollection.get(0).getId().getType().toString(), IBizHasDeal.class);
        }
        catch (EASDBException e) {
            throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)e);
        }
        if (checkers == null || checkers.length == 0) {
            return BizCheckResult.NOTFOUND;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int count = pcAccountViewCollection.size();
        for (int j = 0; j < count; ++j) {
            BOSUuid objID = pcAccountViewCollection.get(j).getId();
            idList.add(objID.toString());
        }
        for (int i = 0; i < checkers.length; ++i) {
            AccountCheckResult checkResult = AccountCheckResult.NOTFOUND;
            String checkerName = "";
            try {
                checkerName = checkers[i];
                Class<?> checkerClass = Class.forName(checkers[i]);
                Object checker = checkerClass.newInstance();
                if (checker != null && checker instanceof IBatchBizHasDeal) {
                    checkResult = ((IBatchBizHasDeal)checker).checkHasDeal(ctx, idList, null);
                    if (!checkResult.isFound()) continue;
                    AccountCheckResult accountCheckResult = new AccountCheckResult((BizCheckResult)checkResult, checkerName);
                    return accountCheckResult;
                }
                if (checker == null || !(checker instanceof IBizHasDeal)) continue;
                int count2 = pcAccountViewCollection.size();
                for (int j = 0; j < count2; ++j) {
                    BOSUuid objID = pcAccountViewCollection.get(j).getId();
                    checkResult = ((IBizHasDeal)checker).checkHasDeal(ctx, objID);
                    if (!checkResult.isFound()) continue;
                    AccountCheckResult accountCheckResult = new AccountCheckResult((BizCheckResult)checkResult, checkerName);
                    return accountCheckResult;
                }
                continue;
            }
            catch (BizHasDealException e) {
                throw new PcAccountException(PcAccountException.ACCOUNTBIZ, e, new Object[]{AcctRefContrastHelper.getSubSystemName((Context)ctx, (String)checkerName) + " " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())});
            }
            catch (Exception e) {
                throw new BizHasDealException(BizHasDealException.CHECK_ERROR, (Throwable)e);
            }
        }
        return BizCheckResult.NOTFOUND;
    }

    public static BizCheckResult isReferenced(Context ctx, PcAccountViewCollection pcAccountViewCollection) throws BizReferenceException {
        if (pcAccountViewCollection == null || pcAccountViewCollection.size() == 0) {
            return BizCheckResult.NOTFOUND;
        }
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)pcAccountViewCollection.get(0).getId().getType().toString(), IBizReference.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers == null || checkers.length == 0) {
            return BizCheckResult.NOTFOUND;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int count = pcAccountViewCollection.size();
        for (int j = 0; j < count; ++j) {
            BOSUuid objID = pcAccountViewCollection.get(j).getId();
            idList.add(objID.toString());
        }
        for (int i = 0; i < checkers.length; ++i) {
            BizCheckResult checkResult = BizCheckResult.NOTFOUND;
            try {
                Class<?> checkerClass = Class.forName(checkers[i]);
                Object checker = checkerClass.newInstance();
                if (checker != null && checker instanceof IBatchBizReference) {
                    checkResult = ((IBatchBizReference)checker).checkReferenced(ctx, idList, null);
                    if (!checkResult.isFound()) continue;
                    return checkResult;
                }
                if (checker == null || !(checker instanceof IBizReference)) continue;
                int count2 = pcAccountViewCollection.size();
                for (int j = 0; j < count2; ++j) {
                    BOSUuid objID = pcAccountViewCollection.get(j).getId();
                    checkResult = ((IBizReference)checker).checkReferenced(ctx, objID);
                    if (!checkResult.isFound()) continue;
                    return checkResult;
                }
                continue;
            }
            catch (BizReferenceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BizReferenceException(BizReferenceException.CHECK_ERROR, (Throwable)e);
            }
        }
        return BizCheckResult.NOTFOUND;
    }

    public static void checkProfitCenterAccountTable(Context ctx, ProfitCenterOrgUnitInfo curProfit) throws BOSException, EASBizException {
        if (curProfit == null) {
            throw new RuntimeException("Company can not be null.");
        }
        if (curProfit.getPcaccountTable() == null) {
            throw new PcAccountException(PcAccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE);
        }
    }

    public static boolean isStringEqual(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null && str2 != null && str2.trim().equals("")) {
            return true;
        }
        if (str1 != null && str1.trim().equals("") && str2 == null) {
            return true;
        }
        return str1 != null && str2 != null && str1.equals(str2);
    }
}

