/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.pcacct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.pcacct.IPcAccount_Control;
import com.kingdee.eas.basedata.pcacct.PcAccountTableFactory;
import com.kingdee.eas.basedata.pcacct.PcAccountTableInfo;
import com.kingdee.eas.basedata.pcacct.PcAccountUserLevelCollection;
import com.kingdee.eas.basedata.pcacct.PcAccountUserLevelInfo;
import com.kingdee.eas.basedata.pcacct.PcAccount_ControlCollection;
import com.kingdee.eas.basedata.pcacct.PcAccount_ControlFactory;
import com.kingdee.eas.basedata.pcacct.PcAccount_ControlInfo;
import com.kingdee.eas.basedata.pcacct.app.AbstractPcAccountTableControllerBean;
import com.kingdee.eas.basedata.pcacct.app.PcAccountException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PcAccountTableControllerBean
extends AbstractPcAccountTableControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.pcacct.app.PcAccountTableControllerBean");

    @Override
    protected boolean _usedByAccountView(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected void _canControlGroup(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected int _getMaxAccoutLevel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        int maxLevel = -1;
        if (pk != null) {
            String sql = "SELECT MAX(FLevel) AS maxLevel FROM T_BD_PCAccountView WHERE FPcAccountTableID=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
            try {
                if (rs.next()) {
                    maxLevel = rs.getInt("maxLevel");
                }
            }
            catch (SQLException err) {
                throw new BOSException((Throwable)err);
            }
        }
        return maxLevel;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk, IObjectValue profitCenter) throws BOSException, EASBizException {
        PcAccount_ControlInfo acctCtrlInfo;
        PcAccountTableInfo accountTableInfo = (PcAccountTableInfo)PcAccountTableFactory.getLocalInstance(ctx).getValue(pk);
        String methodName = "";
        IObjectPK instancePK = pk;
        BOSObjectType bizObjType = accountTableInfo.getBOSType();
        String instanceDetail = accountTableInfo.getNumber() + "  " + accountTableInfo.getName();
        String logItemName = "bd_pcacct_pcAccountTable_delete";
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bizObjType, (IObjectPK)instancePK, (String)instanceDetail, (String)logItemName);
        ProfitCenterOrgUnitInfo currentProfitCenter = (ProfitCenterOrgUnitInfo)profitCenter;
        IPcAccount_Control acctCtrl = PcAccount_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destProfitCenter", (Object)currentProfitCenter.getId().toString()));
        evi.setFilter(filter);
        PcAccount_ControlCollection acctCtrlCols = acctCtrl.getPcAccount_ControlCollection(evi);
        if (acctCtrlCols != null && acctCtrlCols.size() > 0 && (acctCtrlInfo = acctCtrlCols.get(0)) != null) {
            if (acctCtrlInfo.getSrcProfitCenter() == null) {
                this.deleteSelfTable(ctx, pk, currentProfitCenter);
            } else {
                this.deleteUpperTable(ctx, pk, currentProfitCenter);
            }
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PcAccountTableInfo Info = null;
        Info = (PcAccountTableInfo)model;
        ((ObjectBaseInfo)model).setCU(AccountTools.getCurrentCU((Context)ctx));
        if (Info.getProfitCenter() == null) {
            Info.setProfitCenter(ContextUtil.getCurrentProfitUnit((Context)ctx));
        }
        super._checkNameBlank(ctx, (IObjectValue)Info);
        super._checkNumberBlank(ctx, (IObjectValue)Info);
        super._checkNameDup(ctx, (IObjectValue)Info);
        super._checkNumberDup(ctx, (IObjectValue)Info);
        this._checkSeparatorAndLevel(Info);
        this.checkUserLevelsValid(Info);
        IObjectPK pk = null;
        pk = super._addnew(ctx, (IObjectValue)Info);
        this.setAcctControlInfo(Info, ctx);
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PcAccount_ControlInfo acctCtrlInfo;
        PcAccountTableInfo accountTableInfo = (PcAccountTableInfo)PcAccountTableFactory.getLocalInstance(ctx).getValue(pk);
        String methodName = "";
        IObjectPK instancePK = pk;
        BOSObjectType bizObjType = accountTableInfo.getBOSType();
        String instanceDetail = accountTableInfo.getNumber() + "  " + accountTableInfo.getName();
        String logItemName = "bd_pcacct_pcAccountTable_delete";
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bizObjType, (IObjectPK)instancePK, (String)instanceDetail, (String)logItemName);
        ProfitCenterOrgUnitInfo currentProfitCenter = ContextUtil.getCurrentProfitUnit((Context)ctx);
        IPcAccount_Control acctCtrl = PcAccount_ControlFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destProfitCenter", (Object)currentProfitCenter.getId().toString()));
        evi.setFilter(filter);
        PcAccount_ControlCollection acctCtrlCols = acctCtrl.getPcAccount_ControlCollection(evi);
        if (acctCtrlCols != null && acctCtrlCols.size() > 0 && (acctCtrlInfo = acctCtrlCols.get(0)) != null) {
            if (acctCtrlInfo.getSrcProfitCenter() == null) {
                this.deleteSelfTable(ctx, pk, currentProfitCenter);
            } else {
                this.deleteUpperTable(ctx, pk, currentProfitCenter);
            }
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void deleteSelfTable(Context ctx, IObjectPK pk, ProfitCenterOrgUnitInfo currentProfitCenter) throws EASBizException, BOSException {
        try {
            String sql = "SELECT TOP 1 1 FROM T_BD_PCACCOUNTVIEW WHERE FPCAccountTableID=? and FProfitCenterID=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString(), currentProfitCenter.getId().toString()});
            if (rs.next()) {
                throw new PcAccountException(PcAccountException.TABLEHASPCACCOUNTVIEW);
            }
            sql = "SELECT TOP 1 1 FROM T_BD_PcAccountType WHERE FPCAccountTableID=?";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
            if (rs.next()) {
                throw new PcAccountException(PcAccountException.CANTDELTABLECAUSETYPE);
            }
            sql = "SELECT TOP 1 1 FROM T_BD_PCAccount_Control WHERE FPcAccountTableID=? and FDestProfitCenterID!=?";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString(), currentProfitCenter.getId().toString()});
            if (rs.next()) {
                throw new PcAccountException(PcAccountException.TABLEHASASSIGNEDTOCHILD);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)pk.toString()));
            filter.getFilterItems().add(new FilterItemInfo("destProfitCenter", (Object)currentProfitCenter.getId().toString()));
            IPcAccount_Control acctCtrl = PcAccount_ControlFactory.getLocalInstance(ctx);
            acctCtrl.delete(filter);
            super._delete(ctx, pk);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void deleteUpperTable(Context ctx, IObjectPK pk, ProfitCenterOrgUnitInfo currentProfitCenter) throws EASBizException, BOSException {
        boolean canDeleteTable = true;
        if (canDeleteTable) {
            try {
                String sql = "SELECT TOP 1 1 FROM T_BD_PCACCOUNTVIEW WHERE FPcAccountTableID=? and FProfitCenterID=?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString(), currentProfitCenter.getId().toString()});
                if (rs.next()) {
                    throw new AccountException(AccountException.TABLEHASACCOUNTVIEW);
                }
                String sqlForCheckAssignment = "SELECT TOP 1 1 FROM T_BD_PCAccount_Control WHERE FPcAccountTableID=? and FSrcProfitCenterID=?";
                IRowSet rsForCheckAssignment = DbUtil.executeQuery((Context)ctx, (String)sqlForCheckAssignment, (Object[])new Object[]{pk.toString(), currentProfitCenter.getId().toString()});
                if (rsForCheckAssignment.next()) {
                    throw new AccountException(AccountException.TABLEHASASSIGNEDTOCHILD);
                }
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)pk.toString()));
                filter.getFilterItems().add(new FilterItemInfo("destProfitCenter", (Object)currentProfitCenter.getId().toString()));
                IPcAccount_Control acctCtrl = PcAccount_ControlFactory.getLocalInstance(ctx);
                acctCtrl.delete(filter);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void _checkSeparatorAndLevel(PcAccountTableInfo model) throws BOSException, EASBizException {
        if (!model.isIsUseSeparator() && !model.isIsUserLevel()) {
            throw new AccountException(AccountException.MUSTHASONECHECKED);
        }
        if (model.isIsUserLevel() && model.getUserLevel().size() < 1) {
            throw new AccountException(AccountException.MUSTHASONEUSERLEVEL);
        }
    }

    private void checkUserLevelsValid(PcAccountTableInfo newTable) throws AccountException {
        PcAccountUserLevelCollection newLevels = newTable.getUserLevel();
        for (int i = 0; i < newLevels.size(); ++i) {
            PcAccountUserLevelInfo newLevel = newLevels.get(i);
            if (newLevel.getLevel() >= 1 && newLevel.getLength() >= 1) continue;
            throw new AccountException(AccountException.TABLE_ADDNEW_LEVELS_INVALID);
        }
    }

    private void setAcctControlInfo(PcAccountTableInfo info, Context ctx) throws EASBizException, BOSException {
        PcAccount_ControlInfo acctCtrlInfo = new PcAccount_ControlInfo();
        acctCtrlInfo.setPcAccountTableID(info);
        acctCtrlInfo.setStrCu(null);
        acctCtrlInfo.setDestCu(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        acctCtrlInfo.setSrcProfitCenter(null);
        acctCtrlInfo.setDestProfitCenter(info.getProfitCenter());
        acctCtrlInfo.setIsDefaultForRef(false);
        IPcAccount_Control acctCtrl = PcAccount_ControlFactory.getLocalInstance(ctx);
        acctCtrl.addnew((CoreBaseInfo)acctCtrlInfo);
        acctCtrlInfo.setId(null);
        acctCtrlInfo.setIsDefaultForRef(true);
        acctCtrl.addnew((CoreBaseInfo)acctCtrlInfo);
    }
}

