/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.pcacct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.pcacct.IPcAccountView;
import com.kingdee.eas.basedata.pcacct.PcAccountTypeCollection;
import com.kingdee.eas.basedata.pcacct.PcAccountTypeInfo;
import com.kingdee.eas.basedata.pcacct.PcAccountViewFactory;
import com.kingdee.eas.basedata.pcacct.app.AbstractPcAccountTypeControllerBean;
import com.kingdee.eas.basedata.pcacct.app.PcAccountException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PcAccountTypeControllerBean
extends AbstractPcAccountTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.pcacct.app.PcAccountTypeControllerBean");

    @Override
    protected IObjectCollection _getChildrenByID(Context ctx, IObjectPK parentID, IObjectPK pcAccountTableID) throws BOSException, EASBizException {
        PcAccountTypeCollection ret = null;
        if (parentID == null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)pcAccountTableID.toString().trim()));
            filter.setMaskString("#0 and #1");
            evi.setFilter(filter);
            evi.getSorter().add(new SorterItemInfo("longNumber"));
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("pcAccountID.pcAccountTableID"));
            ret = this.getPcAccountTypeCollection(ctx, evi);
        } else {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)parentID.toString().trim(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)parentID.toString().trim()));
            evi.setFilter(filter);
            evi.getSorter().add(new SorterItemInfo("longNumber"));
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("pcAccountID.pcAccountTableID"));
            ret = this.getPcAccountTypeCollection(ctx, evi);
        }
        return ret;
    }

    @Override
    protected boolean _isReferencedByPcAccount(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _hasParent(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sqlToGetAcctInfo = "SELECT TOP 1 FPARENTID FROM T_BD_PCACCOUNTTYPE WHERE FID=?";
        IRowSet rsToGetAcctInfo = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctInfo, (Object[])new Object[]{pk.toString()});
        String parentId = null;
        try {
            if (rsToGetAcctInfo != null && rsToGetAcctInfo.next() && (parentId = rsToGetAcctInfo.getString("FPARENTID")) != null && parentId.length() > 0) {
                String sqlGetAccount;
                IRowSet rsTogetAccount;
                int count = 0;
                String sqlToCheckHasRefByAccount = "SELECT count(fid) count FROM T_BD_PCACCOUNTTYPE WHERE FPARENTID=? ";
                IRowSet rsToCheckHasRefByAccount = DbUtil.executeQuery((Context)ctx, (String)sqlToCheckHasRefByAccount, (Object[])new Object[]{parentId});
                if (rsToCheckHasRefByAccount != null && rsToCheckHasRefByAccount.next()) {
                    count = rsToCheckHasRefByAccount.getInt("count");
                }
                if (count == 1 && (rsTogetAccount = DbUtil.executeQuery((Context)ctx, (String)(sqlGetAccount = "SELECT TOP 1 FId FROM T_BD_PCACCOUNTVIEW WHERE FPcAccountTypeID=?"), (Object[])new Object[]{pk.toString()})) != null && rsTogetAccount.next()) {
                    return true;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PcAccountTypeInfo pcAccountTypeInfo = (PcAccountTypeInfo)model;
        ((ObjectBaseInfo)model).setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this._checkNumberBlank(ctx, (IObjectValue)pcAccountTypeInfo);
        this._checkNameBlank(ctx, (IObjectValue)pcAccountTypeInfo);
        PcAccountTypeInfo parentInfo = null;
        if (pcAccountTypeInfo.getParent() != null) {
            parentInfo = super.getPcAccountTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(pcAccountTypeInfo.getParent().getId()));
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)pcAccountTypeInfo);
        if (pcAccountTypeInfo.getParent() == null) {
            return pk;
        }
        this.synchronizeParentInfo(ctx, pcAccountTypeInfo, parentInfo, pk);
        return pk;
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PcAccountTypeInfo accountTypeInfo = (PcAccountTypeInfo)model;
        PcAccountTypeInfo oldModel = super.getPcAccountTypeInfo(ctx, pk);
        ((ObjectBaseInfo)model).setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this._checkNumberBlank(ctx, (IObjectValue)accountTypeInfo);
        this._checkNameBlank(ctx, (IObjectValue)accountTypeInfo);
        if (!(oldModel.isIsLeaf() || oldModel.getNumber().trim().equalsIgnoreCase(accountTypeInfo.getNumber().trim()) && oldModel.getProperty().getValue() == accountTypeInfo.getProperty().getValue())) {
            throw new PcAccountException(PcAccountException.NOTEDITTYPENOTISLEAF);
        }
        IPcAccountView iAccountView = PcAccountViewFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("pcaccountTypeID", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("pcaccountTableID", (Object)accountTypeInfo.getPcAccountTable().getId().toString()));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        SorterItemCollection sorterc = new SorterItemCollection();
        sorterc.add(new SorterItemInfo("number"));
        if (!(iAccountView.getPKList(filter, sorterc).length <= 0 || oldModel.getNumber().trim().equalsIgnoreCase(accountTypeInfo.getNumber().trim()) && oldModel.getProperty().getValue() == accountTypeInfo.getProperty().getValue())) {
            throw new PcAccountException(PcAccountException.NOTEDIT_BYREF);
        }
        if (!oldModel.getNumber().trim().equalsIgnoreCase(accountTypeInfo.getNumber().trim())) {
            this._checkNumberDup(ctx, (IObjectValue)accountTypeInfo);
        }
        PcAccountTypeInfo parentInfo = null;
        if (oldModel.getParent() != null && !oldModel.getParent().getId().equals((Object)oldModel.getId())) {
            parentInfo = super.getPcAccountTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(accountTypeInfo.getParent().getId()));
        }
        super._update(ctx, pk, (IObjectValue)accountTypeInfo);
    }

    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PcAccountTypeInfo model = super.getPcAccountTypeInfo(ctx, pk);
        if (!model.isIsLeaf()) {
            throw new PcAccountException(PcAccountException.NOTDEL_NOTISLEAF);
        }
        String parentId = null;
        if (model.getParent() != null) {
            parentId = model.getParent().getId().toString();
        }
        boolean hasParent = false;
        if (parentId != null) {
            hasParent = this._hasParent(ctx, pk);
        }
        if (hasParent) {
            String sqlToGetAcctInfo = "SELECT TOP 1 FNumber FROM T_BD_PCACCOUNTTYPE WHERE FID=?";
            IRowSet rsToGetAcctInfo = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctInfo, (Object[])new Object[]{parentId});
            String fparentnumber = null;
            try {
                if (rsToGetAcctInfo != null && rsToGetAcctInfo.next()) {
                    fparentnumber = rsToGetAcctInfo.getString("FNumber");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            String updateParent = " update T_BD_PCACCOUNTTYPE set fnumber='$'||fnumber where fid=? ";
            DbUtil.execute((Context)ctx, (String)updateParent, (Object[])new Object[]{parentId});
            ObjectUuidPK pPk = new ObjectUuidPK(parentId);
            PcAccountTypeInfo parent = (PcAccountTypeInfo)this.getValue(ctx, (IObjectPK)pPk);
            parent.setIsLeaf(true);
            parent.setNumber(fparentnumber);
            parent.setId(BOSUuid.read((String)pk.toString()));
            super._update(ctx, pk, (IObjectValue)parent);
            String deleteSQL = "delete from t_bd_pcAccounttype where fid = ?";
            DbUtil.execute((Context)ctx, (String)deleteSQL, (Object[])new Object[]{pPk.toString()});
            parentId = pk.toString();
            return;
        }
        IPcAccountView iAccountView = PcAccountViewFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("pcAccountTypeID", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)model.getPcAccountTable().getId().toString()));
        filter.setMaskString("#0 and #1");
        SorterItemCollection sorterc = new SorterItemCollection();
        sorterc.add(new SorterItemInfo("number"));
        if (iAccountView.getPKList(filter, sorterc).length > 0) {
            throw new PcAccountException(PcAccountException.BYPCACCOUNTREF);
        }
        super._delete(ctx, pk);
        if (model.getParent() == null) {
            return;
        }
        if (!model.getParent().getId().toString().trim().equalsIgnoreCase(model.getId().toString().trim())) {
            EntityViewInfo evi = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)model.getParent().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("pcAccountTable", (Object)model.getPcAccountTable().getId().toString()));
            filter.setMaskString("#0 and #1");
            evi.setFilter(filter);
            if (super.getCollection(ctx, evi).size() == 0) {
                PcAccountTypeInfo parentInfo = super.getPcAccountTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(model.getParent().getId()));
                parentInfo.setIsLeaf(true);
                super.update(ctx, (IObjectPK)new ObjectUuidPK(parentInfo.getId()), (CoreBaseInfo)parentInfo);
            }
        }
    }

    private void synchronizeParentInfo(Context ctx, PcAccountTypeInfo pcAccountTypeInfo, PcAccountTypeInfo parentInfo, IObjectPK pk) throws BOSException, EASBizException {
        if (pcAccountTypeInfo.getParent() != null && !pcAccountTypeInfo.getParent().getId().toString().trim().equalsIgnoreCase(pcAccountTypeInfo.getId().toString().trim()) && parentInfo != null && parentInfo.isIsLeaf()) {
            parentInfo.setIsLeaf(false);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(parentInfo.getId()), (IObjectValue)parentInfo);
            StringBuffer sql = new StringBuffer("UPDATE T_BD_PcAccountView SET FPcAccountTypeID='");
            sql.append(pk.toString().trim()).append("' WHERE FPcAccountTableID='");
            sql.append(parentInfo.getPcAccountTable().getId().toString().trim());
            sql.append("' AND FPcAccountTypeID='");
            sql.append(parentInfo.getId().toString().trim()).append("' ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PcAccountTypeInfo acctType = (PcAccountTypeInfo)model;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)acctType.getNumber().trim()));
        filter.getFilterItems().add(new FilterItemInfo("pcAccountTable", (Object)acctType.getPcAccountTable().getId().toString()));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        if (super.getCollection(ctx, evi).size() > 0) {
            throw new PcAccountException(PcAccountException.ACCOUNT_TYPE_DUPLICATED, new Object[]{acctType.getNumber()});
        }
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
    }
}

