/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.pcacct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fi.gl.app.AppHelper;
import com.kingdee.eas.base.message.util.StringUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.pcacct.AbstractPcAccountViewInfo;
import com.kingdee.eas.basedata.pcacct.IPcAccountTable;
import com.kingdee.eas.basedata.pcacct.PcAccountCurrencyCollection;
import com.kingdee.eas.basedata.pcacct.PcAccountCurrencyInfo;
import com.kingdee.eas.basedata.pcacct.PcAccountTableFactory;
import com.kingdee.eas.basedata.pcacct.PcAccountTableInfo;
import com.kingdee.eas.basedata.pcacct.PcAccountTools;
import com.kingdee.eas.basedata.pcacct.PcAccountTypeFactory;
import com.kingdee.eas.basedata.pcacct.PcAccountTypeInfo;
import com.kingdee.eas.basedata.pcacct.PcAccountViewCollection;
import com.kingdee.eas.basedata.pcacct.PcAccountViewFactory;
import com.kingdee.eas.basedata.pcacct.PcAccountViewInfo;
import com.kingdee.eas.basedata.pcacct.PcAccount_ControlFactory;
import com.kingdee.eas.basedata.pcacct.PcAccount_ControlInfo;
import com.kingdee.eas.basedata.pcacct.app.AbstractPcAccountViewControllerBean;
import com.kingdee.eas.basedata.pcacct.app.PcAccountException;
import com.kingdee.eas.basedata.pcacct.app.PcAccountPLType;
import com.kingdee.eas.basedata.pcacct.app.PcAccountProperty;
import com.kingdee.eas.basedata.pcacct.app.PcAccountingCurrencyEnum;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.app.PinYinHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PcAccountViewControllerBean
extends AbstractPcAccountViewControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.pcacct.app.PcAccountViewControllerBean");
    private String checkerName = null;
    private BizCheckResult accountCheck = null;

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, IObjectPK profitCenterPK) throws BOSException, EASBizException {
        return null;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._addnew(ctx, model, false);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model, boolean isAssign) throws BOSException, EASBizException {
        PcAccountViewInfo pcAcctInfo = (PcAccountViewInfo)model;
        if (!isAssign && !this.isCUBDAllowAddnew(ctx, pcAcctInfo)) {
            throw new PcAccountException(PcAccountException.CUBD_CANNOT_ADDNEW);
        }
        AbstractPcAccountViewInfo parentInfo = null;
        if (pcAcctInfo.getParent() != null && pcAcctInfo.getParent().getId() != null && pcAcctInfo.getParent().getId().toString().length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("pcaccountTypeID.property");
            sic.add("pcaccountCurrency.*");
            parentInfo = (PcAccountViewInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(pcAcctInfo.getParent().getId()), sic);
        }
        PcAccountViewInfo upperInfo = null;
        if (pcAcctInfo.getUpper() != null && pcAcctInfo.getUpper().getId() != null && pcAcctInfo.getUpper().getId().toString().length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("pcaccountTypeID.property");
            sic.add("pcaccountCurrency.*");
            upperInfo = (PcAccountViewInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(pcAcctInfo.getUpper().getId()), sic);
            pcAcctInfo.setUpper(upperInfo);
        }
        if (pcAcctInfo != null) {
            PcAccountTools.checkAccountCanAdd(ctx, pcAcctInfo);
        }
        this.attributeCheck(ctx, pcAcctInfo, null, isAssign);
        IObjectPK pk = null;
        if (parentInfo != null && parentInfo.isIsLeaf() && pcAcctInfo.getProfitCenterID().isIsBizUnit()) {
            boolean parentHasDeal;
            if ((parentInfo.getCAA() == null && pcAcctInfo.getCAA() != null || parentInfo.getCAA() != null && pcAcctInfo.getCAA() == null || parentInfo.getCAA() != null && pcAcctInfo.getCAA() != null && !parentInfo.getCAA().getId().equals((Object)pcAcctInfo.getCAA().getId())) && (parentHasDeal = this.isHasDeal(ctx, (IObjectPK)new ObjectUuidPK(parentInfo.getId()), false))) {
                throw new PcAccountException(PcAccountException.ACC_NOT_SAME, new Object[]{pcAcctInfo.getProfitCenterID().getNumber(), parentInfo.getNumber(), pcAcctInfo.getNumber(), parentInfo.getNumber()});
            }
            if (parentInfo.getCAA() != null) {
                String sql = "delete from T_BD_PCACCOUNTASSTDFTVALUE where FPCACCOUNTID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{parentInfo.getId().toString()});
            }
            pk = new ObjectUuidPK(parentInfo.getId());
            PcAccountViewInfo temp = (PcAccountViewInfo)parentInfo.clone();
            temp.setId(null);
            temp.setIsLeaf(false);
            temp.setHasUserProperty(false);
            PcAccountCurrencyCollection acctCuDetails = temp.getPcAccountCurrency();
            if (acctCuDetails != null) {
                int count = acctCuDetails.size();
                for (int i = 0; i < count; ++i) {
                    acctCuDetails.get(i).setPcAccountView(temp);
                    acctCuDetails.get(i).remove("id");
                }
            }
            parentInfo.setNumber(pcAcctInfo.getNumber());
            super._update(ctx, pk, (IObjectValue)parentInfo);
            IObjectPK temppk = super.innerAddnew(ctx, (IObjectValue)temp);
            String sqlToSynchronizeUpperId = "UPDATE T_BD_PCACCOUNTVIEW SET FUPPERID=? WHERE FUPPERID=?";
            DbUtil.execute((Context)ctx, (String)sqlToSynchronizeUpperId, (Object[])new Object[]{temppk.toString(), pk.toString()});
            parentInfo.setId(BOSUuid.read((String)temppk.toString()));
            pcAcctInfo.setParent((PcAccountViewInfo)parentInfo);
            pcAcctInfo.setId(BOSUuid.read((String)pk.toString()));
            this.setInnerAddnewProperties(ctx, pcAcctInfo, (PcAccountViewInfo)parentInfo);
            super._update(ctx, pk, (IObjectValue)pcAcctInfo);
            String updateUpper = "update t_bd_pcaccountview set fupperid =? where fid=?";
            String updateUpperNull = "update t_bd_pcaccountview set fupperid =null where fid=?";
            if (pcAcctInfo.getUpper() == null) {
                DbUtil.execute((Context)ctx, (String)updateUpperNull, (Object[])new Object[]{pcAcctInfo.getId().toString()});
            } else {
                DbUtil.execute((Context)ctx, (String)updateUpper, (Object[])new Object[]{pcAcctInfo.getUpper().getId().toString(), pcAcctInfo.getId().toString()});
            }
            ORMValueCacheService.getInstance().remove(ctx, pcAcctInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(pcAcctInfo.getId()));
            AppHelper.copyAccountBalance((Context)ctx, (String)pk.toString(), (String)temppk.toString(), (String)pcAcctInfo.getProfitCenterID().getId().toString());
        } else {
            if (pcAcctInfo.get("hasUserProperty") == null) {
                pcAcctInfo.setHasUserProperty(false);
            }
            pcAcctInfo.setRefId("");
            pk = super._addnew(ctx, (IObjectValue)pcAcctInfo);
        }
        if (!isAssign) {
            this.checkDupName(ctx, pcAcctInfo);
        }
        this.handleAstInitClosed(ctx, pcAcctInfo);
        PinYinHelper.generatePinYin((Context)ctx, (String)"com.kingdee.eas.basedata.pcacct.app.PcAccountView", (String[])pk.toString().split(""));
        return pk;
    }

    private void checkDupName(Context ctx, PcAccountViewInfo acctInfo) throws BOSException, EASBizException {
        if (acctInfo == null || acctInfo.getProfitCenterID() == null || acctInfo.getPcAccountTableID() == null || acctInfo.getName() == null || acctInfo.getId() == null) {
            return;
        }
        String sql = "select id where profitCenterID.id='" + acctInfo.getProfitCenterID().getId().toString() + "' and pcAccountTableID.id='" + acctInfo.getPcAccountTableID().getId().toString() + "' and name='" + acctInfo.getName().trim().replaceAll("'", "''") + "' and level = " + (acctInfo.getLevel() < 1 ? 1 : acctInfo.getLevel()) + (acctInfo.getParent() != null ? " and parent.id = '" + acctInfo.getParent().getId().toString() + "'" : "") + (acctInfo.getId() != null ? " and id != '" + acctInfo.getId().toString() + "'" : "");
        if (PcAccountViewFactory.getLocalInstance(ctx).exists(sql)) {
            throw new PcAccountException(PcAccountException.NAMEALEADYEXIST, new Object[]{acctInfo.getName()});
        }
    }

    private void checkIsInEnabledAcctref(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection seleColl = new SelectorItemCollection();
        seleColl.add(new SelectorItemInfo("id"));
        seleColl.add(new SelectorItemInfo("profitCenterID.id"));
        seleColl.add(new SelectorItemInfo("pcAccountTableID.id"));
        seleColl.add(new SelectorItemInfo("pcAccountTableID.name"));
        PcAccountViewInfo acctInfo = PcAccountViewFactory.getLocalInstance(ctx).getPcAccountViewInfo(pk, seleColl);
        if (acctInfo == null || acctInfo.getId() == null) {
            return;
        }
    }

    protected void setPropertiesWhenHasDeal(Context ctx, PcAccountViewInfo info, PcAccountViewInfo oldAcctInfo, PcAccountViewInfo parentInfo) throws EASBizException, BOSException {
        PcAccountViewInfo parent;
        boolean hasChanged = false;
        PcAccountViewInfo acctInfoBeforeModify = null;
        if (info.getId() == null || info.getId().toString().length() < 1) {
            if (info.getParent() != null && info.getParent().isIsLeaf()) {
                acctInfoBeforeModify = parentInfo;
            }
        } else {
            acctInfoBeforeModify = oldAcctInfo;
        }
        if (acctInfoBeforeModify != null && (info.getDC().getValue() != acctInfoBeforeModify.getDC().getValue() || info.isIsCash() != acctInfoBeforeModify.isIsCash() || info.getControlLevel() != acctInfoBeforeModify.getControlLevel() || info.isIsBank() != acctInfoBeforeModify.isIsBank() || info.isIsCashEquivalent() != acctInfoBeforeModify.isIsCashEquivalent() || info.getPLType().getValue() != acctInfoBeforeModify.getPLType().getValue() || info.getCAA() == null && acctInfoBeforeModify.getCAA() != null || info.getCAA() != null && acctInfoBeforeModify.getCAA() == null || info.getCAA() != null && acctInfoBeforeModify.getCAA() != null && !info.getCAA().getId().toString().equals(acctInfoBeforeModify.getCAA().getId().toString()) || info.isIsQty() && !acctInfoBeforeModify.isIsQty() || info.isAC() && !acctInfoBeforeModify.isAC() || !info.getPcAccountTypeID().getId().toString().equals(acctInfoBeforeModify.getPcAccountTypeID().getId().toString()) || info.isACNotice() && !acctInfoBeforeModify.isACNotice() || info.isBw() && !acctInfoBeforeModify.isBw() || this.compareAccountCurrency(info, acctInfoBeforeModify) < 0)) {
            hasChanged = true;
        }
        if (!hasChanged) {
            return;
        }
        boolean isReference = info.getId() == null || info.getId().toString().length() < 1 ? (info.getParent() != null && info.getParent().isIsLeaf() ? PcAccountTools.checkAccountHasReference(ctx, info.getParent()) : false) : (info.getRefId() != null && info.getRefId().equals("HASDEAL") ? true : PcAccountTools.checkAccountHasReference(ctx, info));
        if (isReference) {
            if (info.getControlLevel() < acctInfoBeforeModify.getControlLevel()) {
                throw new PcAccountException(PcAccountException.CONTROLLEVEL_ERR, new Object[]{info.getNumber(), new Integer(acctInfoBeforeModify.getControlLevel())});
            }
            if (info.getPcAccountTypeID() != null && acctInfoBeforeModify.getPcAccountTypeID() != null && !info.getPcAccountTypeID().getId().toString().equals(acctInfoBeforeModify.getPcAccountTypeID().getId().toString())) {
                throw new PcAccountException(PcAccountException.CANTALTERACCTTYPE);
            }
            PcAccountViewInfo standardInfo = acctInfoBeforeModify;
            info.setDC(standardInfo.getDC());
            info.setIsCash(standardInfo.isIsCash());
            info.setIsBank(standardInfo.isIsBank());
            info.setIsCashEquivalent(standardInfo.isIsCashEquivalent());
            info.setPLType(standardInfo.getPLType());
            info.setCAA(standardInfo.getCAA());
            if (!standardInfo.isIsQty()) {
                info.setIsQty(false);
            }
            if (!standardInfo.isAC()) {
                info.setAC(false);
            }
            if (!standardInfo.isBw()) {
                info.setBw(false);
            }
            if (info.getAccountingCurrency().getValue() < standardInfo.getAccountingCurrency().getValue()) {
                throw new PcAccountException(PcAccountException.PCACCOUNTCURRENCYPOLICYWHENHASDEAL, new Object[]{info.getNumber()});
            }
            if (info.getAccountingCurrency().getValue() == standardInfo.getAccountingCurrency().getValue() && info.getAccountingCurrency() == PcAccountingCurrencyEnum.ONECURRENCY) {
                PcAccountCurrencyInfo acctCuDetailInfo;
                int i;
                int count;
                PcAccountCurrencyCollection acctCuDetails;
                ArrayList<String> currencyIdList = new ArrayList<String>();
                if (info.getPcAccountCurrency() != null) {
                    acctCuDetails = info.getPcAccountCurrency();
                    count = acctCuDetails.size();
                    for (i = 0; i < count; ++i) {
                        acctCuDetailInfo = acctCuDetails.get(i);
                        if (acctCuDetailInfo == null || acctCuDetailInfo.getCurrency().getId() == null || acctCuDetailInfo.getCurrency().getId().toString().length() <= 0) continue;
                        currencyIdList.add(acctCuDetailInfo.getCurrency().getId().toString());
                    }
                }
                if (standardInfo.getPcAccountCurrency() != null) {
                    acctCuDetails = standardInfo.getPcAccountCurrency();
                    count = acctCuDetails.size();
                    for (i = 0; i < count; ++i) {
                        String currencyId;
                        acctCuDetailInfo = acctCuDetails.get(i);
                        if (acctCuDetailInfo == null || acctCuDetailInfo.getCurrency().getId() == null || acctCuDetailInfo.getCurrency().getId().toString().length() <= 0 || currencyIdList.contains(currencyId = acctCuDetailInfo.getCurrency().getId().toString())) continue;
                        throw new PcAccountException(PcAccountException.PCACCOUNTCURRENCYPOLICYWHENHASDEAL, new Object[]{info.getNumber()});
                    }
                }
            }
        }
        if (info.getParent() != null && (parent = acctInfoBeforeModify) != null && parent.getControlLevel() > info.getControlLevel()) {
            throw new PcAccountException(PcAccountException.CONTROLLEVEL_ERR, new Object[]{info.getNumber(), new Integer(parent.getControlLevel())});
        }
        if (info.getUpper() != null && info.getControlLevel() < acctInfoBeforeModify.getControlLevel()) {
            throw new PcAccountException(PcAccountException.CONTROLLEVEL_ERR, new Object[]{info.getNumber(), new Integer(acctInfoBeforeModify.getControlLevel())});
        }
    }

    protected void setPropertiesWhenHasInferior(Context ctx, PcAccountViewInfo acctInfo, PcAccountViewInfo oldAcctInfo) throws EASBizException, BOSException {
        if (oldAcctInfo == null || acctInfo.getId() == null || acctInfo.getId().toString().length() < 1) {
            return;
        }
        boolean isHasInferior = PcAccountTools.checkAccountHasInferior(ctx, acctInfo);
        boolean hasChanged = false;
        if (acctInfo.getHelpCode() == null && oldAcctInfo.getHelpCode() != null || acctInfo.getHelpCode() != null && oldAcctInfo.getHelpCode() == null || acctInfo.getHelpCode() != null && oldAcctInfo.getHelpCode() != null && !acctInfo.getHelpCode().equals(oldAcctInfo.getHelpCode())) {
            hasChanged = true;
        }
        if (!hasChanged) {
            return;
        }
        if (isHasInferior) {
            PcAccountViewInfo standardInfo = oldAcctInfo;
            acctInfo.setHelpCode(standardInfo.getHelpCode());
        }
    }

    protected void setParentProperties(Context ctx, PcAccountViewInfo accountViewInfo, PcAccountViewInfo oldAcctInfo, PcAccountViewInfo parent) throws EASBizException, BOSException {
        if (accountViewInfo.getParent() == null) {
            accountViewInfo.setLevel(1);
            accountViewInfo.setLongName(accountViewInfo.getName());
            accountViewInfo.setLongName(accountViewInfo.getName(locale_L1), locale_L1);
            accountViewInfo.setLongName(accountViewInfo.getName(locale_L2), locale_L2);
            accountViewInfo.setLongName(accountViewInfo.getName(locale_L3), locale_L3);
            accountViewInfo.setLongNumber(accountViewInfo.getNumber());
            return;
        }
        if (accountViewInfo.getId() == null || accountViewInfo.getId().toString().length() < 1) {
            if (parent.isIsCFreeze()) {
                throw new PcAccountException(PcAccountException.PARENTISFROZEWHENADDNEW);
            }
        } else {
            accountViewInfo.setIsCFreeze(parent.isIsCFreeze());
            accountViewInfo.setIsGFreeze(parent.isIsGFreeze());
            accountViewInfo.setIsParentFreeze(parent.isIsParentFreeze() || parent.isIsSelfFreeze());
        }
        if (!accountViewInfo.getProfitCenterID().getId().toString().equals(parent.getProfitCenterID().getId().toString())) {
            throw new PcAccountException(PcAccountException.CHILDCOMPANYMUSTEQUALPARENTCOMPANY, new Object[]{accountViewInfo.getNumber()});
        }
        accountViewInfo.setPcAccountTypeID(parent.getPcAccountTypeID());
        accountViewInfo.setIsCash(parent.isIsCash());
        accountViewInfo.setIsBank(parent.isIsBank());
        accountViewInfo.setIsCashEquivalent(parent.isIsCashEquivalent());
        if (parent.getControl().getValue() != 0) {
            accountViewInfo.setControl(parent.getControl());
        }
        accountViewInfo.setPLType(parent.getPLType());
        accountViewInfo.setParentAA(parent.getCAA());
        if (accountViewInfo.getUpper() == null && accountViewInfo.getCAA() == null) {
            accountViewInfo.setCAA(parent.getCAA());
        }
        if (accountViewInfo.getParentAA() != null && accountViewInfo.getCAA() == null) {
            accountViewInfo.setCAA(accountViewInfo.getParentAA());
        }
        accountViewInfo.setLongNumber(parent.getLongNumber() + "!" + accountViewInfo.getNumber());
        accountViewInfo.setLongName(parent.getLongName() + "_" + accountViewInfo.getName());
        accountViewInfo.setLongName(parent.getLongName(locale_L1) + "_" + accountViewInfo.getName(locale_L1), locale_L1);
        accountViewInfo.setLongName(parent.getLongName(locale_L2) + "_" + accountViewInfo.getName(locale_L2), locale_L2);
        accountViewInfo.setLongName(parent.getLongName(locale_L3) + "_" + accountViewInfo.getName(locale_L3), locale_L3);
        if (parent.isIsQty()) {
            accountViewInfo.setIsQty(true);
            if (accountViewInfo.getMeasureUnitGroup() == null || accountViewInfo.getMeasureUnitGroup().getId().toString().length() < 1) {
                accountViewInfo.setMeasureUnitGroup(parent.getMeasureUnitGroup());
            }
            if (accountViewInfo.getMeasureUnitID() == null || accountViewInfo.getMeasureUnitID().getId().toString().length() < 1) {
                accountViewInfo.setMeasureUnitID(parent.getMeasureUnitID());
            }
        }
        if (parent.isAC()) {
            accountViewInfo.setAC(true);
        }
        if (parent.isACNotice()) {
            accountViewInfo.setACNotice(true);
        }
        if (parent.isBw()) {
            accountViewInfo.setBw(true);
        }
        if (parent.isIsChangeCurrency()) {
            accountViewInfo.setIsChangeCurrency(true);
        }
        if (!(parent.getBorrowerMainCashFlowItem() == null || accountViewInfo.getBorrowerMainCashFlowItem() != null && accountViewInfo.getBorrowerMainCashFlowItem().getId().toString().equals(parent.getBorrowerMainCashFlowItem().getId().toString()))) {
            throw new PcAccountException(PcAccountException.CHILD_PARENT_MAIN_ITEM_DIFF);
        }
        if (!(parent.getBorrowerAttCashFlowItemID() == null || accountViewInfo.getBorrowerAttCashFlowItemID() != null && accountViewInfo.getBorrowerAttCashFlowItemID().getId().toString().equals(parent.getBorrowerAttCashFlowItemID().getId().toString()))) {
            throw new PcAccountException(PcAccountException.CHILD_PARENT_ATT_ITEM_DIFF);
        }
        if (!(parent.getLenderMainCashFl() == null || accountViewInfo.getLenderMainCashFl() != null && accountViewInfo.getLenderMainCashFl().getId().toString().equals(parent.getLenderMainCashFl().getId().toString()))) {
            throw new PcAccountException(PcAccountException.CHILD_PARENT_MAIN_ITEM_DIFF);
        }
        if (!(parent.getLenderAttCashFlowItemID() == null || accountViewInfo.getLenderAttCashFlowItemID() != null && accountViewInfo.getLenderAttCashFlowItemID().getId().toString().equals(parent.getLenderAttCashFlowItemID().getId().toString()))) {
            throw new PcAccountException(PcAccountException.CHILD_PARENT_ATT_ITEM_DIFF);
        }
    }

    protected void setUpperProperties(Context ctx, PcAccountViewInfo acctInfo, PcAccountViewInfo oldAcctInfo, PcAccountViewInfo upper, boolean isAssign) throws EASBizException, BOSException {
        PcAccountViewInfo child;
        if (oldAcctInfo == null && acctInfo.getUpper() == null || oldAcctInfo != null && oldAcctInfo.getUpper() == null) {
            return;
        }
        acctInfo.setNumber(upper.getNumber());
        acctInfo.setName(upper.getName());
        acctInfo.setPcAccountTypeID(upper.getPcAccountTypeID());
        acctInfo.setIsCash(upper.isIsCash());
        acctInfo.setIsBank(upper.isIsBank());
        acctInfo.setIsCashEquivalent(upper.isIsCashEquivalent());
        acctInfo.setGAA(upper.getCAA());
        acctInfo.setPLType(upper.getPLType());
        if (acctInfo.getParent() == null && acctInfo.getCAA() == null && upper.getCAA() != null) {
            throw new PcAccountException(PcAccountException.CAANOTINCLUDEGAA, new Object[]{acctInfo.getNumber()});
        }
        if (acctInfo.getParent() == null && acctInfo.getCAA() == null) {
            acctInfo.setCAA(upper.getCAA());
        }
        acctInfo.setIsGFreeze(upper.isIsCFreeze());
        PcAccount_ControlInfo acctCtrlInfo = PcAccountTools.getAcctCtrlInfo(ctx, acctInfo.getPcAccountTableID(), acctInfo.getProfitCenterID());
        if (acctCtrlInfo == null) {
            return;
        }
        if (acctCtrlInfo.getDc() == 1) {
            acctInfo.setDC(upper.getDC());
        }
        if (acctCtrlInfo.getControl() == 1) {
            acctInfo.setControl(upper.getControl());
        }
        if (acctCtrlInfo.getIsQty() == 1 && upper.isIsQty()) {
            acctInfo.setIsQty(true);
            if (acctInfo.getMeasureUnitGroup() == null || acctInfo.getMeasureUnitGroup().getId().toString().length() < 1) {
                acctInfo.setMeasureUnitGroup(upper.getMeasureUnitGroup());
            }
            if (acctInfo.getMeasureUnitID() == null || acctInfo.getMeasureUnitID().getId().toString().length() < 1) {
                acctInfo.setMeasureUnitID(upper.getMeasureUnitID());
            }
        }
        if (acctCtrlInfo.getAc() == 1 && upper.isAC()) {
            acctInfo.setAC(upper.isAC());
        }
        if (acctCtrlInfo.getAcNotice() == 1 && upper.isACNotice()) {
            acctInfo.setACNotice(upper.isACNotice());
        }
        if (acctCtrlInfo.getBw() == 1 && upper.isBw()) {
            acctInfo.setBw(upper.isBw());
        }
        if (acctCtrlInfo.getIsChangeCurrency() == 1 && upper.isIsChangeCurrency()) {
            acctInfo.setIsChangeCurrency(upper.isIsChangeCurrency());
        }
        if (isAssign) {
            return;
        }
        PcAccountViewCollection acctCol = null;
        if (!acctInfo.isIsLeaf()) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection seleColl = new SelectorItemCollection();
            seleColl.add(new SelectorItemInfo("borrowerMainCashFlowItem"));
            seleColl.add(new SelectorItemInfo("borrowerAttCashFlowItemID"));
            seleColl.add(new SelectorItemInfo("lenderMainCashFl"));
            seleColl.add(new SelectorItemInfo("lenderAttCashFlowItemID"));
            seleColl.add(new SelectorItemInfo("upper.borrowerMainCashFlowItem"));
            seleColl.add(new SelectorItemInfo("upper.borrowerAttCashFlowItemID"));
            seleColl.add(new SelectorItemInfo("upper.lenderMainCashFl"));
            seleColl.add(new SelectorItemInfo("upper.lenderAttCashFlowItemID"));
            viewInfo.setSelector(seleColl);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(acctInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)acctInfo.getPcAccountTableID().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("profitCenterID", (Object)acctInfo.getProfitCenterID().getId().toString()));
            viewInfo.setFilter(filter);
            acctCol = this.getPcAccountsByDAO(ctx, viewInfo);
        }
        if (upper.getBorrowerMainCashFlowItem() != null) {
            if (acctInfo.getBorrowerMainCashFlowItem() == null || !upper.getBorrowerMainCashFlowItem().getId().toString().equals(acctInfo.getBorrowerMainCashFlowItem().getId().toString())) {
                throw new PcAccountException(PcAccountException.NOT_MATCH_UPPER_MAINCASHFLOWITEM);
            }
        } else if (!acctInfo.isIsLeaf() && acctInfo.getBorrowerMainCashFlowItem() != null && acctCol != null && acctCol.size() > 0) {
            for (int i = 0; i < acctCol.size(); ++i) {
                child = acctCol.get(i);
                if (child == null || child.getUpper() == null || child.getBorrowerMainCashFlowItem() == null || child.getUpper().getBorrowerMainCashFlowItem() == null || child.getBorrowerMainCashFlowItem().getId().toString().equals(acctInfo.getBorrowerMainCashFlowItem().getId().toString())) continue;
                throw new PcAccountException(PcAccountException.NOT_MATCH_CHILD_BORMAINCASHFLOW);
            }
        }
        if (upper.getBorrowerAttCashFlowItemID() != null) {
            if (acctInfo.getBorrowerAttCashFlowItemID() == null || !upper.getBorrowerAttCashFlowItemID().getId().toString().equals(acctInfo.getBorrowerAttCashFlowItemID().getId().toString())) {
                throw new AccountException(AccountException.NOT_MATCH_UPPER_ATTCASHFLOWITEM);
            }
        } else if (!acctInfo.isIsLeaf() && acctInfo.getBorrowerAttCashFlowItemID() != null && acctCol != null && acctCol.size() > 0) {
            for (int i = 0; i < acctCol.size(); ++i) {
                child = acctCol.get(i);
                if (child == null || child.getUpper() == null || child.getBorrowerAttCashFlowItemID() == null || child.getUpper().getBorrowerAttCashFlowItemID() == null || child.getBorrowerAttCashFlowItemID().getId().toString().equals(acctInfo.getBorrowerAttCashFlowItemID().getId().toString())) continue;
                throw new PcAccountException(PcAccountException.NOT_MATCH_CHILD_BORATTCASHFLOW);
            }
        }
        if (upper.getLenderMainCashFl() != null) {
            if (acctInfo.getLenderMainCashFl() == null || !upper.getLenderMainCashFl().getId().toString().equals(acctInfo.getLenderMainCashFl().getId().toString())) {
                throw new PcAccountException(PcAccountException.NOT_MATCH_UPPER_MAINCASHFLOWITEM);
            }
        } else if (!acctInfo.isIsLeaf() && acctInfo.getLenderMainCashFl() != null && acctCol != null && acctCol.size() > 0) {
            for (int i = 0; i < acctCol.size(); ++i) {
                child = acctCol.get(i);
                if (child == null || child.getUpper() == null || child.getMainCashFlowItem() == null || child.getUpper().getMainCashFlowItem() == null || child.getMainCashFlowItem().getId().toString().equals(acctInfo.getLenderMainCashFl().getId().toString())) continue;
                throw new PcAccountException(PcAccountException.NOT_MATCH_CHILD_LENDERMAINCASHFLOW);
            }
        }
        if (upper.getLenderAttCashFlowItemID() != null) {
            if (acctInfo.getLenderAttCashFlowItemID() == null || !upper.getLenderAttCashFlowItemID().getId().toString().equals(acctInfo.getLenderAttCashFlowItemID().getId().toString())) {
                throw new PcAccountException(PcAccountException.NOT_MATCH_UPPER_ATTCASHFLOWITEM);
            }
        } else if (!acctInfo.isIsLeaf() && acctInfo.getLenderAttCashFlowItemID() != null && acctCol != null && acctCol.size() > 0) {
            for (int i = 0; i < acctCol.size(); ++i) {
                child = acctCol.get(i);
                if (child == null || child.getUpper() == null || child.getLenderAttCashFlowItemID() == null || child.getUpper().getLenderAttCashFlowItemID() == null || child.getLenderAttCashFlowItemID().getId().toString().equals(acctInfo.getLenderAttCashFlowItemID().getId().toString())) continue;
                throw new PcAccountException(PcAccountException.NOT_MATCH_CHILD_LENDERATTCASHFLOW);
            }
        }
    }

    protected void setPropertiesAccordToOtherRule(Context ctx, PcAccountViewInfo acctInfo, PcAccountViewInfo oldAcctInfo, boolean isAssign) throws EASBizException, BOSException {
        this.checkAccountCurrency(ctx, acctInfo);
        this.checkQuantity(acctInfo);
        this.checkPLType(ctx, acctInfo);
    }

    protected void checkPLType(Context ctx, PcAccountViewInfo account) throws AccountException, EASBizException, BOSException {
        PcAccountTypeInfo accountTypeInfo = null;
        accountTypeInfo = PcAccountTypeFactory.getLocalInstance(ctx).getPcAccountTypeInfo((IObjectPK)new ObjectUuidPK(account.getPcAccountTypeID().getId()));
        if (accountTypeInfo.getProperty() == PcAccountProperty.SUNYI) {
            if (account.getPLType() == PcAccountPLType.NONE) {
                throw new PcAccountException(PcAccountException.PLTYPE_PCACCOUNT_MUST_PLTYPE, new Object[]{account.getNumber()});
            }
        } else if (account.getPLType() != PcAccountPLType.NONE) {
            throw new PcAccountException(PcAccountException.NOPLTYPEMUSTNONEPLTYPE, new Object[]{account.getNumber()});
        }
    }

    protected void checkProfitAuxAccount(Context ctx, PcAccountViewInfo account) throws BOSException, EASBizException {
        IRowSet rowset;
        String sql;
        String caa;
        if (account.isAC()) {
            if (account.getCAA() == null) {
                throw new PcAccountException(PcAccountException.AC_MUST_HAS_GCA);
            }
            caa = account.getCAA().getId().toString();
            sql = "select FasstHGAttribute from t_bd_asstacttype  a  left join T_BD_AsstActTypeDefault b  on a.fid=b.fasstacttypeid where b.FCompanyID=? and b.fisaccountcussent=1 and  a.fid in ( select fasstacttypeid from t_bd_asstactgroupdetail where fasstaccountid =? )";
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{account.getProfitCenterID().getId().toString(), caa});
            try {
                if (rowset == null || !rowset.next()) {
                    ProfitCenterOrgUnitInfo companyOrgUnitInfo = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(account.getProfitCenterID().getId()));
                    throw new PcAccountException(PcAccountException.CAAMUSTASSTBUTE, new Object[]{account.getNumber(), companyOrgUnitInfo.getNumber()});
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (account.isACNotice()) {
            if (account.getCAA() == null) {
                throw new PcAccountException(PcAccountException.ACNOTICE_MUST_HAS_GCA);
            }
            caa = account.getCAA().getId().toString();
            sql = "select FasstHGAttribute from t_bd_asstacttype where  fid in ( select fasstacttypeid from t_bd_asstactgroupdetail where \tfasstaccountid =? )";
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{caa});
            boolean hasCPS = false;
            try {
                while (rowset != null && rowset.next()) {
                    String asstHGAttribute = rowset.getString("FasstHGAttribute");
                    if (!"customer".equals(asstHGAttribute) && !"companyOrg".equals(asstHGAttribute) && !"provider".equals(asstHGAttribute)) continue;
                    hasCPS = true;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            if (!hasCPS) {
                throw new PcAccountException(PcAccountException.CAAMUSTCSP, new Object[]{account.getNumber()});
            }
        }
    }

    protected void checkQuantity(PcAccountViewInfo accountViewInfo) throws BOSException, EASBizException {
        if (accountViewInfo.isIsQty()) {
            if (accountViewInfo.getMeasureUnitGroup() == null || accountViewInfo.getMeasureUnitID() == null) {
                throw new PcAccountException(PcAccountException.ISQTY_MEASUREUNIT);
            }
        } else {
            accountViewInfo.setMeasureUnitGroup(null);
            accountViewInfo.setMeasureUnitID(null);
        }
    }

    protected void checkAccountCurrency(Context ctx, PcAccountViewInfo acctInfo) throws BOSException, EASBizException {
        PcAccount_ControlInfo acctCtrlInfo;
        int i;
        if (acctInfo.getAccountingCurrency() == PcAccountingCurrencyEnum.ONECURRENCY && (acctInfo.getPcAccountCurrency() == null || acctInfo.getPcAccountCurrency().size() < 1)) {
            throw new PcAccountException(PcAccountException.MUSTHASCURRENCY, new Object[]{acctInfo.getNumber()});
        }
        ArrayList<String> currencyIdList = new ArrayList<String>();
        PcAccountCurrencyCollection acctCuDetails = acctInfo.getPcAccountCurrency();
        if (acctCuDetails != null) {
            int count = acctCuDetails.size();
            for (int i2 = 0; i2 < count; ++i2) {
                currencyIdList.add(acctCuDetails.get(i2).getCurrency().getId().toString());
            }
        }
        if (acctInfo.getId() != null && acctInfo.getId().toString().length() > 1) {
            try {
                String sqlToGetAccountingCurrency = "SELECT TOP 1 Fnumber FROM T_BD_PCACCOUNTVIEW WHERE FPARENTID=? AND FAcctCurrency>?";
                IRowSet rsToGetAccountingCurrency = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAccountingCurrency, (Object[])new Object[]{acctInfo.getId().toString(), new Integer(acctInfo.getAccountingCurrency().getValue())});
                if (rsToGetAccountingCurrency != null && rsToGetAccountingCurrency.next()) {
                    String number = rsToGetAccountingCurrency.getString("Fnumber");
                    throw new PcAccountException(PcAccountException.PCACCOUNTCURRENCYPOLICYWITHPARENT, new Object[]{number});
                }
                sqlToGetAccountingCurrency = "SELECT TOP 1 Fnumber FROM T_BD_PCACCOUNTVIEW WHERE FUpperID=? AND FAcctCurrency>?";
                rsToGetAccountingCurrency = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAccountingCurrency, (Object[])new Object[]{acctInfo.getId().toString(), new Integer(acctInfo.getAccountingCurrency().getValue())});
                if (rsToGetAccountingCurrency != null && rsToGetAccountingCurrency.next()) {
                    String number = rsToGetAccountingCurrency.getString("Fnumber");
                    throw new PcAccountException(PcAccountException.ACCTCURRENCYPOLICYWITHUPPER, new Object[]{number});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (acctInfo.getAccountingCurrency() == PcAccountingCurrencyEnum.ONECURRENCY) {
                String number;
                String currencyId;
                String sql = "SELECT DISTINCT ACCTCU.FCurrencyID,ACCT.FNUMBER FROM T_BD_PCACCOUNTVIEW ACCT JOIN T_BD_PCACCOUNTCURRENCY ACCTCU ON ACCT.FID=ACCTCU.FPcAccountViewID WHERE ACCT.FPARENTID=?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{acctInfo.getId().toString()});
                if (rs != null) {
                    try {
                        while (rs.next()) {
                            currencyId = rs.getString("FCurrencyID");
                            number = rs.getString("Fnumber");
                            if (currencyIdList.contains(currencyId)) continue;
                            throw new PcAccountException(PcAccountException.PCACCOUNTCURRENCYPOLICYWITHPARENT, new Object[]{number});
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if ((rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT DISTINCT ACCTCU.FCurrencyID ,ACCT.FNUMBER FROM T_BD_PCACCOUNTVIEW ACCT JOIN T_BD_ACCOUNTCURRENCY ACCTCU ON ACCT.FID=ACCTCU.FPcAccountViewID WHERE ACCT.FUPPERID=?"), (Object[])new Object[]{acctInfo.getId().toString()})) != null) {
                    try {
                        while (rs.next()) {
                            currencyId = rs.getString("FCurrencyID");
                            number = rs.getString("Fnumber");
                            if (currencyIdList.contains(currencyId)) continue;
                            throw new PcAccountException(PcAccountException.ACCTCURRENCYPOLICYWITHUPPER, new Object[]{number});
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
        }
        if (acctInfo.getParent() != null && acctInfo.getAccountingCurrency().getValue() >= 1) {
            String queryCurrency = "SELECT tmp.currencycount AS COUNT, (SELECT facctcurrency FROM T_BD_PCACCOUNTVIEW WHERE fid = '" + acctInfo.getParent().getId().toString() + "') AS facctcurrency FROM (" + "SELECT count(a.fcurrencyid) as currencycount FROM T_BD_PcAccountCurrency a WHERE a.FPcAccountViewID ='" + acctInfo.getParent().getId().toString() + "' ";
            int size = acctInfo.getPcAccountCurrency().size();
            for (i = 0; i < size; ++i) {
                queryCurrency = queryCurrency + (i == 0 ? " and a.fcurrencyid IN ('" + acctInfo.getPcAccountCurrency().get(i).getCurrency().getId().toString() + "'" : " ,'" + acctInfo.getPcAccountCurrency().get(i).getCurrency().getId().toString() + "'");
                queryCurrency = queryCurrency + (i == size - 1 ? " ) " : "");
            }
            queryCurrency = queryCurrency + " ) tmp ";
            try {
                IRowSet hasCurrency = DbUtil.executeQuery((Context)ctx, (String)queryCurrency);
                if (hasCurrency.next()) {
                    int count = hasCurrency.getInt(1);
                    int accountingcurrency = hasCurrency.getInt(2);
                    if (accountingcurrency < 2 && count < acctInfo.getPcAccountCurrency().size()) {
                        throw new PcAccountException(PcAccountException.PCACCOUNTCURRENCYPOLICYWITHPARENT, new Object[]{acctInfo.getNumber()});
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (acctInfo.getUpper() != null && acctInfo.getAccountingCurrency().getValue() >= 1) {
            String queryCurrency = "SELECT tmp.currencycount AS COUNT, (SELECT facctcurrency FROM T_BD_PCACCOUNTVIEW WHERE fid = '" + acctInfo.getUpper().getId().toString() + "') AS facctcurrency FROM (" + "SELECT count(a.fcurrencyid) as currencycount FROM T_BD_PcAccountCurrency a WHERE a.FPcAccountViewID ='" + acctInfo.getUpper().getId().toString() + "' ";
            int size = acctInfo.getPcAccountCurrency().size();
            for (i = 0; i < size; ++i) {
                queryCurrency = queryCurrency + (i == 0 ? " and a.fcurrencyid IN ('" + acctInfo.getPcAccountCurrency().get(i).getCurrency().getId().toString() + "'" : " ,'" + acctInfo.getPcAccountCurrency().get(i).getCurrency().getId().toString() + "'");
                queryCurrency = queryCurrency + (i == size - 1 ? " ) " : "");
            }
            queryCurrency = queryCurrency + " ) tmp ";
            try {
                IRowSet hasCurrency = DbUtil.executeQuery((Context)ctx, (String)queryCurrency);
                if (hasCurrency.next()) {
                    int count = hasCurrency.getInt(1);
                    int accountingcurrency = hasCurrency.getInt(2);
                    if (accountingcurrency < 2 && count < acctInfo.getPcAccountCurrency().size()) {
                        throw new PcAccountException(PcAccountException.ACCTCURRENCYPOLICYWITHUPPER, new Object[]{acctInfo.getNumber()});
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if ((acctCtrlInfo = PcAccountTools.getAcctCtrlInfo(ctx, acctInfo.getPcAccountTableID(), acctInfo.getProfitCenterID())) == null) {
            return;
        }
        if (acctCtrlInfo.getCurrencyID() == 1 && acctInfo.getUpper() != null && acctInfo.getAccountingCurrency().getValue() >= 1) {
            PcAccountViewInfo upper = acctInfo.getUpper();
            if (acctCtrlInfo.getCurrencyID() == 1) {
                int i3;
                if (acctInfo.getAccountingCurrency().getValue() != upper.getAccountingCurrency().getValue()) {
                    throw new PcAccountException(PcAccountException.PCACCOUNTCURRENCYPOLICYWITHUPPER);
                }
                ArrayList<String> upperAcctCurrencyIdList = new ArrayList<String>();
                if (upper.getPcAccountCurrency() != null) {
                    PcAccountCurrencyCollection upperAcctCu = upper.getPcAccountCurrency();
                    int count = upperAcctCu.size();
                    for (int i4 = 0; i4 < count; ++i4) {
                        PcAccountCurrencyInfo acctCuDetailInfo = upperAcctCu.get(i4);
                        if (acctCuDetailInfo == null || acctCuDetailInfo.getCurrency().getId() == null || acctCuDetailInfo.getCurrency().getId().toString().length() <= 0) continue;
                        upperAcctCurrencyIdList.add(acctCuDetailInfo.getCurrency().getId().toString());
                    }
                }
                int count = currencyIdList.size();
                for (i3 = 0; i3 < count; ++i3) {
                    if (upperAcctCurrencyIdList.contains(currencyIdList.get(i3))) continue;
                    throw new PcAccountException(PcAccountException.PCACCOUNTCURRENCYPOLICYWITHUPPER);
                }
                count = upperAcctCurrencyIdList.size();
                for (i3 = 0; i3 < count; ++i3) {
                    if (currencyIdList.contains(upperAcctCurrencyIdList.get(i3))) continue;
                    throw new PcAccountException(PcAccountException.PCACCOUNTCURRENCYPOLICYWITHUPPER);
                }
            }
        }
    }

    protected int compareAccountCurrency(PcAccountViewInfo newInfo, PcAccountViewInfo oldInfo) {
        int result = 0;
        if (newInfo.getAccountingCurrency().getValue() > oldInfo.getAccountingCurrency().getValue()) {
            result = 1;
        } else if (newInfo.getAccountingCurrency().getValue() < oldInfo.getAccountingCurrency().getValue()) {
            result = -1;
        } else if (newInfo.getAccountingCurrency() == PcAccountingCurrencyEnum.ONECURRENCY) {
            int i;
            int size;
            PcAccountCurrencyCollection acctCurCols;
            ArrayList<String> newCurrencyIdList = new ArrayList<String>();
            ArrayList<String> oldCurrencyIdList = new ArrayList<String>();
            if (newInfo.getPcAccountCurrency() != null) {
                acctCurCols = newInfo.getPcAccountCurrency();
                size = acctCurCols.size();
                for (i = 0; i < size; ++i) {
                    newCurrencyIdList.add(acctCurCols.get(i).getCurrency().getId().toString());
                }
            }
            if (oldInfo.getPcAccountCurrency() != null) {
                acctCurCols = oldInfo.getPcAccountCurrency();
                size = acctCurCols.size();
                for (i = 0; i < size; ++i) {
                    oldCurrencyIdList.add(acctCurCols.get(i).getCurrency().getId().toString());
                }
            }
            result = newCurrencyIdList.size() == oldCurrencyIdList.size() && newCurrencyIdList.containsAll(oldCurrencyIdList) ? 0 : (newCurrencyIdList.containsAll(oldCurrencyIdList) ? 1 : (oldCurrencyIdList.containsAll(newCurrencyIdList) ? -1 : -2));
        }
        return result;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PcAccountViewInfo pcacctInfo = (PcAccountViewInfo)model;
        boolean isAc = pcacctInfo.isAC();
        PcAccountViewInfo oldPcAcctInfo = (PcAccountViewInfo)super._getValue(ctx, (IObjectPK)new ObjectUuidPK(pcacctInfo.getId().toString()));
        PcAccountViewInfo parentInfo = null;
        if (oldPcAcctInfo.getParent() != null && oldPcAcctInfo.getParent().getId() != null && oldPcAcctInfo.getParent().getId().toString().length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("pcaccountTypeID.property");
            sic.add("pcaccountCurrency.*");
            parentInfo = this.getPcAccountViewInfo(ctx, (IObjectPK)new ObjectUuidPK(oldPcAcctInfo.getParent().getId()), sic);
        }
        PcAccountViewInfo upperInfo = null;
        if (oldPcAcctInfo.getUpper() != null && oldPcAcctInfo.getUpper().getId() != null && oldPcAcctInfo.getUpper().getId().toString().length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("pcaccountTypeID.property");
            sic.add("pcaccountCurrency.*");
            upperInfo = this.getPcAccountViewInfo(ctx, (IObjectPK)new ObjectUuidPK(oldPcAcctInfo.getUpper().getId()), sic);
            pcacctInfo.setUpper(upperInfo);
        }
        this.attributeCheck(ctx, pcacctInfo, oldPcAcctInfo, false);
        pcacctInfo.setRefId("test");
        super._update(ctx, pk, (IObjectValue)pcacctInfo);
        if (!(pcacctInfo.getCAA() == null || oldPcAcctInfo.getCAA() != null && oldPcAcctInfo.getCAA().getId().equals((Object)pcacctInfo.getCAA().getId()))) {
            this.handleAstInitClosed(ctx, pcacctInfo);
        }
        pcacctInfo.setRefId(null);
        PinYinHelper.generatePinYin((Context)ctx, (String)"com.kingdee.eas.basedata.pcacct.app.PcAccountView", (String[])pk.toString().split(""));
    }

    private void handleAstInitClosed(Context ctx, PcAccountViewInfo acctInfo) throws BOSException {
        if (acctInfo == null || acctInfo.getCAA() == null) {
            return;
        }
        if (!acctInfo.getProfitCenterID().isIsBizUnit()) {
            try {
                ProfitCenterOrgUnitInfo profitCenter = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctInfo.getProfitCenterID().getId()));
                if (!profitCenter.isIsBizUnit()) {
                    return;
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
        }
        if (!acctInfo.isIsLeaf()) {
            return;
        }
        String accountID = acctInfo.getId().toString();
        String accountTableID = acctInfo.getPcAccountTableID().getId().toString();
        String currentProfitCenterID = acctInfo.getProfitCenterID().getId().toString();
        String caaID = acctInfo.getCAA().getId().toString();
    }

    protected void setInnerAddnewProperties(Context ctx, PcAccountViewInfo accountViewInfo, PcAccountViewInfo parentInfo) {
        accountViewInfo.setLevel(parentInfo.getLevel() + 1);
        accountViewInfo.setLongNumber(parentInfo.getLongNumber() + "!" + accountViewInfo.getNumber());
        accountViewInfo.setIsLeaf(true);
        UserInfo user = this.getUserInfo(ctx);
        accountViewInfo.setCreator(user);
        accountViewInfo.setLastUpdateUser(user);
        long time = new Date().getTime();
        accountViewInfo.setCreateTime(new Timestamp(time));
        accountViewInfo.setLastUpdateTime(new Timestamp(time));
    }

    protected UserInfo getUserInfo(Context ctx) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    protected PcAccountViewInfo getParentPcAccount(Context ctx, PcAccountViewInfo vo, PcAccountTableInfo table) throws EASBizException, BOSException {
        PcAccountViewInfo parent = null;
        String parentNum = this.getParentNum(vo, table);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Number", (Object)parentNum, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)table.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("profitCenterID", (Object)vo.getProfitCenterID().getId().toString()));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        PcAccountViewCollection pcAccounts = this.getPcAccountsByDAO(ctx, evi);
        if (pcAccounts != null && pcAccounts.size() > 0) {
            parent = pcAccounts.get(0);
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PcAccountViewCollection getPcAccountsByDAO(Context ctx, EntityViewInfo evi) throws BOSException, EASBizException {
        PcAccountViewCollection pcAccounts = new PcAccountViewCollection();
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            pcAccounts = (PcAccountViewCollection)super.getDAO(ctx, cn).getCollection(evi);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return pcAccounts;
    }

    protected String getParentNum(PcAccountViewInfo model, PcAccountTableInfo table) {
        String num;
        block2: {
            int levelLen;
            int len;
            int index;
            block1: {
                num = null;
                index = 0;
                len = 0;
                levelLen = 0;
                if (!table.isIsUseSeparator()) break block1;
                index = model.getNumber().lastIndexOf(table.getSeparator());
                if (index <= 0) break block2;
                num = model.getNumber().substring(0, index);
                break block2;
            }
            for (int i = 0; i < table.getUserLevel().size(); ++i) {
                if ((len += table.getUserLevel().get(i).getLength()) != model.getNumber().length()) continue;
                index = i;
                levelLen = len - table.getUserLevel().get(i).getLength();
                num = model.getNumber().substring(0, levelLen);
                break;
            }
        }
        return num;
    }

    protected void attributeCheck(Context ctx, PcAccountViewInfo pcAccountViewInfo, PcAccountViewInfo oldPcAcctInfo, boolean isAssign) throws EASBizException, BOSException {
        boolean isSelfConstructed;
        if (!isAssign) {
            this.updateMLName(ctx, pcAccountViewInfo, oldPcAcctInfo);
            super._checkNameBlank(ctx, (IObjectValue)pcAccountViewInfo);
            super._checkNumberBlank(ctx, (IObjectValue)pcAccountViewInfo);
            if (pcAccountViewInfo.getPcAccountTypeID() == null) {
                throw new PcAccountException(PcAccountException.ACCOUNT_TYPE_CANNOT_NULL);
            }
            this.checkNumberIsAppropriate(ctx, pcAccountViewInfo);
            this.checkHelpCodeDup(ctx, pcAccountViewInfo);
        }
        this._checkNumberDup(ctx, (IObjectValue)pcAccountViewInfo);
        if (oldPcAcctInfo != null) {
            String originalParentId = null;
            String parentId = null;
            originalParentId = oldPcAcctInfo.getId().toString();
            parentId = pcAccountViewInfo.getId().toString();
            if (!PcAccountTools.isStringEqual(parentId, originalParentId)) {
                throw new PcAccountException(PcAccountException.PARENT_POSITION_NOT_ALLOW_CHANGED);
            }
        }
        this.checkCashBankCashEquivalentCashFlow(ctx, pcAccountViewInfo);
        if (oldPcAcctInfo != null && pcAccountViewInfo != null && pcAccountViewInfo.getPcAccountTypeID() != null && oldPcAcctInfo.getPcAccountTypeID() != null && !pcAccountViewInfo.getPcAccountTypeID().getId().toString().equals(oldPcAcctInfo.getPcAccountTypeID().getId().toString()) && !(isSelfConstructed = PcAccountTools.checkAccountTableIsSelfConstructed(ctx, pcAccountViewInfo.getProfitCenterID(), pcAccountViewInfo.getPcAccountTableID()))) {
            throw new PcAccountException(PcAccountException.ACCOUNTTYPECANTCHANGE);
        }
        if (pcAccountViewInfo != null && oldPcAcctInfo != null) {
            pcAccountViewInfo.setIsGFreeze(oldPcAcctInfo.isIsGFreeze());
            pcAccountViewInfo.setIsParentFreeze(oldPcAcctInfo.isIsParentFreeze());
            pcAccountViewInfo.setIsSelfFreeze(oldPcAcctInfo.isIsSelfFreeze());
            pcAccountViewInfo.setIsCFreeze(oldPcAcctInfo.isIsCFreeze());
        }
    }

    protected void checkNumberIsAppropriate(Context ctx, PcAccountViewInfo pcAccountViewInfo) {
    }

    protected boolean checkCashBankCashEquivalentCashFlow(Context ctx, PcAccountViewInfo model) throws EASBizException, BOSException {
        boolean ret = false;
        if (model == null) {
            return true;
        }
        if (model.isIsCash() && model.isIsBank() || model.isIsCash() && model.isIsCashEquivalent() || model.isIsBank() && model.isIsCashEquivalent()) {
            throw new PcAccountException(PcAccountException.ACCOUNTATTRIBUTEERROR, new Object[]{model.getNumber()});
        }
        if ((model.isIsCash() || model.isIsBank() || model.isIsCashEquivalent()) && (model.getBorrowerMainCashFlowItem() != null || model.getBorrowerAttCashFlowItemID() != null || model.getLenderMainCashFl() != null || model.getLenderAttCashFlowItemID() != null)) {
            throw new PcAccountException(PcAccountException.CASHFLOWMUTEX);
        }
        return ret;
    }

    protected boolean checkHelpCodeDup(Context ctx, PcAccountViewInfo model) throws EASBizException, BOSException {
        boolean ret = false;
        if (model.getHelpCode() == null || model.getHelpCode().equals("")) {
            return true;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("helpCode", (Object)model.getHelpCode().trim()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)model.getPcAccountTableID().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)model.getProfitCenterID().getId().toString()));
        if (model.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.setMaskString("#0 and #1 and #2");
        }
        if (this._exists(ctx, filter)) {
            throw new PcAccountException(PcAccountException.DUPHELPCODE, new Object[]{model.getHelpCode()});
        }
        return ret;
    }

    private void updateMLName(Context ctx, PcAccountViewInfo acctInfo, PcAccountViewInfo oldAcctInfo) {
        Locale locale = ctx.getLocale();
        String currentName = acctInfo.getName(locale);
        String name_l1 = acctInfo.getName(LocaleUtils.locale_l1);
        String name_l2 = acctInfo.getName(LocaleUtils.locale_l2);
        String name_l3 = acctInfo.getName(LocaleUtils.locale_l3);
        if (oldAcctInfo != null) {
            String oldName_l1 = oldAcctInfo.getName(LocaleUtils.locale_l1);
            String oldName_l2 = oldAcctInfo.getName(LocaleUtils.locale_l2);
            String oldName_l3 = oldAcctInfo.getName(LocaleUtils.locale_l3);
            if (!"l1".equals(locale.toString()) && StringUtil.isEmpty((String)name_l1) && StringUtil.isEmpty((String)oldName_l1)) {
                acctInfo.put("name_l1", currentName);
            }
            if (!"l2".equals(locale.toString()) && StringUtil.isEmpty((String)name_l2) && StringUtil.isEmpty((String)oldName_l2)) {
                acctInfo.put("name_l2", currentName);
            }
            if (!"l3".equals(locale.toString()) && StringUtil.isEmpty((String)name_l3) && StringUtil.isEmpty((String)oldName_l3)) {
                acctInfo.put("name_l3", currentName);
            }
        } else {
            if (!"l1".equals(locale.toString()) && StringUtil.isEmpty((String)name_l1)) {
                acctInfo.put("name_l1", currentName);
            }
            if (!"l2".equals(locale.toString()) && StringUtil.isEmpty((String)name_l2)) {
                acctInfo.put("name_l2", currentName);
            }
            if (!"l3".equals(locale.toString()) && StringUtil.isEmpty((String)name_l3)) {
                acctInfo.put("name_l3", currentName);
            }
        }
    }

    @Override
    protected void _addPcAccountByProfitCenter(Context ctx, IObjectPK profitCenterPK) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateByProfitCenter(Context ctx, IObjectPK profitCenterPK, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateByProfitCenter(Context ctx, IObjectPK profitCenterPK, IObjectPK oldPcAccountTablePK, IObjectPK newPcAccountTablePK) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteByProfitCenter(Context ctx, IObjectPK profitCenterPK) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectCollection _getChildrenList(Context ctx, IObjectPK pk, IObjectPK profitCenterPK) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _getListByType(Context ctx, IObjectPK pcAccountTypePK, IObjectPK profitCenterPK) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _getListCAAIsNotNull(Context ctx, IObjectPK profitCenterPK, String pcAccountTableID) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected int _getMaxLevel(Context ctx, IObjectPK profitCenterPK) throws BOSException, EASBizException {
        return 0;
    }

    @Override
    protected int _getMaxGroupControlLevel(Context ctx, IObjectPK profitCenterPK) throws BOSException, EASBizException {
        return 0;
    }

    @Override
    protected boolean _isHasDeal(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _isHasDeal(Context ctx, IObjectPK pk, boolean isCheckChilden) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected void _addAccountByProfitCenter(Context ctx, IObjectValue profitCenterInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateGroupAccount(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateProfitCenterAccount(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _disablePcAccount(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _enablePcAccount(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _importAllGPcAccountsAsCPcAccounts(Context ctx, IObjectPK profitCenterPK) throws BOSException, EASBizException {
    }

    @Override
    protected void _importGPcAccountsAsCPcAccounts(Context ctx, IObjectPK profitCenterPK) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateDisperseModePcAccount(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectCollection _getGroupConrolPcAccountsByProfitCenter(Context ctx, IObjectPK profitCenterPK) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _checkProfitCenterAccounts(Context ctx, IObjectPK profitCenterPK) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IRowSet _checkAllAccounts(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _repairProfitCenterAccounts(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _getNonImportedGAsByProfitCenter(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _assignPcAccountToChild(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _referUpperPcAccount(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _updatePcAcctounProperties(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _getAllUpperAcctIdByCuAndTbl(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _getAllUpperAcctIdByCompanyAndTbl(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _batchGetAllUpperAcctIdByProfitCentersAndTbl(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _getAllPcAccountForAssign(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _getPcAccountColsFromExternalExcel(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _importPcAccountTemplate(Context ctx, String fileName, IObjectValue pcAcctTblInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void _importPcAccountTemplate(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _getAccountColsFromExternalExcel(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _submitSelf(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateSelf(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _getPcAccountForAssign(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _dataUpdate(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _updatePcAccountData(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _upadteBizData(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _repairUperID(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _isOnlyChild(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _getNoDealPcAccountIDSet(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _getNoDealPcAccountNumberSet(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _batchEnable(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _batchDisable(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateIsUpperAllowCA(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _getOrgUnitInfosByType(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _chkInfeParentCashFlow(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _isAllHasSameAsst(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateCashFlowItem(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _accountAssign(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _isAllowEditAC(Context ctx, IObjectValue profitCenter, IObjectValue pcacctView) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected Map _isHasDealAndHasInferior(Context ctx, IObjectValue pcacctView) throws BOSException, EASBizException {
        PcAccountViewInfo info = (PcAccountViewInfo)pcacctView;
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        boolean isHasDeal = this._isHasDeal(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        resultMap.put("isHasDeal", new Boolean(isHasDeal));
        boolean isHasInferior = false;
        resultMap.put("isHasInferior", new Boolean(isHasInferior));
        return resultMap;
    }

    @Override
    protected void _getCurrentProfitCenterPcAccountTable(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _disablePcAccountTable(Context ctx, String profitCenterID, String pcAcctTableID) throws BOSException, EASBizException {
        boolean hasAssign = this.checkAccountTableHasAssign(ctx, profitCenterID, pcAcctTableID);
        if (hasAssign) {
            PcAccountTableInfo accountTableInfo = PcAccountTableFactory.getLocalInstance(ctx).getPcAccountTableInfo((IObjectPK)new ObjectStringPK(profitCenterID));
            throw new PcAccountException(PcAccountException.ACCOUNT_HAS_ASSIGN, new Object[]{accountTableInfo.getName()});
        }
        boolean hasAccountRefContrast = false;
        hasAccountRefContrast = this.checkAccountTableHasRefContrast(ctx, profitCenterID, pcAcctTableID);
        if (hasAccountRefContrast) {
            // empty if block
        }
        boolean isAccountTableHasDeal = false;
        isAccountTableHasDeal = this.checkAccountTableHasDeal(ctx, profitCenterID, pcAcctTableID);
        if (isAccountTableHasDeal) {
            throw new PcAccountException(PcAccountException.ACCOUNTTABLEHASDEAL);
        }
        NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).updateAccountTableInProfitCenter(profitCenterID, null);
    }

    @Override
    protected void _enablePcAccountTable(Context ctx, String profitCenterID, String pcAcctTableID) throws BOSException, EASBizException {
        ProfitCenterOrgUnitInfo profitCenterInfo = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectStringPK(profitCenterID));
        String oql = "select id where  destProfitCenter='" + profitCenterID + "' and pcAccountTableID='" + pcAcctTableID + "'";
        if (!PcAccount_ControlFactory.getLocalInstance(ctx).exists(oql)) {
            throw new PcAccountException(PcAccountException.ACCOUNTTABLENOTAVAILABLE);
        }
        if (profitCenterInfo.getPcaccountTable() != null) {
            this._disablePcAccountTable(ctx, profitCenterID, profitCenterInfo.getPcaccountTable().getId().toString());
        }
        NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).updateAccountTableInProfitCenter(profitCenterID, pcAcctTableID);
    }

    private boolean checkAccountTableHasAssign(Context ctx, String profitCenterID, String pcAcctTableID) throws BOSException {
        boolean hasAssign = false;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT top 1 fid ");
        sql.append(" FROM T_BD_PcAccount_Control ");
        sql.append(" WHERE FSrcProfitCenterID = ? and FDestProfitCenterID!=? and FPcAccountTableID = ? ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{profitCenterID, profitCenterID, pcAcctTableID});
            if (rowSet.next()) {
                hasAssign = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return hasAssign;
    }

    private boolean checkAccountTableHasRefContrast(Context ctx, String profitCenterID, String pcAcctTableID) throws BOSException {
        boolean hasAccountRefContrast = false;
        return hasAccountRefContrast;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PcAccountViewInfo account = (PcAccountViewInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)account.getNumber().trim()));
        filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)account.getPcAccountTableID().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("profitCenterID", (Object)account.getProfitCenterID().getId().toString()));
        filter.setMaskString("#0 and #1 and #2");
        if (account.getId() != null && account.getId().toString().length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)account.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3");
        }
        if (this._exists(ctx, filter)) {
            String profitNumber = account.getProfitCenterID().getNumber();
            if (profitNumber == null || profitNumber.length() < 1) {
                String sqlToGetProfitCenterNumber = "SELECT TOP 1 FNUMBER FROM T_ORG_ProfitCenter WHERE FID = ?";
                IRowSet rsToGetProfitCenterNumber = DbUtil.executeQuery((Context)ctx, (String)sqlToGetProfitCenterNumber, (Object[])new Object[]{account.getProfitCenterID().getId().toString()});
                try {
                    profitNumber = rsToGetProfitCenterNumber.next() ? rsToGetProfitCenterNumber.getString("FNUMBER") : "";
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            String accountTableName = "";
            if (account.getPcAccountTableID() != null) {
                accountTableName = account.getPcAccountTableID().getName();
            }
            if (accountTableName == null || accountTableName.trim().length() == 0) {
                IPcAccountTable accountTable = PcAccountTableFactory.getLocalInstance(ctx);
                PcAccountTableInfo accountTableInfo = accountTable.getPcAccountTableInfo((IObjectPK)new ObjectUuidPK(account.getPcAccountTableID().getId()));
                accountTableName = accountTableInfo.getName() != null && accountTableInfo.getName().trim().length() > 0 ? accountTableInfo.getName() : "";
            }
            throw new PcAccountException(PcAccountException.DUPLONGNUMBER, new Object[]{profitNumber, accountTableName, account.getNumber()});
        }
    }

    private boolean checkAccountTableHasDeal(Context ctx, String profitCenterID, String pcAcctTableID) throws BOSException, EASBizException {
        boolean isAccountTableHasDeal = false;
        ProfitCenterOrgUnitInfo profitCenter = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectStringPK(profitCenterID));
        if (profitCenter == null) {
            logger.debug((Object)("ProfitCenter " + profitCenterID + " does not exist."));
            return isAccountTableHasDeal;
        }
        if (!profitCenter.isIsBizUnit()) {
            return isAccountTableHasDeal;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("profitCenterID", (Object)profitCenterID));
        filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)profitCenterID));
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        SorterItemCollection coll = new SorterItemCollection();
        SorterItemInfo info = new SorterItemInfo("number");
        coll.add(info);
        evi.setSorter(coll);
        PcAccountViewCollection accountViewCollection = this.getPcAccountViewCollection(ctx, evi);
        if (accountViewCollection == null || accountViewCollection.size() <= 0) {
            return isAccountTableHasDeal;
        }
        BizCheckResult checkResult = this.checkIsAccountHasDeal(ctx, accountViewCollection, BOSUuid.read((String)profitCenterID), BOSUuid.read((String)pcAcctTableID));
        if (checkResult != null && checkResult.isFound()) {
            isAccountTableHasDeal = true;
        }
        return isAccountTableHasDeal;
    }

    private BizCheckResult checkIsAccountHasDeal(Context ctx, PcAccountViewCollection pcAccountViewColl, BOSUuid currentProfitCenter, BOSUuid pcAccountTable) throws BOSException, EASBizException {
        BizCheckResult checkResult = BizCheckResult.NOTFOUND;
        if (pcAccountViewColl == null || pcAccountViewColl.size() == 0 || currentProfitCenter == null || pcAccountTable == null) {
            return checkResult;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("id");
        view.setSelector(coll);
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("pcAccountTableID", (Object)pcAccountTable.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Boolean(true)));
        ProfitCenterOrgUnitInfo profitCenterOrgUnitInfo = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentProfitCenter));
        filter.getFilterItems().add(new FilterItemInfo("profitCenterID.longNumber", (Object)(profitCenterOrgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
        maskString.append("(#0 and #1 and #2 and (");
        int index = 3;
        String lastNumber = "9999999999";
        int count = pcAccountViewColl.size();
        for (int i = 0; i < count; ++i) {
            PcAccountViewInfo acctInfo = pcAccountViewColl.get(i);
            String number = acctInfo.getNumber();
            if (number.indexOf(lastNumber, 0) == 0) continue;
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(number + "%"), CompareType.LIKE));
            if (i > 0) {
                maskString.append(" or ");
            }
            lastNumber = number;
            maskString.append(" #" + index++);
        }
        maskString.append("))");
        filter.setMaskString(maskString.toString());
        PcAccountViewCollection accountViewCollection = this.getPcAccountViewCollection(ctx, view);
        checkResult = PcAccountTools.hasDeal(ctx, accountViewCollection);
        if (checkResult.isFound()) {
            return checkResult;
        }
        checkResult = PcAccountTools.isReferenced(ctx, accountViewCollection);
        if (checkResult.isFound()) {
            return checkResult;
        }
        return checkResult;
    }

    private boolean isCUBDAllowAddnew(Context ctx, PcAccountViewInfo acctInfo) throws BOSException, EASBizException {
        boolean isAllowAddnew = true;
        ICUBDControl cubdControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        try {
            String cuID = null;
            if (acctInfo != null && acctInfo.getCU() != null && acctInfo.getCU().getId() != null) {
                cuID = acctInfo.getCU().getId().toString();
            } else if (acctInfo != null && acctInfo.getProfitCenterID() != null && acctInfo.getProfitCenterID().getCU() != null && acctInfo.getProfitCenterID().getCU().getId() != null) {
                cuID = acctInfo.getProfitCenterID().getCU().getId().toString();
            } else if (acctInfo != null && acctInfo.getProfitCenterID() != null && acctInfo.getProfitCenterID().getCU() == null) {
                ProfitCenterOrgUnitInfo profitOrgUnitInfo = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctInfo.getProfitCenterID().getId()));
                acctInfo.setProfitCenterID(profitOrgUnitInfo);
                cuID = profitOrgUnitInfo.getCU().getId().toString();
            }
            CUBDControlInfo cubdControlInfo = cubdControl.getBDCtrlInfo(acctInfo.getBOSType().toString(), cuID);
            if (cubdControlInfo == null) {
                return isAllowAddnew;
            }
            isAllowAddnew = cubdControlInfo.isIsSubordinateAddnewable();
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return isAllowAddnew;
    }

    @Override
    protected boolean _checkPcAccountHasInferior(Context ctx, IObjectValue pcacctView) throws BOSException, EASBizException {
        return false;
    }
}

