/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.init.HRInitForBaseFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOUPartAdmin;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.OUPartAdminFactory;
import com.kingdee.eas.basedata.org.OUPartAdminInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonException;
import com.kingdee.eas.basedata.person.app.AbstractPersonMainListUIHandler;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;

public class PersonMainListUIHandler
extends AbstractPersonMainListUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
    }

    protected void _handleActionAddNew(RequestContext request, ResponseContext response, Context context) throws Exception {
        BOSUuid positionId = (BOSUuid)request.get("positionNodeId");
        if (null != positionId) {
            PersonMainListUIHandler.checkAdminIsSealupByPosition(context, positionId.toString());
            if (request.get("isBasePersonManage") != null && ((Boolean)request.get("isBasePersonManage")).booleanValue()) {
                this.checkIsPositionRelatedHROrgInitFinished(context, positionId.toString());
            }
        }
        super._handleActionAddNew(request, response, context);
    }

    public static void checkAdminIsSealupByPosition(Context context, String positionId) throws Exception {
        IPosition iPosition = PositionFactory.getLocalInstance((Context)context);
        PositionInfo info = iPosition.getPositionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)positionId)));
        if (null != info && null != info.getAdminOrgUnit()) {
            PersonMainListUIHandler.checkAdminIsSealup(context, info.getAdminOrgUnit().getId().toString());
        }
    }

    public static void checkAdminIsSealup(Context context, String adminId) throws Exception {
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance((Context)context);
        FullOrgUnitInfo fullInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)adminId)));
        IOUPartAdmin iOUPartAdmin = OUPartAdminFactory.getLocalInstance((Context)context);
        if (null != fullInfo && null != fullInfo.getPartAdmin()) {
            OUPartAdminInfo oUPartAdminInfo = iOUPartAdmin.getOUPartAdminInfo((IObjectPK)new ObjectUuidPK(fullInfo.getPartAdmin().getId()));
        }
    }

    protected void _handleActionEdit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionEdit(request, response, context);
    }

    protected void _handleActionView(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionView(request, response, context);
    }

    @Override
    protected void _handleActionImportPerson(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleAction_Input(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    private void checkIsPositionRelatedHROrgInitFinished(Context ctx, String positionID) throws Exception {
        int finished = HRInitForBaseFactory.createInstance((Context)ctx).isPositionRelatedHROrgFinished(positionID);
        if (finished > 0) {
            throw new PersonException(PersonException.IS_HRINIT_FINISHED);
        }
    }

    @Override
    protected void _handleActionShowDiaplayName(RequestContext request, ResponseContext response, Context context) throws Exception {
    }
}

