/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.participant.PositionInfo;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.app.OrgAppUtils;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;

public class PersonToWFAdapterRemote {
    public BOSObjectType getType() {
        return new BOSObjectType("HRWFPPVE");
    }

    public Person getPersonByUserId(String userId) throws WfParticipantException {
        IRowSet rows;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("User.id", (Object)userId));
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.PersonFromUser");
        IQueryExecutor queryExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        Person wfPersonInfo = new Person();
        try {
            rows = queryExec.executeQuery();
        }
        catch (BOSException e1) {
            throw new WfParticipantException((Throwable)e1);
        }
        try {
            if (rows.next()) {
                wfPersonInfo.setEmployeeName(new Locale("L2", ""), rows.getString("person.name"));
                wfPersonInfo.setUserId(userId);
                wfPersonInfo.setUserName(new Locale("L2", ""), rows.getString("User.name"));
                wfPersonInfo.setEmployeeId(rows.getString("person.id"));
            }
            rows.close();
            return wfPersonInfo;
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    public Person[] getPersonByEmployeeId(String employeeId) throws WfParticipantException {
        IRowSet rows;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)employeeId));
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.PersonFromUser");
        IQueryExecutor queryExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        try {
            rows = queryExec.executeQuery();
        }
        catch (BOSException e1) {
            throw new WfParticipantException((Throwable)e1);
        }
        Person[] wfPersons = new Person[rows.size()];
        int i = 0;
        try {
            while (rows.next()) {
                wfPersons[i] = new Person();
                wfPersons[i].setEmployeeName(new Locale("L2", ""), rows.getString("person.name"));
                wfPersons[i].setUserId("User.id");
                wfPersons[i].setUserName(new Locale("L2", ""), rows.getString("User.name"));
                wfPersons[i].setEmployeeId(employeeId);
                ++i;
            }
            rows.close();
            return wfPersons;
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    private UserCollection getUserSByPerson(String personId) throws BOSException {
        UserCollection userColl = null;
        IUser iUser = UserFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = new FilterItemInfo("person.id", (Object)personId.trim());
        filter.getFilterItems().add(filterItem);
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        env.getSelector().add(new SelectorItemInfo("id"));
        env.getSelector().add(new SelectorItemInfo("name"));
        userColl = iUser.getUserCollection(env);
        return userColl;
    }

    private PersonInfo getPersonByUser(String userId) throws BOSException {
        IUser iUser = UserFactory.getRemoteInstance();
        IPerson iPerson = PersonFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)userId));
        PersonInfo personInfo = null;
        try {
            UserInfo userInfo = iUser.getUserInfo((IObjectPK)pk);
            pk = new ObjectUuidPK(userInfo.getPerson().getId());
            personInfo = iPerson.getPersonInfo((IObjectPK)pk);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return personInfo;
    }

    public Person[] getPositionHolders(String positionId) throws WfParticipantException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId));
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.PositionHolders");
        IQueryExecutor queryExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        try {
            return this.getPersonArrayByIRowSet(queryExec.executeQuery());
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    private UserCollection getUsersByPerson(PersonInfo personInfo) throws BOSException {
        IUser iUser = UserFactory.getRemoteInstance();
        UserCollection userColl = null;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = new FilterItemInfo("person", (Object)personInfo.getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        userColl = iUser.getUserCollection(viewInfo);
        return userColl;
    }

    private Person[] getOrgMembersByOrgId(String adminOrgId, boolean isAll) throws WfParticipantException {
        BOSUuid treeId;
        IOrgUnitCommon iOrgUnitComm = null;
        try {
            iOrgUnitComm = OrgUnitCommonFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        try {
            treeId = iOrgUnitComm.getBasicTree(OrgType.Admin).getId();
        }
        catch (EASBizException e1) {
            throw new WfParticipantException((Throwable)e1);
        }
        catch (BOSException e1) {
            throw new WfParticipantException((Throwable)e1);
        }
        IOrgStructure iOrgStructure = null;
        try {
            iOrgStructure = OrgStructureFactory.getRemoteInstance();
        }
        catch (BOSException e2) {
            e2.printStackTrace();
        }
        OrgTreeInfo treeInfo = new OrgTreeInfo();
        treeInfo.setId(treeId);
        AdminOrgUnitInfo orgInfo = new AdminOrgUnitInfo();
        orgInfo.setId(BOSUuid.read((String)adminOrgId));
        OrgStructureInfo info = null;
        try {
            info = iOrgStructure.getValue(treeInfo, (OrgUnitInfo)orgInfo);
        }
        catch (EASBizException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        String longNumber = info.getLongNumber();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.Persons2ByAdminOrg");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("OrgTree.id", (Object)treeId.toString()));
        if (isAll) {
            filterInfo.getFilterItems().add(new FilterItemInfo("OrgStructure.longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("OrgStructure.longNumber", (Object)longNumber, CompareType.EQUALS));
        }
        filterInfo.setMaskString("#0 and #1");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        queryExcu.setObjectView(viewInfo);
        try {
            return this.getPersonArrayByIRowSet(queryExcu.executeQuery());
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    public Person[] getOrgMember(String orgId) throws WfParticipantException {
        return this.getOrgMembersByOrgId(orgId, false);
    }

    private ArrayList[] removeReDuplicatedPerson(ArrayList[] list) {
        boolean isExists = false;
        for (int i = 0; i < list.length - 1; ++i) {
            for (int j = i + 1; j < list.length; ++j) {
                for (int k = list[j].size() - 1; k >= 0; --k) {
                    isExists = false;
                    for (int m = 0; m < list[i].size(); ++m) {
                        if (!((Person)list[j].get(k)).getEmployeeId().equals(((Person)list[i].get(m)).getEmployeeId()) || !list[j].get(k).toString().equals(list[i].get(m).toString())) continue;
                        isExists = true;
                        break;
                    }
                    if (!isExists) continue;
                    list[j].remove(k);
                }
            }
        }
        return list;
    }

    private Person[] getPersonArrayByIRowSet(IRowSet rows, String idStr, String nameStr, String userIdStr, String userNameStr) throws SQLException {
        return this.getPersonArrayByIRowSet(rows, idStr, nameStr, userIdStr, userNameStr, true);
    }

    private Person[] getPersonArrayByIRowSet(IRowSet rows, String idStr, String nameStr, String userIdStr, String userNameStr, boolean removeDuplicate) throws SQLException {
        if (idStr == null) {
            idStr = "person.id";
        }
        if (nameStr == null) {
            nameStr = "person.name";
        }
        if (userIdStr == null) {
            userIdStr = "user.id";
        }
        if (userNameStr == null) {
            userNameStr = "user.name";
        }
        Person[] persons = null;
        if (removeDuplicate) {
            int i;
            Person person = null;
            boolean hasSamePerson = false;
            ArrayList<Person> list = new ArrayList<Person>();
            while (rows.next()) {
                person = new Person();
                person.setEmployeeId(rows.getString(idStr));
                person.setEmployeeName(new Locale("L2", ""), rows.getString(nameStr));
                person.setUserId(rows.getString(userIdStr));
                person.setUserName(new Locale("L2", ""), rows.getString(userNameStr));
                hasSamePerson = false;
                for (i = 0; i < list.size(); ++i) {
                    if (!((Person)list.get(i)).getEmployeeId().equals(person.getEmployeeId())) continue;
                    hasSamePerson = true;
                    break;
                }
                if (hasSamePerson) continue;
                list.add(person);
            }
            rows.close();
            persons = new Person[list.size()];
            for (i = 0; i < list.size(); ++i) {
                persons[i] = (Person)list.get(i);
            }
        } else {
            int i = 0;
            persons = new Person[rows.size()];
            while (rows.next()) {
                persons[i] = new Person();
                persons[i].setEmployeeId(rows.getString(idStr));
                persons[i].setEmployeeName(new Locale("L2", ""), rows.getString(nameStr));
                persons[i].setUserId(rows.getString(userIdStr));
                persons[i].setUserName(new Locale("L2", ""), rows.getString(userNameStr));
                ++i;
            }
        }
        return persons;
    }

    private Person[] getPersonArrayByIRowSet(IRowSet rows) throws SQLException {
        return this.getPersonArrayByIRowSet(rows, null, null, null, null, false);
    }

    private ArrayList getPersonListByIRowSet(IRowSet rows) throws SQLException {
        ArrayList<Person> list = new ArrayList<Person>();
        Person person = null;
        while (rows.next()) {
            person = new Person();
            person.setEmployeeId(rows.getString("Person.id"));
            person.setEmployeeName(new Locale("L2", ""), rows.getString("Person.name"));
            person.setUserId(rows.getString("user.id"));
            person.setUserName(new Locale("L2", ""), rows.getString("user.name"));
            list.add(person);
        }
        rows.close();
        return list;
    }

    private ArrayList getPositionListByIRowSet(IRowSet rows) throws SQLException {
        ArrayList<PositionInfo> list = new ArrayList<PositionInfo>();
        PositionInfo position = null;
        while (rows.next()) {
            position = new PositionInfo();
            position.setId(rows.getString("Position.id"));
            position.setName(new Locale("L2", ""), rows.getString("Position.name"));
            position.setOrgId(rows.getString("AdminOrg.id"));
            position.setOrgName(new Locale("L2", ""), rows.getString("AdminOrg.name"));
            list.add(position);
        }
        rows.close();
        return list;
    }

    private Person[] getOrgMemberByOrgIds(String[] orgIds) throws WfParticipantException {
        double d = new Integer(orgIds.length).doubleValue();
        HashSet[] sets = new HashSet[new Double(Math.ceil(d / (double)OrgAppUtils.IN_CLAUSE_COUNT)).intValue()];
        ArrayList[] tmp = new ArrayList[sets.length];
        EntityViewInfo evi = null;
        FilterInfo filter = null;
        evi = new EntityViewInfo();
        int count = 0;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.AdminOrgPersons");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        for (int i = 0; i < sets.length; ++i) {
            filter = new FilterInfo();
            sets[i] = new HashSet();
            count = i * OrgAppUtils.IN_CLAUSE_COUNT + OrgAppUtils.IN_CLAUSE_COUNT >= orgIds.length ? orgIds.length : i * OrgAppUtils.IN_CLAUSE_COUNT + OrgAppUtils.IN_CLAUSE_COUNT;
            for (int j = i * OrgAppUtils.IN_CLAUSE_COUNT; j < count; ++j) {
                sets[i].add(orgIds[j]);
            }
            filter.getFilterItems().add(new FilterItemInfo("AdminOrg.id", (Object)sets[i], CompareType.INCLUDE));
            if (evi.getFilter() != null) {
                evi.getFilter().clear();
            }
            evi.setFilter(filter);
            if (queryExcu.getObjectView() != null) {
                queryExcu.getObjectView().clear();
            }
            queryExcu.setObjectView(evi);
            try {
                tmp[i] = this.getPersonListByIRowSet(queryExcu.executeQuery());
                continue;
            }
            catch (BOSException e) {
                throw new WfParticipantException((Throwable)e);
            }
            catch (SQLException e) {
                throw new WfParticipantException((Throwable)e);
            }
        }
        if (tmp.length >= 2) {
            tmp = this.removeReDuplicatedPerson(tmp);
        }
        int personCount = 0;
        for (int i = 0; i < tmp.length; ++i) {
            personCount += tmp[i].size();
        }
        Person[] wfPersons = new Person[personCount];
        int tmpCount = 0;
        for (int i = 0; i < tmp.length; ++i) {
            for (int j = 0; j < tmp[i].size(); ++j) {
                wfPersons[tmpCount] = (Person)tmp[i].get(j);
                ++tmpCount;
            }
        }
        return wfPersons;
    }

    public Person[] getOrgAllMember(String orgId) throws WfParticipantException {
        return this.getOrgMembersByOrgId(orgId, true);
    }

    public Person[] getOrgPrincipal(String orgId) throws WfParticipantException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)orgId));
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.OrgPrincipal");
        IQueryExecutor queryExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        try {
            return this.getPersonArrayByIRowSet(queryExec.executeQuery());
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    private Person[] getSuperAndSubPersons(String id, int type) throws WfParticipantException {
        FilterInfo filter = new FilterInfo();
        String filterStr = null;
        String idStr = null;
        String nameStr = null;
        String userIdStr = null;
        String userNameStr = null;
        String currentPersonId = id;
        switch (type) {
            case 0: {
                filterStr = "childUser.id";
                idStr = "parentPerson.id";
                nameStr = "parentPerson.name";
                userIdStr = "parentUser.id";
                userNameStr = "parentUser.name";
                break;
            }
            case 1: {
                filterStr = "parentUser.id";
                idStr = "childPerson.id";
                nameStr = "childPerson.name";
                userIdStr = "childUser.id";
                userNameStr = "childUser.name";
                break;
            }
            case 2: {
                filterStr = "childPerson.id";
                idStr = "parentPerson.id";
                nameStr = "parentPerson.name";
                userIdStr = "parentUser.id";
                userNameStr = "parentUser.name";
                currentPersonId = id;
                break;
            }
            case 3: {
                filterStr = "parentPerson.id";
                idStr = "childPerson.id";
                nameStr = "childPerson.name";
                userIdStr = "childUser.id";
                userNameStr = "childUser.name";
                currentPersonId = id;
            }
        }
        if (type == 0 || type == 1) {
            currentPersonId = this.getPersonByUserId(id).getEmployeeId();
            filter.getFilterItems().add(new FilterItemInfo(filterStr, (Object)id));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(filterStr, (Object)id));
        }
        filter.getFilterItems().add(new FilterItemInfo(idStr, (Object)currentPersonId, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1");
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.SuperAndSubPersons");
        IQueryExecutor queryExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        try {
            return this.getPersonArrayByIRowSet(queryExec.executeQuery(), idStr, nameStr, userIdStr, userNameStr);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    public Person[] getSupervisor(String userId) throws WfParticipantException {
        return this.getSuperAndSubPersons(userId, 0);
    }

    public Person[] getSubordinate(String userId) throws WfParticipantException {
        return this.getSuperAndSubPersons(userId, 1);
    }

    public Person[] getFellow(String userId) throws WfParticipantException {
        String personId = null;
        personId = this.getPersonByUserId(userId).getEmployeeId();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
        filter.getFilterItems().add(new FilterItemInfo("fellow.id", (Object)personId, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1");
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.Fellows");
        IQueryExecutor queryExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        try {
            return this.getPersonArrayByIRowSet(queryExec.executeQuery(), "fellow.id", "fellow.name", "fellowUser.id", "fellowUser.name");
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    public Person[] getRoleMember(String personUserId, String roleId) throws WfParticipantException {
        return null;
    }

    public PositionInfo[] getPositionArrayByUserId(String userId) throws WfParticipantException {
        try {
            return this.getPositionArrayByPersons(new String[]{this.getPersonByUser(userId).getId().toString()});
        }
        catch (WfParticipantException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    private PositionInfo[] getPositionArrayByPersons(String[] personIds) throws WfParticipantException {
        double d = new Integer(personIds.length).doubleValue();
        HashSet[] sets = new HashSet[new Double(Math.ceil(d / (double)OrgAppUtils.IN_CLAUSE_COUNT)).intValue()];
        ArrayList[] tmp = new ArrayList[sets.length];
        EntityViewInfo evi = null;
        FilterInfo filter = null;
        evi = new EntityViewInfo();
        int count = 0;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.PersonToPositions");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        for (int i = 0; i < sets.length; ++i) {
            filter = new FilterInfo();
            sets[i] = new HashSet();
            count = i * OrgAppUtils.IN_CLAUSE_COUNT + OrgAppUtils.IN_CLAUSE_COUNT >= personIds.length ? personIds.length : i * OrgAppUtils.IN_CLAUSE_COUNT + OrgAppUtils.IN_CLAUSE_COUNT;
            for (int j = i * OrgAppUtils.IN_CLAUSE_COUNT; j < count; ++j) {
                sets[i].add(personIds[j]);
            }
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)sets[i], CompareType.INCLUDE));
            if (evi.getFilter() != null) {
                evi.getFilter().clear();
            }
            evi.setFilter(filter);
            if (queryExcu.getObjectView() != null) {
                queryExcu.getObjectView().clear();
            }
            queryExcu.setObjectView(evi);
            try {
                tmp[i] = this.getPositionListByIRowSet(queryExcu.executeQuery());
                continue;
            }
            catch (BOSException e) {
                throw new WfParticipantException((Throwable)e);
            }
            catch (SQLException e) {
                throw new WfParticipantException((Throwable)e);
            }
        }
        int positionCount = 0;
        for (int i = 0; i < tmp.length; ++i) {
            positionCount += tmp[i].size();
        }
        PositionInfo[] wfPostions = new PositionInfo[positionCount];
        int tmpCount = 0;
        for (int i = 0; i < tmp.length; ++i) {
            for (int j = 0; j < tmp[i].size(); ++j) {
                wfPostions[tmpCount] = (PositionInfo)tmp[i].get(j);
                ++tmpCount;
            }
        }
        return wfPostions;
    }

    public PositionInfo[] getPositionArrayByEmployeeId(String employeeId) throws WfParticipantException {
        return this.getPositionArrayByPersons(new String[]{employeeId});
    }

    public com.kingdee.bos.workflow.participant.OrgUnitInfo[] getOrgUnitArrayById(String id, int type) throws WfParticipantException {
        IRowSet rows;
        FilterInfo filter = new FilterInfo();
        String idStr = null;
        idStr = type == 0 ? "person.id" : "user.id";
        filter.getFilterItems().add(new FilterItemInfo(idStr, (Object)id));
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.WFOrgByPerson");
        IQueryExecutor queryExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        HashSet<String> set = new HashSet<String>();
        try {
            rows = queryExec.executeQuery();
            while (rows.next()) {
                set.add(rows.getString("AdminOrgUnit.id"));
            }
            rows.close();
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        com.kingdee.bos.workflow.participant.OrgUnitInfo[] orgs = null;
        if (set.size() > 0) {
            metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.WFOrgQuery");
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("OrgUnit.type", (Object)new Integer(OrgType.Admin.getValue())));
            filter.getFilterItems().add(new FilterItemInfo("OrgUnit.id", set, CompareType.INCLUDE));
            filter.setMaskString("#0 and #1");
            evi.setFilter(filter);
            queryExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metadataPK);
            queryExec.setObjectView(evi);
            try {
                rows = queryExec.executeQuery();
                orgs = new com.kingdee.bos.workflow.participant.OrgUnitInfo[rows.size()];
                int i = 0;
                while (rows.next()) {
                    orgs[i] = new com.kingdee.bos.workflow.participant.OrgUnitInfo();
                    orgs[i].setId(rows.getString("OrgUnit.id"));
                    orgs[i].setName(new Locale("L2", ""), rows.getString("OrgUnit.name"));
                    orgs[i].setParentId(rows.getString("parent.id"));
                    orgs[i].setParentName(new Locale("L2", ""), rows.getString("parent.name"));
                    ++i;
                }
                rows.close();
            }
            catch (BOSException e) {
                throw new WfParticipantException((Throwable)e);
            }
            catch (SQLException e) {
                throw new WfParticipantException((Throwable)e);
            }
        }
        return orgs;
    }

    public com.kingdee.bos.workflow.participant.OrgUnitInfo[] getOrgUnitArrayByEmployeeId(String employeeId) throws WfParticipantException {
        return this.getOrgUnitArrayById(employeeId, 0);
    }

    public com.kingdee.bos.workflow.participant.OrgUnitInfo[] getOrgUnitArrayByUserId(String userId) throws WfParticipantException {
        return this.getOrgUnitArrayById(userId, 1);
    }

    public com.kingdee.bos.workflow.participant.OrgUnitInfo getParentOrgUnit(String orgUnitId) throws WfParticipantException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("OrgUnit.type", (Object)new Integer(OrgType.Admin.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("OrgUnit.id", (Object)orgUnitId));
        filter.setMaskString("#0 and #1");
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.WFOrgQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        IRowSet rows = null;
        try {
            rows = queryExec.executeQuery();
            if (rows.next()) {
                orgUnitId = rows.getString("Parent.id");
            }
            rows.close();
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("OrgUnit.type", (Object)new Integer(OrgType.Admin.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("OrgUnit.id", (Object)orgUnitId));
        filter.setMaskString("#0 and #1");
        com.kingdee.bos.workflow.participant.OrgUnitInfo wfOrg = null;
        try {
            rows = queryExec.executeQuery();
            if (rows.next()) {
                wfOrg = new com.kingdee.bos.workflow.participant.OrgUnitInfo();
                wfOrg.setId(rows.getString("OrgUnit.id"));
                wfOrg.setName(new Locale("L2", ""), rows.getString("OrgUnit.name"));
                wfOrg.setParentId(rows.getString("Parent.id"));
                wfOrg.setParentName(new Locale("L2", ""), rows.getString("Parent.name"));
            }
            rows.close();
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        return wfOrg;
    }

    public PositionInfo[] getPositionArrayByOrgUnitId(String orgUnitId) throws WfParticipantException {
        PositionInfo[] wfPositions = null;
        try {
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filtem = new FilterItemInfo("adminOrgUnit.id", (Object)orgUnitId);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("adminOrgUnit.name"));
            filter.getFilterItems().add(filtem);
            viewInfo.setFilter(filter);
            IPosition iPosition = PositionFactory.getRemoteInstance();
            PositionCollection positionColl = iPosition.getPositionCollection(viewInfo);
            com.kingdee.eas.basedata.org.PositionInfo info = null;
            if (positionColl != null) {
                int size = positionColl.size();
                wfPositions = new PositionInfo[size];
                for (int i = 0; i < size; ++i) {
                    info = positionColl.get(i);
                    wfPositions[i] = new PositionInfo();
                    wfPositions[i].setId(info.getId().toString());
                    wfPositions[i].setName(new Locale("L2", ""), info.getName());
                    wfPositions[i].setOrgId(info.getAdminOrgUnit().getId().toString());
                    wfPositions[i].setOrgName(new Locale("L2", ""), info.getAdminOrgUnit().getName());
                }
            }
        }
        catch (BOSException ex) {
            throw new WfParticipantException((Throwable)ex);
        }
        return wfPositions;
    }

    public com.kingdee.bos.workflow.participant.OrgUnitInfo[] getAllOrgUnitByType(int orgType) throws WfParticipantException {
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.basedata.org.app.WFOrgQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("OrgUnit.type", (Object)new Integer(orgType)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExcu.setObjectView(evi);
        try {
            IRowSet rows = queryExcu.executeQuery();
            com.kingdee.bos.workflow.participant.OrgUnitInfo[] wfOrgUnits = new com.kingdee.bos.workflow.participant.OrgUnitInfo[rows.size()];
            int i = 0;
            while (rows.next()) {
                wfOrgUnits[i] = new com.kingdee.bos.workflow.participant.OrgUnitInfo();
                wfOrgUnits[i].setId(rows.getString("OrgUnit.id"));
                wfOrgUnits[i].setName(new Locale("L2", ""), rows.getString("OrgUnit.name"));
                wfOrgUnits[i].setParentId(rows.getString("Parent.id"));
                wfOrgUnits[i].setParentName(new Locale("L2", ""), rows.getString("Parent.name"));
                ++i;
            }
            rows.close();
            return wfOrgUnits;
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    public com.kingdee.bos.workflow.participant.OrgUnitInfo getRootUnit(int orgType) throws WfParticipantException {
        IRowSet rows;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("OrgUnit.type", (Object)new Integer(orgType)));
        filter.getFilterItems().add(new FilterItemInfo("Parent.id", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.WFOrgQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        String unitId = null;
        try {
            rows = queryExec.executeQuery();
            if (rows.next()) {
                unitId = rows.getString("OrgUnit.id");
            }
            rows.close();
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        com.kingdee.bos.workflow.participant.OrgUnitInfo wfOrg = null;
        if (unitId != null) {
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("OrgUnit.type", (Object)new Integer(orgType)));
            filter.getFilterItems().add(new FilterItemInfo("OrgUnit.id", (Object)unitId));
            filter.setMaskString("#0 and #1");
            evi.setFilter(filter);
            queryExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metadataPK);
            queryExec.setObjectView(evi);
            try {
                rows = queryExec.executeQuery();
                if (rows.next()) {
                    wfOrg = new com.kingdee.bos.workflow.participant.OrgUnitInfo();
                    wfOrg.setId(rows.getString("OrgUnit.id"));
                    wfOrg.setName(new Locale("L2", ""), rows.getString("OrgUnit.name"));
                    wfOrg.setParentId(rows.getString("parent.id"));
                    wfOrg.setParentName(new Locale("L2", ""), rows.getString("parent.name"));
                }
                rows.close();
            }
            catch (BOSException e) {
                throw new WfParticipantException((Throwable)e);
            }
            catch (SQLException e) {
                throw new WfParticipantException((Throwable)e);
            }
        }
        return wfOrg;
    }

    public boolean isPersonInOrg(String personId, String OrgId) {
        boolean isIn = false;
        IOrgUnitCommon iOrgUnitComm = null;
        String treeId = null;
        try {
            iOrgUnitComm = OrgUnitCommonFactory.getRemoteInstance();
            treeId = iOrgUnitComm.getBasicTree(OrgType.Admin).getId().toString();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        String sql = "";
        sql = sql + "select FLongNumber, FLevel from T_Org_Structure where FUnitID = '";
        sql = sql + OrgId + "' and FTreeId = '" + treeId + "'";
        ISQLExecutor isql = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rows = null;
        String longNumber = "";
        int level = 0;
        try {
            rows = isql.executeSQL();
            if (rows.next()) {
                longNumber = rows.getString("FLongNumber");
                level = rows.getInt("FLevel");
            }
            rows.close();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        sql = "select FUnitId from t_org_structure where FLevel >= ";
        sql = sql + String.valueOf(level) + " and FLongNumber like '" + longNumber + "%' and FTreeID = '";
        sql = sql + treeId + "' order by FLongNumber";
        isql = SQLExecutorFactory.getRemoteInstance((String)sql);
        String[] orgIds = null;
        try {
            rows = isql.executeSQL();
            orgIds = new String[rows.size()];
            int i = 0;
            while (rows.next()) {
                orgIds[i] = rows.getString("FUnitID");
                ++i;
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        double d = new Integer(orgIds.length).doubleValue();
        int sqlCount = new Double(Math.ceil(d / (double)OrgAppUtils.IN_CLAUSE_COUNT)).intValue();
        String ids = "";
        for (int i = 0; i < sqlCount; ++i) {
            ids = "";
            for (int j = 0; j < OrgAppUtils.IN_CLAUSE_COUNT && i * OrgAppUtils.IN_CLAUSE_COUNT + j < orgIds.length; ++j) {
                ids = ids.length() == 0 ? ids + "'" + orgIds[i * OrgAppUtils.IN_CLAUSE_COUNT + j] + "'" : ids + ",'" + orgIds[i * OrgAppUtils.IN_CLAUSE_COUNT + j] + "'";
            }
            sql = "select a.fid from t_org_positionmember a inner join t_org_position b on a.fpositionid = b.fid ";
            sql = sql + "where fpersonid = '" + personId + "' and fAdminOrgUnitId in (" + ids + ")";
            isql = SQLExecutorFactory.getRemoteInstance((String)sql);
            try {
                rows = isql.executeSQL();
                if (rows.size() <= 0) continue;
                rows.close();
                isIn = true;
                break;
            }
            catch (BOSException e2) {
                e2.printStackTrace();
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return isIn;
    }

    public Object[] getPositionAndOrgByUserId(String userId) throws WfParticipantException {
        String sql = "select distinct fpositionid from t_org_positionMember a inner join t_bd_person b on a. fpersonid = b.fid  inner join t_pm_user c on b.fid = c.fpersonid where c.fid = '" + userId + "'";
        Object[] rtn = new Object[2];
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        try {
            IRowSet rows = exec.executeSQL();
            if (rows.size() == 0) {
                rtn[0] = new String[0];
                rtn[1] = new String[0][0];
                return rtn;
            }
            String[] positions = new String[rows.size()];
            int i = 0;
            while (rows.next()) {
                positions[i] = rows.getString(1);
                ++i;
            }
            rows.close();
            sql = "select distinct FAdminOrgUnitId from t_org_position where FID in ('" + positions[0] + "'";
            for (int j = 1; j < positions.length; ++j) {
                sql = sql + ", '" + positions[j] + "'";
            }
            sql = sql + ")";
            exec = SQLExecutorFactory.getRemoteInstance((String)sql);
            rows = exec.executeSQL();
            String[] orgs = new String[rows.size()];
            i = 0;
            while (rows.next()) {
                orgs[i] = rows.getString(1);
                ++i;
            }
            rows.close();
            String[][] rtnOrgs = new String[orgs.length][0];
            String longNumber = null;
            String treeId = null;
            for (int k = 0; k < orgs.length; ++k) {
                sql = "select FLongNumber, FTreeID from t_org_structure where funitid = '" + orgs[k] + "'";
                exec = SQLExecutorFactory.getRemoteInstance((String)sql);
                rows = exec.executeSQL();
                if (rows.next()) {
                    longNumber = rows.getString(1);
                    treeId = rows.getString(2);
                    rows.close();
                    sql = "select FUnitID from t_org_structure where charindex(flongnumber, '" + longNumber + "') = 1 and ftreeid = '" + treeId + "' order by flongnumber desc";
                    exec = SQLExecutorFactory.getRemoteInstance((String)sql);
                    rows = exec.executeSQL();
                    rtnOrgs[k] = new String[rows.size()];
                    int j = 0;
                    while (rows.next()) {
                        rtnOrgs[k][j] = rows.getString(1);
                        ++j;
                    }
                }
                rows.close();
            }
            rtn[0] = positions;
            rtn[1] = rtnOrgs;
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rtn;
    }

    public com.kingdee.bos.workflow.participant.OrgUnitInfo[] getAllOrgUnitArray() throws WfParticipantException {
        return null;
    }

    public com.kingdee.bos.workflow.participant.OrgUnitInfo[] getSubOrgUnit(String arg1) throws WfParticipantException {
        return null;
    }

    public void initProvider(WfEngine arg0) throws WfParticipantException {
    }
}

