/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.participant.OrgUnitInfo;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.participant.PositionInfo;
import com.kingdee.eas.basedata.person.app.AbstractPersonWFTestControllerBean;
import com.kingdee.eas.basedata.person.app.PersonToWFAdapter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PersonWFTestControllerBean
extends AbstractPersonWFTestControllerBean {
    private static Logger log = Logger.getLogger(PersonWFTestControllerBean.class);
    static PersonToWFAdapter personWF = new PersonToWFAdapter();

    @Override
    protected Object _test(Context ctx, String methodName, Class[] clases, Object[] params) throws BOSException, EASBizException {
        return this._invokeMethod(ctx, methodName, clases, params);
    }

    private Object _invokeMethod(Context ctx, String methodName, Class[] clases, Object[] params) throws BOSException {
        Class<?> wfClass = personWF.getClass();
        Class[] newClases = new Class[clases.length + 1];
        newClases[0] = Context.class;
        for (int i = 0; i < clases.length; ++i) {
            newClases[i + 1] = clases[i];
        }
        Object[] newParams = new Object[params.length + 1];
        newParams[0] = ctx;
        for (int i = 0; i < params.length; ++i) {
            newParams[i + 1] = params[i];
        }
        try {
            Method method = wfClass.getMethod(methodName, newClases);
            return method.invoke((Object)personWF, newParams);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _test(Context ctx) throws BOSException {
        try {
            this.testGetSubOrgPersons(ctx);
            this.testGetSuperOrgPersons(ctx);
            this.testGetFellowOrgPersons(ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void logArray(Person[] persons, Context ctx) {
        int size = persons.length;
        for (int i = 0; i < size; ++i) {
            log.debug((Object)(persons[i].getEmployeeName(ctx.getLocale()) + "   " + persons[i].getUserName(ctx.getLocale())));
        }
    }

    private void testGetSuperOrgPersons(Context context) {
        try {
            Person[] persons = personWF.getSuperOrgPersons(context, "000fcb08-0106-1000-e000-0cb9c0a8100dCCE7AED4");
            this.logArray(persons, context);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void testGetSubOrgPersons(Context context) {
        try {
            Person[] persons = personWF.getSubOrgPersons(context, "000fcb08-0106-1000-e000-07b8c0a8100dCCE7AED4");
            this.logArray(persons, context);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void testGetFellowOrgPersons(Context context) {
        try {
            Person[] persons = personWF.getFellowOrgPersons(context, "000fcb08-0106-1000-e000-0cb9c0a8100dCCE7AED4");
            this.logArray(persons, context);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void testGetHierarchyNameByID(Context context) {
        try {
            long time = System.currentTimeMillis();
            String value = personWF.getHierarchyNameByID(context, "00000000-0000-0000-0000-000000000001396FCAD0");
            log.info((Object)value);
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"35_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetPositionByPersonAndHierarchy(Context context) {
        try {
            long time = System.currentTimeMillis();
            PositionInfo[] value = personWF.getPositionByPersonAndHierarchy(context, "955a8885-0102-1000-e000-02e6c0a8126f13B7DE7F", "00000000-0000-0000-0000-000000000001396FCAD0");
            log.info((Object)value);
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"35_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetPositionAndOrgByUserId(Context context) {
        try {
            int i;
            long time = System.currentTimeMillis();
            Object[] value = personWF.getPositionAndOrgByUserId(context, "955a8885-0102-1000-e000-02e6c0a8126f13B7DE7F");
            String[] positions = (String[])value[0];
            String[][] orgs = (String[][])value[1];
            log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"36_PersonWFTestControllerBean", (Locale)context.getLocale()));
            log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"37_PersonWFTestControllerBean", (Locale)context.getLocale()) + positions.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale())));
            for (i = 0; i < positions.length; ++i) {
                log.info((Object)(i + " " + positions[i]));
            }
            log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"39_PersonWFTestControllerBean", (Locale)context.getLocale()) + orgs.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"40_PersonWFTestControllerBean", (Locale)context.getLocale())));
            for (i = 0; i < orgs.length; ++i) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"40_PersonWFTestControllerBean", (Locale)context.getLocale()) + i + "\uff1a"));
                for (int j = 0; j < orgs[i].length; ++j) {
                    log.info((Object)orgs[i][j]);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"35_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testGetPersonByUserId(Context context) {
        Person info = null;
        try {
            long time = System.currentTimeMillis();
            info = personWF.getPersonByUserId(context, "955a8885-0102-1000-e000-02e6c0a8126f13B7DE7F");
            log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"41_PersonWFTestControllerBean", (Locale)context.getLocale()) + info.getUserName(context.getLocale())));
            if (!info.getUserName(context.getLocale()).equals("administrator")) return;
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"42_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetPersonByEmployeeId(Context context) {
        Person[] infos = null;
        try {
            long time = System.currentTimeMillis();
            infos = personWF.getPersonByEmployeeId(context, "9ffe79bc-0102-1000-e000-00dbc0a813c780EF7DED");
            log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"43_PersonWFTestControllerBean", (Locale)context.getLocale()) + infos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale())));
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"44_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetPositionHolders(Context context) {
        Person[] infos = null;
        try {
            long time = System.currentTimeMillis();
            infos = personWF.getPositionHolders(context, "9efcbba5-0102-1000-e000-003bc0a813c774AE612E");
            log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"45_PersonWFTestControllerBean", (Locale)context.getLocale()) + infos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale())));
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"46_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetOrgMember(Context context) {
        Person[] infos = null;
        try {
            long time = System.currentTimeMillis();
            infos = personWF.getOrgMember(context, "916f83d3-0102-1000-e000-0331c0a813e1CCE7AED4");
            if (infos != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"47_PersonWFTestControllerBean", (Locale)context.getLocale()) + infos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale())));
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"48_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetOrgAllMember(Context context) {
        Person[] infos = null;
        try {
            long time = System.currentTimeMillis();
            infos = personWF.getOrgAllMember(context, "916f83d3-0102-1000-e000-0331c0a813e1CCE7AED4");
            if (infos != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"49_PersonWFTestControllerBean", (Locale)context.getLocale()) + infos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"50_PersonWFTestControllerBean", (Locale)context.getLocale()) + (System.currentTimeMillis() - time) + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"51_PersonWFTestControllerBean", (Locale)context.getLocale())));
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"52_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetOrgPrincipal(Context context) {
        Person[] infos = null;
        try {
            long time = System.currentTimeMillis();
            infos = personWF.getOrgPrincipal(context, "916f83d3-0102-1000-e000-0331c0a813e1CCE7AED4");
            if (infos != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"53_PersonWFTestControllerBean", (Locale)context.getLocale()) + infos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale())));
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"54_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetSupervisor(Context context) {
        Person[] infos = null;
        try {
            long time = System.currentTimeMillis();
            infos = personWF.getSupervisor(context, "cec53dd5-0102-1000-e001-bb14c0a810f080EF7DED", "cec53dd5-0102-1000-e001-b93ec0a810f074AE612E", "00000000-0000-0000-0000-000000000001396FCAD0");
            if (infos != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"55_PersonWFTestControllerBean", (Locale)context.getLocale()) + infos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale())));
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"56_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetSubordinate(Context context) {
        Person[] infos = null;
        try {
            long time = System.currentTimeMillis();
            infos = personWF.getSubordinate(context, "cec53dd5-0102-1000-e001-bb54c0a810f080EF7DED", "cec53dd5-0102-1000-e001-ac95c0a810f074AE612E", "00000000-0000-0000-0000-000000000001396FCAD0");
            if (infos != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"57_PersonWFTestControllerBean", (Locale)context.getLocale()) + infos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale())));
                for (int i = 0; i < infos.length; ++i) {
                    log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"58_PersonWFTestControllerBean", (Locale)context.getLocale()) + i + " " + infos[i]));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"59_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetFellow(Context context) {
        Person[] infos = null;
        try {
            long time = System.currentTimeMillis();
            infos = personWF.getFellow(context, "cec53dd5-0102-1000-e001-bb14c0a810f080EF7DED", "cec53dd5-0102-1000-e001-b93ec0a810f074AE612E", "00000000-0000-0000-0000-000000000001396FCAD0");
            if (infos != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"60_PersonWFTestControllerBean", (Locale)context.getLocale()) + infos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale())));
                for (int i = 0; i < infos.length; ++i) {
                    log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"58_PersonWFTestControllerBean", (Locale)context.getLocale()) + i + " " + infos[i]));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"61_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetPositionArrayByUserId(Context context) {
        PositionInfo[] positionInfos = null;
        try {
            long time = System.currentTimeMillis();
            positionInfos = personWF.getPositionArrayByUserId(context, "955a8885-0102-1000-e000-02e6c0a8126f13B7DE7F");
            if (positionInfos != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"62_PersonWFTestControllerBean", (Locale)context.getLocale()) + positionInfos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale())));
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"63_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetPositionArrayByEmployeeId(Context context) {
        PositionInfo[] positionInfos = null;
        try {
            long time = System.currentTimeMillis();
            positionInfos = personWF.getPositionArrayByEmployeeId(context, "9ffe79bc-0102-1000-e000-00dbc0a813c780EF7DED");
            if (positionInfos != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"64_PersonWFTestControllerBean", (Locale)context.getLocale()) + positionInfos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale())));
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"65_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetOrgUnitArrayByEmployeeId(Context context) {
        OrgUnitInfo[] orgUnitInfos = null;
        try {
            long time = System.currentTimeMillis();
            orgUnitInfos = personWF.getOrgUnitArrayByEmployeeId(context, "9ffe79bc-0102-1000-e000-00dbc0a813c780EF7DED");
            if (orgUnitInfos != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"66_PersonWFTestControllerBean", (Locale)context.getLocale()) + orgUnitInfos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale())));
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"67_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetOrgUnitArrayByUserId(Context context) {
        OrgUnitInfo[] orgUnitInfos = null;
        try {
            long time = System.currentTimeMillis();
            orgUnitInfos = personWF.getOrgUnitArrayByUserId(context, "955a8885-0102-1000-e000-02e6c0a8126f13B7DE7F");
            if (orgUnitInfos != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"68_PersonWFTestControllerBean", (Locale)context.getLocale()) + orgUnitInfos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale())));
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"69_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetParentOrgUnit(Context context) {
        OrgUnitInfo orgUnitInfo = null;
        try {
            long time = System.currentTimeMillis();
            orgUnitInfo = personWF.getParentOrgUnit(context, "916f83d3-0102-1000-e000-0331c0a813e1CCE7AED4");
            if (orgUnitInfo != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"70_PersonWFTestControllerBean", (Locale)context.getLocale()) + orgUnitInfo.getName(context.getLocale())));
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"71_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetPositionArrayByOrgUnitId(Context context) {
        PositionInfo[] positionInfos = null;
        try {
            long time = System.currentTimeMillis();
            positionInfos = personWF.getPositionArrayByOrgUnitId(context, "916f83d3-0102-1000-e000-0331c0a813e1CCE7AED4");
            if (positionInfos != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"72_PersonWFTestControllerBean", (Locale)context.getLocale()) + positionInfos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale())));
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"73_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetAllOrgUnitByType(Context context) {
        OrgUnitInfo[] orgUnitInfos = null;
        try {
            long time = System.currentTimeMillis();
            orgUnitInfos = personWF.getAllOrgUnitByType(context, 0);
            if (orgUnitInfos != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"74_PersonWFTestControllerBean", (Locale)context.getLocale()) + orgUnitInfos.length + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"38_PersonWFTestControllerBean", (Locale)context.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"50_PersonWFTestControllerBean", (Locale)context.getLocale()) + (System.currentTimeMillis() - time) + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"51_PersonWFTestControllerBean", (Locale)context.getLocale())));
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"75_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testGetRootUnit(Context context) {
        OrgUnitInfo orgUnitInfo = null;
        try {
            long time = System.currentTimeMillis();
            orgUnitInfo = personWF.getRootUnit(context, 0);
            if (orgUnitInfo != null) {
                log.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"76_PersonWFTestControllerBean", (Locale)context.getLocale()) + orgUnitInfo.getName(context.getLocale())));
            }
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"77_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }

    private void testIsPersonInOrg(Context context) throws Exception {
        try {
            long time = System.currentTimeMillis();
            String orgId = "916f83d3-0102-1000-e000-0331c0a813e1CCE7AED4";
            String personId = "9ffe79bc-0102-1000-e000-00dbc0a813c780EF7DED";
            boolean value = personWF.isPersonInOrg(context, personId, orgId);
            log.info((Object)("testIsPersonInOrg() " + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"50_PersonWFTestControllerBean", (Locale)context.getLocale()) + (System.currentTimeMillis() - time) + ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"51_PersonWFTestControllerBean", (Locale)context.getLocale())));
        }
        catch (Exception e) {
            log.error((Object)ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"78_PersonWFTestControllerBean", (Locale)context.getLocale()), (Throwable)e);
        }
    }
}

