/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class DbUtil {
    public static Connection getConn(Context ctx) throws SQLDataException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            SQLUtils.cleanup((Connection)conn);
            throw new SQLDataException(e);
        }
        return conn;
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
    }

    public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    public static int[] executeBatch(Context ctx, List sqls) throws SQLDataException {
        int[] ret = null;
        if (sqls == null || sqls.size() == 0) {
            return ret;
        }
        Connection conn = DbUtil.getConn(ctx);
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            int n = sqls.size();
            for (int i = 0; i < n; ++i) {
                stmt.addBatch(sqls.get(i).toString());
            }
            ret = stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        return ret;
    }

    public static int[] executeBatch(Context ctx, String prepareSql, List params) throws SQLDataException {
        int[] ret = null;
        if (prepareSql == null || params == null || params.size() == 0) {
            return ret;
        }
        Connection conn = DbUtil.getConn(ctx);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(prepareSql);
            int n = params.size();
            for (int i = 0; i < n; ++i) {
                Object param = params.get(i);
                if (param instanceof Object[]) {
                    Object[] arryParam = (Object[])param;
                    int m = arryParam.length;
                    for (int j = 0; j < m; ++j) {
                        ps.setObject(j + 1, arryParam[j]);
                    }
                } else {
                    ps.setObject(1, param);
                }
                ps.addBatch();
            }
            ret = ps.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
        return ret;
    }

    public static PreparedStatement createState(Connection conn, String sql, Object[] params) throws SQLException {
        PreparedStatement state = conn.prepareStatement(sql);
        if (params == null) {
            return state;
        }
        for (int i = 0; i < params.length; ++i) {
            Object object = params[i];
            state.setObject(i + 1, object);
        }
        return state;
    }
}

