/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.core.fi.gl.GLUtilPorcessFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class AppHelper {
    private static final String ORIGINAL_1 = "1f";
    private static final String ORIGINAL_5 = "5f";
    private static final String GENERAL_LOCAL_1 = "1l";
    private static final String GENERAL_LOCAL_5 = "5l";
    private static final String GENERAL_RPT_1 = "1r";
    private static final String GENERAL_RPT_5 = "5r";

    public static void checkModifyStartPeriod(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        GLUtilPorcessFactory.getGLUtilPorcess().checkModifyStartPeriod(ctx, orgUnitId);
    }

    protected static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static void copyAccountBalance(Context ctx, String srcId, String destId, String companyId) throws BOSException {
        AppHelper.copyAccountBalance(ctx, srcId, destId, companyId, ORIGINAL_1);
        AppHelper.copyAccountBalance(ctx, srcId, destId, companyId, ORIGINAL_5);
        AppHelper.copyAccountBalance(ctx, srcId, destId, companyId, GENERAL_LOCAL_1);
        AppHelper.copyAccountBalance(ctx, srcId, destId, companyId, GENERAL_LOCAL_5);
        AppHelper.copyAccountBalance(ctx, srcId, destId, companyId, GENERAL_RPT_1);
        AppHelper.copyAccountBalance(ctx, srcId, destId, companyId, GENERAL_RPT_5);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = AppHelper.getConnection(ctx);
            StringBuffer sql = new StringBuffer("insert into t_gl_initaccountbalance(").append("FOrgUnitID,FAccountID,FCurrencyID,FBeginBalanceFor,").append("FYearDebitFor,FYearCreditFor,FDebitFor,FCreditFor,FEndBalanceFor,").append("FBeginBalanceLocal,FYearDebitLocal,FYearCreditLocal,FDebitLocal,FCreditLocal").append(",FEndBalanceLocal,FBeginBalanceRpt,FYearDebitRpt,FYearCreditRpt,FDebitRpt").append(",FCreditRpt,FEndBalanceRpt,FYearPnLFor,FMonthPnLFor,FYearPnLLocal,FMonthPnLLocal").append(",FYearPnLRpt,FMonthPnLRpt,FBeginQty,FYearDebitQty,FYearCreditQty,FDebitQty,FCreditQty,FEndQty").append(") select ").append("FOrgUnitID,'").append(destId).append("',FCurrencyID,FBeginBalanceFor,").append("FYearDebitFor,FYearCreditFor,FDebitFor,FCreditFor,FEndBalanceFor,").append("FBeginBalanceLocal,FYearDebitLocal,FYearCreditLocal,FDebitLocal,FCreditLocal").append(",FEndBalanceLocal,FBeginBalanceRpt,FYearDebitRpt,FYearCreditRpt,FDebitRpt").append(",FCreditRpt,FEndBalanceRpt,FYearPnLFor,FMonthPnLFor,FYearPnLLocal,FMonthPnLLocal").append(",FYearPnLRpt,FMonthPnLRpt,FBeginQty,FYearDebitQty,FYearCreditQty,FDebitQty,FCreditQty,FEndQty").append(" from t_gl_initaccountbalance where faccountid=? and forgunitid=? ");
            ps = con.prepareStatement(sql.toString());
            int index = 1;
            ps.setString(index++, srcId);
            ps.setString(index++, companyId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        AppHelper.copyPcaAccountBalance(ctx, srcId, destId);
    }

    private static void copyAccountBalance(Context ctx, String srcId, String destId, String companyId, String balType) throws BOSException {
        String tableName = "t_gl_accountbalance_" + balType;
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tableName).append("(");
        sql.append("FOrgUnitID,FPeriod,FAccountID");
        if (balType == ORIGINAL_1 || balType == ORIGINAL_5) {
            sql.append(",FCurrencyID,FBeginBalanceFor,FYearDebitFor,FYearCreditFor,FDebitFor,FCreditFor,FEndBalanceFor,FYearPnLFor,FMonthPnLFor");
        }
        if (balType == GENERAL_LOCAL_1 || balType == GENERAL_LOCAL_5 || balType == ORIGINAL_1 || balType == ORIGINAL_5) {
            sql.append(",FBeginBalanceLocal,FYearDebitLocal,FYearCreditLocal,FDebitLocal,FCreditLocal,FEndBalanceLocal,FYearPnLLocal,FMonthPnLLocal");
        }
        if (balType == GENERAL_RPT_1 || balType == GENERAL_RPT_5 || balType == ORIGINAL_1 || balType == ORIGINAL_5) {
            sql.append(",FBeginBalanceRpt,FYearDebitRpt,FYearCreditRpt,FDebitRpt,FCreditRpt,FEndBalanceRpt,FYearPnLRpt,FMonthPnLRpt");
        }
        sql.append(",FBeginQty,FYearDebitQty,FYearCreditQty,FDebitQty,FCreditQty,FEndQty)");
        sql.append(" select GL.FOrgUnitID,GL.FPeriod,?");
        if (balType == ORIGINAL_1 || balType == ORIGINAL_5) {
            sql.append(",GL.FCurrencyID,GL.FBeginBalanceFor,GL.FYearDebitFor,GL.FYearCreditFor,GL.FDebitFor,GL.FCreditFor,GL.FEndBalanceFor,GL.FYearPnLFor,GL.FMonthPnLFor");
        }
        if (balType == GENERAL_LOCAL_1 || balType == GENERAL_LOCAL_5 || balType == ORIGINAL_1 || balType == ORIGINAL_5) {
            sql.append(",GL.FBeginBalanceLocal,GL.FYearDebitLocal,GL.FYearCreditLocal,GL.FDebitLocal,GL.FCreditLocal,GL.FEndBalanceLocal,GL.FYearPnLLocal,GL.FMonthPnLLocal");
        }
        if (balType == GENERAL_RPT_1 || balType == GENERAL_RPT_5 || balType == ORIGINAL_1 || balType == ORIGINAL_5) {
            sql.append(",GL.FBeginBalanceRpt,GL.FYearDebitRpt,GL.FYearCreditRpt,GL.FDebitRpt,GL.FCreditRpt,GL.FEndBalanceRpt,GL.FYearPnLRpt,GL.FMonthPnLRpt");
        }
        sql.append(",GL.FBeginQty,GL.FYearDebitQty,GL.FYearCreditQty,GL.FDebitQty,GL.FCreditQty,GL.FEndQty");
        sql.append(" from ").append(tableName).append(" GL ");
        sql.append(" where GL.faccountid=? and GL.forgunitid=? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{destId, srcId, companyId});
    }

    public static void copyPcaAccountBalance(Context ctx, String srcId, String destId) throws BOSException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = AppHelper.getConnection(ctx);
            AppHelper.copyPcaAccountBalance(ctx, srcId, destId, ORIGINAL_1);
            AppHelper.copyPcaAccountBalance(ctx, srcId, destId, ORIGINAL_5);
            AppHelper.copyPcaAccountBalance(ctx, srcId, destId, GENERAL_LOCAL_1);
            AppHelper.copyPcaAccountBalance(ctx, srcId, destId, GENERAL_LOCAL_5);
            AppHelper.copyPcaAccountBalance(ctx, srcId, destId, GENERAL_RPT_1);
            AppHelper.copyPcaAccountBalance(ctx, srcId, destId, GENERAL_RPT_5);
            StringBuffer sql = new StringBuffer("insert into t_pca_initpcaccountbalance(").append("FOrgUnitID,FProfitCenterID,FAccountID,FCurrencyID,FBeginBalanceFor,").append("FYearDebitFor,FYearCreditFor,FDebitFor,FCreditFor,FEndBalanceFor,").append("FBeginBalanceLocal,FYearDebitLocal,FYearCreditLocal,FDebitLocal,FCreditLocal").append(",FEndBalanceLocal,FBeginBalanceRpt,FYearDebitRpt,FYearCreditRpt,FDebitRpt").append(",FCreditRpt,FEndBalanceRpt,FYearPnLFor,FMonthPnLFor,FYearPnLLocal,FMonthPnLLocal").append(",FYearPnLRpt,FMonthPnLRpt,FBeginQty,FYearDebitQty,FYearCreditQty,FDebitQty,FCreditQty,FEndQty").append(") select ").append("FOrgUnitID,FProfitCenterID,'").append(destId).append("',FCurrencyID,FBeginBalanceFor,").append("FYearDebitFor,FYearCreditFor,FDebitFor,FCreditFor,FEndBalanceFor,").append("FBeginBalanceLocal,FYearDebitLocal,FYearCreditLocal,FDebitLocal,FCreditLocal").append(",FEndBalanceLocal,FBeginBalanceRpt,FYearDebitRpt,FYearCreditRpt,FDebitRpt").append(",FCreditRpt,FEndBalanceRpt,FYearPnLFor,FMonthPnLFor,FYearPnLLocal,FMonthPnLLocal").append(",FYearPnLRpt,FMonthPnLRpt,FBeginQty,FYearDebitQty,FYearCreditQty,FDebitQty,FCreditQty,FEndQty").append(" from t_pca_initpcaccountbalance where faccountid=? ");
            ps = con.prepareStatement(sql.toString());
            int index = 1;
            ps.setString(index, srcId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private static void copyPcaAccountBalance(Context ctx, String srcId, String destId, String balType) throws BOSException {
        String tableName = "t_pca_pcaccountbalance_" + balType;
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tableName).append("(");
        sql.append("FProfitCenterID,FOrgUnitID,FPeriod,FAccountID");
        if (balType == ORIGINAL_1 || balType == ORIGINAL_5) {
            sql.append(",FCurrencyID,FBeginBalanceFor,FYearDebitFor,FYearCreditFor,FDebitFor,FCreditFor,FEndBalanceFor,FYearPnLFor,FMonthPnLFor");
        }
        if (balType == GENERAL_LOCAL_1 || balType == GENERAL_LOCAL_5 || balType == ORIGINAL_1 || balType == ORIGINAL_5) {
            sql.append(",FBeginBalanceLocal,FYearDebitLocal,FYearCreditLocal,FDebitLocal,FCreditLocal,FEndBalanceLocal,FYearPnLLocal,FMonthPnLLocal");
        }
        if (balType == GENERAL_RPT_1 || balType == GENERAL_RPT_5 || balType == ORIGINAL_1 || balType == ORIGINAL_5) {
            sql.append(",FBeginBalanceRpt,FYearDebitRpt,FYearCreditRpt,FDebitRpt,FCreditRpt,FEndBalanceRpt,FYearPnLRpt,FMonthPnLRpt");
        }
        sql.append(",FBeginQty,FYearDebitQty,FYearCreditQty,FDebitQty,FCreditQty,FEndQty)");
        sql.append(" select PCA.FProfitCenterID,PCA.FOrgUnitID,PCA.FPeriod,?");
        if (balType == ORIGINAL_1 || balType == ORIGINAL_5) {
            sql.append(",PCA.FCurrencyID,PCA.FBeginBalanceFor,PCA.FYearDebitFor,PCA.FYearCreditFor,PCA.FDebitFor,PCA.FCreditFor,PCA.FEndBalanceFor,PCA.FYearPnLFor,PCA.FMonthPnLFor");
        }
        if (balType == GENERAL_LOCAL_1 || balType == GENERAL_LOCAL_5 || balType == ORIGINAL_1 || balType == ORIGINAL_5) {
            sql.append(",PCA.FBeginBalanceLocal,PCA.FYearDebitLocal,PCA.FYearCreditLocal,PCA.FDebitLocal,PCA.FCreditLocal,PCA.FEndBalanceLocal,PCA.FYearPnLLocal,PCA.FMonthPnLLocal");
        }
        if (balType == GENERAL_RPT_1 || balType == GENERAL_RPT_5 || balType == ORIGINAL_1 || balType == ORIGINAL_5) {
            sql.append(",PCA.FBeginBalanceRpt,PCA.FYearDebitRpt,PCA.FYearCreditRpt,PCA.FDebitRpt,PCA.FCreditRpt,PCA.FEndBalanceRpt,PCA.FYearPnLRpt,PCA.FMonthPnLRpt");
        }
        sql.append(",PCA.FBeginQty,PCA.FYearDebitQty,PCA.FYearCreditQty,PCA.FDebitQty,PCA.FCreditQty,PCA.FEndQty");
        sql.append(" from ").append(tableName).append(" PCA ");
        sql.append(" where PCA.faccountid=? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{destId, srcId});
    }
}

