/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.VerifyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.fi.cas.subacct.ISubAccount;
import com.kingdee.eas.fi.cas.subacct.SubAccountCollection;
import com.kingdee.eas.fi.cas.subacct.SubAccountException;
import com.kingdee.eas.fi.cas.subacct.SubAccountFactory;
import com.kingdee.eas.fi.cas.subacct.SubAccountInfo;
import com.kingdee.eas.fi.cas.subacct.SubAcctCurrencyBalance;
import com.kingdee.eas.fi.cas.subacct.app.AbstractSubAccountControllerBean;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SubAccountControllerBean
extends AbstractSubAccountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.subacct.app.SubAccountControllerBean");

    @Override
    protected boolean _referCondition(Context ctx, BOSUuid pk) throws BOSException {
        try {
            return ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)pk);
        }
        catch (BizReferenceException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void checkSameTopBank(IObjectValue model) throws SubAccountException {
        SubAccountInfo info = (SubAccountInfo)model;
        BankInfo subAcc = info.getBank();
        if (subAcc == null || EmptyUtil.isEmpty((String)subAcc.getLongNumber())) {
            return;
        }
        String bankTopNum = subAcc.getLongNumber().split("!")[0];
        AccountBankInfo acctBankInfo = info.getAccountBank();
        if (acctBankInfo == null || acctBankInfo.getBank() == null) {
            return;
        }
        String parentAccLongN = acctBankInfo.getBank().getLongNumber();
        if (EmptyUtil.isEmpty((String)parentAccLongN)) {
            return;
        }
        String parentTopNum = parentAccLongN.split("!")[0];
        if (!(EmptyUtil.isEmpty((String)bankTopNum) || EmptyUtil.isEmpty((String)parentTopNum) || bankTopNum.equals(parentTopNum))) {
            throw new SubAccountException(SubAccountException.PARENT_BANK_SAMETOP);
        }
    }

    private void checkInnerAcc(Context ctx, IObjectValue model) throws SubAccountException {
        SubAccountInfo info = (SubAccountInfo)model;
        if (info.getInnerAccount() == null || info.getInnerAccount().getCompany() == null || info.getInnerAccount().getApplyUnit() == null || info.getRelationalUnit() == null) {
            return;
        }
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (currentCompany == null || currentCompany.getId() == null) {
            return;
        }
        if (!info.getInnerAccount().getCompany().getId().equals((Object)currentCompany.getId()) || !info.getRelationalUnit().getId().equals((Object)info.getInnerAccount().getApplyUnit().getId())) {
            throw new SubAccountException(SubAccountException.INNER_ACCOUNT);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SubAccountInfo info = (SubAccountInfo)model;
        VerifyUtil.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        VerifyUtil.checkBlank((Context)ctx, (IObjectValue)info, (String)"name");
        VerifyUtil.checkBlank((Context)ctx, (IObjectValue)info, (String)"accountNumber");
        VerifyUtil.checkBlank((Context)ctx, (IObjectValue)info, (String)"company");
        VerifyUtil.checkBlank((Context)ctx, (IObjectValue)info, (String)"relationalUnit");
        VerifyUtil.checkBlank((Context)ctx, (IObjectValue)info, (String)"bank");
        VerifyUtil.checkBlank((Context)ctx, (IObjectValue)info, (String)"accountBank");
        if (info.getAccountView() != null && info.getInnerAccount() != null) {
            throw new SubAccountException(SubAccountException.PAYEE_INNER_BOTH);
        }
        if (info.getAccountView() == null && info.getInnerAccount() == null) {
            throw new SubAccountException(SubAccountException.PAYEE_INNER_NULL);
        }
        this.checkInnerAcc(ctx, model);
        this.checkSameTopBank(model);
        this.checkCombine(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    private void checkCombine(Context ctx, IObjectValue model) throws BOSException, SubAccountException {
        SubAccountInfo infoNow = (SubAccountInfo)model;
        if (infoNow.getRelationalUnit() == null || infoNow.getRelationalUnit().getId() == null) {
            return;
        }
        String comID = infoNow.getRelationalUnit().getId().toString();
        BankInfo subAcc = infoNow.getBank();
        if (subAcc == null || subAcc.getLongNumber() == null) {
            return;
        }
        String mainId = null;
        if (infoNow.getId() != null) {
            mainId = infoNow.getId().toString();
        }
    }

    private void checkUsedAcc(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        SubAccountInfo infoOrigin = (SubAccountInfo)this.getValue(ctx, pk);
        SubAccountInfo infoNow = (SubAccountInfo)model;
        if (infoOrigin == null || infoNow == null) {
            return;
        }
        if (infoNow.getRelationalUnit() == null || infoOrigin.getRelationalUnit() == null || infoNow.getBank() == null || infoOrigin.getRelationalUnit() == null || infoNow.getAccountBank() == null || infoOrigin.getAccountBank() == null) {
            return;
        }
        if (ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)infoNow.getId()) && infoNow.getRelationalUnit().getId().toString().equals(infoOrigin.getRelationalUnit().getId().toString()) && infoNow.getBank().getId().toString().equals(infoOrigin.getBank().getId().toString()) && infoNow.getAccountBank().getId().toString().equals(infoOrigin.getAccountBank().getId().toString())) {
            throw new SubAccountException(SubAccountException.UPDATE_REFER);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()))) {
            throw new SubAccountException(SubAccountException.DELETE_REFER);
        }
        super._delete(ctx, pk);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    @Override
    protected boolean _actionCancel(Context ctx, String subAccountId) throws BOSException {
        return true;
    }

    @Override
    protected IObjectCollection _getSubAccounts(Context ctx, String motherAcctBankId) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)motherAcctBankId)) {
            return new SubAccountCollection();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)motherAcctBankId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        ISubAccount iSubAcct = SubAccountFactory.getRemoteInstance();
        return iSubAcct.getSubAccountCollection(evi);
    }

    @Override
    protected IObjectCollection _getCompanyAcctBanks(Context ctx, String motherAcctBankId) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)motherAcctBankId)) {
            return new AccountBankCollection();
        }
        String innerSql = "SELECT FId FROM T_CAS_SubAccount WHERE FAccountBankID = '" + motherAcctBankId + "'";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("subAccount.id", (Object)innerSql, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("bank.name");
        evi.getSelector().add("subAccount.*");
        evi.getSelector().add("subAccount.innerAccount.*");
        evi.getSelector().add("company.*");
        evi.getSelector().add("ctrlStrategy.*");
        evi.getSelector().add("openArea.*");
        IAccountBank iAcctBank = AccountBankFactory.getLocalInstance((Context)ctx);
        return iAcctBank.getAccountBankCollection(evi);
    }

    protected Map _getTransUpAcctBankAmt(Context ctx, String motherAcctBankId, Date upDate, String currencyId) throws BOSException, EASBizException {
        AccountBankCollection acctBankColl = (AccountBankCollection)this._getCompanyAcctBanks(ctx, motherAcctBankId);
        return null;
    }

    protected Map _getTransDowAcctBankAmt(Context ctx, String motherAcctBankId, String currencyId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected boolean _monoCombine(Context ctx, String relaOrg, String topBank, String mainId) throws BOSException {
        if (EmptyUtil.isEmpty((String)relaOrg) || EmptyUtil.isEmpty((String)topBank)) {
            return false;
        }
        String sql = "SELECT T_CAS_SUBACCOUNT.FID FROM T_CAS_SUBACCOUNT,T_BD_BANK WHERE T_CAS_SUBACCOUNT.FRelationalUnitID = '" + relaOrg + "' AND T_BD_BANK.FLONGNUMBER LIKE '" + topBank + "%' AND T_CAS_SUBACCOUNT.FBankID = T_BD_BANK.FID ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (set != null && set.size() > 0) {
            try {
                set.next();
                return !EmptyUtil.isEmpty((String)mainId) && set.size() == 1 && !EmptyUtil.isEmpty((String)set.getString(1)) && mainId.equals(set.getString(1));
            }
            catch (SQLException e) {
                e.printStackTrace();
                SysUtil.abort((Throwable)e);
                return false;
            }
        }
        return true;
    }

    private String getPeriodStartSql(String accountBankId, String currencyId, PeriodInfo period, Date queryDate) {
        StringBuffer sql = new StringBuffer();
        sql.append("select  FPeriodStartBalance SubResult  from T_CAS_SubAccountBalance where ");
        sql.append("FIsInit =0   ");
        sql.append(" and FSubacctID='").append(accountBankId).append("'");
        sql.append(" AND FCurrencyId = '").append(currencyId).append("'");
        sql.append(" AND FPeriodId = '").append(period.getId().toString()).append("'");
        return sql.toString();
    }

    private String getRangeSql(String accountBankId, String currencyId, PeriodInfo period, Date queryDate) {
        StringBuffer sql = new StringBuffer();
        sql.append("select   sum(FDebitAmount - FCreditAmount)  SubResult  from T_CAS_SubAcctJournal where ");
        sql.append(" FSubacctID='").append(accountBankId).append("'");
        sql.append(" AND FCurrencyId = '").append(currencyId).append("'");
        sql.append(" and FBookDate <= {").append(TypeConversionUtils.objToDate((Object)queryDate)).append("} ");
        sql.append(" AND FBookDate >= {").append(TypeConversionUtils.objToDate((Object)period.getBeginDate())).append(" } ");
        return sql.toString();
    }

    private BigDecimal getBalance(Context ctx, String accountBankId, String currencyId, Date queryDate) throws EASBizException, BOSException {
        BigDecimal balance = Constants.ZERO;
        SubAccountInfo subAccountInfo = SubAccountFactory.getLocalInstance(ctx).getSubAccountInfo((IObjectPK)new ObjectUuidPK(accountBankId));
        CompanyOrgUnitInfo company = null;
        if (subAccountInfo == null || subAccountInfo.getCompany() == null) {
            return balance;
        }
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(subAccountInfo.getCompany().getId().toString()));
        PeriodInfo period = null;
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (startPeriod == null) {
            return balance;
        }
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        period = queryDate.before(startPeriod.getBeginDate()) ? startPeriod : (queryDate.after(currentPeriod.getBeginDate()) ? currentPeriod : PeriodUtils.getPeriodInfo((Context)ctx, (Date)queryDate, (CompanyOrgUnitInfo)company));
        StringBuffer innerSql = new StringBuffer();
        innerSql.append(this.getPeriodStartSql(accountBankId, currencyId, period, queryDate));
        innerSql.append(" union all ");
        innerSql.append(this.getRangeSql(accountBankId, currencyId, period, queryDate));
        StringBuffer sql = new StringBuffer();
        sql.append("select isnull(sum(SubResult),0) Result from (");
        sql.append(innerSql);
        sql.append(") tt ");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (set.next()) {
                balance = set.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return balance;
    }

    @Override
    protected List _getInstantBalance(Context ctx, List subAcctCurrencyList, Date queryDate) throws BOSException, EASBizException {
        for (int j = 0; j < subAcctCurrencyList.size(); ++j) {
            BigDecimal balance = null;
            SubAcctCurrencyBalance destObj = null;
            destObj = (SubAcctCurrencyBalance)subAcctCurrencyList.get(j);
            balance = this.getBalance(ctx, destObj.getSubAcctId(), destObj.getCurrencyId(), queryDate);
            destObj.setBalance(balance);
        }
        return subAcctCurrencyList;
    }

    @Override
    protected void _setClosed(Context ctx, boolean closeStatus, IObjectPK pk) throws BOSException, EASBizException {
        SubAccountInfo info = (SubAccountInfo)this.getValue(ctx, pk);
        if (info == null || info.getId() == null) {
            return;
        }
        String subAccId = info.getId().toString();
        Object[] params = new String[]{subAccId};
        String sql = "";
        sql = closeStatus ? "UPDATE T_CAS_SUBACCOUNT SET FISCLOSED = 1 WHERE FID = ?" : "UPDATE T_CAS_SUBACCOUNT SET FISCLOSED = 0 WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }
}

