/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.hr.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.app.AbstractAdminTreeBuilderFacadeControllerBean;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.ITechPostType;
import com.kingdee.eas.hr.base.ITechnicalPost;
import com.kingdee.eas.hr.base.TechPostTypeCollection;
import com.kingdee.eas.hr.base.TechPostTypeFactory;
import com.kingdee.eas.hr.base.TechPostTypeInfo;
import com.kingdee.eas.hr.base.TechnicalPostCollection;
import com.kingdee.eas.hr.base.TechnicalPostFactory;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class AdminTreeBuilderFacadeControllerBean
extends AbstractAdminTreeBuilderFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.core.hr.app.AdminTreeBuilderFacadeControllerBean");

    @Override
    protected HashMap _getAdminOrgData(Context ctx, boolean includePosition, HashSet hroSet, String adminId) throws BOSException, EASBizException {
        return this._getAdminOrgData(ctx, includePosition, hroSet, adminId, false);
    }

    @Override
    protected HashMap _getAdminOrgData(Context ctx, boolean includePosition, HashSet hroSet, String adminId, boolean includeSealup) throws BOSException, EASBizException {
        return this._getAdminOrgData(ctx, includePosition, hroSet, adminId, includeSealup, true);
    }

    @Override
    protected HashMap _getAdminOrgData(Context ctx, boolean includePosition, HashSet hroSet, String adminId, boolean includeSealup, boolean showVirtualOrg) throws BOSException, EASBizException {
        return this._getAdminOrgData(ctx, includePosition, hroSet, adminId, includeSealup, showVirtualOrg, true);
    }

    @Override
    protected HashMap _getAdminOrgData(Context ctx, boolean includePosition, HashSet hroSet, String adminId, boolean includeSealup, boolean showVirtualOrg, boolean userOrgRange) throws BOSException, EASBizException {
        String rootId = adminId;
        HashMap map = new HashMap();
        ArrayList adminList = this.getAdminList(ctx, hroSet, includeSealup, rootId, userOrgRange);
        if (adminList == null || adminList.size() == 0) {
            return null;
        }
        if (StringUtils.isEmpty((String)adminId)) {
            rootId = this.getRootAdminID(ctx, adminList);
        }
        if (StringUtils.isEmpty((String)rootId)) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT FID,FParentID,FSortCode,FName_" + ctx.getLocale() + ",FLongNumber,FIsLeaf, FLevel, FIsSealUp ");
        sql.append("FROM T_ORG_Admin ");
        sql.append(" WHERE (FParentID = '");
        sql.append(rootId);
        if (StringUtils.isEmpty((String)adminId)) {
            sql.append("' OR FID = '");
            sql.append(rootId);
        }
        sql.append("') ");
        if (!showVirtualOrg) {
            sql.append(" AND FIsVirtual = 0 ");
        }
        if (!includeSealup) {
            sql.append("AND FIsSealUp = 0 ");
        }
        sql.append(" ORDER BY FSortCode,FLongNumber");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            HashMap<String, Integer> adminNodeType = new HashMap<String, Integer>();
            String longNumber = null;
            while (rows.next()) {
                int type = 0;
                longNumber = rows.getString("FLongNumber");
                if (adminList.contains(longNumber)) {
                    type = 1;
                } else {
                    int length = adminList.size();
                    for (int t = 0; t < length; ++t) {
                        if (adminList.get(t).toString().indexOf(longNumber + "!") == -1) continue;
                        type = 2;
                        break;
                    }
                }
                adminNodeType.put(rows.getString("FID"), new Integer(type));
            }
            map.put("AdminNodeType", adminNodeType);
            rows.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        map.put("AdminRowSet", rows);
        if (includePosition) {
            StringBuffer adminSql = new StringBuffer("SELECT FID ");
            adminSql.append(" FROM T_ORG_Admin ");
            adminSql.append(" WHERE (FParentID = '");
            adminSql.append(rootId);
            adminSql.append("' OR FID = '");
            adminSql.append(rootId);
            adminSql.append("') ");
            if (!includeSealup) {
                adminSql.append("AND FIsSealUp = 0 ");
            }
            StringBuffer positionSql = new StringBuffer("SELECT DISTINCT P.FID id ,P.FName_");
            positionSql.append(ctx.getLocale());
            positionSql.append(" name, CASE P.FID WHEN A.FResponPositionID THEN 1 ELSE 0 END AS DEFAULTPOSITION ,");
            positionSql.append(" FAdminOrgUnitID,P.FIndex PFIndex  ");
            positionSql.append(" FROM T_ORG_Position P ");
            positionSql.append(" INNER JOIN T_ORG_Admin A ON P.FAdminOrgUnitID = A.FID ");
            positionSql.append(" WHERE FAdminOrgUnitID IN( ");
            positionSql.append(adminSql.toString());
            positionSql.append(") ");
            boolean isDistabled = HRParamUtil.getParamOfHR(ctx, "IS_AFFAIR", null);
            if (!isDistabled) {
                positionSql.append(" AND (P.FDeletedStatus =1 OR P.FDeletedStatus IS NULL) ");
            }
            if (!showVirtualOrg) {
                sql.append(" AND A.FIsVirtual = 0 ");
            }
            if (!includeSealup) {
                positionSql.append("AND A.FIsSealUp = 0 ");
            }
            positionSql.append(" ORDER BY DEFAULTPOSITION DESC,PFIndex ASC");
            map.put("PositionRowSet", DbUtil.executeQuery((Context)ctx, (String)positionSql.toString()));
        }
        return map;
    }

    @Override
    protected HashMap _getAdminOrgDataByHR(Context ctx, boolean includePosition, HashSet hroSet, String adminId, boolean includeSealup, boolean showVirtualOrg) throws BOSException, EASBizException {
        String rootId = adminId;
        HashMap map = new HashMap();
        if (StringUtils.isEmpty((String)rootId)) {
            ArrayList adminList = this.getAdminListByHR(ctx, hroSet, includeSealup);
            if (adminList == null || adminList.size() == 0) {
                return null;
            }
            map.put("AdminRangeList", adminList);
            rootId = this.getRootAdminID(ctx, adminList);
            if (StringUtils.isEmpty((String)rootId)) {
                return null;
            }
        }
        StringBuffer sql = new StringBuffer("SELECT FID,FParentID,FSortCode,FName_" + ctx.getLocale() + ",FLongNumber,FIsLeaf, FLevel, FIsSealUp ");
        sql.append("FROM T_ORG_Admin ");
        sql.append(" WHERE (FParentID = '");
        sql.append(rootId);
        if (StringUtils.isEmpty((String)adminId)) {
            sql.append("' OR FID = '");
            sql.append(rootId);
        }
        sql.append("') ");
        if (!showVirtualOrg) {
            sql.append(" AND FIsVirtual = 0 ");
        }
        if (!includeSealup) {
            sql.append("AND FIsSealUp = 0 ");
        }
        sql.append(" ORDER BY FSortCode,FLongNumber");
        map.put("AdminRowSet", DbUtil.executeQuery((Context)ctx, (String)sql.toString()));
        if (includePosition) {
            StringBuffer adminSql = new StringBuffer("SELECT FID ");
            adminSql.append(" FROM T_ORG_Admin ");
            adminSql.append(" WHERE (FParentID = '");
            adminSql.append(rootId);
            adminSql.append("' OR FID = '");
            adminSql.append(rootId);
            adminSql.append("') ");
            if (!includeSealup) {
                adminSql.append("AND FIsSealUp = 0 ");
            }
            StringBuffer positionSql = new StringBuffer("SELECT DISTINCT P.FID id ,P.FName_");
            positionSql.append(ctx.getLocale());
            positionSql.append(" name, CASE P.FID WHEN A.FResponPositionID THEN 1 ELSE 0 END AS DEFAULTPOSITION ,");
            positionSql.append(" FAdminOrgUnitID,P.FIndex PFIndex  ");
            positionSql.append(" FROM T_ORG_Position P ");
            positionSql.append(" INNER JOIN T_ORG_Admin A ON P.FAdminOrgUnitID = A.FID ");
            positionSql.append(" WHERE FAdminOrgUnitID IN( ");
            positionSql.append(adminSql.toString());
            positionSql.append(") ");
            boolean isDistabled = HRParamUtil.getParamOfHR(ctx, "IS_AFFAIR", null);
            if (!isDistabled) {
                positionSql.append(" AND (P.FDeletedStatus =1 OR P.FDeletedStatus IS NULL) ");
            }
            if (!showVirtualOrg) {
                sql.append(" AND A.FIsVirtual = 0 ");
            }
            if (!includeSealup) {
                positionSql.append("AND A.FIsSealUp = 0 ");
            }
            positionSql.append(" ORDER BY DEFAULTPOSITION DESC,PFIndex ASC");
            map.put("PositionRowSet", DbUtil.executeQuery((Context)ctx, (String)positionSql.toString()));
        }
        return map;
    }

    @Override
    protected void _InputStandardTechnicalPost(Context ctx, IObjectCollection techCols) throws BOSException, EASBizException {
        TechnicalPostCollection postCols = (TechnicalPostCollection)techCols;
        ITechnicalPost iTech = TechnicalPostFactory.getLocalInstance(ctx);
        ITechPostType iType = TechPostTypeFactory.getLocalInstance(ctx);
        CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        for (int i = 0; i < postCols.size(); ++i) {
            TechnicalPostInfo info = postCols.get(i);
            TechPostTypeInfo typeInfo = this.checkTechPostTypeExist(ctx, info);
            if (typeInfo == null) {
                TechPostTypeInfo tInfo = info.getCategory();
                tInfo.setId(null);
                tInfo.setCU(ctrlInfo);
                tInfo.setHrOrgUnit(hrInfo);
                tInfo.setIsStandard(0);
                IObjectPK pk = iType.addnew((CoreBaseInfo)tInfo);
                tInfo.setId(BOSUuid.read((String)pk.toString()));
                TechnicalPostInfo aInfo = postCols.get(i);
                aInfo.setId(null);
                aInfo.setCU(ctrlInfo);
                aInfo.setCategory(tInfo);
                aInfo.setIsStandard(0);
                aInfo.setHrOrgUnit(hrInfo);
                iTech.addnew((CoreBaseInfo)aInfo);
                continue;
            }
            TechnicalPostInfo aInfo = postCols.get(i);
            aInfo.setId(null);
            aInfo.setCategory(typeInfo);
            aInfo.setIsStandard(0);
            aInfo.setCU(ctrlInfo);
            aInfo.setHrOrgUnit(hrInfo);
            iTech.addnew((CoreBaseInfo)aInfo);
        }
    }

    @Override
    protected ArrayList _getAdminTreeData(Context ctx, boolean includePosition, boolean includeVirtualOrg, HashSet hroSet) throws BOSException, EASBizException {
        return this._getAdminTreeData(ctx, includePosition, includeVirtualOrg, hroSet, false);
    }

    @Override
    protected ArrayList _getAdminTreeData(Context ctx, boolean includePosition, boolean includeVirtualOrg, HashSet hroSet, boolean includeSealup) throws BOSException, EASBizException {
        return this._getAdminTreeData(ctx, includePosition, includeVirtualOrg, hroSet, includeSealup, true);
    }

    @Override
    protected ArrayList _getAdminTreeData(Context ctx, boolean includePosition, boolean includeVirtualOrg, HashSet hroSet, boolean includeSealup, boolean showHiddenInChart) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT FLongNumber ");
        sql.append(" FROM T_ORG_Admin ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
        if (hroSet != null && hroSet.size() > 0) {
            sql.append(" INNER JOIN T_ORG_UnitRelation ON T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID");
        }
        sql.append(" WHERE T_PM_OrgRange.FType = 20 ");
        if (!includeSealup) {
            sql.append("AND T_ORG_Admin.FIsSealUp = 0 ");
        }
        sql.append(" AND T_PM_OrgRange.FUserID='");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        if (hroSet != null && hroSet.size() > 0) {
            sql.append("' AND T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' AND T_ORG_UnitRelation.FToUnitID IN (");
            Iterator iter = hroSet.iterator();
            while (iter.hasNext()) {
                sql.append("'");
                sql.append(iter.next());
                if (!iter.hasNext()) continue;
                sql.append("',");
            }
            sql.append("') ORDER BY FLongNumber ");
        } else {
            sql.append("' ORDER BY FLongNumber ");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> adminList = new ArrayList<String>();
        try {
            while (rows.next()) {
                adminList.add(rows.getString("FLongNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (adminList.size() == 0) {
            return null;
        }
        String longNumber = adminList.get(0).toString();
        int size = adminList.size();
        for (int i = 1; i < size; ++i) {
            if (adminList.get(i).toString().indexOf(longNumber) != -1) continue;
            longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
        }
        sql = new StringBuffer("SELECT T_ORG_Admin.FID,FParentID,FSortCode,FName_" + ctx.getLocale() + ",FLongNumber,FIsLeaf, FLevel ");
        sql.append("FROM T_ORG_Admin ");
        if (!showHiddenInChart) {
            sql.append("LEFT OUTER JOIN T_HR_AdminOther ON T_ORG_Admin.FID=T_HR_AdminOther.FAdminOrgUnitID ");
        }
        sql.append("WHERE (FLongNumber = '");
        sql.append(longNumber);
        sql.append("' OR FLongNumber LIKE '");
        sql.append(longNumber);
        sql.append("!%') ");
        if (!includeVirtualOrg) {
            sql.append(" AND FIsVirtual = 0 ");
        }
        if (!includeSealup) {
            sql.append("AND FIsSealUp = 0 ");
        }
        if (!showHiddenInChart) {
            sql.append("AND (T_HR_AdminOther.FIsVisibleInOrgChart=1 OR T_HR_AdminOther.FIsVisibleInOrgChart IS NULL) ");
        }
        sql.append(" ORDER BY FLongNumber ");
        ArrayList<Object> returnList = new ArrayList<Object>();
        returnList.add(adminList);
        returnList.add(DbUtil.executeQuery((Context)ctx, (String)sql.toString()));
        if (includePosition) {
            sql = new StringBuffer("SELECT distinct P.FID id ,P.FName_");
            sql.append(ctx.getLocale());
            sql.append(" name, CASE P.FID WHEN A.FResponPositionID THEN 1 ELSE 0 END AS DEFAULTPOSITION ,");
            sql.append(" FAdminOrgUnitID,P.FIndex PFIndex  ");
            sql.append(" FROM T_ORG_Position P ");
            sql.append(" INNER JOIN T_ORG_Admin A ON P.FAdminOrgUnitID=A.FID ");
            sql.append(" INNER JOIN T_PM_OrgRange R ON A.FID = R.FOrgID ");
            sql.append(" WHERE R.FType = 20 AND R.FUserID='");
            sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            sql.append("' ");
            boolean isDistabled = HRParamUtil.getParamOfHR(ctx, "IS_AFFAIR", null);
            if (!isDistabled) {
                sql.append(" AND (P.FDeletedStatus =1 OR P.FDeletedStatus IS NULL) ");
            }
            if (!includeSealup) {
                sql.append("AND A.FIsSealUp = 0 ");
            }
            sql.append("ORDER BY DEFAULTPOSITION DESC,PFIndex ASC");
            returnList.add(DbUtil.executeQuery((Context)ctx, (String)sql.toString()));
        } else {
            returnList.add("NoPositionData");
        }
        sql = new StringBuffer("SELECT DISTINCT FFromUnitID, FToUnitID ");
        sql.append(" FROM T_ORG_UnitRelation ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_UnitRelation.FFromUnitID = T_PM_OrgRange.FOrgID ");
        sql.append(" WHERE T_PM_OrgRange.FType = 20 AND T_PM_OrgRange.FUserID='");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql.append("' AND T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            FullOrgUnitCollection orgCollection = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), OrgType.HRO, null, "HR_Org_View");
            HashSet<String> hrOrgSet = new HashSet<String>();
            if (orgCollection != null) {
                int n = orgCollection.size();
                for (int i = 0; i < n; ++i) {
                    hrOrgSet.add(orgCollection.get(i).getId().toString());
                }
            }
            String hrOrgId = null;
            String fromUnitId = null;
            HashSet<String> hasPermissionOrgSet = new HashSet<String>();
            while (rows.next()) {
                fromUnitId = rows.getString("FFromUnitID");
                hrOrgId = rows.getString("FToUnitID");
                if (!hrOrgSet.contains(hrOrgId)) continue;
                hasPermissionOrgSet.add(fromUnitId);
            }
            returnList.add(hasPermissionOrgSet);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return returnList;
    }

    @Override
    protected ArrayList _getOrgChartData(Context ctx) throws BOSException, EASBizException {
        return this._getOrgChartData(ctx, false);
    }

    @Override
    protected ArrayList _getOrgChartData(Context ctx, boolean includeSealup) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        MetaDataPK queryPK = null;
        MetaDataPK queryPK2 = null;
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.PositionOfAdminQuery");
            queryPK2 = new MetaDataPK("com.kingdee.eas.hr.org.app.PersonOfPositionQuery");
            CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId()));
        } else {
            queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.AdminOfPositionQuery");
            queryPK2 = new MetaDataPK("com.kingdee.eas.hr.org.app.PositionOfPersonQuery");
            filterInfo.getFilterItems().add(new FilterItemInfo("PMUser.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
        }
        if (includeSealup) {
            filterInfo.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.IsSealUp", (Object)new Integer(0)));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.responPosition.deletedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        ArrayList<IRowSet> list = new ArrayList<IRowSet>(2);
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)queryExcu.getSQL());
        list.add(rows);
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK2);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows2 = DbUtil.executeQuery((Context)ctx, (String)queryExcu.getSQL());
        list.add(rows2);
        return list;
    }

    private ArrayList getAdminList(Context ctx, HashSet hroSet, boolean includeSealup, String rootId, boolean userOrgRange) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT FLongNumber ");
        sql.append(" FROM T_ORG_Admin ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
        if (hroSet != null && hroSet.size() > 0) {
            sql.append(" INNER JOIN T_ORG_UnitRelation ON T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID");
        }
        sql.append(" WHERE T_PM_OrgRange.FType = 20 ");
        if (!StringUtils.isEmpty((String)rootId)) {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select flongnumber from t_org_admin where fid = '" + rootId + "'"));
            try {
                if (rowSet.next()) {
                    sql.append("and t_org_admin.flongnumber like '");
                    sql.append(rowSet.getString("flongnumber"));
                    sql.append("%' ");
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        if (!includeSealup) {
            sql.append("AND T_ORG_Admin.FIsSealUp = 0 ");
        }
        if (userOrgRange) {
            sql.append(" AND T_PM_OrgRange.FUserID='");
            sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            sql.append("'");
        }
        if (hroSet != null && hroSet.size() > 0) {
            sql.append(" AND T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' AND T_ORG_UnitRelation.FToUnitID IN (");
            Iterator iter = hroSet.iterator();
            while (iter.hasNext()) {
                sql.append("'");
                sql.append(iter.next());
                if (!iter.hasNext()) continue;
                sql.append("',");
            }
            sql.append("') ORDER BY FLongNumber ");
        } else {
            sql.append(" ORDER BY FLongNumber ");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> adminList = new ArrayList<String>();
        try {
            while (rows.next()) {
                adminList.add(rows.getString("FLongNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (adminList.size() == 0) {
            return null;
        }
        return adminList;
    }

    private String getRootAdminID(Context ctx, ArrayList adminList) throws BOSException, EASBizException {
        if (adminList == null || adminList.size() == 0) {
            return null;
        }
        String longNumber = adminList.get(0).toString();
        int size = adminList.size();
        for (int i = 1; i < size; ++i) {
            for (int count = 0; adminList.get(i).toString().indexOf(longNumber) == -1 && count < 20; ++count) {
                longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
            }
        }
        StringBuffer sql = new StringBuffer("SELECT FID FROM T_ORG_Admin WHERE FLongNumber = '");
        sql.append(longNumber);
        sql.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                return rows.getString("FID");
            }
            return null;
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private ArrayList getAdminListByHR(Context ctx, HashSet hroSet, boolean includeSealup) throws BOSException, EASBizException {
        ArrayList<String> adminList = new ArrayList<String>();
        if (hroSet != null && hroSet.size() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("select adminOrg.FLongNumber from T_ORG_Admin adminOrg where adminOrg.fid in (");
            sql.append("select unitRelation.FFromUnitId from T_ORG_UnitRelation as unitRelation ");
            sql.append("inner join T_ORG_TypeRelation as relationType ON unitRelation.FTypeRelationID = relationType.FID ");
            sql.append("where relationType.FFromType = 0 AND relationType.FToType = 16 ");
            sql.append(" and unitRelation.FToUnitID in (");
            Iterator iter = hroSet.iterator();
            while (iter.hasNext()) {
                sql.append("'");
                sql.append(iter.next());
                if (!iter.hasNext()) continue;
                sql.append("',");
            }
            sql.append("'))");
            if (includeSealup) {
                sql.append("and adminOrg.FIsSealUp = 0 order by adminOrg.FLongNumber");
            }
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rows.next()) {
                    adminList.add(rows.getString("FLongNumber"));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return adminList;
    }

    TechPostTypeInfo checkTechPostTypeExist(Context ctx, TechnicalPostInfo info) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getCategory().getName()));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isStandard", (Object)new Integer(0)));
        view.setFilter(filter);
        ITechPostType iType = TechPostTypeFactory.getLocalInstance(ctx);
        TechPostTypeCollection postCols = iType.getTechPostTypeCollection(view);
        if (postCols.size() != 0) {
            return postCols.get(0);
        }
        return null;
    }
}

