/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.hr.util;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.AdminTreeBuilderFacadeFactory;
import com.kingdee.eas.base.core.hr.IAdminTreeBuilderFacade;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class AdminTreeBuilder {
    private static final Icon groupIcon = EASResource.getIcon((String)"imgTree_group");
    private static final Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    private static final Icon positionIcon = EASResource.getIcon((String)"imgTree_position");
    private boolean includePosition = false;
    private HashMap adminNodeType = null;
    private HashSet hroSet = null;
    private boolean includeSealup = false;
    private boolean showVirtualOrg = false;

    public AdminTreeBuilder() throws Exception {
    }

    public void setIncludeSealup(boolean includeSealup) {
        this.includeSealup = includeSealup;
    }

    public void setShowVirtualOrg(boolean showVirtualOrg) {
        this.showVirtualOrg = showVirtualOrg;
    }

    public AdminTreeBuilder(boolean includePosition) throws Exception {
        this.includePosition = includePosition;
    }

    public AdminTreeBuilder(boolean includePosition, HashSet hroSet) throws Exception {
        this.includePosition = includePosition;
        this.hroSet = hroSet;
    }

    public void buildTree(JTree treeMain, boolean includeSealUp) throws Exception {
        this.buildTree(treeMain, includeSealUp, false);
    }

    public void buildTree(JTree treeMain, boolean includeSealUp, boolean isOnlyHRFilter) throws Exception {
        this.buildTree(treeMain, includeSealUp, isOnlyHRFilter, true);
    }

    public void buildTree(final JTree treeMain, final boolean includeSealUp, boolean isOnlyHRFilter, final boolean userOrgRange) throws Exception {
        treeMain.setModel(null);
        treeMain.setShowsRootHandles(true);
        IAdminTreeBuilderFacade iATBFacade = AdminTreeBuilderFacadeFactory.getRemoteInstance();
        HashMap map = null;
        map = isOnlyHRFilter ? iATBFacade.getAdminOrgDataByHR(isOnlyHRFilter, this.hroSet, null, includeSealUp, isOnlyHRFilter) : iATBFacade.getAdminOrgData(this.includePosition, this.hroSet, null, includeSealUp, this.showVirtualOrg, userOrgRange);
        if (map == null || map.size() == 0) {
            return;
        }
        KDTreeNode rootNode = this.buildTreeNode(null, map);
        if (rootNode == null) {
            treeMain.setModel(null);
        } else {
            treeMain.setModel(new DefaultTreeModel((TreeNode)rootNode));
        }
        treeMain.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                try {
                    AdminTreeBuilder.this.buildChildNode((KDTreeNode)e.getPath().getLastPathComponent(), includeSealUp, userOrgRange);
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)treeMain, (Throwable)exc);
                }
            }
        });
        treeMain.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    AdminTreeBuilder.this.buildChildNode((KDTreeNode)e.getPath().getLastPathComponent(), includeSealUp, userOrgRange);
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)treeMain, (Throwable)exc);
                }
            }
        });
    }

    public void buildTree(JTree treeMain) throws Exception {
        this.buildTree(treeMain, this.includeSealup);
    }

    private void buildChildNode(KDTreeNode parentNode, boolean includeSealup, boolean userOrgRange) throws Exception {
        if (parentNode.isVirtual()) {
            parentNode.setVirtual(false);
            parentNode.removeAllChildren();
            if (!(parentNode.getUserObject() instanceof AdminOrgUnitInfo)) {
                return;
            }
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)parentNode.getUserObject();
            IAdminTreeBuilderFacade iATBFacade = AdminTreeBuilderFacadeFactory.getRemoteInstance();
            HashMap map = iATBFacade.getAdminOrgData(this.includePosition, this.hroSet, adminInfo.getId().toString(), includeSealup, this.showVirtualOrg, userOrgRange);
            this.buildTreeNode(parentNode, map);
        }
    }

    private KDTreeNode buildTreeNode(KDTreeNode rootTreeNode, HashMap map) throws Exception {
        if (map == null) {
            return null;
        }
        this.adminNodeType = (HashMap)map.get("AdminNodeType");
        IRowSet adminRowSet = (IRowSet)map.get("AdminRowSet");
        if (adminRowSet == null) {
            return null;
        }
        KDTreeNode subTreeNode = null;
        AdminOrgUnitInfo adminInfo = null;
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        int nodeType = 1;
        if (rootTreeNode != null && rootTreeNode.getUserObject() != null && rootTreeNode.getUserObject() instanceof AdminOrgUnitInfo) {
            adminInfo = (AdminOrgUnitInfo)rootTreeNode.getUserObject();
            nodeMap.put(adminInfo.getId().toString(), rootTreeNode);
        }
        adminRowSet.beforeFirst();
        while (adminRowSet.next()) {
            adminInfo = AdminTreeBuilder.createAdminUnitInfo(adminRowSet);
            if (this.adminNodeType != null && this.adminNodeType.containsKey(adminInfo.getId().toString()) && this.adminNodeType.get(adminInfo.getId().toString()) instanceof Integer) {
                nodeType = (Integer)this.adminNodeType.get(adminInfo.getId().toString());
            }
            if (rootTreeNode == null) {
                rootTreeNode = new KDTreeNode((Object)adminInfo);
                rootTreeNode.setCustomIcon(groupIcon);
                nodeMap.put(adminInfo.getId().toString(), rootTreeNode);
                if (nodeType != 2) continue;
                HRTreeUtil.disableTreeNode((DefaultKingdeeTreeNode)rootTreeNode);
                continue;
            }
            subTreeNode = new KDTreeNode((Object)adminInfo);
            if (nodeType == 0) continue;
            if (nodeType == 2) {
                HRTreeUtil.disableTreeNode((DefaultKingdeeTreeNode)subTreeNode);
            }
            if (!adminInfo.isIsLeaf()) {
                subTreeNode.setVirtual(true);
                subTreeNode.add((MutableTreeNode)new KDTreeNode((Object)""));
            }
            subTreeNode.setCustomIcon(companyIcon);
            rootTreeNode.add((MutableTreeNode)subTreeNode);
            nodeMap.put(adminInfo.getId().toString(), subTreeNode);
        }
        if (this.includePosition) {
            IRowSet positionRowSet = (IRowSet)map.get("PositionRowSet");
            positionRowSet.beforeFirst();
            this.addPositionNode(nodeMap, positionRowSet);
        }
        return rootTreeNode;
    }

    private void addPositionNode(HashMap nodeMap, IRowSet positionRowSet) throws Exception {
        if (positionRowSet == null || positionRowSet.size() == 0) {
            return;
        }
        String adminID = null;
        PositionInfo positionInfo = null;
        KDTreeNode positionTreeNode = null;
        KDTreeNode parentNode = null;
        KDTreeNode childNode = null;
        int index = 0;
        while (positionRowSet.next()) {
            adminID = positionRowSet.getString("FAdminOrgUnitID");
            if (!nodeMap.containsKey(adminID) || HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)(parentNode = (KDTreeNode)nodeMap.get(adminID)))) continue;
            positionInfo = AdminTreeBuilder.createPositionInfo(positionRowSet);
            positionTreeNode = new KDTreeNode((Object)positionInfo);
            positionTreeNode.setCustomIcon(positionIcon);
            if (positionRowSet.getBoolean("DefaultPosition")) {
                parentNode.insert((MutableTreeNode)positionTreeNode, 0);
                continue;
            }
            if (parentNode.getChildCount() > 0) {
                childNode = (KDTreeNode)parentNode.getChildAt(0);
                index = positionRowSet.getInt("PFIndex") + 1;
                if (childNode.getUserObject() instanceof PositionInfo && parentNode.getChildCount() > index && positionRowSet.getString("PFIndex") != null && positionRowSet.getInt("PFIndex") >= 0) {
                    this.insertPositionNode(parentNode, positionTreeNode, index);
                    continue;
                }
                if (childNode.getUserObject() instanceof PositionInfo && parentNode.getChildCount() <= index) {
                    this.insertPositionNode(parentNode, positionTreeNode, parentNode.getChildCount());
                    continue;
                }
                if (childNode.getUserObject() instanceof PositionInfo) {
                    parentNode.insert((MutableTreeNode)positionTreeNode, 1);
                    continue;
                }
                parentNode.insert((MutableTreeNode)positionTreeNode, 0);
                continue;
            }
            parentNode.add((MutableTreeNode)positionTreeNode);
        }
        nodeMap = null;
    }

    private void insertPositionNode(KDTreeNode parent, KDTreeNode child, int index) {
        for (int i = index; i > 0; --i) {
            if (!(((KDTreeNode)parent.getChildAt(i - 1)).getUserObject() instanceof PositionInfo)) continue;
            parent.insert((MutableTreeNode)child, i);
            return;
        }
        parent.insert((MutableTreeNode)child, 0);
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("FID")));
        adminInfo.setName(row.getString("FName_" + SysContext.getSysContext().getLocale()));
        adminInfo.setSortCode(row.getString("FSortCode"));
        adminInfo.setLongNumber(row.getString("FLongNumber"));
        adminInfo.setIsLeaf(row.getBoolean("FIsLeaf"));
        adminInfo.setLevel(row.getInt("FLevel"));
        adminInfo.setIsSealUp(row.getBoolean("FIsSealUp"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (StringUtils.isEmpty((String)row.getString("FParentID"))) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("FParentID")));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    private static PositionInfo createPositionInfo(IRowSet row) throws Exception {
        PositionInfo info = new PositionInfo();
        info.setId(BOSUuid.read((String)row.getString("id")));
        info.setName(row.getString("name"));
        return info;
    }
}

