/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.base.EmployeeBaseException;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.base.ITechPostType;
import com.kingdee.eas.hr.base.ITechnicalPost;
import com.kingdee.eas.hr.base.TechPostTypeCollection;
import com.kingdee.eas.hr.base.TechPostTypeFactory;
import com.kingdee.eas.hr.base.TechPostTypeInfo;
import com.kingdee.eas.hr.base.TechnicalPostCollection;
import com.kingdee.eas.hr.base.TechnicalPostFactory;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.app.AbstractTechPostTypeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;

public class TechPostTypeControllerBean
extends AbstractTechPostTypeControllerBean {
    protected void verifyData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._checkNameBlank(ctx, model);
        this._checkNumberExists(ctx, model);
        TechPostTypeInfo dataBaseInfo = (TechPostTypeInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        FilterItemInfo filterItem1 = new FilterItemInfo("isStandard", (Object)new Integer(0), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem1);
        if (dataBaseInfo.getCU() == null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)super.getCU(ctx, (ObjectBaseInfo)dataBaseInfo).getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)dataBaseInfo.getCU().getId().toString(), CompareType.EQUALS));
        }
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, (DataBaseInfo)dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.verifyData(ctx, model);
        TechPostTypeInfo typeInfo = (TechPostTypeInfo)model;
        super._addnew(ctx, pk, (IObjectValue)typeInfo);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verifyData(ctx, model);
        TechPostTypeInfo typeInfo = (TechPostTypeInfo)model;
        return super._addnew(ctx, (IObjectValue)typeInfo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.verifyData(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkHasExistTechnicalPost(ctx, pk);
        super._delete(ctx, pk);
    }

    void checkHasExistTechnicalPost(Context ctx, IObjectPK pk) throws EmployeeBaseException, EASBizException, BOSException {
        String strQl = "select * where category.id='" + pk.toString() + "'";
        ITechnicalPost iTech = TechnicalPostFactory.getLocalInstance(ctx);
        if (iTech.exists(strQl)) {
            throw new EmployeeBaseException(EmployeeBaseException.CAN_NOT_DELETE_TECHNICALPOSTTYPE);
        }
    }

    protected void _checkNumberExists(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TechPostTypeInfo postInfo = (TechPostTypeInfo)model;
        if (!StringUtils.isEmpty((String)postInfo.getNumber())) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)postInfo.getNumber(), CompareType.EQUALS));
            if (postInfo.getCU() == null) {
                filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)super.getCU(ctx, (ObjectBaseInfo)postInfo).getId().toString(), CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)postInfo.getCU().getId().toString(), CompareType.EQUALS));
            }
            if (postInfo.getId() != null && !StringUtils.isEmpty((String)postInfo.getId().toString())) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)postInfo.getId().toString(), CompareType.NOTEQUALS));
            }
            if (this._exists(ctx, filter)) {
                throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{postInfo.getNumber()});
            }
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _inputStandardTechnicalPost(Context ctx, IObjectCollection techCols) throws BOSException, EASBizException {
        TechnicalPostCollection postCols = (TechnicalPostCollection)techCols;
        ITechnicalPost iTech = TechnicalPostFactory.getLocalInstance(ctx);
        ITechPostType iType = TechPostTypeFactory.getLocalInstance(ctx);
        CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        for (int i = 0; i < postCols.size(); ++i) {
            TechnicalPostInfo info = postCols.get(i);
            TechPostTypeInfo typeInfo = this.checkTechPostTypeExist(ctx, info);
            HROrgUnitInfo hrOrgUnit = info.getHrOrgUnit();
            if (typeInfo == null) {
                TechPostTypeInfo tInfo = info.getCategory();
                tInfo.setId(null);
                tInfo.setCU(ctrlInfo);
                tInfo.setHrOrgUnit(hrOrgUnit);
                tInfo.setIsStandard(0);
                IObjectPK pk = iType.addnew((CoreBaseInfo)tInfo);
                tInfo.setId(BOSUuid.read((String)pk.toString()));
                TechnicalPostInfo aInfo = postCols.get(i);
                aInfo.setId(null);
                aInfo.setCU(ctrlInfo);
                aInfo.setCategory(tInfo);
                aInfo.setIsStandard(0);
                aInfo.setHrOrgUnit(hrOrgUnit);
                iTech.addnew((CoreBaseInfo)aInfo);
                continue;
            }
            TechnicalPostInfo aInfo = postCols.get(i);
            aInfo.setId(null);
            aInfo.setCategory(typeInfo);
            aInfo.setIsStandard(0);
            aInfo.setCU(ctrlInfo);
            aInfo.setHrOrgUnit(hrOrgUnit);
            iTech.addnew((CoreBaseInfo)aInfo);
        }
    }

    TechPostTypeInfo checkTechPostTypeExist(Context ctx, TechnicalPostInfo info) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getCategory().getName()));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isStandard", (Object)0));
        view.setFilter(filter);
        ITechPostType iType = TechPostTypeFactory.getLocalInstance(ctx);
        TechPostTypeCollection postCols = iType.getTechPostTypeCollection(view);
        if (postCols.size() != 0) {
            return postCols.get(0);
        }
        return null;
    }
}

