/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.base.EmployeeBaseException;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.base.ITechPostType;
import com.kingdee.eas.hr.base.ITechnicalPost;
import com.kingdee.eas.hr.base.TechPostTypeCollection;
import com.kingdee.eas.hr.base.TechPostTypeFactory;
import com.kingdee.eas.hr.base.TechPostTypeInfo;
import com.kingdee.eas.hr.base.TechnicalPostCollection;
import com.kingdee.eas.hr.base.TechnicalPostFactory;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.app.AbstractTechnicalPostControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;

public class TechnicalPostControllerBean
extends AbstractTechnicalPostControllerBean {
    protected void _checkNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        String name = dataBaseInfo.getName(SysContext.getSysContext().getLocale());
        if (name == null || name.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
    }

    protected void verifyData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._checkNameBlank(ctx, model);
        this._checkTechTypeBlank(ctx, model);
        this._checkTechNameRup(ctx, model);
        this._checkNumberExists(ctx, model);
    }

    void _checkTechNameRup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        TechnicalPostInfo info = (TechnicalPostInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("category.id", (Object)info.getCategory().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName(), CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EmployeeBaseException(EmployeeBaseException.SAME_TYPE_NAME_NOT_RUP);
        }
    }

    protected void _checkTechTypeBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TechnicalPostInfo info = (TechnicalPostInfo)model;
        TechPostTypeInfo typeInfo = info.getCategory();
        if (typeInfo == null) {
            throw new EmployeeBaseException(EmployeeBaseException.MUST_INPUT_TECHNICALLEVEL);
        }
    }

    protected void _checkNumberExists(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TechnicalPostInfo postInfo = (TechnicalPostInfo)model;
        if (!StringUtils.isEmpty((String)postInfo.getNumber())) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)postInfo.getNumber(), CompareType.EQUALS));
            if (postInfo.getId() != null && !StringUtils.isEmpty((String)postInfo.getId().toString())) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)postInfo.getId().toString(), CompareType.NOTEQUALS));
            }
            if (this._exists(ctx, filter)) {
                throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{postInfo.getNumber()});
            }
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.verifyData(ctx, model);
        TechnicalPostInfo postInfo = (TechnicalPostInfo)model;
        super._addnew(ctx, pk, (IObjectValue)postInfo);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verifyData(ctx, model);
        TechnicalPostInfo postInfo = (TechnicalPostInfo)model;
        return super._addnew(ctx, (IObjectValue)postInfo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.verifyData(ctx, model);
        TechnicalPostInfo postInfo = (TechnicalPostInfo)model;
        super._update(ctx, pk, (IObjectValue)postInfo);
    }

    @Override
    protected void _InputStandardTechnicalPost(Context ctx, IObjectCollection techCols) throws BOSException, EASBizException {
        TechnicalPostCollection postCols = (TechnicalPostCollection)techCols;
        ITechnicalPost iTech = TechnicalPostFactory.getLocalInstance(ctx);
        ITechPostType iType = TechPostTypeFactory.getLocalInstance(ctx);
        CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        for (int i = 0; i < postCols.size(); ++i) {
            TechnicalPostInfo info = postCols.get(i);
            TechPostTypeInfo typeInfo = this.checkTechPostTypeExist(ctx, info);
            HROrgUnitInfo hrOrgUnit = info.getHrOrgUnit();
            if (typeInfo == null) {
                TechPostTypeInfo tInfo = info.getCategory();
                tInfo.setId(null);
                tInfo.setCU(ctrlInfo);
                tInfo.setHrOrgUnit(hrOrgUnit);
                tInfo.setIsStandard(0);
                IObjectPK pk = iType.addnew((CoreBaseInfo)tInfo);
                tInfo.setId(BOSUuid.read((String)pk.toString()));
                TechnicalPostInfo aInfo = postCols.get(i);
                aInfo.setId(null);
                aInfo.setCU(ctrlInfo);
                aInfo.setCategory(tInfo);
                aInfo.setIsStandard(0);
                aInfo.setHrOrgUnit(hrOrgUnit);
                iTech.addnew((CoreBaseInfo)aInfo);
                continue;
            }
            TechnicalPostInfo aInfo = postCols.get(i);
            aInfo.setId(null);
            aInfo.setCategory(typeInfo);
            aInfo.setIsStandard(0);
            aInfo.setCU(ctrlInfo);
            aInfo.setHrOrgUnit(hrOrgUnit);
            iTech.addnew((CoreBaseInfo)aInfo);
        }
    }

    TechPostTypeInfo checkTechPostTypeExist(Context ctx, TechnicalPostInfo info) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getCategory().getName()));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isStandard", (Object)new Integer(0)));
        view.setFilter(filter);
        ITechPostType iType = TechPostTypeFactory.getLocalInstance(ctx);
        TechPostTypeCollection postCols = iType.getTechPostTypeCollection(view);
        if (postCols.size() != 0) {
            return postCols.get(0);
        }
        return null;
    }
}

