/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.framework.DataStateEnum;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.MaterialTrademarkException;
import com.kingdee.eas.mm.basedata.MaterialTrademarkInfo;
import com.kingdee.eas.mm.basedata.app.AbstractMaterialTrademarkControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MaterialTrademarkControllerBean
extends AbstractMaterialTrademarkControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.basedata.app.MaterialTrademarkControllerBean");
    private static final String DIRECTDELIVERYSOURCE = "com.kingdee.eas.mm.basedata.MaterialTrademarkResource";
    boolean isAutoNumber = false;
    ICodingRuleManager iCodingRuleManager = null;

    private boolean isAutoNumber(IObjectValue model, Context ctx) throws BOSException, EASBizException {
        String cuId;
        if (this.iCodingRuleManager == null) {
            this.iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        }
        return this.iCodingRuleManager.isExist(model, cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
    }

    private boolean isAddView(IObjectValue model, Context ctx) throws BOSException, EASBizException {
        String cuId;
        if (this.iCodingRuleManager == null) {
            this.iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        }
        return this.iCodingRuleManager.isAddView(model, cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, model);
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        if (this.isAutoNumber(model, ctx) && !this.isAddView(model, ctx)) {
            MaterialTrademarkInfo info = (MaterialTrademarkInfo)model;
            info.setNumber(this.iCodingRuleManager.getNonbreakNumber(model, cuId));
        }
        return super._addnew(ctx, model);
    }

    private void addNewCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!this.isAutoNumber(model, ctx)) {
            this._checkNumberBlank(ctx, model);
        }
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
    }

    protected void _cancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        for (int i = 0; i < pks.length; ++i) {
            IObjectPK pk = pks[i];
            MaterialTrademarkInfo info = super.getMaterialTrademarkInfo(ctx, pk);
            if (pks.length == 1 && DataStateEnum.DISABLE.equals((Object)info.getStatus())) {
                throw new MaterialTrademarkException(MaterialTrademarkException.ROWSTATUS_CANCEL);
            }
            info.setStatus(DataStateEnum.DISABLE);
            super._update(ctx, pk, (IObjectValue)info);
        }
    }

    private String getResourceMsg(String key, Context ctx) {
        return ResourceBase.getString((String)DIRECTDELIVERYSOURCE, (String)key, (Locale)ctx.getLocale());
    }

    protected void _cancelcancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        for (int i = 0; i < pks.length; ++i) {
            IObjectPK pk = pks[i];
            MaterialTrademarkInfo info = super.getMaterialTrademarkInfo(ctx, pk);
            if (pks.length == 1 && DataStateEnum.ENABLE.equals((Object)info.getStatus())) {
                throw new MaterialTrademarkException(MaterialTrademarkException.ROWSTATUS_CAN);
            }
            info.setStatus(DataStateEnum.ENABLE);
            super._update(ctx, pk, (IObjectValue)info);
        }
    }

    protected void _delete(Context ctx, IObjectPK dataBaseDPK) throws BOSException, EASBizException {
        MaterialTrademarkInfo info = this.getMaterialTrademarkInfo(ctx, dataBaseDPK);
        this.rollBackNumber(ctx, (IObjectValue)info, (OrgUnitInfo)info.getAdminCU());
        super._delete(ctx, dataBaseDPK);
    }

    private boolean rollBackNumber(Context ctx, IObjectValue model, OrgUnitInfo mainOrgInfo) throws EASBizException, BOSException {
        String mainOrgId;
        if (model == null || mainOrgInfo == null || mainOrgInfo.getId() == null) {
            return false;
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = codingRuleManager.getRuleStatus(model, mainOrgInfo.getId().toString());
        if (ruleStatus != null && ruleStatus.isExist() && codingRuleManager.isExist(model, mainOrgId = mainOrgInfo.getId().toString()) && codingRuleManager.isUseIntermitNumber(model, mainOrgId)) {
            return codingRuleManager.recycleNumber(model, mainOrgId, model.getString("number"));
        }
        return false;
    }
}

