/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.framework.DataStateEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.MaterialTrademarkFactory;
import com.kingdee.eas.mm.basedata.MaterialTrademarkInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.Enum;
import java.util.Hashtable;
import java.util.Locale;

public class MaterialTrademarkDataTransmission
extends AbstractDataTransmission {
    private String trademarkResource = "com.kingdee.eas.mm.basedata.MaterialTrademarkResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialTrademarkFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this.innerTransmit(hsData, ctx);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (EASBizException ee) {
            throw new TaskExternalException(ee.getMessage());
        }
        catch (Exception ex) {
            throw new TaskExternalException(ExceptionUtil.getExcLinkStackTrace((Throwable)ex));
        }
    }

    private CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws Exception {
        MaterialTrademarkInfo info = new MaterialTrademarkInfo();
        info.setNumber(DataImportTools.getDataString((Hashtable)hsData, (String)"FNumber"));
        info.setName(DataImportTools.getDataString((Hashtable)hsData, (String)"FName"));
        info.setDescription(DataImportTools.getDataString((Hashtable)hsData, (String)"FDescription"));
        info.setStatus(this.getDataStateEnum(DataImportTools.getDataString((Hashtable)hsData, (String)"FStatus"), ctx));
        return info;
    }

    private DataStateEnum getDataStateEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(DataImportTools.getResString((String)"DataImport_UsedStatus_Error", (Context)ctx));
        }
        if (DataImportTools.EnumEqualByAlias((String)value, (Enum)DataStateEnum.ENABLE)) {
            return DataStateEnum.ENABLE;
        }
        if (DataImportTools.EnumEqualByAlias((String)value, (Enum)DataStateEnum.DISABLE)) {
            return DataStateEnum.DISABLE;
        }
        throw new TaskExternalException(ResourceBase.getString((String)this.trademarkResource, (String)"STATUS_VALUE_INVALID", (Locale)ctx.getLocale()));
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"FNumber", (Object)rs.getString("number"));
            DataImportTools.putToHashtable(result, (Object)"FName", (Object)rs.getString("name"));
            DataImportTools.putToHashtable(result, (Object)"FDescription", (Object)rs.getString("description"));
            DataImportTools.putToHashtable(result, (Object)"FStatus", (Object)DataStateEnum.getEnum((int)rs.getInt("status")).getAlias(ctx.getLocale()));
        }
        catch (Exception e) {
            throw new TaskExternalException(ExceptionUtil.getExcLinkStackTrace((Throwable)e), (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.mm.basedata.app.MaterialTrademarkQuery";
    }
}

