/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.bot.engine.common.BOTPFormulaEngineTools;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTExtMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.BOTTransform;
import com.kingdee.bos.metadata.bot.BOTTransformSQLE;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.openapi.third.exception.BizException;
import com.kingdee.bos.openapi.third.exception.InvokeNetworkException;
import com.kingdee.bos.openapi.third.exception.LoginException;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.eas.base.bot.trace.TraceConstants;
import com.kingdee.eas.base.bot.trace.TraceManagerFactory;
import com.kingdee.eas.base.bot.trace.TraceParamInfo;
import com.kingdee.eas.base.bot.trace.core.ITraceManager;
import com.kingdee.eas.base.bot.trace.util.TraceConfigurator;
import com.kingdee.eas.base.bot.trace.util.TraceLevel;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.botp.util.BOTObjectCache;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.botp.util.BotpUtils;
import com.kingdee.eas.base.botp.util.MappingCache;
import com.kingdee.eas.base.codingrule.AbstractCodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.SeqSegmentInfo;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPBill;
import com.kingdee.eas.base.dap.app.DAPAppTools;
import com.kingdee.eas.base.dap.app.DAPTransformUtils;
import com.kingdee.eas.base.dap.app.IDAPInnerTransformer;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.framework.BudgetAuditedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.ThreadLocalCache;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DAPFIVoucherTransformer
implements IDAPInnerTransformer {
    protected ITraceManager trace = TraceManagerFactory.newInstance((int)TraceConstants.TRACETYPE_BOTP);
    private static final String VOUCHERFLAG = "fiVouchered";
    private static final String VOUCHERTYPE = "2652E01E";
    private String resClass = "com.kingdee.eas.base.dap.app.DAPTransformerResource";
    private Context ctx = null;
    private BOTTransform botTransform = null;
    private BOTTransformSQLE botTransformSqle = null;
    private DAPTransformResult dapTransformerResult = new DAPTransformResult();
    private List transformerResultList = new ArrayList();
    private boolean isCheckPermission = true;
    private CoreBillBaseCollection sourceBillCollection = null;
    private CoreBillBaseInfo sourceBillInfo = null;
    private BOTMappingInfo mapping = null;
    private IVoucher iVoucher = null;
    private IBOTRelation iBOTRelation = null;
    private List allSrcBillColsList = null;
    private Date currentDate = null;
    private static final String BOT = "__BOT";
    private static Logger logger = Logger.getLogger(DAPFIVoucherTransformer.class);
    private List srcIDsList = new ArrayList();
    private LowTimer t = new LowTimer();
    private String seprator = "--------------------------------------------------------------";

    private void init(Context ctx) throws BOSException {
        this.ctx = ctx;
        if (this.iVoucher == null) {
            this.iVoucher = VoucherFactory.getLocalInstance((Context)this.ctx);
        }
        if (this.iBOTRelation == null) {
            this.iBOTRelation = BOTRelationFactory.getLocalInstance((Context)this.ctx);
        }
        this.currentDate = new Date();
        this.dapTransformerResult = new DAPTransformResult();
    }

    @Override
    public DAPTransformResult transform(Context ctx, CoreBillBaseCollection sourceBillCollection, BOTMappingInfo mapping) throws BOSException, EASBizException {
        BOTMappingCollection botMappingCols = new BOTMappingCollection();
        botMappingCols.add(mapping);
        return this.transform(ctx, sourceBillCollection, botMappingCols);
    }

    @Override
    public DAPTransformResult transform(Context ctx, CoreBillBaseCollection sourceBillCollection, BOTMappingCollection botMappingCols) throws BOSException, EASBizException {
        this.init(ctx);
        this.sourceBillCollection = sourceBillCollection;
        this.mapping = botMappingCols.get(0);
        this.t.reset();
        this.preTransform();
        logger.info((Object)("Pre Transform : " + this.t.msValue() + "ms"));
        IObjectCollection objColl = null;
        Object botException = null;
        BOTObjectCache cache = BOTObjectCache.getInstance((Context)ctx);
        cache.clear();
        try {
            this.t.reset();
            this.botTransform = BOTPTools.getBOTTransform((Context)ctx, (BOTMappingCollection)botMappingCols);
            ArrayList<CoreBillBaseCollection> srcBillColsList = new ArrayList<CoreBillBaseCollection>();
            srcBillColsList.add(sourceBillCollection);
            BOTPTools.prepareCache((Context)ctx, (BOTTransform)this.botTransform, srcBillColsList, (IObjectCollection)botMappingCols);
            objColl = this.botTransform.businessObjectTransform((IObjectCollection)sourceBillCollection, botMappingCols);
            logger.info((Object)("Bote Transform : " + this.t.msValue() + "ms"));
            logger.debug((Object)("voucher size :" + this.dapTransformerResult.getVoucherCollection().size()));
        }
        catch (BOSException e) {
            logger.error((Object)"DAP Transform error!", (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)"DAP Transform error!", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"DAP Transform error!", (Throwable)e);
            throw new DAPException(DAPException.BOTE_NOT_RIGHT2, new Object[]{e});
        }
        finally {
            cache.clear();
            ThreadLocalCache.detroyRegion((String)BOT);
        }
        if (objColl != null) {
            this.t.reset();
            this.dapTransformerResult.setVoucherCollection(objColl);
            this.dapTransformerResult.setRelationCollection(this.botTransform.getBOTRelationCollection());
            this.dapTransformerResult.setVoucherType(DAPVoucherTypeEnum.FIVoucher);
            this.afterTransform();
            logger.info((Object)("After Transform : " + this.t.msValue() + "ms"));
        }
        return this.dapTransformerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DAPTransformResult boteTransform(Context ctx, List srcBillColsList, BOTMappingCollection botMappingCols) throws Exception {
        DAPTransformResult actualReturn = new DAPTransformResult();
        BOTTransform botTransform = null;
        botTransform = BOTPTools.getBOTTransform((Context)ctx, (BOTMappingCollection)botMappingCols);
        BOTObjectCache cache = BOTObjectCache.getInstance((Context)ctx);
        cache.clear();
        BOTPTools.prepareCache((Context)ctx, (BOTTransform)botTransform, (List)srcBillColsList, (IObjectCollection)botMappingCols);
        try {
            IObjectCollection destBills = botTransform.businessObjectTransform(srcBillColsList, botMappingCols);
            actualReturn.setVoucherCollection(destBills);
            actualReturn.setRelationCollection(botTransform.getBOTRelationCollection());
            actualReturn.setVoucherType(DAPVoucherTypeEnum.FIVoucher);
            actualReturn.setIdRelation(botTransform.getIdRelation());
        }
        finally {
            cache.clear();
        }
        return actualReturn;
    }

    @Override
    public DAPTransformResult transform(Context ctx, List srcBillColsList, BOTMappingCollection botMappingCols) throws BOSException, EASBizException {
        this.init(ctx);
        if (this.sourceBillCollection == null) {
            this.sourceBillCollection = new CoreBillBaseCollection();
        } else {
            this.sourceBillCollection.clear();
        }
        Iterator srcBillColsIter = srcBillColsList.iterator();
        while (srcBillColsIter.hasNext()) {
            this.sourceBillCollection.addObjectCollection((IObjectCollection)srcBillColsIter.next());
        }
        this.mapping = botMappingCols.get(0);
        this.preTransform();
        try {
            this.dapTransformerResult = this.boteTransform(ctx, srcBillColsList, botMappingCols);
        }
        catch (BOSException e) {
            logger.error((Object)"DAP Transform error!", (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)"DAP Transform error!", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"DAP Transform error!", (Throwable)e);
            throw new DAPException(DAPException.BOTE_NOT_RIGHT2, new Object[]{e});
        }
        this.trace.setTraceLevel(TraceConfigurator.getTraceLevel((BOTMappingCollection)botMappingCols));
        this.trace.start("Engine AfterTransform");
        this.afterTransform();
        this.trace.end();
        return this.dapTransformerResult;
    }

    @Override
    public void save(Context ctx, CoreBillBaseCollection sourceBillCollection, DAPTransformResult result) throws BOSException, EASBizException {
        try {
            this.trace.start("DAPSave");
            this.setTraceLevel(ctx, result.getRelationCollection());
            this.trace.newSub("save_init");
            this.init(ctx);
            this.sourceBillCollection = sourceBillCollection;
            this.dapTransformerResult = result;
            this.transformerResultList.add(result);
            this.allSrcBillColsList = new ArrayList();
            this.allSrcBillColsList.add(sourceBillCollection);
            this.trace.endSub();
            this.trace.newSub("innerSaveAndSubmitVoucherRelation");
            this.innerSaveAndSubmitVoucherRelation(false);
            this.trace.endSub();
        }
        catch (BOSException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        finally {
            this.trace.end();
        }
    }

    @Override
    public void save(Context ctx, CoreBillBaseCollection sourceBillCollection, List resultList) throws BOSException, EASBizException {
        try {
            this.trace.start("DAPSave");
            this.setTraceLevel(ctx, ((DAPTransformResult)resultList.get(0)).getRelationCollection());
            this.trace.newSub("save_init");
            this.init(ctx);
            this.sourceBillCollection = sourceBillCollection;
            this.transformerResultList = resultList;
            this.allSrcBillColsList = new ArrayList();
            this.allSrcBillColsList.add(sourceBillCollection);
            this.trace.endSub();
            this.innerSaveAndSubmitVoucherRelation(false);
        }
        catch (BOSException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        finally {
            this.trace.end();
        }
    }

    @Override
    public void preview(Context ctx, CoreBillBaseCollection sourceBillCollection, DAPTransformResult result) throws BOSException, EASBizException {
        try {
            this.trace.start("DAPSave");
            this.setTraceLevel(ctx, result.getRelationCollection());
            this.trace.newSub("save_init");
            this.init(ctx);
            this.sourceBillCollection = sourceBillCollection;
            this.dapTransformerResult = result;
            this.transformerResultList.add(result);
            this.allSrcBillColsList = new ArrayList();
            this.allSrcBillColsList.add(sourceBillCollection);
            this.trace.endSub();
            for (VoucherInfo voucher : this.dapTransformerResult.getVoucherCollection()) {
                this.iVoucher.previewVoucher((BaseVoucherInfo)voucher);
            }
        }
        catch (BOSException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        finally {
            this.trace.end();
        }
    }

    @Override
    public void save(Context ctx, List srcBillColsList, DAPTransformResult result) throws BOSException, EASBizException {
        try {
            this.trace.start("DAPSave");
            this.trace.newSub("save_init");
            this.init(ctx);
            if (this.sourceBillCollection == null) {
                this.sourceBillCollection = new CoreBillBaseCollection();
            } else {
                this.sourceBillCollection.clear();
            }
            this.allSrcBillColsList = srcBillColsList;
            Iterator srcBillColsIter = srcBillColsList.iterator();
            while (srcBillColsIter.hasNext()) {
                this.sourceBillCollection.addObjectCollection((IObjectCollection)srcBillColsIter.next());
            }
            this.dapTransformerResult = result;
            this.transformerResultList.add(result);
            this.trace.endSub();
            this.innerSaveAndSubmitVoucherRelation(false);
        }
        catch (BOSException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        finally {
            this.trace.end();
        }
    }

    @Override
    public void saveSQLE(Context ctx, IObjectPK[] srcBillIDsList, DAPTransformResult result, SelectorItemCollection selectors) throws BOSException, EASBizException {
        try {
            if (srcBillIDsList == null || result == null) {
                return;
            }
            this.init(ctx);
            if (this.sourceBillCollection == null) {
                this.sourceBillCollection = new CoreBillBaseCollection();
            } else {
                this.sourceBillCollection.clear();
            }
            this.dapTransformerResult = result;
            this.innerSaveAndSubmitVoucherRelationSQLE(srcBillIDsList, false);
        }
        catch (BOSException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        finally {
            this.trace.end();
        }
    }

    protected void innerSaveAndSubmitVoucherRelation(boolean bIsSubmit) throws BOSException, EASBizException {
        for (int i = 0; i < this.transformerResultList.size(); ++i) {
            long t0 = System.currentTimeMillis();
            boolean isTempSave = DAPFIVoucherTransformer.isTempSave(this.ctx, ((DAPTransformResult)this.transformerResultList.get(i)).getRelationCollection());
            this.dapTransformerResult = (DAPTransformResult)this.transformerResultList.get(i);
            this.writeBack();
            long t1 = System.currentTimeMillis();
            if (this.isCheckPermission && this.isCheckPermission(this.ctx)) {
                ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            }
            try {
                this.saveAndSubmitVoucher();
                long t2 = System.currentTimeMillis();
                this.resetRelation();
                long t3 = System.currentTimeMillis();
                if (this.transformerResultList.size() - 1 == i) {
                    this.saveSourceBill();
                }
                long t4 = System.currentTimeMillis();
                DAPTransformUtils.takeAttachmentOnRelations(this.ctx, (IObjectCollection)this.dapTransformerResult.getRelationCollection());
                this.checkRebuild(this.ctx, this.dapTransformerResult.getRelationCollection());
                this.saveRelation();
                long t5 = System.currentTimeMillis();
                logger.info((Object)("***DAPFIVoucherTransformer, InnerSaveAndSubmitVoucherRelation,  writeBack=" + (t1 - t0) + "ms, saveAndSubmitVoucher=" + (t2 - t1) + "ms, resetRelation=" + (t3 - t2) + "ms, saveSourceBill=" + (t4 - t3) + "ms, saveRelation=" + (t5 - t4) + "ms"));
                if (this.dapTransformerResult.getRelationCollection() != null && this.dapTransformerResult.getRelationCollection().size() != 0) continue;
                throw new BOSException(EASCommonResource.getString((String)this.resClass, (String)"ReSaveRelationIsNull", (Locale)this.ctx.getLocale()) + "(DAPFIVoucherTransformer.save)!");
            }
            catch (Exception e) {
                logger.error((Object)("\u51ed\u8bc1\u4fdd\u5b58\u540e\u53d1\u751f\u5f02\u5e38\uff0c\u56de\u6536\u65ad\u53f7-------------------" + e.getMessage()), (Throwable)e);
                for (VoucherInfo voucher : this.dapTransformerResult.getVoucherCollection()) {
                    ICoreBillBase iBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)voucher.getBOSType());
                    if (isTempSave) {
                        voucher.setBizStatus(VoucherStatusEnum.TEMP);
                    } else {
                        voucher.setBizStatus(VoucherStatusEnum.SUBMITTED);
                    }
                    if (voucher == null || voucher.getNumber() == null) continue;
                    iBillBase.recycleNumber((CoreBillBaseInfo)voucher, null, null, null, voucher.getNumber());
                }
                if (e instanceof BOSException) {
                    throw (BOSException)((Object)e);
                }
                if (e instanceof EASBizException) {
                    throw (EASBizException)((Object)e);
                }
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void innerSaveAndSubmitVoucherRelationSQLE(IObjectPK[] srcBillIDsList, boolean bIsSubmit) throws BOSException, EASBizException {
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        if (this.isCheckPermission && this.isCheckPermission(this.ctx)) {
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        }
        try {
            this.saveAndSubmitVoucher();
            long t2 = System.currentTimeMillis();
            this.resetRelation();
            long t3 = System.currentTimeMillis();
            this.saveSourceBillSQLE(srcBillIDsList);
            long t4 = System.currentTimeMillis();
            this.checkRebuild(this.ctx, this.dapTransformerResult.getRelationCollection());
            this.saveRelation();
            long t5 = System.currentTimeMillis();
            logger.info((Object)("***DAPFIVoucherTransformer, InnerSaveAndSubmitVoucherRelationSQLE,  writeBack=" + (t1 - t0) + "ms, saveAndSubmitVoucher=" + (t2 - t1) + "ms, resetRelation=" + (t3 - t2) + "ms, saveSourceBill=" + (t4 - t3) + "ms, saveRelation=" + (t5 - t4) + "ms"));
            if (this.dapTransformerResult.getRelationCollection() == null || this.dapTransformerResult.getRelationCollection().size() == 0) {
                throw new BOSException(EASCommonResource.getString((String)this.resClass, (String)"ReSaveRelationIsNull", (Locale)this.ctx.getLocale()) + "(DAPFIVoucherTransformer.save)!");
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u51ed\u8bc1\u4fdd\u5b58\u540e\u53d1\u751f\u5f02\u5e38\uff0c\u56de\u6536\u65ad\u53f7SQL-------------------" + e.getMessage()), (Throwable)e);
            for (VoucherInfo voucher : this.dapTransformerResult.getVoucherCollection()) {
                ICoreBillBase iBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)voucher.getBOSType());
                if (DAPFIVoucherTransformer.isTempSave(this.ctx, this.dapTransformerResult.getRelationCollection())) {
                    voucher.setBizStatus(VoucherStatusEnum.TEMP);
                } else {
                    voucher.setBizStatus(VoucherStatusEnum.SUBMITTED);
                }
                if (voucher == null || voucher.getNumber() == null) continue;
                iBillBase.recycleNumber((CoreBillBaseInfo)voucher, null, null, null, voucher.getNumber());
            }
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
    }

    private void resetRelation() {
        VoucherCollection voucherCols = (VoucherCollection)this.dapTransformerResult.getVoucherCollection();
        BOTRelationCollection relationCols = this.dapTransformerResult.getRelationCollection();
        BOTRelationInfo botRelationInfo = null;
        BOTRelationEntryInfo botRelationEntryInfo2 = null;
        int count = relationCols.size();
        for (int i = 0; i < count; ++i) {
            botRelationInfo = relationCols.get(i);
            boolean hasRelationInfoExist = false;
            VoucherInfo destVoucherInfo = null;
            int size = voucherCols.size();
            for (int j = 0; j < size; ++j) {
                VoucherInfo voucherInfo = voucherCols.get(j);
                if (!botRelationInfo.getDestObjectID().equals(voucherInfo.getId().toString())) continue;
                destVoucherInfo = voucherInfo;
                hasRelationInfoExist = true;
                break;
            }
            if (hasRelationInfoExist && destVoucherInfo != null) {
                BOTRelationEntryCollection botRelationEntryCols = botRelationInfo.getRelationEntries();
                VoucherEntryCollection voucherEntryCollection = destVoucherInfo.getEntries();
                int reCount = botRelationEntryCols.size();
                for (int k = 0; k < reCount; ++k) {
                    botRelationEntryInfo2 = botRelationEntryCols.get(k);
                    boolean hasEntryExist = false;
                    if (botRelationEntryInfo2.getDestEntryID().equals(destVoucherInfo.getId().toString())) {
                        hasEntryExist = true;
                    } else {
                        int veCount = voucherEntryCollection.size();
                        for (int m = 0; m < veCount; ++m) {
                            VoucherEntryInfo voucherEntryInfo = voucherEntryCollection.get(m);
                            if (!botRelationEntryInfo2.getDestEntryID().equals(voucherEntryInfo.getId().toString())) continue;
                            hasEntryExist = true;
                            break;
                        }
                    }
                    if (hasEntryExist) continue;
                    botRelationEntryCols.removeObject(k);
                    --k;
                    --reCount;
                }
                continue;
            }
            relationCols.removeObject(i);
            --i;
            --count;
        }
        Map idRelation = this.dapTransformerResult.getIdRelation();
        if (idRelation != null) {
            BOTRelationCollection newRelation = new BOTRelationCollection();
            HashMap<String, BOTRelationInfo> headMap = new HashMap<String, BOTRelationInfo>();
            String headID = null;
            BOTRelationInfo tempInfo = null;
            BOTRelationEntryInfo tempEntryInfo = null;
            String[] ids = null;
            int count2 = relationCols.size();
            for (int i = 0; i < count2; ++i) {
                botRelationInfo = relationCols.get(i);
                if (idRelation.containsKey(botRelationInfo.getSrcObjectID())) {
                    ids = idRelation.get(botRelationInfo.getSrcObjectID()).toString().split(";");
                    int k = ids.length;
                    for (int j = 0; j < k; ++j) {
                        tempInfo = new BOTRelationInfo();
                        tempInfo.setId(BOSUuid.create((BOSObjectType)botRelationInfo.getBOSType()));
                        tempInfo.setSrcObjectID(ids[j]);
                        tempInfo.setDestEntityID(botRelationInfo.getDestEntityID());
                        tempInfo.setDestObjectID(botRelationInfo.getDestObjectID());
                        tempInfo.setSrcEntityID(botRelationInfo.getSrcEntityID());
                        tempInfo.setType(botRelationInfo.getType());
                        tempInfo.setOperatorID(botRelationInfo.getOperatorID());
                        tempInfo.setBOTMappingID(botRelationInfo.getBOTMappingID());
                        tempInfo.setDate(botRelationInfo.getDate());
                        newRelation.add(tempInfo);
                        headMap.put(ids[j], tempInfo);
                    }
                    for (BOTRelationEntryInfo botRelationEntryInfo2 : botRelationInfo.getRelationEntries()) {
                        if (!idRelation.containsKey(botRelationEntryInfo2.getSrcEntryID())) continue;
                        ids = idRelation.get(botRelationEntryInfo2.getSrcEntryID()).toString().split(";");
                        int k2 = ids.length;
                        for (int j = 0; j < k2; ++j) {
                            headID = (String)idRelation.get(ids[j] + "HeadID");
                            if (!headMap.containsKey(headID)) continue;
                            tempEntryInfo = new BOTRelationEntryInfo();
                            tempEntryInfo.setSrcEntryID(ids[j]);
                            tempEntryInfo.setSrcObjectID(headID);
                            tempEntryInfo.setDestEntryID(botRelationEntryInfo2.getDestEntryID());
                            tempEntryInfo.setDestEntryPropName(botRelationEntryInfo2.getDestEntryPropName());
                            tempEntryInfo.setDestPropertyName(botRelationEntryInfo2.getDestPropertyName());
                            tempEntryInfo.setDestObjectID(botRelationEntryInfo2.getDestObjectID());
                            tempEntryInfo.setSrcEntryPropName(botRelationEntryInfo2.getSrcEntryPropName());
                            tempEntryInfo.setSrcPropertyName(botRelationEntryInfo2.getSrcPropertyName());
                            tempEntryInfo.setValue(botRelationEntryInfo2.getValue());
                            ((BOTRelationInfo)headMap.get(headID)).getRelationEntries().add(tempEntryInfo);
                        }
                    }
                    continue;
                }
                newRelation.add(botRelationInfo);
            }
            this.dapTransformerResult.setRelationCollection(newRelation);
        }
    }

    @Override
    public void undoTransformFromVoucher(Context ctx, CoreBillBaseInfo voucher) throws BOSException, EASBizException {
        this.init(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)voucher.getId().toString()));
        IBOTRelation iRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection botRelationCols = iRelation.getCollection(evi);
        ICoreBillBase iBillBase = null;
        Method mothod = null;
        Method mothod_new = null;
        ArrayList<BOSObjectType> bosTypes = new ArrayList<BOSObjectType>();
        HashMap<BOSObjectType, BOTRelationCollection> relationMap = new HashMap<BOSObjectType, BOTRelationCollection>();
        BOTRelationCollection curBotRelationCols = null;
        for (int i = 0; i < botRelationCols.size(); ++i) {
            BOTRelationCollection botRelationTemp;
            BOTRelationInfo botRelationInfo = botRelationCols.get(i);
            String srcBillId = botRelationInfo.getSrcObjectID();
            BOSUuid srcUuid = BOSUuid.read((String)srcBillId);
            BOSObjectType bosObjectType = srcUuid.getType();
            if (!bosTypes.contains(bosObjectType)) {
                botRelationTemp = new BOTRelationCollection();
                botRelationTemp.add(botRelationInfo);
                bosTypes.add(bosObjectType);
                relationMap.put(bosObjectType, botRelationTemp);
                continue;
            }
            botRelationTemp = (BOTRelationCollection)relationMap.get(bosObjectType);
            botRelationTemp.add(botRelationInfo);
        }
        for (int k = 0; k < bosTypes.size(); ++k) {
            String srcBillId;
            BOTRelationInfo botRelationInfo;
            mothod = null;
            mothod_new = null;
            curBotRelationCols = (BOTRelationCollection)relationMap.get(bosTypes.get(k));
            if (curBotRelationCols == null || curBotRelationCols.size() <= 0) continue;
            iBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)((BOSObjectType)bosTypes.get(k)));
            Class[] clz = new Class[]{IObjectPK[].class, CoreBillBaseCollection.class, BOTBillOperStateEnum.class, BOTRelationCollection.class};
            Class[] newClz = new Class[]{IObjectPK[].class, CoreBillBaseCollection.class, BOTBillOperStateEnum.class, BOTRelationCollection.class, IObjectCollection.class};
            try {
                mothod_new = iBillBase.getClass().getMethod("batchReverseSave", newClz);
            }
            catch (NoSuchMethodException srcUuid) {
                // empty catch block
            }
            if (mothod_new == null) {
                try {
                    mothod = iBillBase.getClass().getMethod("batchReverseSave", clz);
                }
                catch (NoSuchMethodException srcUuid) {
                    // empty catch block
                }
            }
            if (mothod_new != null || mothod != null) {
                ObjectUuidPK[] pks = new ObjectUuidPK[curBotRelationCols.size()];
                int count = curBotRelationCols.size();
                for (int i = 0; i < count; ++i) {
                    botRelationInfo = curBotRelationCols.get(i);
                    srcBillId = botRelationInfo.getSrcObjectID();
                    pks[i] = new ObjectUuidPK(srcBillId);
                }
                CoreBillBaseCollection destBillCollection = new CoreBillBaseCollection();
                destBillCollection.addObject((IObjectValue)voucher);
                Object[] objz = new Object[]{pks, null, BOTBillOperStateEnum.DELETE, curBotRelationCols};
                Object[] objz2 = new Object[]{pks, null, BOTBillOperStateEnum.DELETE, curBotRelationCols, destBillCollection};
                try {
                    if (mothod_new != null) {
                        mothod_new.invoke((Object)iBillBase, objz2);
                    } else {
                        mothod.invoke((Object)iBillBase, objz);
                    }
                    iRelation.removeRelationByDestObjId(voucher.getId().toString(), iBillBase.getType().toString());
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    if (e instanceof InvocationTargetException) {
                        InvocationTargetException targetEx = (InvocationTargetException)e;
                        if (targetEx.getTargetException() == null || targetEx.getTargetException().getMessage() == null) continue;
                        logger.error((Object)targetEx.getTargetException().getMessage(), targetEx.getTargetException());
                        throw new DAPException(DAPException.VOUCHER_NOT_DELETE, new Object[]{targetEx.getTargetException().getMessage()});
                    }
                    throw new DAPException(DAPException.VOUCHER_NOT_DELETE, e);
                }
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            int count = curBotRelationCols.size();
            for (int i = 0; i < count; ++i) {
                IDAPBill iDAPBill;
                botRelationInfo = curBotRelationCols.get(i);
                srcBillId = botRelationInfo.getSrcObjectID();
                BOSObjectType srcBosType = BotpHelper.getSrcBillBosType((Context)ctx, (String)srcBillId);
                ICoreBillBase srcBillInterface = null;
                srcBillInterface = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)srcBosType);
                CoreBillBaseInfo srcBillInfo = srcBosType.toString().equals("46DEC9DB") ? (CoreBillBaseInfo)srcBillInterface.getValue((IObjectPK)new ObjectUuidPK(srcBillId)) : (CoreBillBaseInfo)srcBillInterface.getValue((IObjectPK)new ObjectUuidPK(srcBillId), sic);
                String sqlToCheckSrcBillHasOtherVoucher = "SELECT TOP 1 1 FROM T_BOT_Relation WHERE FSrcObjectID = ? AND FDestObjectID != ? AND FDestEntityID = ?";
                IRowSet rsToCheckSrcBillHasOtherVoucher = DbUtil.executeQuery((Context)ctx, (String)sqlToCheckSrcBillHasOtherVoucher, (Object[])new Object[]{srcBillId, voucher.getId().toString(), VOUCHERTYPE});
                try {
                    if (!rsToCheckSrcBillHasOtherVoucher.next()) {
                        srcBillInfo.setBoolean(VOUCHERFLAG, false);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (srcBillInfo instanceof IDAPBill && (iDAPBill = (IDAPBill)srcBillInfo).getVoucher() != null && iDAPBill.getVoucher().getId() != null && iDAPBill.getVoucher().getId().toString().equals(voucher.getId().toString())) {
                    iDAPBill.setVoucher(null);
                }
                srcBillInterface.reverseSave((IObjectPK)new ObjectUuidPK(srcBillInfo.getId()), (IObjectValue)srcBillInfo, BOTBillOperStateEnum.DELETE, (IObjectValue)botRelationInfo, (IObjectValue)voucher);
                iRelation.delete((IObjectPK)new ObjectUuidPK(botRelationInfo.getId()));
                logger.info((Object)("\n\u5220\u9664\u51ed\u8bc1\u65f6\u5220\u9664\u5173\u7cfb:" + botRelationInfo.getId().toString()));
            }
        }
        if (BOTPTools.isExistCrossSysRelation((Context)ctx, (BOTRelationCollection)botRelationCols)) {
            String loginType;
            BOTPTools.deleteRelation4CrossSystem((Context)ctx, (BOTRelationCollection)botRelationCols);
            String string = loginType = ctx.get((Object)"LOGIN_TYPE") != null ? ctx.get((Object)"LOGIN_TYPE").toString() : "";
            if (!(StringUtils.isEmpty((String)loginType) || loginType.equals("WEBSERVICE") || loginType.equals("OPENAPI"))) {
                String result;
                ArrayList<BOSUuid> relationIDs = new ArrayList<BOSUuid>();
                for (int i = 0; i < botRelationCols.size(); ++i) {
                    BOTRelationInfo relation = botRelationCols.get(i);
                    relationIDs.add(relation.getId());
                }
                ArrayList<ObjectUuidPK> invokeDatas = new ArrayList<ObjectUuidPK>();
                invokeDatas.add(new ObjectUuidPK(voucher.getId()));
                ArrayList<String> voucherList = new ArrayList<String>();
                voucherList.add(voucher.getId().toString());
                HashMap tempData = new HashMap();
                boolean idNeedLog = true;
                try {
                    result = BOTPTools.invokeMethod4CrossSys((Context)ctx, (String)VOUCHERTYPE, (String)"deleteVoucherForRetry", (String)"111", voucherList, (boolean)idNeedLog, (boolean)true, invokeDatas, tempData);
                }
                catch (BizException e1) {
                    e1.printStackTrace();
                    throw new BOSException("\u8de8\u7cfb\u7edf\u5220\u9664\u5355\u636e\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38" + (StringUtils.isEmpty((String)e1.getMessage()) ? "" : "(" + e1.getMessage() + ")"));
                }
                catch (LoginException e1) {
                    e1.printStackTrace();
                    throw new BOSException("\u8de8\u7cfb\u7edf\u5220\u9664\u5355\u636e\u53d1\u751f\u767b\u5f55\u5f02\u5e38" + (StringUtils.isEmpty((String)e1.getMessage()) ? "" : "(" + e1.getMessage() + ")"));
                }
                catch (InvokeNetworkException e1) {
                    e1.printStackTrace();
                    boolean flag = true;
                    try {
                        result = BOTPTools.invokeMethod4CrossSys((Context)ctx, (String)VOUCHERTYPE, (String)"deleteVoucherForRetry", (String)"111", voucherList, (boolean)true, (boolean)true, invokeDatas, tempData);
                    }
                    catch (Exception e) {
                        flag = false;
                        logger.error((Object)"\u8de8\u7cfb\u7edf\u5220\u9664\u5355\u636e\u53d1\u751f\u8d85\u65f6\u5f02\u5e38\uff0c\u4e14\u8865\u507f\u5931\u8d25");
                        e.printStackTrace();
                    }
                    if (flag) {
                        throw new BOSException("\u8de8\u7cfb\u7edf\u5220\u9664\u5355\u636e\u53d1\u751f\u767b\u5f55\u5f02\u5e38,\u4f46\u8865\u507f\u751f\u6548" + (StringUtils.isEmpty((String)e1.getMessage()) ? "" : "(" + e1.getMessage() + ")"));
                    }
                    throw new BOSException("\u8de8\u7cfb\u7edf\u5220\u9664\u5355\u636e\u53d1\u751f\u767b\u5f55\u5f02\u5e38,\u4e14\u8865\u507f\u5931\u6548" + (StringUtils.isEmpty((String)e1.getMessage()) ? "" : "(" + e1.getMessage() + ")"));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    throw new BOSException("\u8de8\u7cfb\u7edf\u5220\u9664\u5355\u636e\u53d1\u751f\u672a\u77e5\u5f02\u5e38" + (StringUtils.isEmpty((String)e1.getMessage()) ? "" : "(" + e1.getMessage() + ")"));
                }
            }
        }
    }

    private void preTransform() throws BOSException, EASBizException {
    }

    private int getCurrencyPresicion(IObjectPK pk) {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("precision"));
        try {
            CurrencyInfo info = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo(pk, selectors);
            return info.getPrecision();
        }
        catch (EASBizException e) {
            logger.error((Object)"\u53d6\u5e01\u522b\u7cbe\u5ea6\u65f6\u53d1\u751f\u5f02\u5e38");
        }
        catch (BOSException e) {
            logger.error((Object)"\u53d6\u5e01\u522b\u7cbe\u5ea6\u65f6\u53d1\u751f\u5f02\u5e38");
        }
        return 2;
    }

    private void afterTransform() throws BOSException, EASBizException {
        this.trace.log("*****before Engine AfterTransform*****");
        UserInfo userInfo = (UserInfo)this.ctx.get((Object)"UserInfo");
        VoucherCollection voucherCollection = (VoucherCollection)this.dapTransformerResult.getVoucherCollection();
        for (VoucherInfo voucherInfo : voucherCollection) {
            boolean isEryOrderBool;
            CompanyOrgUnitInfo companyInfo;
            this.printVoucher(voucherInfo);
            if (voucherInfo.get("company") == null) {
                companyInfo = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                voucherInfo.setCompany(companyInfo);
            } else {
                Object obj = voucherInfo.get("company");
                if (obj instanceof FullOrgUnitInfo) {
                    CompanyOrgUnitInfo fiOrg = new CompanyOrgUnitInfo();
                    fiOrg.setId(((FullOrgUnitInfo)obj).getId());
                    voucherInfo.setCompany(fiOrg);
                }
            }
            companyInfo = voucherInfo.getCompany();
            companyInfo = this.getCompanyInfo(companyInfo);
            int localPresicion = 0;
            if (companyInfo.getBaseCurrency() != null) {
                localPresicion = this.getCurrencyPresicion((IObjectPK)new ObjectUuidPK(companyInfo.getBaseCurrency().getId()));
            }
            int reportPresicion = 0;
            if (companyInfo.getReportCurrency() != null) {
                reportPresicion = this.getCurrencyPresicion((IObjectPK)new ObjectUuidPK(companyInfo.getReportCurrency().getId()));
            }
            if (voucherInfo.getBookedDate() == null) {
                voucherInfo.setBookedDate(this.currentDate);
            }
            voucherInfo.setPeriod(this.getPeriod(companyInfo, voucherInfo.getBookedDate()));
            if (voucherInfo.getBizDate() == null) {
                voucherInfo.setBizDate(this.currentDate);
            }
            voucherInfo.setHandler(userInfo);
            if (voucherInfo.getDescription() == null || voucherInfo.getDescription().length() == 0) {
                voucherInfo.setDescription(EASCommonResource.getString((String)this.resClass, (String)"Description", (Locale)this.ctx.getLocale()));
            }
            voucherInfo.setSourceType(SourceType.NONE);
            voucherInfo.setBgStatus(BudgetAuditedStatusEnum.UNAUDITED);
            voucherInfo.setIsReverseVoucher(false);
            BigDecimal localDebitAmount = null;
            BigDecimal localCreditAmount = null;
            BigDecimal reportingDebitAmount = null;
            BigDecimal reportingCreditAmount = null;
            VoucherEntryCollection voucherEntryCollection = voucherInfo.getEntries();
            Iterator itrVoucherEntry = voucherEntryCollection.iterator();
            int entrySeq = 1;
            while (itrVoucherEntry.hasNext()) {
                AccountViewInfo acctInfo;
                CurrencyInfo cInfo;
                VoucherEntryInfo voucherEntryInfo = (VoucherEntryInfo)itrVoucherEntry.next();
                voucherEntryInfo.setOprStatus(1);
                CurrencyInfo srcCurrencyInfo = voucherEntryInfo.getCurrency();
                if (srcCurrencyInfo == null) {
                    // empty if block
                }
                if (voucherEntryInfo.getOriginalAmount() == null) {
                    // empty if block
                }
                if (voucherEntryInfo.getLocalExchangeRate() == null) {
                    voucherEntryInfo.setLocalExchangeRate(this.getLocalExchangeRate(srcCurrencyInfo, companyInfo, voucherInfo.getBookedDate()));
                }
                if (voucherEntryInfo.getLocalAmount() == null && voucherEntryInfo.getOriginalAmount() != null && voucherEntryInfo.getLocalExchangeRate() != null) {
                    ExchangeRateInfo rateInfo = this.getLocalExchangeInfo(srcCurrencyInfo, companyInfo, voucherInfo.getBookedDate());
                    if (rateInfo == null) {
                        voucherEntryInfo.setLocalAmount(voucherEntryInfo.getOriginalAmount());
                    } else if (rateInfo.getConvertMode().getValue() == 0) {
                        voucherEntryInfo.setLocalAmount(voucherEntryInfo.getOriginalAmount().multiply(voucherEntryInfo.getLocalExchangeRate()));
                    } else if (rateInfo.getConvertMode().getValue() == 1) {
                        voucherEntryInfo.setLocalAmount(voucherEntryInfo.getOriginalAmount().divide(voucherEntryInfo.getLocalExchangeRate(), localPresicion, 4));
                    }
                }
                if (voucherEntryInfo.getReportingExchangeRate() == null) {
                    cInfo = srcCurrencyInfo;
                    if (3 == companyInfo.getReportConvertMode().getValue()) {
                        cInfo = companyInfo.getBaseCurrency();
                    }
                    voucherEntryInfo.setReportingExchangeRate(this.getReportingExchangeRate(cInfo, companyInfo, voucherInfo.getBookedDate()));
                }
                if (voucherEntryInfo.getReportingAmount() == null && voucherEntryInfo.getOriginalAmount() != null && voucherEntryInfo.getReportingExchangeRate() != null) {
                    cInfo = srcCurrencyInfo;
                    if (3 == companyInfo.getReportConvertMode().getValue()) {
                        cInfo = companyInfo.getBaseCurrency();
                    }
                    ExchangeRateInfo rateInfo = this.getReportingExchangeInfo(cInfo, companyInfo, voucherInfo.getBookedDate());
                    BigDecimal amount = voucherEntryInfo.getOriginalAmount();
                    if (3 == companyInfo.getReportConvertMode().getValue()) {
                        amount = voucherEntryInfo.getLocalAmount();
                    }
                    if (rateInfo == null) {
                        voucherEntryInfo.setReportingAmount(amount);
                    } else if (rateInfo.getConvertMode().getValue() == 0) {
                        voucherEntryInfo.setReportingAmount(amount.multiply(voucherEntryInfo.getReportingExchangeRate()));
                    } else if (rateInfo.getConvertMode().getValue() == 1) {
                        voucherEntryInfo.setReportingAmount(amount.divide(voucherEntryInfo.getReportingExchangeRate(), reportPresicion, 4));
                    }
                }
                if (voucherEntryInfo.getDescription() == null || voucherEntryInfo.getDescription().length() == 0) {
                    voucherEntryInfo.setDescription(EASCommonResource.getString((String)this.resClass, (String)"EntryDescription", (Locale)this.ctx.getLocale()));
                }
                if ((acctInfo = voucherEntryInfo.getAccount()) == null || acctInfo.getCAA() == null) {
                    boolean hasCaa = false;
                    if (acctInfo != null) {
                        try {
                            String sqlToCheckAcctHasCaa = "SELECT TOP 1 1 FROM T_BD_ACCOUNTVIEW WHERE FID=? AND ( FCAA IS NOT NULL or Fhasuserproperty=1 )";
                            IRowSet rsToCheckAcctHasCaa = DbUtil.executeQuery((Context)this.ctx, (String)sqlToCheckAcctHasCaa, (Object[])new Object[]{acctInfo.getId().toString()});
                            if (rsToCheckAcctHasCaa.next()) {
                                hasCaa = true;
                            }
                        }
                        catch (SQLException e) {
                            throw new BOSException((Throwable)e);
                        }
                    }
                    if (!hasCaa) {
                        voucherEntryInfo.getAssistRecords().clear();
                    }
                }
                VoucherAssistRecordCollection voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
                Iterator itrVoucherAssistRecord = voucherAssistRecordCollection.iterator();
                int assistRecordSeq = 1;
                while (itrVoucherAssistRecord.hasNext()) {
                    VoucherAssistRecordInfo voucherAssistRecordInfo = (VoucherAssistRecordInfo)itrVoucherAssistRecord.next();
                    voucherAssistRecordInfo.setOprStatus(1);
                    if (voucherAssistRecordInfo.getBizDate() == null) {
                        voucherAssistRecordInfo.setBizDate(voucherInfo.getBizDate());
                    }
                    if (voucherAssistRecordInfo.getLocalAmount() == null && voucherAssistRecordInfo.getOriginalAmount() != null && voucherAssistRecordInfo.getLocalAmount() == null && voucherEntryInfo.getLocalExchangeRate() != null) {
                        ExchangeRateInfo rateInfo = this.getLocalExchangeInfo(srcCurrencyInfo, companyInfo, voucherInfo.getBookedDate());
                        if (rateInfo == null) {
                            voucherAssistRecordInfo.setLocalAmount(voucherAssistRecordInfo.getOriginalAmount());
                        } else if (rateInfo.getConvertMode().getValue() == 0) {
                            voucherAssistRecordInfo.setLocalAmount(voucherAssistRecordInfo.getOriginalAmount().multiply(voucherEntryInfo.getLocalExchangeRate()));
                        } else if (rateInfo.getConvertMode().getValue() == 1) {
                            voucherAssistRecordInfo.setLocalAmount(voucherAssistRecordInfo.getOriginalAmount().divide(voucherEntryInfo.getLocalExchangeRate(), localPresicion, 4));
                        }
                    }
                    if (voucherAssistRecordInfo.getReportingAmount() == null && voucherAssistRecordInfo.getOriginalAmount() != null && voucherAssistRecordInfo.getReportingAmount() == null && voucherEntryInfo.getReportingExchangeRate() != null) {
                        CurrencyInfo cInfo2 = srcCurrencyInfo;
                        if (3 == companyInfo.getReportConvertMode().getValue()) {
                            cInfo2 = companyInfo.getBaseCurrency();
                        }
                        ExchangeRateInfo rateInfo = this.getReportingExchangeInfo(cInfo2, companyInfo, voucherInfo.getBookedDate());
                        BigDecimal amount = voucherAssistRecordInfo.getOriginalAmount();
                        if (3 == companyInfo.getReportConvertMode().getValue()) {
                            amount = voucherAssistRecordInfo.getLocalAmount();
                        }
                        if (rateInfo == null) {
                            voucherAssistRecordInfo.setReportingAmount(amount);
                        } else if (rateInfo.getConvertMode().getValue() == 0) {
                            voucherAssistRecordInfo.setReportingAmount(amount.multiply(voucherEntryInfo.getReportingExchangeRate()));
                        } else if (rateInfo.getConvertMode().getValue() == 1) {
                            voucherAssistRecordInfo.setReportingAmount(amount.divide(voucherEntryInfo.getReportingExchangeRate(), reportPresicion, 4));
                        }
                    }
                    voucherAssistRecordInfo.setSeq(assistRecordSeq);
                    ++assistRecordSeq;
                }
                if (voucherEntryInfo.getEntryDC().getValue() == 0) {
                    if (voucherEntryInfo.getLocalAmount() != null || localCreditAmount != null) {
                        if (localCreditAmount == null) {
                            localCreditAmount = new BigDecimal("0.0");
                        }
                        if (voucherEntryInfo.getLocalAmount() != null) {
                            localCreditAmount = localCreditAmount.add(voucherEntryInfo.getLocalAmount());
                        }
                    }
                    if (voucherEntryInfo.getReportingAmount() != null || reportingCreditAmount != null) {
                        if (reportingCreditAmount == null) {
                            reportingCreditAmount = new BigDecimal("0.0");
                        }
                        if (voucherEntryInfo.getReportingAmount() != null) {
                            reportingCreditAmount = reportingCreditAmount.add(voucherEntryInfo.getReportingAmount());
                        }
                    }
                }
                if (voucherEntryInfo.getEntryDC().getValue() == 1) {
                    if (voucherEntryInfo.getLocalAmount() != null || localDebitAmount != null) {
                        if (localDebitAmount == null) {
                            localDebitAmount = new BigDecimal("0.0");
                        }
                        if (voucherEntryInfo.getLocalAmount() != null) {
                            localDebitAmount = localDebitAmount.add(voucherEntryInfo.getLocalAmount());
                        }
                    }
                    if (voucherEntryInfo.getReportingAmount() != null || reportingDebitAmount != null) {
                        if (reportingDebitAmount == null) {
                            reportingDebitAmount = new BigDecimal("0.0");
                        }
                        if (voucherEntryInfo.getReportingAmount() != null) {
                            reportingDebitAmount = reportingDebitAmount.add(voucherEntryInfo.getReportingAmount());
                        }
                    }
                }
                voucherEntryInfo.setSeq(entrySeq);
                ++entrySeq;
            }
            String isEryOrder = ParamManager.getParamValue((Context)this.ctx, null, (String)"DAP_ENTRY_ORDER");
            boolean bl = isEryOrderBool = "true".equals(isEryOrder);
            if (isEryOrderBool) {
                VoucherEntryCollection vec = voucherInfo.getEntries();
                ArrayList<VoucherEntryInfo> ll = new ArrayList<VoucherEntryInfo>();
                for (VoucherEntryInfo vei : vec) {
                    ll.add(vei);
                }
                Collections.sort(ll, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        VoucherEntryInfo vei1 = (VoucherEntryInfo)o1;
                        VoucherEntryInfo vei2 = (VoucherEntryInfo)o2;
                        int b = 0;
                        if (vei1.getAccount() == null || vei1.getAccount().getNumber() == null) {
                            return -1;
                        }
                        if (vei2.getAccount() == null || vei2.getAccount().getNumber() == null) {
                            return 1;
                        }
                        String accout1 = vei1.getAccount().getNumber().toString();
                        String accout2 = vei2.getAccount().getNumber().toString();
                        int entryDC1 = vei1.getEntryDC().getValue();
                        int entryDC2 = vei2.getEntryDC().getValue();
                        if (accout1.compareTo(accout2) > 0) {
                            return 1;
                        }
                        if (accout1.compareTo(accout2) < 0) {
                            return -1;
                        }
                        if (entryDC1 > entryDC2) {
                            return 1;
                        }
                        if (entryDC1 < entryDC2) {
                            return -1;
                        }
                        return b;
                    }
                });
                Iterator ait = ll.iterator();
                int newseq = 1;
                while (ait.hasNext()) {
                    VoucherEntryInfo veio = (VoucherEntryInfo)ait.next();
                    veio.setSeq(newseq);
                    voucherInfo.getEntries().add(veio);
                    ++newseq;
                }
            }
            voucherInfo.setLocalDebitAmount(localDebitAmount);
            voucherInfo.setLocalCreditAmount(localCreditAmount);
            voucherInfo.setReportingDebitAmount(reportingDebitAmount);
            voucherInfo.setReportingCreditAmount(reportingCreditAmount);
        }
        this.trace.log("*****after Engine AfterTransform*****");
        this.trace.log(new TraceParamInfo(new Object[]{this.dapTransformerResult.getVoucherCollection()}));
    }

    private void writeBack() throws BOSException, EASBizException {
        Iterator itrSourceBillCollection = this.sourceBillCollection.iterator();
        boolean needLog = BotpUtils.needLog((Context)this.ctx);
        StringBuffer sb = new StringBuffer(new Date().toString());
        sb.append("\tDAP reverse write begin...\n");
        while (itrSourceBillCollection.hasNext()) {
            this.sourceBillInfo = (CoreBillBaseInfo)itrSourceBillCollection.next();
            VoucherCollection voucherCollection = this.getDestVoucherCollection(this.sourceBillInfo, (VoucherCollection)this.dapTransformerResult.getVoucherCollection(), this.dapTransformerResult.getRelationCollection());
            if (voucherCollection == null || voucherCollection.size() <= 0) continue;
            VoucherInfo voucherInfo = voucherCollection.get(0);
            this.sourceBillInfo.setBoolean(VOUCHERFLAG, true);
            if (needLog) {
                sb.append("Voucher Info:");
                sb.append(voucherInfo.toString()).append("\n");
            }
            if (!(this.sourceBillInfo instanceof IDAPBill)) continue;
            IDAPBill iDAPBill = (IDAPBill)this.sourceBillInfo;
            iDAPBill.setVoucher(voucherInfo);
            if (!needLog) continue;
            sb.append("Voucher:").append(voucherInfo.getId().toString()).append(" reverse write success!\n");
        }
        if (needLog) {
            sb.append("DAP reverse write end...\n");
            BotpUtils.createUserBOTPLog((Context)this.ctx, (String)sb.toString(), (boolean)false);
        }
    }

    private void writeBackSQLE(BOSObjectType srcBosObjectType, List srcBillIDsList, Map srcRelaMap, Map voucherRelationMap) throws BOSException, EASBizException {
        ArrayList<String> sqlList = new ArrayList<String>();
        String strTableName = "";
        try {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
            EntityObjectInfo entity = loader.getEntity(srcBosObjectType);
            strTableName = entity.getTable().getName();
            PropertyInfo prop = (PropertyInfo)entity.getInheritedPropertiesRuntime().getObject((Object)"voucher");
            String sVoucherFieldName = "";
            sVoucherFieldName = !prop.getMappingField().isMultilingual() ? prop.getMappingField().getName() : prop.getMappingField().getName() + "_" + this.ctx.getLocale();
            String strSqlUpdate = "update " + strTableName + " set fFiVouchered=1, " + sVoucherFieldName + "='";
            long t0 = System.currentTimeMillis();
            for (Map.Entry entry : voucherRelationMap.entrySet()) {
                String sVoucherID = entry.getKey().toString();
                BOTRelationCollection relations = (BOTRelationCollection)entry.getValue();
                String strSqlStart = strSqlUpdate + sVoucherID.toString() + "' Where fID  in (";
                if (relations == null || relations.size() <= 0) continue;
                StringBuffer sb = new StringBuffer();
                int iTempLenth = 0;
                for (int i = 0; i < relations.size(); ++i) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append("'" + relations.get(i).getSrcObjectID() + "'");
                    if (iTempLenth <= 2000) continue;
                    iTempLenth = 0;
                    sqlList.add(strSqlStart + sb.toString() + ")");
                    sb = new StringBuffer();
                }
                sqlList.add(strSqlStart + sb.toString() + ")");
            }
            DAPAppTools.executeBatchUpdate(this.ctx, sqlList);
            long t1 = System.currentTimeMillis();
            logger.info((Object)("executeBatchUpdate,   time=" + (t1 - t0) + "ms"));
        }
        catch (SQLException e) {
            throw new BOSException("Update DAPBill Faild!  strTableName=" + strTableName, (Throwable)e);
        }
    }

    private void saveAndSubmitVoucher() throws BOSException, EASBizException {
        this.iVoucher = VoucherFactory.getLocalInstance((Context)this.ctx);
        boolean needLog = BotpUtils.needLog((Context)this.ctx);
        StringBuffer sb = new StringBuffer(new Date().toLocaleString());
        sb.append("\tDAP save voucher begin...\n");
        BOTRelationCollection botRelationCols = this.dapTransformerResult.getRelationCollection();
        HashMap<String, BOTRelationCollection> relationMap = new HashMap<String, BOTRelationCollection>();
        BOTRelationCollection botRelationTemp = null;
        for (int i = 0; i < botRelationCols.size(); ++i) {
            BOTRelationInfo botRelationInfo = botRelationCols.get(i);
            String destBillId = botRelationInfo.getDestObjectID();
            if (!relationMap.containsKey(destBillId)) {
                botRelationTemp = new BOTRelationCollection();
                botRelationTemp.add(botRelationInfo);
                relationMap.put(destBillId, botRelationTemp);
                continue;
            }
            botRelationTemp = (BOTRelationCollection)relationMap.get(destBillId);
            botRelationTemp.add(botRelationInfo);
        }
        try {
            for (VoucherInfo voucher : this.dapTransformerResult.getVoucherCollection()) {
                this.innerPrint("*************\u51ed\u8bc1\u4fdd\u5b58\u524d*************", null);
                this.printVoucher(voucher);
                if (DAPFIVoucherTransformer.isTempSave(this.ctx, this.dapTransformerResult.getRelationCollection())) {
                    if (voucher.getId() != null && relationMap.get(voucher.getId().toString()) != null) {
                        voucher.put("botrelation", relationMap.get(voucher.getId().toString()));
                    }
                    this.iVoucher.save((CoreBaseInfo)voucher);
                    if (needLog) {
                        sb.append("Voucher temp save success!\n");
                    }
                } else {
                    if (voucher.getId() != null && relationMap.get(voucher.getId().toString()) != null) {
                        voucher.put("botrelation", relationMap.get(voucher.getId().toString()));
                    }
                    this.iVoucher.submit((CoreBaseInfo)voucher);
                    this.wfSubmit(this.ctx, voucher);
                    if (needLog) {
                        sb.append("Voucher submit workflow success!\n");
                    }
                }
                this.innerPrint("*************\u51ed\u8bc1\u4fdd\u5b58\u540e*************", null);
                this.printVoucher(voucher);
            }
            this.trace.log("after save All Voucher:");
            this.trace.log(new TraceParamInfo(new Object[]{this.dapTransformerResult.getVoucherCollection()}));
        }
        catch (EASBizException e) {
            if (needLog) {
                sb.append("*****Voucher save failed:*****");
                sb.append(e.getMessage(this.ctx.getLocale())).append("\n");
            }
            throw new DAPException(DAPException.VOUCHER_NOT_SAVE, e, new Object[]{e.getMessage(this.ctx.getLocale())});
        }
        catch (WfException e) {
            if (needLog) {
                sb.append("Voucher submit workflow failed:");
                sb.append(e.getMessage()).append("\n");
            }
            throw new DAPException(DAPException.VOUCHER_NOT_SUBMIT, e);
        }
        finally {
            if (needLog) {
                BotpUtils.createUserBOTPLog((Context)this.ctx, (String)sb.toString(), (boolean)false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSourceBill() throws BOSException, EASBizException {
        block40: {
            boolean needLog = BotpUtils.needLog((Context)this.ctx);
            StringBuffer sb = new StringBuffer(new Date().toLocaleString());
            sb.append("\tDAP save source bill after reverse write begin...\n");
            try {
                CoreBillBaseInfo billBaseInfo = null;
                Iterator itrSourceBillCollection = null;
                assert (this.sourceBillCollection.size() > 0);
                HashMap bosTypeToEntityImpl = new HashMap();
                BOTRelationCollection botRelationCols = this.dapTransformerResult.getRelationCollection();
                ArrayList<BOSObjectType> bosTypes = new ArrayList<BOSObjectType>();
                HashMap<BOSObjectType, BOTRelationCollection> relationMap = new HashMap<BOSObjectType, BOTRelationCollection>();
                BOTRelationCollection botRelationTemp = null;
                for (int i = 0; i < botRelationCols.size(); ++i) {
                    BOTRelationInfo botRelationInfo = botRelationCols.get(i);
                    String srcBillId = botRelationInfo.getSrcObjectID();
                    BOSUuid srcUuid = BOSUuid.read((String)srcBillId);
                    BOSObjectType bosObjectType = srcUuid.getType();
                    if (!bosTypes.contains(bosObjectType)) {
                        botRelationTemp = new BOTRelationCollection();
                        botRelationTemp.add(botRelationInfo);
                        bosTypes.add(bosObjectType);
                        relationMap.put(bosObjectType, botRelationTemp);
                        continue;
                    }
                    botRelationTemp = (BOTRelationCollection)relationMap.get(bosObjectType);
                    botRelationTemp.add(botRelationInfo);
                }
                CoreBillBaseCollection curSrcBillCollection = null;
                BOTRelationCollection botRelationCol = null;
                for (int k = 0; k < this.allSrcBillColsList.size(); ++k) {
                    Object[] objz;
                    ObjectUuidPK[] pks;
                    ICoreBillBase isrcBillBase = null;
                    Method mothod = null;
                    Method mothod_new = null;
                    Method mothod_multi = null;
                    BOSObjectType srcBosObjectType = null;
                    curSrcBillCollection = (CoreBillBaseCollection)this.allSrcBillColsList.get(k);
                    itrSourceBillCollection = curSrcBillCollection.iterator();
                    if (curSrcBillCollection.size() > 0) {
                        srcBosObjectType = curSrcBillCollection.get(0).getBOSType();
                        botRelationCol = (BOTRelationCollection)relationMap.get(srcBosObjectType);
                        isrcBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)srcBosObjectType);
                        Class[] MultiClz = new Class[]{IObjectPK[].class, CoreBillBaseCollection.class, BOTBillOperStateEnum.class, List.class, List.class};
                        Class[] newClz = new Class[]{IObjectPK[].class, CoreBillBaseCollection.class, BOTBillOperStateEnum.class, BOTRelationCollection.class, IObjectCollection.class};
                        Class[] clz = new Class[]{IObjectPK[].class, CoreBillBaseCollection.class, BOTBillOperStateEnum.class, BOTRelationCollection.class};
                        if (this.transformerResultList.size() > 1) {
                            try {
                                mothod_multi = isrcBillBase.getClass().getMethod("batchReverseSave", MultiClz);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                        if (mothod_multi == null) {
                            try {
                                mothod_new = isrcBillBase.getClass().getMethod("batchReverseSave", newClz);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                        if (mothod_new == null) {
                            try {
                                mothod = isrcBillBase.getClass().getMethod("batchReverseSave", clz);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                    }
                    if (null != mothod_multi) {
                        pks = new ObjectUuidPK[curSrcBillCollection.size()];
                        for (int i = 0; i < curSrcBillCollection.size(); ++i) {
                            pks[i] = new ObjectUuidPK(curSrcBillCollection.get(i).getId());
                        }
                        ArrayList<BOTRelationCollection> botRelationColList = new ArrayList<BOTRelationCollection>();
                        for (int i = 0; i < this.transformerResultList.size(); ++i) {
                            botRelationColList.add(((DAPTransformResult)this.transformerResultList.get(i)).getRelationCollection());
                        }
                        ArrayList<IObjectCollection> voucherColList = new ArrayList<IObjectCollection>();
                        for (int i = 0; i < this.transformerResultList.size(); ++i) {
                            voucherColList.add(((DAPTransformResult)this.transformerResultList.get(i)).getVoucherCollection());
                        }
                        Object[] objz2 = new Object[]{pks, curSrcBillCollection, BOTBillOperStateEnum.ADDNEW, botRelationColList, voucherColList};
                        mothod_multi.invoke((Object)isrcBillBase, objz2);
                        continue;
                    }
                    if (mothod_new != null) {
                        pks = new ObjectUuidPK[curSrcBillCollection.size()];
                        for (int i = 0; i < curSrcBillCollection.size(); ++i) {
                            pks[i] = new ObjectUuidPK(curSrcBillCollection.get(i).getId());
                        }
                        objz = new Object[]{pks, curSrcBillCollection, BOTBillOperStateEnum.ADDNEW, botRelationCol, this.dapTransformerResult.getVoucherCollection()};
                        mothod_new.invoke((Object)isrcBillBase, objz);
                        continue;
                    }
                    if (mothod != null) {
                        pks = new ObjectUuidPK[curSrcBillCollection.size()];
                        for (int i = 0; i < curSrcBillCollection.size(); ++i) {
                            pks[i] = new ObjectUuidPK(curSrcBillCollection.get(i).getId());
                        }
                        objz = new Object[]{pks, curSrcBillCollection, BOTBillOperStateEnum.ADDNEW, botRelationCol};
                        mothod.invoke((Object)isrcBillBase, objz);
                        continue;
                    }
                    while (itrSourceBillCollection.hasNext()) {
                        billBaseInfo = (CoreBillBaseInfo)itrSourceBillCollection.next();
                        String srcBillId = billBaseInfo.getId().toString();
                        if (needLog) {
                            sb.append("Src Bill ID:").append(srcBillId).append("\n");
                        }
                        BOSObjectType bosObjectType = billBaseInfo.getBOSType();
                        String bosTypeStr = bosObjectType.toString();
                        ICoreBillBase iBillBase = null;
                        if (bosTypeToEntityImpl.containsKey(bosTypeStr)) {
                            iBillBase = (ICoreBillBase)bosTypeToEntityImpl.get(bosTypeStr);
                        }
                        if (iBillBase == null) {
                            iBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosObjectType);
                        }
                        Iterator iter = botRelationCol.iterator();
                        BOTRelationInfo botRelationInfo = null;
                        while (iter.hasNext()) {
                            BOTRelationInfo currentBotRelationInfo = (BOTRelationInfo)iter.next();
                            if (!currentBotRelationInfo.getSrcObjectID().equals(srcBillId)) continue;
                            botRelationInfo = currentBotRelationInfo;
                        }
                        if (needLog) {
                            sb.append("BOTP relation info:");
                            sb.append(botRelationInfo.toString()).append("\n");
                        }
                        logger.error((Object)"DAPFIVoucherTransformer---saveSourceBill  \u5f00\u59cb111");
                        String botMappingId = ((BOTRelationInfo)botRelationCol.getObject(0)).getBOTMappingID();
                        BOTMappingInfo botMappingInfo = MappingCache.getInstance((Context)this.ctx).getMappingInfo(botMappingId, this.ctx);
                        BOTExtMappingInfo extMappingInfo = botMappingInfo.getExtRule();
                        String dataFilter = extMappingInfo.getDataFilter();
                        if (dataFilter != null && !"".equals(dataFilter)) {
                            IDAPBill iDAPBill;
                            VoucherInfo voucherInfo = null;
                            if (billBaseInfo instanceof IDAPBill) {
                                iDAPBill = (IDAPBill)billBaseInfo;
                                voucherInfo = iDAPBill.getVoucher();
                            }
                            billBaseInfo = (CoreBillBaseInfo)this.getBill(srcBillId);
                            billBaseInfo.setBoolean(VOUCHERFLAG, true);
                            if (voucherInfo != null) {
                                iDAPBill = (IDAPBill)billBaseInfo;
                                iDAPBill.setVoucher(voucherInfo);
                            }
                        }
                        logger.error((Object)"DAPFIVoucherTransformer---saveSourceBill  \u5f00\u59cb222");
                        iBillBase.reverseSave((IObjectPK)new ObjectUuidPK(srcBillId), billBaseInfo, BOTBillOperStateEnum.ADDNEW, botRelationInfo);
                        if (!needLog) continue;
                        sb.append("DAP reverse save source bill success!\n");
                    }
                }
            }
            catch (Exception e) {
                if (needLog) {
                    sb.append("DAP reverse save source bill failed:");
                    sb.append(e.getMessage()).append("\n");
                }
                if (e instanceof InvocationTargetException) {
                    InvocationTargetException targetEx = (InvocationTargetException)e;
                    if (targetEx.getTargetException() != null && targetEx.getTargetException().getMessage() != null) {
                        throw new DAPException(DAPException.SOURCEBILL_NOT_SAVE, e, new Object[]{targetEx.getTargetException().getMessage()});
                    }
                    break block40;
                }
                throw new DAPException(DAPException.SOURCEBILL_NOT_SAVE, e, new Object[]{e.getMessage()});
            }
            finally {
                if (needLog) {
                    BotpUtils.createUserBOTPLog((Context)this.ctx, (String)sb.toString(), (boolean)false);
                }
            }
        }
    }

    private Method getBatchReverseSaveMethod(ICoreBillBase isrcBillBase, BOSObjectType srcBosObjectType) throws BOSException, EASBizException {
        Method method = null;
        Class[] clz = new Class[]{IObjectPK[].class, CoreBillBaseCollection.class, BOTBillOperStateEnum.class, BOTRelationCollection.class};
        try {
            method = isrcBillBase.getClass().getMethod("batchReverseSave", clz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    private void saveSourceBillSQLE(IObjectPK[] srcBillIDsList) throws BOSException, EASBizException {
        try {
            int kk = 10;
            HashMap srcIDTypeKindMap = new HashMap();
            HashMap srcIDRelationKindMap = new HashMap();
            HashMap srcVoucherRelationMap = new HashMap();
            BOTRelationCollection botRelationCols = this.dapTransformerResult.getRelationCollection();
            VoucherCollection vouchers = (VoucherCollection)this.dapTransformerResult.getVoucherCollection();
            this.buildSrcIDKindMapByBOSType(srcBillIDsList, botRelationCols, vouchers, srcIDTypeKindMap, srcIDRelationKindMap, srcVoucherRelationMap);
            if (srcIDTypeKindMap == null || srcIDTypeKindMap.size() <= 0) {
                return;
            }
            SelectorItemCollection selectors = new SelectorItemCollection();
            SelectorItemInfo selectItem = new SelectorItemInfo("id");
            selectors.add(selectItem);
            HashMap<String, BOTRelationInfo> srcRelaMap = new HashMap<String, BOTRelationInfo>();
            if (botRelationCols != null && botRelationCols.size() > 0) {
                for (int i = 0; i < botRelationCols.size(); ++i) {
                    BOTRelationInfo relation = botRelationCols.get(i);
                    String srcID = relation.getSrcObjectID();
                    srcRelaMap.put(srcID, relation);
                }
            }
            for (Map.Entry entry : srcIDTypeKindMap.entrySet()) {
                BOSObjectType srcBosObjectType = (BOSObjectType)entry.getKey();
                List pkList = (List)entry.getValue();
                if (pkList == null || pkList.size() <= 0) continue;
                IObjectPK objectPK = (IObjectPK)pkList.get(0);
                CoreBillBaseInfo firstBillBase = this.transSrcPk2BizObj(this.ctx, objectPK, selectors);
                if (firstBillBase instanceof IDAPBill) {
                    long t0 = System.currentTimeMillis();
                    this.writeBackSQLE(srcBosObjectType, pkList, srcRelaMap, srcVoucherRelationMap);
                    long t1 = System.currentTimeMillis();
                    logger.info((Object)("***DAPFIVoucherTransformer, writeBackSQLE,  " + (t1 - t0) + "ms"));
                }
                ICoreBillBase isrcBillBase = null;
                isrcBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)srcBosObjectType);
                Method batchMethod = this.getBatchReverseSaveMethod(isrcBillBase, srcBosObjectType);
                if (batchMethod != null) {
                    ObjectUuidPK[] pks = new ObjectUuidPK[pkList.size()];
                    for (int i = 0; i < pkList.size(); ++i) {
                        pks[i] = (IObjectPK)pkList.get(i);
                    }
                    BOTRelationCollection botRelationCol = (BOTRelationCollection)srcIDRelationKindMap.get(srcBosObjectType);
                    Object[] objz = new Object[]{pks, null, BOTBillOperStateEnum.ADDNEW, botRelationCol};
                    batchMethod.invoke((Object)isrcBillBase, objz);
                    continue;
                }
                CoreBillBaseCollection bills = this.transAllSrcPks2BizObj(this.ctx, srcBillIDsList, selectors);
                Iterator itrSourceBillCollection = bills.iterator();
                HashMap bosTypeToEntityImpl = new HashMap();
                while (itrSourceBillCollection.hasNext()) {
                    BOTRelationInfo botRelationInfo;
                    CoreBillBaseInfo billBaseInfo = (CoreBillBaseInfo)itrSourceBillCollection.next();
                    String srcBillId = billBaseInfo.getId().toString();
                    BOSObjectType bosObjectType = billBaseInfo.getBOSType();
                    String bosTypeStr = bosObjectType.toString();
                    ICoreBillBase iBillBase = null;
                    if (bosTypeToEntityImpl.containsKey(bosTypeStr)) {
                        iBillBase = (ICoreBillBase)bosTypeToEntityImpl.get(bosTypeStr);
                    }
                    if (iBillBase == null) {
                        iBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosObjectType);
                    }
                    if ((botRelationInfo = (BOTRelationInfo)srcRelaMap.get(srcBillId)) == null) continue;
                    iBillBase.reverseSave((IObjectPK)new ObjectUuidPK(srcBillId), billBaseInfo, BOTBillOperStateEnum.ADDNEW, botRelationInfo);
                }
            }
        }
        catch (Exception e) {
            throw new DAPException(DAPException.SOURCEBILL_NOT_SAVE, e, new Object[]{e.getMessage()});
        }
    }

    private void buildSrcIDKindMapByBOSType(IObjectPK[] srcBillIDsList, BOTRelationCollection botRelationCols, VoucherCollection vouchers, Map srcIDTypeKindMap, Map srcIDRelationKindMap, Map srcVoucherRelationMap) throws BOSException, EASBizException {
        BOTRelationInfo botRelationInfo;
        int i;
        if (srcBillIDsList == null || srcBillIDsList.length <= 0) {
            return;
        }
        for (i = 0; i < srcBillIDsList.length; ++i) {
            BOSUuid uuid = BOSUuid.read((String)srcBillIDsList[i].toString());
            BOSObjectType srcBosObjectType = uuid.getType();
            ArrayList<IObjectPK> pkList = (ArrayList<IObjectPK>)srcIDTypeKindMap.get(srcBosObjectType);
            if (pkList == null) {
                pkList = new ArrayList<IObjectPK>();
                srcIDTypeKindMap.put(srcBosObjectType, pkList);
            }
            pkList.add(srcBillIDsList[i]);
        }
        for (i = 0; i < botRelationCols.size(); ++i) {
            botRelationInfo = botRelationCols.get(i);
            String srcBillId = botRelationInfo.getSrcObjectID();
            BOSUuid srcUuid = BOSUuid.read((String)srcBillId);
            BOSObjectType bosObjectType = srcUuid.getType();
            BOTRelationCollection botRelationTemp = (BOTRelationCollection)srcIDRelationKindMap.get(bosObjectType);
            if (botRelationTemp == null) {
                botRelationTemp = new BOTRelationCollection();
                botRelationTemp.add(botRelationInfo);
                srcIDRelationKindMap.put(bosObjectType, botRelationTemp);
                continue;
            }
            botRelationTemp.add(botRelationInfo);
        }
        for (i = 0; i < botRelationCols.size(); ++i) {
            botRelationInfo = botRelationCols.get(i);
            String destBillId = botRelationInfo.getDestObjectID();
            BOTRelationCollection botRelationTemp = (BOTRelationCollection)srcVoucherRelationMap.get(destBillId);
            if (botRelationTemp == null) {
                botRelationTemp = new BOTRelationCollection();
                botRelationTemp.add(botRelationInfo);
                srcVoucherRelationMap.put(destBillId, botRelationTemp);
                continue;
            }
            botRelationTemp.add(botRelationInfo);
        }
    }

    private CoreBillBaseCollection transAllSrcPks2BizObj(Context ctx, IObjectPK[] srcBillPKs, SelectorItemCollection selectors) throws BOSException {
        if (srcBillPKs == null || srcBillPKs.length <= 0) {
            return null;
        }
        long ts = System.currentTimeMillis();
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        if (srcBillPKs == null || srcBillPKs.length <= 0) {
            return null;
        }
        int total = srcBillPKs.length;
        int step = 1000;
        int max = total % step == 0 ? total / step : total / step + 1;
        for (int j = 0; j < max; ++j) {
            int start = j * step;
            int length = step;
            if (start + length > total) {
                length = total - start;
            }
            CoreBillBaseCollection items = this.transAllSrcPks2BizObjStep(ctx, srcBillPKs, selectors, start, length);
            for (int i = 0; i < items.size(); ++i) {
                CoreBillBaseInfo bill = (CoreBillBaseInfo)items.getObject(i);
                sourceBillCollection.add(bill);
            }
        }
        long te = System.currentTimeMillis();
        logger.info((Object)("***DAPFIVoucherTransformer,  transAllSrcPks2BizObj,  idsize=" + srcBillPKs.length + ", objsize=" + sourceBillCollection.size() + ", time=" + (te - ts) + "ms"));
        return sourceBillCollection;
    }

    private CoreBillBaseCollection transAllSrcPks2BizObjStep(Context ctx, IObjectPK[] srcBillPKs, SelectorItemCollection selectors, int start, int length) throws BOSException {
        if (start < 0 || start >= srcBillPKs.length || length < 0) {
            return null;
        }
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        Object isrcBillBase = null;
        BOSObjectType srcBosObjectType = null;
        BOSUuid uuid = BOSUuid.read((String)srcBillPKs[0].toString());
        srcBosObjectType = uuid.getType();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            String id = srcBillPKs[start + i].toString();
            if (i > 0) {
                buff.append(",");
            }
            buff.append(id);
        }
        String strIDList = buff.toString();
        FilterItemInfo filterItemInfo = new FilterItemInfo("id", (Object)strIDList, CompareType.INCLUDE);
        filterInfo.getFilterItems().add(filterItemInfo);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(selectors);
        IObjectCollection items = null;
        items = Utils.getObjectCollection((Context)ctx, (BOSObjectType)srcBosObjectType, (EntityViewInfo)viewInfo);
        for (int i = 0; i < items.size(); ++i) {
            CoreBillBaseInfo bill = (CoreBillBaseInfo)items.getObject(i);
            sourceBillCollection.add(bill);
        }
        return sourceBillCollection;
    }

    private CoreBillBaseInfo transSrcPk2BizObj(Context ctx, IObjectPK srcBillPK, SelectorItemCollection selectors) throws BOSException {
        if (srcBillPK == null || selectors == null) {
            return null;
        }
        CoreBillBaseInfo bill = null;
        Object isrcBillBase = null;
        BOSObjectType srcBosObjectType = null;
        BOSUuid uuid = BOSUuid.read((String)srcBillPK.toString());
        srcBosObjectType = uuid.getType();
        FilterInfo filterInfo = new FilterInfo();
        String sID = srcBillPK.toString();
        FilterItemInfo filterItemInfo = new FilterItemInfo("id", (Object)sID, CompareType.INCLUDE);
        filterInfo.getFilterItems().add(filterItemInfo);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(selectors);
        IObjectCollection colls = Utils.getObjectCollection((Context)ctx, (BOSObjectType)srcBosObjectType, (EntityViewInfo)viewInfo);
        if (colls != null && colls.size() > 0) {
            bill = (CoreBillBaseInfo)colls.getObject(0);
        }
        return bill;
    }

    private void reverseSaveSourceBill4SQLE(List srcIDsList) throws BOSException, EASBizException {
        boolean kk = false;
        boolean needLog = BotpUtils.needLog((Context)this.ctx);
        StringBuffer sb = new StringBuffer(new Date().toLocaleString());
        sb.append("\tDAP save source bill after reverse write begin...\n");
        try {
            Object billBaseInfo = null;
            BOTRelationCollection botRelationCols = this.dapTransformerResult.getRelationCollection();
            HashMap<BOSObjectType, ArrayList<BOTRelationInfo>> relationMap = new HashMap<BOSObjectType, ArrayList<BOTRelationInfo>>();
            HashMap<BOSObjectType, ArrayList<BOSUuid>> srcIDMap = new HashMap<BOSObjectType, ArrayList<BOSUuid>>();
            HashMap<BOSObjectType, BOSObjectType> typeMap = new HashMap<BOSObjectType, BOSObjectType>();
            for (int i = 0; i < botRelationCols.size(); ++i) {
                BOTRelationInfo botRelationInfo = botRelationCols.get(i);
                String strBillId = botRelationInfo.getSrcObjectID();
                BOSUuid srcUuid = BOSUuid.read((String)strBillId);
                BOSObjectType bosObjectType = srcUuid.getType();
                typeMap.put(bosObjectType, bosObjectType);
                ArrayList<BOTRelationInfo> botRelationTempList = (ArrayList<BOTRelationInfo>)relationMap.get(bosObjectType);
                if (botRelationTempList == null) {
                    botRelationTempList = new ArrayList<BOTRelationInfo>();
                    relationMap.put(bosObjectType, botRelationTempList);
                }
                botRelationTempList.add(botRelationInfo);
                ArrayList<BOSUuid> srcIDList = (ArrayList<BOSUuid>)srcIDMap.get(bosObjectType);
                if (botRelationTempList == null) {
                    srcIDList = new ArrayList<BOSUuid>();
                    srcIDMap.put(bosObjectType, srcIDList);
                }
                srcIDList.add(srcUuid);
            }
            for (BOSObjectType bosObjectType : typeMap.values()) {
                List srcIDList = (List)srcIDMap.get(bosObjectType);
                List botRelationTempList = (List)relationMap.get(bosObjectType);
                Method method = this.getDynBatchReverseMethodByID(bosObjectType);
                if (method == null) continue;
            }
            IObjectPK[] srcBillPKs = null;
            BOTRelationCollection botRelationCol = null;
            for (int k = 0; k < srcIDsList.size(); ++k) {
                Object isrcBillBase = null;
                Object mothod = null;
                BOSObjectType srcBosObjectType = null;
                srcBillPKs = (IObjectPK[])srcIDsList.get(k);
                if (srcBillPKs.length <= 0) continue;
                BOSUuid id = BOSUuid.read((String)srcBillPKs[0].toString());
                srcBosObjectType = id.getType();
                botRelationCol = (BOTRelationCollection)relationMap.get(srcBosObjectType);
            }
        }
        catch (Exception e) {
            if (needLog) {
                sb.append("DAP reverse save source bill failed:");
                sb.append(e.getMessage()).append("\n");
            }
            throw new DAPException(DAPException.SOURCEBILL_NOT_SAVE, e, new Object[]{e.getMessage()});
        }
        finally {
            if (needLog) {
                BotpUtils.createUserBOTPLog((Context)this.ctx, (String)sb.toString(), (boolean)false);
            }
        }
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private void saveRelation() throws BOSException, EASBizException {
        Connection cn = null;
        try {
            cn = this.getConnection(this.ctx);
            BOTRelationCollection botRelationCollection = this.dapTransformerResult.getRelationCollection();
            Iterator iter = botRelationCollection.iterator();
            int tmpRelationSize = 0;
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            String sql = "insert into t_bot_relation (FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE) values (?,?,?,?,?,?,?,?,?,?)";
            while (iter.hasNext()) {
                BOTRelationInfo dapRelationInfo = (BOTRelationInfo)iter.next();
                Object[] params = new Object[]{dapRelationInfo.getId().toString(), dapRelationInfo.getSrcEntityID(), dapRelationInfo.getDestEntityID(), dapRelationInfo.getSrcObjectID(), dapRelationInfo.getDestObjectID(), dapRelationInfo.getDate() != null ? new Timestamp(dapRelationInfo.getDate().getTime()) : new Timestamp(System.currentTimeMillis()), dapRelationInfo.getOperatorID(), dapRelationInfo.isIsEffected(), dapRelationInfo.getBOTMappingID(), dapRelationInfo.getType()};
                paramList.add(params);
                dapRelationInfo.setIsEffected(true);
                tmpRelationSize = paramList.size();
                if (tmpRelationSize <= 2000) continue;
                DbUtil.executeBatch((Context)this.ctx, (String)sql, paramList);
                paramList.clear();
                tmpRelationSize = 0;
            }
            if (tmpRelationSize != 0) {
                DbUtil.executeBatch((Context)this.ctx, (String)sql, paramList);
                paramList.clear();
            }
        }
        catch (Exception e) {
            try {
                throw new DAPException(DAPException.RELATION_NOT_ADD, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
    }

    private VoucherCollection getDestVoucherCollection(CoreBillBaseInfo billBaseInfo, VoucherCollection voucherCollection, BOTRelationCollection botRelationCollection) throws BOSException, EASBizException {
        VoucherCollection voucher = new VoucherCollection();
        String srcID = billBaseInfo.getId().toString();
        for (BOTRelationInfo relationInfo : botRelationCollection) {
            if (!relationInfo.getSrcObjectID().equals(srcID)) continue;
            String destID = relationInfo.getDestObjectID();
            for (VoucherInfo voucherInfo : voucherCollection) {
                if (!voucherInfo.getId().toString().equals(destID)) continue;
                voucher.add(voucherInfo);
            }
        }
        return voucher;
    }

    private PeriodInfo getPeriod(CompanyOrgUnitInfo companyInfo, Date date) throws BOSException, EASBizException {
        try {
            return PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)date, (CompanyOrgUnitInfo)companyInfo, (SystemEnum)SystemEnum.GENERALLEDGER);
        }
        catch (Exception e) {
            throw new DAPException(DAPException.PERIOD_NOT_GET, e);
        }
    }

    private CompanyOrgUnitInfo getCompanyInfo(CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyInfo.getId());
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)pk, selectors);
        return companyInfo;
    }

    private BigDecimal getLocalExchangeRate(CurrencyInfo srcCurrencyInfo, CompanyOrgUnitInfo companyOrgUnitInfo, Date date) throws BOSException, EASBizException {
        ObjectUuidPK targetCurrencyID = null;
        ObjectUuidPK sourceCurrencyID = null;
        try {
            CurrencyInfo localCurrencyInfo = companyOrgUnitInfo.getBaseCurrency();
            targetCurrencyID = new ObjectUuidPK(localCurrencyInfo.getId());
            sourceCurrencyID = new ObjectUuidPK(srcCurrencyInfo.getId());
            if (targetCurrencyID.equals((Object)sourceCurrencyID)) {
                return new BigDecimal(1.0);
            }
            ObjectUuidPK exchangetableId = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
            ExchangeRateInfo rateInfo = ExchangeRateFactory.getLocalInstance((Context)this.ctx).getExchangeRate((IObjectPK)exchangetableId, (IObjectPK)sourceCurrencyID, (IObjectPK)targetCurrencyID, date);
            if (rateInfo == null) {
                throw new DAPException(DAPException.LOCALEXCHANGERATE_NOT_GET);
            }
            return rateInfo.getConvertRate();
        }
        catch (Exception e) {
            String srcC = "NULL";
            String targetC = "NULL";
            if (sourceCurrencyID != null) {
                srcC = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo(sourceCurrencyID).getName();
            }
            if (targetCurrencyID != null) {
                targetC = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)targetCurrencyID).getName();
            }
            throw new DAPException(DAPException.LOCALEXCHANGERATE_NOT_GET, new Object[]{srcC, targetC});
        }
    }

    private BigDecimal getReportingExchangeRate(CurrencyInfo srcCurrencyInfo, CompanyOrgUnitInfo companyOrgUnitInfo, Date date) throws BOSException, EASBizException {
        CurrencyInfo reportCurrencyInfo = companyOrgUnitInfo.getReportCurrency();
        ObjectUuidPK targetCurrencyID = null;
        ObjectUuidPK sourceCurrencyID = null;
        if (reportCurrencyInfo != null) {
            targetCurrencyID = new ObjectUuidPK(reportCurrencyInfo.getId());
            if (srcCurrencyInfo == null) {
                throw new DAPException(DAPException.SRCCURRENCYCANNOTBENULL);
            }
            sourceCurrencyID = new ObjectUuidPK(srcCurrencyInfo.getId());
            if (targetCurrencyID.equals((Object)sourceCurrencyID)) {
                return new BigDecimal(1.0);
            }
            ObjectUuidPK exchangetableId = new ObjectUuidPK(companyOrgUnitInfo.getReportExchangeTable().getId());
            ExchangeRateInfo rateInfo = ExchangeRateFactory.getLocalInstance((Context)this.ctx).getExchangeRate((IObjectPK)exchangetableId, (IObjectPK)sourceCurrencyID, (IObjectPK)targetCurrencyID, date);
            if (rateInfo != null) {
                return rateInfo.getConvertRate();
            }
            String srcC = "NULL";
            String targetC = "NULL";
            if (sourceCurrencyID != null) {
                srcC = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)sourceCurrencyID).getName();
            }
            if (targetCurrencyID != null) {
                targetC = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)targetCurrencyID).getName();
            }
            throw new DAPException(DAPException.REPORTCURRENCY_NOT_GET, new Object[]{srcC, targetC});
        }
        return null;
    }

    private ExchangeRateInfo getLocalExchangeInfo(CurrencyInfo srcCurrencyInfo, CompanyOrgUnitInfo companyOrgUnitInfo, Date date) throws BOSException, EASBizException {
        ObjectUuidPK targetCurrencyID = null;
        ObjectUuidPK sourceCurrencyID = null;
        try {
            CurrencyInfo localCurrencyInfo = companyOrgUnitInfo.getBaseCurrency();
            targetCurrencyID = new ObjectUuidPK(localCurrencyInfo.getId());
            sourceCurrencyID = new ObjectUuidPK(srcCurrencyInfo.getId());
            if (targetCurrencyID.equals((Object)sourceCurrencyID)) {
                return null;
            }
            ObjectUuidPK exchangetableId = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
            ExchangeRateInfo rateInfo = ExchangeRateFactory.getLocalInstance((Context)this.ctx).getExchangeRate((IObjectPK)exchangetableId, (IObjectPK)sourceCurrencyID, (IObjectPK)targetCurrencyID, date);
            if (rateInfo == null) {
                throw new DAPException(DAPException.LOCALEXCHANGERATE_NOT_GET);
            }
            return rateInfo;
        }
        catch (Exception e) {
            String srcC = "NULL";
            String targetC = "NULL";
            if (sourceCurrencyID != null) {
                srcC = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo(sourceCurrencyID).getName();
            }
            if (targetCurrencyID != null) {
                targetC = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)targetCurrencyID).getName();
            }
            throw new DAPException(DAPException.LOCALEXCHANGERATE_NOT_GET, new Object[]{srcC, targetC});
        }
    }

    private ExchangeRateInfo getReportingExchangeInfo(CurrencyInfo srcCurrencyInfo, CompanyOrgUnitInfo companyOrgUnitInfo, Date date) throws BOSException, EASBizException {
        CurrencyInfo reportCurrencyInfo = companyOrgUnitInfo.getReportCurrency();
        ObjectUuidPK targetCurrencyID = null;
        ObjectUuidPK sourceCurrencyID = null;
        if (reportCurrencyInfo != null) {
            targetCurrencyID = new ObjectUuidPK(reportCurrencyInfo.getId());
            if (srcCurrencyInfo == null) {
                throw new DAPException(DAPException.SRCCURRENCYCANNOTBENULL);
            }
            sourceCurrencyID = new ObjectUuidPK(srcCurrencyInfo.getId());
            if (targetCurrencyID.equals((Object)sourceCurrencyID)) {
                return null;
            }
            ObjectUuidPK exchangetableId = new ObjectUuidPK(companyOrgUnitInfo.getReportExchangeTable().getId());
            ExchangeRateInfo rateInfo = ExchangeRateFactory.getLocalInstance((Context)this.ctx).getExchangeRate((IObjectPK)exchangetableId, (IObjectPK)sourceCurrencyID, (IObjectPK)targetCurrencyID, date);
            if (rateInfo != null) {
                return rateInfo;
            }
            String srcC = "NULL";
            String targetC = "NULL";
            if (sourceCurrencyID != null) {
                srcC = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)sourceCurrencyID).getName();
            }
            if (targetCurrencyID != null) {
                targetC = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)targetCurrencyID).getName();
            }
            throw new DAPException(DAPException.REPORTCURRENCY_NOT_GET, new Object[]{srcC, targetC});
        }
        return null;
    }

    private BOTRelationCollection getVouchersByRelation(Context ctx, CoreBillBaseInfo billInfo) throws BOSException, EASBizException {
        IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)VOUCHERTYPE));
        entityView.setFilter(filter);
        BOTRelationCollection relationCollection = new BOTRelationCollection();
        relationCollection.addCollection(iBotRelation.getCollection(entityView));
        return relationCollection;
    }

    @Override
    public boolean undoTransformFromBill(Context ctx, CoreBillBaseInfo sourceBill) throws BOSException, EASBizException {
        CoreBillBaseInfo billInfo = sourceBill;
        if (billInfo.containsKey(VOUCHERFLAG) && (billInfo.getBoolean(VOUCHERFLAG) || this.getVouchersByRelation(ctx, billInfo).size() > 0)) {
            IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
            if (billInfo instanceof IDAPBill && ((IDAPBill)billInfo).getVoucher() != null) {
                VoucherInfo voucherInfo = ((IDAPBill)billInfo).getVoucher();
                iVoucher.delete((IObjectPK)new ObjectUuidPK(voucherInfo.getId()));
                return true;
            }
            BOTRelationCollection relationCollection = this.getVouchersByRelation(ctx, billInfo);
            if (relationCollection.size() > 0) {
                for (BOTRelationInfo relationInfo : relationCollection) {
                    String voucherId = relationInfo.getDestObjectID();
                    iVoucher.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)voucherId)));
                }
                return true;
            }
        }
        return false;
    }

    private void wfSubmit(Context ctx, VoucherInfo voucher) throws BOSException, WfException {
    }

    private static boolean isTempSave(Context ctx, BOTRelationCollection relations) throws BOSException {
        BOTRelationInfo relation;
        if (relations != null && relations.size() > 0 && (relation = relations.get(0)) != null && !StringUtils.isEmpty((String)relation.getBOTMappingID())) {
            BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(relation.getBOTMappingID(), ctx);
            return mappingInfo.getIsTempSave() == 1;
        }
        return false;
    }

    private static int getMappingRuleSaveMode(Context ctx, BOTRelationCollection relations) {
        BOTRelationInfo relation;
        if (relations != null && relations.size() > 0 && (relation = relations.get(0)) != null && !StringUtils.isEmpty((String)relation.getBOTMappingID())) {
            String sql = "select FIsTempSave from T_BOT_Mapping where FID = ?";
            try {
                IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{relation.getBOTMappingID()});
                if (rowset.next()) {
                    return rowset.getInt(1);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return 2;
    }

    @Override
    public void removeVoucherRelationOrg(Context ctx, List vouhcherIDList) throws BOSException, EASBizException {
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        int n = vouhcherIDList.size();
        for (int i = 0; i < n; ++i) {
            String voucherID = (String)vouhcherIDList.get(i);
            ObjectUuidPK voucherPK = new ObjectUuidPK((String)vouhcherIDList.get(i));
            VoucherInfo voucher = (VoucherInfo)iVoucher.getValue((IObjectPK)voucherPK);
            this.undoTransformFromVoucher(ctx, (CoreBillBaseInfo)voucher);
            iVoucher.delete((IObjectPK)voucherPK);
        }
    }

    private void setTraceLevel(Context ctx, BOTRelationCollection relations) throws BOSException, EASBizException {
        this.trace.setTraceLevel(TraceLevel.LEVEL_NO);
        try {
            if (relations != null && relations.size() > 0) {
                BOTRelationInfo relation = relations.get(0);
                BOSUuid mappingId = BOSUuid.read((String)relation.getBOTMappingID());
                BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo((IObjectPK)new ObjectUuidPK(mappingId), ctx);
                TraceLevel traceLevel = TraceConfigurator.getTraceLevel((BOTMappingInfo)mappingInfo);
                this.trace.setTraceLevel(traceLevel);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Set Trace Level error!", (Throwable)e);
        }
    }

    public void addSrcIDList(IObjectPK[] srcBillIDList) {
        if (srcBillIDList == null || srcBillIDList.length <= 0) {
            return;
        }
        this.srcIDsList.add(srcBillIDList);
    }

    protected void removeSrcIDList(List srcBillIDList) {
        if (srcBillIDList == null || srcBillIDList.size() <= 0) {
            return;
        }
        this.srcIDsList.remove(srcBillIDList);
    }

    @Override
    public DAPTransformResult transformSqle(Context ctx, IObjectPK[] srcBillIDList, BOTMappingInfo botMappingInfo, SelectorItemCollection selectors) throws BOSException, EASBizException {
        this.init(ctx);
        this.preTransform();
        IObjectCollection resultColl = null;
        Object botException = null;
        BOTObjectCache cache = BOTObjectCache.getInstance((Context)ctx);
        cache.clear();
        try {
            this.botTransformSqle = new BOTTransformSQLE(ctx);
            BOTPFormulaEngineTools.initFormula((Context)ctx, (BOTTransformSQLE)this.botTransformSqle, (BOTMappingInfo)botMappingInfo);
            String[] srcBillIDs = new String[srcBillIDList.length];
            for (int i = 0; i < srcBillIDList.length; ++i) {
                srcBillIDs[i] = srcBillIDList[i].toString();
            }
            resultColl = this.botTransformSqle.businessObjectTransform(srcBillIDs, null, null, botMappingInfo);
            if (resultColl != null) {
                this.dapTransformerResult.setVoucherCollection(resultColl);
                this.dapTransformerResult.setRelationCollection(this.botTransformSqle.getBOTRelationCollection());
                this.dapTransformerResult.setVoucherType(DAPVoucherTypeEnum.FIVoucher);
                this.afterTransform();
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DAPException(DAPException.BOTE_NOT_RIGHT2, new Object[]{e});
        }
        finally {
            cache.clear();
            ThreadLocalCache.detroyRegion((String)BOT);
        }
        return this.dapTransformerResult;
    }

    private Method getDynBatchReverseMethodByObjColl(BOSObjectType bosObjectType) throws BOSException {
        Method method = null;
        String methodName = "batchReverseSave";
        ICoreBillBase isrcBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosObjectType);
        Class[] clz = new Class[]{IObjectPK[].class, CoreBillBaseCollection.class, BOTBillOperStateEnum.class, BOTRelationCollection.class};
        try {
            method = isrcBillBase.getClass().getMethod(methodName, clz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    private Method getDynBatchReverseMethodByID(BOSObjectType bosObjectType) throws BOSException {
        Method method = null;
        String methodName = "batchReverseSave";
        ICoreBillBase isrcBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosObjectType);
        Class[] clz = new Class[]{IObjectPK[].class, BOTBillOperStateEnum.class, IObjectPK[].class};
        try {
            method = isrcBillBase.getClass().getMethod(methodName, clz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    private void innerPrint(String msg, Object obj) {
        if (msg == null) {
            return;
        }
        if (obj == null) {
            this.trace.log("----" + msg + ":\u7a7a");
        } else {
            this.trace.log("----" + msg + ":" + obj.toString());
        }
    }

    private void printVoucher(VoucherInfo voucher) {
        try {
            this.innerPrint("\u51ed\u8bc1\u53f7", voucher.getNumber());
            this.innerPrint("\u516c\u53f8", voucher.getCompany());
            VoucherEntryCollection voucherEntryCollection = voucher.getEntries();
            Iterator itrVoucherEntry = voucherEntryCollection.iterator();
            this.innerPrint("\u5f00\u59cb\u904d\u5386\u5206\u5f55", null);
            while (itrVoucherEntry.hasNext()) {
                this.innerPrint(this.seprator, null);
                VoucherEntryInfo voucherEntryInfo = (VoucherEntryInfo)itrVoucherEntry.next();
                this.innerPrint("\u5206\u5f55\u5e8f\u53f7", voucherEntryInfo.getSeq());
                this.innerPrint("\u79d1\u76ee", voucherEntryInfo.getAccount());
                this.innerPrint("\u8f85\u52a9\u8d26", voucherEntryInfo.getAssistRecords());
                if (voucherEntryInfo.getAssistRecords() != null && voucherEntryInfo.getAssistRecords().size() > 0) {
                    VoucherAssistRecordCollection assistRecords = voucherEntryInfo.getAssistRecords();
                    for (int i = 0; i < assistRecords.size(); ++i) {
                        VoucherAssistRecordInfo voucherAssistRecordInfo = assistRecords.get(i);
                        if (voucherAssistRecordInfo == null) continue;
                        this.innerPrint("\u8f85\u52a9\u8d26\u6838\u7b97\u9879\u76ee", voucherAssistRecordInfo.getAssGrp());
                    }
                }
                this.innerPrint("\u539f\u5e01\u91d1\u989d", voucherEntryInfo.getOriginalAmount());
                this.innerPrint("\u672c\u4f4d\u91d1\u989d", voucherEntryInfo.getLocalAmount());
                this.innerPrint("\u62a5\u544a\u5e01\u91d1\u989d", voucherEntryInfo.getReportingAmount());
                this.innerPrint("\u672c\u4f4d\u5e01\u6298\u7b97\u6c47\u7387", voucherEntryInfo.getLocalExchangeRate());
                this.innerPrint("\u62a5\u544a\u5e01\u6298\u7b97\u6c47\u7387", voucherEntryInfo.getReportingExchangeRate());
                this.innerPrint("\u5e01\u522b", voucherEntryInfo.getCurrency());
            }
        }
        catch (Exception e) {
            this.innerPrint("\u6253\u5370\u65e5\u5fd7\u5f02\u5e38", null);
        }
    }

    private void recycleVoucherNumber(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (this.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo, voucherInfo.getBizStatus())) {
            this.recycleVoucherId(ctx, voucherInfo, voucherInfo.getNumber());
        } else {
            VoucherStatusEnum bizStatus = voucherInfo.getBizStatus();
            voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            if (this.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo, voucherInfo.getBizStatus())) {
                this.recycleVoucherId(ctx, voucherInfo, voucherInfo.getNumber());
            }
            voucherInfo.setBizStatus(bizStatus);
        }
    }

    public boolean isExistVoucherCodingRule(Context ctx, String companyId, VoucherInfo voucherInfo, VoucherStatusEnum status) throws EASBizException, BOSException {
        VoucherStatusEnum oldStatus = voucherInfo.getBizStatus();
        voucherInfo.setBizStatus(status);
        boolean isExistCodingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)voucherInfo, companyId, "bizStatus");
        voucherInfo.setBizStatus(oldStatus);
        return isExistCodingRule;
    }

    protected void recycleVoucherId(Context ctx, VoucherInfo voucherInfo, String voucherNumber) throws BOSException, EASBizException {
        if (voucherNumber != null) {
            VoucherFactory.getLocalInstance((Context)ctx).recycleVoucherNumber((BaseVoucherInfo)voucherInfo, voucherNumber);
        } else {
            VoucherInfo previousVoucher = null;
            String[] value = this.getCodingRuleProperties(ctx, voucherInfo);
            if (value != null && value.length > 0) {
                SelectorItemCollection sic = new SelectorItemCollection();
                for (int i = 0; i < value.length; ++i) {
                    sic.add(new SelectorItemInfo(value[i]));
                }
                previousVoucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), sic);
                previousVoucher.setNumber(voucherInfo.getNumber());
                previousVoucher.setBizStatus(voucherInfo.getBizStatus());
                this.recycleVoucherId(ctx, previousVoucher, previousVoucher.getNumber());
            }
        }
    }

    private String[] getCodingRuleProperties(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        int size;
        CodingRuleInfo codingRuleInfo;
        SeqSegmentInfo seqInfo;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String[] value = codingRuleManager.getProperties((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
        ArrayList<String> list = new ArrayList<String>();
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                list.add(value[i]);
            }
        }
        if ((seqInfo = ((AbstractCodingRuleInfo)(codingRuleInfo = codingRuleManager.getCodingRule((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus"))).getSeqSegment()) != null && seqInfo.size() > 0) {
            list.add(seqInfo.getAttrName());
        }
        if ((size = list.size()) > 0) {
            String[] returnValue = new String[size];
            for (int i = 0; i < size; ++i) {
                returnValue[i] = list.get(i).toString();
            }
            return returnValue;
        }
        return null;
    }

    private boolean isCheckPermission(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)"CHECK_SUBMITPERMISSION");
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u7279\u6b8a\u6743\u9650\u8bbe\u7f6e\u51fa\u9519   " + e.getMessage()));
        }
        return false;
    }

    private IObjectValue getBill(String currID) throws BOSException, EASBizException {
        BOSUuid srcObjId = BOSUuid.read((String)currID);
        BOSObjectType bosType = srcObjId.getType();
        ICoreBillBase iBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosType);
        return iBillBase.getValue((IObjectPK)new ObjectUuidPK(srcObjId));
    }

    @Override
    public void isCheckPermission(boolean ischeckPermission) throws BOSException, EASBizException {
        this.isCheckPermission = ischeckPermission;
    }

    private void checkRebuild(Context ctx, BOTRelationCollection botRelationColls) throws BOSException {
        BOTRelationInfo relationinfo;
        String srcBosType;
        if (botRelationColls.size() > 0 && ("40284E81".equals(srcBosType = (relationinfo = botRelationColls.get(0)).getSrcEntityID()) || "FA44FD5B".equals(srcBosType)) && relationinfo.getBOTMappingID() != null) {
            ArrayList<String> idList = new ArrayList<String>();
            ArrayList<String> destList = new ArrayList<String>();
            for (int i = 0; i < botRelationColls.size(); ++i) {
                idList.add(botRelationColls.get(i).getSrcObjectID());
                destList.add(botRelationColls.get(i).getDestObjectID());
            }
            BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(relationinfo.getBOTMappingID(), ctx);
            String reBuildControl = "";
            String extconfig = mappingInfo.getExtConfig();
            BotpExtConfigHelper.ExtConfigInfo info = null;
            BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper.XMLProcessor(new BotpExtConfigHelper());
            if (extconfig != null && !extconfig.equals("")) {
                try {
                    info = processor.marshallingExtConfig(extconfig);
                    reBuildControl = info.getReBuildControl();
                    if (reBuildControl.equals("2") && this.hasReBuild(ctx, idList, destList, VOUCHERTYPE)) {
                        BOSException e = new BOSException("\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210");
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw e;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public boolean hasReBuild(Context ctx, List idlist, List destList, String destBillTypeBOSType) throws BOSException {
        String billIds = StringUtils.arrayToString((Object[])idlist.toArray(), (String)",");
        String destbillIds = StringUtils.arrayToString((Object[])destList.toArray(), (String)",");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterBill = new FilterInfo();
        FilterInfo filterMapping = new FilterInfo();
        filterBill.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billIds, CompareType.INCLUDE));
        filterBill.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destbillIds, CompareType.NOTINCLUDE));
        filterMapping.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBillTypeBOSType, CompareType.EQUALS));
        filterBill.mergeFilter(filterMapping, "And");
        viewInfo.setFilter(filterBill);
        BOTRelationCollection relations = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        return relations != null && relations.size() != 0;
    }
}

