/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.MappingUtil;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.bot.trace.TraceConstants;
import com.kingdee.eas.base.bot.trace.TraceManagerFactory;
import com.kingdee.eas.base.bot.trace.core.ITraceManager;
import com.kingdee.eas.base.botp.util.BotpUtils;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.app.DAPAppTools;
import com.kingdee.eas.base.dap.app.DAPTransformUtils;
import com.kingdee.eas.base.dap.app.IDAPInnerTransformer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.util.LowTimer;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class DAPTransformSQLE {
    protected ITraceManager trace = TraceManagerFactory.newInstance((int)TraceConstants.TRACETYPE_BOTP);
    private static Logger logger = Logger.getLogger(DAPTransformSQLE.class);

    protected DAPTransformResult transformSQLE(Context ctx, IObjectPK[] srcBillIDList, DAPVoucherTypeEnum voucherType, IObjectValue botMappingInfo, SelectorItemCollection selectors) throws BOSException, EASBizException {
        long t0 = System.currentTimeMillis();
        DAPAppTools.checkBillExistVoucher(ctx, srcBillIDList, "2652E01E");
        BOTMappingInfo mappingInfo = (BOTMappingInfo)botMappingInfo;
        DAPTransformResult dapTransformResult = null;
        dapTransformResult = this.innerTransformSQLE(ctx, srcBillIDList, voucherType, mappingInfo, selectors);
        long t1 = System.currentTimeMillis();
        dapTransformResult = this.afterTransform(ctx, srcBillIDList, mappingInfo, dapTransformResult, selectors);
        long t2 = System.currentTimeMillis();
        logger.info((Object)("***DAPTransformSQLE, total=" + (t2 - t0) + "ms,  transform time=" + (t1 - t0) + "ms, afterTransform time=" + (t2 - t1) + "ms"));
        return dapTransformResult;
    }

    protected DAPTransformResult afterTransform(Context ctx, IObjectPK[] srcBillIDList, BOTMappingInfo mappingInfo, DAPTransformResult dapTransformResult, SelectorItemCollection selectors) throws BOSException, EASBizException {
        if (dapTransformResult == null || dapTransformResult.getVoucherCollection() == null || dapTransformResult.getVoucherCollection().size() <= 0) {
            return dapTransformResult;
        }
        LowTimer t = new LowTimer();
        t.reset();
        try {
            String action = "";
            boolean bNeedSave = false;
            if (mappingInfo.getIsTempSave() == 1 || mappingInfo.getIsTempSave() == 2) {
                action = "SAVE";
                bNeedSave = true;
            } else if (mappingInfo.getIsTempSave() == 0) {
                action = "SUBMIT";
                bNeedSave = true;
            } else {
                action = "NOTSAVE";
            }
            this.handleAfterTransform(ctx, action, dapTransformResult.getVoucherCollection());
            if (bNeedSave) {
                DAPTransformUtils.save(ctx, srcBillIDList, dapTransformResult, selectors);
            }
            if (dapTransformResult != null) {
                DAPTransformUtils.takeAttachmentOnRelations(ctx, (IObjectCollection)dapTransformResult.getRelationCollection());
            }
            DAPTransformResult dAPTransformResult = dapTransformResult;
            return dAPTransformResult;
        }
        catch (BOSException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        finally {
            this.trace.end();
        }
    }

    protected DAPTransformResult innerTransformSQLE(Context ctx, IObjectPK[] srcBillIDList, DAPVoucherTypeEnum voucherEnum, BOTMappingInfo botMappingInfo, SelectorItemCollection selectors) throws BOSException, DAPException, EASBizException {
        if (srcBillIDList == null || srcBillIDList.length <= 0 || botMappingInfo == null || voucherEnum == null) {
            throw new BOSException("");
        }
        if (botMappingInfo != null) {
            ArrayList<String> botMappingPkCols = new ArrayList<String>();
            botMappingPkCols.add(botMappingInfo.getId().toString());
            IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
            boolean isBotMappingListRight = botMapping.checkBotMappingsHasSameGrpAndAggregate(botMappingPkCols);
            if (!isBotMappingListRight) {
                throw new DAPException(DAPException.BOTMAPPINGHASDIFFERGRPORAGGREGATE);
            }
        }
        BOTMappingCollection botMappingCols = new BOTMappingCollection();
        boolean needLog = BotpUtils.needLog((Context)ctx);
        StringBuffer sb = new StringBuffer(new Date().toString());
        sb.append("\tDAP transform begin...\n");
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IDAPInnerTransformer inner = DAPTransformUtils.getInnerTransformer(ctx, voucherEnum);
        MappingUtil.initMappingEntity((BOTMappingInfo)botMappingInfo, (IMetaDataLoader)loader);
        botMappingCols.add(botMappingInfo);
        if (needLog) {
            sb.append(botMappingInfo.toXml()).append("\n");
        }
        if (needLog) {
            BotpUtils.createUserBOTPLog((Context)ctx, (String)sb.toString(), (boolean)true);
        }
        if (botMappingCols.size() > 1) {
            DAPTransformUtils.adjustGroupAndAggregate(botMappingCols);
        }
        DAPTransformResult result = inner.transformSqle(ctx, srcBillIDList, botMappingInfo, selectors);
        if (needLog) {
            BotpUtils.createUserBOTPLog((Context)ctx, (DAPTransformResult)result);
        }
        return result;
    }

    private void handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws BOSException, EASBizException {
        if (collection == null || collection.size() <= 0) {
            return;
        }
        CoreBillBaseInfo baseinfo = (CoreBillBaseInfo)collection.getObject(0);
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)baseinfo.getBOSType());
        ICoreBillBase iBillBase = (ICoreBillBase)obj;
        iBillBase.handleAfterTransform(action, collection);
    }
}

