/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.bot.app.WfBOTPProvider;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.botp.BotpMappingInfo;
import com.kingdee.bos.workflow.botp.IBotpProvider;
import com.kingdee.bos.workflow.exception.WfBotpException;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.app.CoreBillBaseController;
import java.util.ArrayList;
import java.util.HashMap;

public class WfDAPProvider
extends WfBOTPProvider
implements IBotpProvider {
    public String[] transformByMappingId(Context ctx, String billId, String srcBillType, String botMappingId) throws WfBotpException {
        BOTMappingInfo botMappingInfo = null;
        CoreBillBaseCollection srcBillCollection = null;
        ObjectStringPK botMappingPK = null;
        try {
            IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
            botMappingPK = new ObjectStringPK(botMappingId);
            botMappingInfo = botMapping.getBOTMappingInfo((IObjectPK)botMappingPK);
            SelectorItemCollection botpSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)botMappingInfo);
            botpSelectors.add("*");
            CoreBillBaseController controller = (CoreBillBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBillType));
            srcBillCollection = new CoreBillBaseCollection();
            CoreBillBaseInfo billInfo = controller.getCoreBillBaseInfo(ctx, (IObjectPK)new ObjectStringPK(billId), botpSelectors);
            srcBillCollection.add(billInfo);
        }
        catch (Exception e) {
            throw new WfBotpException(1001, e.fillInStackTrace());
        }
        if (botMappingInfo.getDefineSys().getValue() == 10 && botMappingInfo.getIsTempSave() == 0) {
            throw new WfBotpException(1000);
        }
        try {
            ArrayList<String> destBillIds = new ArrayList<String>();
            if (botMappingInfo.get("destentityname").equals("2652E01E")) {
                IDAPTransformer dapTrans = DAPTransformerFactory.getLocalInstance(ctx);
                DAPTransformResult dapResult = dapTrans.transformForBotp(srcBillCollection, DAPVoucherTypeEnum.FIVoucher, (IObjectPK)botMappingPK);
                for (CoreBillBaseInfo destBillInfo : dapResult.getVoucherCollection()) {
                    destBillIds.add(destBillInfo.getId().toString());
                }
                dapTrans.save(srcBillCollection, dapResult, false);
            } else {
                IBTPManager btpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                BTPTransformResult btpResult = btpManager.transform(srcBillCollection, botMappingInfo);
                BOTRelationCollection botRelationCols = btpResult.getBOTRelationCollection();
                for (CoreBillBaseInfo destBillInfo : btpResult.getBills()) {
                    btpManager.saveRelations(destBillInfo, botRelationCols);
                    destBillIds.add(destBillInfo.getId().toString());
                }
            }
            String[] billIds = new String[destBillIds.size()];
            return destBillIds.toArray(billIds);
        }
        catch (Exception e) {
            throw new WfBotpException(1001, e.fillInStackTrace());
        }
    }

    public BotpMappingInfo[] getBotpMappingInfosByBoth(Context ctx, String orgId, String srcBillType, String destBillType) throws WfBotpException {
        try {
            BOTMappingCollection botMappingInfos = null;
            HashMap<String, CtrlUnitInfo> transmitCtx = new HashMap<String, CtrlUnitInfo>();
            if (!StringUtils.isEmpty((String)orgId)) {
                IFullOrgUnit fullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                CtrlUnitInfo cu = fullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId)).getCU();
                transmitCtx.put("TRANSMITCU", cu);
                botMappingInfos = (BOTMappingCollection)BOTMappingHelper.getMappingForSelect((Context)ctx, (String)srcBillType, (String)destBillType, transmitCtx);
            } else {
                botMappingInfos = (BOTMappingCollection)BOTMappingHelper.getMappingForSelectAllCU((Context)ctx, (String)srcBillType, (String)destBillType, null);
            }
            ArrayList<BotpMappingInfo> list = new ArrayList<BotpMappingInfo>();
            int n = botMappingInfos.size();
            for (int i = 0; i < n; ++i) {
                BOTMappingInfo botMappingInfo = botMappingInfos.get(i);
                if (botMappingInfo.getDefineSys().getValue() == 10 && botMappingInfo.getIsTempSave() == 0) continue;
                BotpMappingInfo mapping = new BotpMappingInfo(botMappingInfo.getId().toString(), botMappingInfo.getAlias());
                list.add(mapping);
            }
            BotpMappingInfo[] mappings = new BotpMappingInfo[list.size()];
            return list.toArray(mappings);
        }
        catch (BOTPException e) {
            throw new WfBotpException(1000, e.getMessage());
        }
        catch (Exception e) {
            throw new WfBotpException(1003, e.getMessage());
        }
    }
}

